(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    729496,      13173]
NotebookOptionsPosition[    722518,      13075]
NotebookOutlinePosition[    723328,      13103]
CellTagsIndexPosition[    723285,      13100]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
         "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
           "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
           "**", "**", "**", "**"}], "**"}], "**"}], "**"}], "**"}], "**"}], 
    "**"}], "******)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Example", ":", " ", 
    RowBox[{
     RowBox[{"Basic", " ", "model", " ", "of", " ", "Tollmien"}], "-", 
     RowBox[{
     "Schlichting", " ", "waves", " ", "and", " ", "analytical", " ", 
      "solution"}]}]}], "    ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Supplementary", " ", 
    RowBox[{"material", ":", " ", 
     RowBox[{"Mathematica", " ", "codes"}]}]}], 
   "                                     ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"version", ":", " ", 
    RowBox[{"221204", "A_thm"}]}], 
   "                                                          ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"author", ":", "  ", 
    RowBox[{"T", ".", " ", "Merz"}]}], 
   "                                                              ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"license", ":", " ", 
    RowBox[{
     RowBox[{"CC", " ", "BY"}], "-", 
     RowBox[{"SA", " ", "4.0"}]}]}], 
   "                                                         ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "created", " ", "with", " ", "WOLFRAM", " ", "MATHEMATICA", " ", "v12", 
    ".3", ".1", ".0", " ", "on", " ", "Windows"}], 
   "                         ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
  "(*", "                                                                     \
          ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
  "(*", "                                                                     \
          ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"CONTENT", ":"}], 
   "                                                                      ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"A", ".", " ", "Calculation"}], " ", "of", " ", "instability", 
    " ", "zones", " ", "and", " ", "state", " ", "amplification", " ", 
    "factor"}], "            ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"B", ".", " ", "Initialization"}], " ", "cell"}], ",", " ", 
    RowBox[{"load", " ", "experimental", " ", "parameters"}]}], 
   "                          ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"C", ".", " ", "Detailed"}], " ", "velocity", " ", "profile", " ",
     "and", " ", "momentum", " ", "thickness"}], 
   "                           ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
  "(*", "                                                                     \
          ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Compatibility", " ", 
    RowBox[{"notice", ":"}]}], 
   "                                                         ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "The", " ", "code", " ", "makes", " ", "use", " ", "of", " ", "the", " ", 
     "domain", " ", "\"\<PositiveReals\>\""}], ","}], 
   "                             ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "newly", " ", "introduced", " ", "in", " ", "Mathematica", " ", "version", 
    " ", "12."}], "                                   ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Changelog", ":"}], 
   "                                                                    ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"221204", 
    RowBox[{"A_thm", ":", " ", 
     RowBox[{
      RowBox[{
      "Changed", " ", "yMax", " ", "of", " ", "the", " ", "graph", " ", 
       "from", " ", "600", " ", "to", " ", "500", " ", "for", " ", "the", " ",
        "lab"}], "-", 
      RowBox[{"example", "."}]}]}]}], "  ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"221010", 
    RowBox[{"A_thm", ":", " ", 
     RowBox[{"Initial", " ", 
      RowBox[{"release", "."}]}]}]}], 
   "                                                 ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.8220262474481077`*^9, 3.8220263264077883`*^9}, {
   3.8220264277181025`*^9, 3.8220265239344673`*^9}, {3.8220472039411693`*^9, 
   3.8220472672914505`*^9}, {3.8221366286911693`*^9, 
   3.8221366549119883`*^9}, {3.8222089097033195`*^9, 
   3.8222089195561514`*^9}, {3.8222232344567723`*^9, 3.822223243452277*^9}, 
   3.822495782036424*^9, {3.8228362808755307`*^9, 3.8228362810327663`*^9}, {
   3.8228418854140882`*^9, 3.822841894544843*^9}, {3.8228419986751175`*^9, 
   3.822842086648415*^9}, {3.822842174991337*^9, 3.8228421912242556`*^9}, {
   3.822842234938654*^9, 3.8228422398838177`*^9}, {3.822843490654336*^9, 
   3.822843542212225*^9}, {3.822843648371709*^9, 3.82284365167266*^9}, {
   3.8228437249059906`*^9, 3.822843736004627*^9}, 3.822844342255701*^9, {
   3.8229063971801853`*^9, 3.8229064739608116`*^9}, {3.823612470234003*^9, 
   3.8236124708315268`*^9}, 3.8236980313998356`*^9, 3.823774576330454*^9, 
   3.823778701185854*^9, {3.823778770869239*^9, 3.823778773808711*^9}, 
   3.8242120951760454`*^9, {3.8242121781272087`*^9, 3.824212183433848*^9}, {
   3.8249011501061563`*^9, 3.8249011510980186`*^9}, {3.825154774660054*^9, 
   3.8251547748470416`*^9}, {3.825427428007775*^9, 3.8254274282129197`*^9}, 
   3.825768858426194*^9, {3.8445968418792906`*^9, 3.844596858073517*^9}, {
   3.8457210748055944`*^9, 3.8457210761687994`*^9}, {3.8457904047240753`*^9, 
   3.845790405562868*^9}, {3.8457923175883293`*^9, 3.845792334108923*^9}, {
   3.845792378114006*^9, 3.845792389616803*^9}, {3.845792459384329*^9, 
   3.845792491074*^9}, 3.845872765833455*^9, 3.8458763489223213`*^9, {
   3.8460016532917843`*^9, 3.8460016537318687`*^9}, {3.8460510076030207`*^9, 
   3.8460510081040325`*^9}, 3.8460590014685783`*^9, {3.8463954032257767`*^9, 
   3.8463954037873516`*^9}, 3.846395656475717*^9, 3.846399060757799*^9, 
   3.8464174547666464`*^9, {3.846480224782501*^9, 3.8464802254516773`*^9}, 
   3.8465002341337767`*^9, 3.8465023420193586`*^9, 3.8465221437454233`*^9, {
   3.8466008554843035`*^9, 3.8466008560200067`*^9}, 3.8466042447548375`*^9, 
   3.8466087274005365`*^9, 3.8466095927425175`*^9, {3.8466477211104918`*^9, 
   3.846647721493278*^9}, 3.8466569994354687`*^9, 3.8466922175777617`*^9, {
   3.8467346588306246`*^9, 3.8467346593309298`*^9}, 3.846830356987029*^9, 
   3.8470853313743553`*^9, 3.8470904943495007`*^9, 3.8471122242744656`*^9, 
   3.847126636790145*^9, {3.847345548167508*^9, 3.8473455491054845`*^9}, {
   3.8474441193974915`*^9, 3.847444121170329*^9}, 3.847444186919831*^9, 
   3.847446276594947*^9, {3.847520016134517*^9, 3.847520016543417*^9}, 
   3.8477128681466155`*^9, 3.8477789183067813`*^9, 3.847791135277559*^9, {
   3.847951325749943*^9, 3.847951326467447*^9}, {3.848134346913954*^9, 
   3.8481343471195383`*^9}, 3.8482111135007772`*^9, 3.8482935024634323`*^9, {
   3.848301525589364*^9, 3.8483017563522363`*^9}, 3.848473980579986*^9, 
   3.848814186170085*^9, {3.8488145568381443`*^9, 3.848814570203802*^9}, 
   3.8489009649850245`*^9, {3.848999781807995*^9, 3.848999782011982*^9}, 
   3.8496763875056925`*^9, 3.849761209428277*^9, {3.8498485866067243`*^9, 
   3.849848586768965*^9}, 3.8499406301966376`*^9, {3.8501041509546366`*^9, 
   3.8501041524182844`*^9}, 3.8506486565423384`*^9, {3.850648707630432*^9, 
   3.8506487120818005`*^9}, 3.8507241286414843`*^9, {3.8508843760734153`*^9, 
   3.8508843762794404`*^9}, 3.8510587493715553`*^9, 3.8512287759128685`*^9, 
   3.8513228817765617`*^9, {3.851401857105225*^9, 3.8514018770721316`*^9}, {
   3.851760102168642*^9, 3.8517601027256193`*^9}, 3.8518377412471604`*^9, 
   3.852270902925746*^9, 3.852444029111745*^9, {3.8524440935115185`*^9, 
   3.8524441216522665`*^9}, {3.852644374906558*^9, 3.852644377448273*^9}, {
   3.8527852268091717`*^9, 3.852785227752913*^9}, 3.8528731257529*^9, 
   3.8530558113762827`*^9, {3.853558943539006*^9, 3.8535589437291913`*^9}, 
   3.8541105198333683`*^9, 3.8542682233540244`*^9, {3.854430666539312*^9, 
   3.854430666668826*^9}, 3.85494692255698*^9, {3.857909200044655*^9, 
   3.8579092007322097`*^9}, 3.8596355645691442`*^9, {3.8607393103788366`*^9, 
   3.8607393107227535`*^9}, {3.8607528532091713`*^9, 
   3.8607528631601505`*^9}, {3.860753408155649*^9, 3.8607534393309107`*^9}, {
   3.8613447662797933`*^9, 3.8613447664377437`*^9}, 3.861685412124543*^9, {
   3.862130510346906*^9, 3.8621305104399004`*^9}, {3.862130612999732*^9, 
   3.862130613485034*^9}, 3.8621994597523117`*^9, 3.8622080181236277`*^9, {
   3.8622144700126934`*^9, 3.8622144802315474`*^9}, 3.8622297579836874`*^9, {
   3.863345064389203*^9, 3.8633450653049297`*^9}, 3.8636670284014006`*^9, 
   3.8637910724671803`*^9, {3.8647272459881277`*^9, 3.8647272462509823`*^9}, {
   3.86488627203872*^9, 3.864886273558524*^9}, {3.8651388161581745`*^9, 
   3.865138816501522*^9}, 3.8651393771281257`*^9, 3.865331303231927*^9, {
   3.873976546438287*^9, 3.873976560182852*^9}, {3.8739773730922875`*^9, 
   3.873977403947277*^9}, {3.8739774687491465`*^9, 3.8739774712097464`*^9}, {
   3.873977546448883*^9, 3.87397758024704*^9}, {3.8739828169777603`*^9, 
   3.8739828264722047`*^9}, {3.874141674123185*^9, 3.874141674903509*^9}, 
   3.8741417241459284`*^9, {3.8741430760963917`*^9, 3.8741430780686307`*^9}, {
   3.874155307009568*^9, 3.874155307656569*^9}, {3.8743847376161947`*^9, 
   3.874384758500492*^9}, {3.8791709785729065`*^9, 3.879170980649993*^9}, {
   3.8791718631327305`*^9, 
   3.8791719873531075`*^9}},ExpressionUUID->"bd086455-bcad-490d-ab2a-\
0cc074b3f5b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"A", ".", " ", "Calculation"}], " ", "of", " ", "instability", 
    " ", "zones", " ", "and", " ", "state", " ", "amplification", " ", 
    "factor"}], "            ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Clear", " ", "previous", " ", "parameters", " ", "to", " ", "avoid", " ", 
    "changeup", " ", 
    RowBox[{"errors", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Quiet", "[", 
    RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"LoadParams", "[", "params", "]"}], ":", " ", 
     RowBox[{
     "Load", " ", "the", " ", "parameters", " ", "of", " ", "the", " ", 
      "desired", " ", "experimental", " ", "setting", " ", "by", " ", 
      "inserting", " ", "one", " ", "of", " ", "the", " ", "following", " ", 
      "strings", " ", "as", " ", "parameters"}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", "  ", 
    RowBox[{"\"\<flight\>\"", " ", ":", " ", 
     RowBox[{
     "Parameters", " ", "as", " ", "in", " ", "the", " ", "experimental", " ",
       "flight", " ", "setting", " ", "from", " ", "Simon", 
      RowBox[{"(", "2017", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "  ", 
    RowBox[{"\"\<lab\>\"", "    ", ":", " ", 
     RowBox[{
     "Parameters", " ", "as", " ", "in", " ", "the", " ", "wind", " ", 
      "tunnel", " ", "setting", " ", "from", " ", "Simon", 
      RowBox[{"(", "2017", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "the", " ", "parameter", " ", "blocks", " ", "are", " ", "defined", " ", 
     "in", " ", "the", " ", "initialization", " ", "cell", " ", "B", " ", 
     "of", " ", "this", " ", "file"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"params", "=", "\"\<flight\>\""}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"A1", ".", "  ", "Symbolic"}], " ", "calculation", " ", "of", 
     " ", "the", " ", "state", " ", "amplification", " ", "function"}], 
    "                 ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"LoadParams", "[", 
     RowBox[{"params", ",", "\"\<geometry only\>\""}], "]"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Geometry type: \>\"", ",", "geometryType", ",", "\"\<.\\n\>\""}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Formulate", " ", "the", " ", "expressions", " ", "in", " ", "terms", 
      " ", "of", " ", "the", " ", "Reynolds", " ", "number", " ", "at", " ", 
      "infinite", " ", "height", " ", "above", " ", "the", " ", "plate", " ", 
      RowBox[{"(", 
       RowBox[{
        SubscriptBox["Re", "\[Infinity]"], " ", "=", " ", 
        RowBox[{
         RowBox[{
          SubscriptBox["Re", 
           RowBox[{"charact", "."}]], "*", " ", 
          SubscriptBox["x", "1"]}], " ", "=", " ", 
         RowBox[{
          SuperscriptBox["\[Rho]", "SI"], "*", 
          SubsuperscriptBox["v", "\[Infinity]", "SI"], "*", 
          RowBox[{
           SubsuperscriptBox["l", "c", "SI"], "/", 
           SuperscriptBox["\[Mu]", "SI"]}], " ", "*", " ", 
          SubscriptBox["x", "1"]}]}]}], ")"}]}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ReyInf", "=", 
     RowBox[{"ReyC", "*", "x1"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    SubscriptBox["Re", "\[Infinity]"], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ReyL", "=", 
     RowBox[{"ReyInf", "*", "v"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    SubscriptBox["Re", "local"], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "use", " ", "the", " ", "detailed", " ", "expression", " ", "for", " ", 
     "printing", " ", "purposes", " ", 
     RowBox[{"only", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ReyCharactPrint", " ", "=", " ", 
     RowBox[{"rhoSI", "*", "vFreestreamSI", "*", 
      RowBox[{"LcharactSI", "/", "viscositySI"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Reynolds number at infinite height above the plate \
\!\(\*SubscriptBox[\(Re\), \(\[Infinity]\)]\)(\!\(\*SubscriptBox[\(x\), \
\(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "ReyInf", "]"}], ",", "3"}], "]"}], ",", 
     "\"\<,\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"print", " ", "the", " ", "detailed", " ", "constant", " ", 
     RowBox[{
      SubscriptBox["Re", 
       RowBox[{"charact", "."}]], ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<using ReyC = \!\(\*SubscriptBox[\(Re\), \(c\)]\) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "ReyCharactPrint", "]"}], ",", "3"}], 
      "]"}], ",", "\"\<.\>\""}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "derived", " ", "fluid", " ", "characteristics", " ", "and", " ", 
     "scattering", " ", 
     RowBox[{"expressions", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"hBar", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "*", 
        RowBox[{"Pi", "/", "3"}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"ReyL", "*", "dC"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]}]}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gPrime2D", "=", 
     RowBox[{
      RowBox[{"3", "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", 
         RowBox[{"2", "^", 
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}]}]}], ")"}]}], "*", 
      RowBox[{"ReyL", "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"q", "=", 
     RowBox[{"hBar", "*", "gPrime2D"}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"alpha", "=", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"4", "*", "Pi", "*", "v"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"q", "^", "2"}], "/", "hBar"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Fluid quantum of action \!\(\*SubscriptBox[\(\[HBar]\), \(Fl\)]\) = \
\>\"", " ", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"hBar", ",", "3"}], "]"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Coupling constant \!\(\*SubscriptBox[\(\[Alpha]\), \(Fl\)]\) = \>\"",
      " ", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"alpha", ",", "3"}], "]"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<\\n\\n------\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Calculate", " ", "the", " ", "effective", " ", 
     RowBox[{"mass", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kEff", "=", 
     RowBox[{
      RowBox[{"c1", "/", 
       RowBox[{"(", 
        RowBox[{"v", "*", "dC", "*", "x1"}], ")"}]}], "*", 
      RowBox[{
       RowBox[{"(", "ReyInf", ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"1", "/", "2"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"omegaEff", "=", 
     RowBox[{"kEff", "*", "v"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mEff", "=", 
     RowBox[{"hBar", "*", "kEff"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Effective mass \!\(\*SubscriptBox[\(m\), \
\(eff\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"FullSimplify", "[", 
        RowBox[{"mEff", ",", 
         RowBox[{"{", 
          RowBox[{"ReyC", ">", "0"}], "}"}]}], "]"}], ",", "3"}], "]"}], ",", 
     "\"\<,\>\""}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Initial", " ", "vortex", " ", "momentum"}], " ", "&"}], " ", 
     "momentum", " ", "ratio", " ", 
     RowBox[{
      SubscriptBox["k", "1"], ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"pVortexInit", "=", 
     RowBox[{"hBar", "*", "k"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k1", "=", " ", 
     RowBox[{"c2", "*", "k", 
      SqrtBox[
       RowBox[{"x1", " "}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Initial momentum ratio \!\(\*SubscriptBox[\(k\), \
\(1\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\),k) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "k1", "]"}], ",", "3"}], "]"}], ",", 
     "\"\<,\>\""}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"print", " ", "the", " ", "detailed", " ", "constant", " ", 
     RowBox[{
      SubscriptBox["c", "2"], ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k1Print", "=", 
     RowBox[{"pVortexInit", "/", "mEff"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c2Print", "=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"k1", "==", "k1Print"}], ",", "c2", ",", "PositiveReals"}], 
        "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2", ",", "1"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<using \!\(\*SubscriptBox[\(c\), \(2\)]\) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "c2Print", "]"}], ",", "3"}], "]"}], ",", 
     "\"\<.\>\""}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Constants", " ", 
     RowBox[{"used", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"ReyC", " ", "=", " ", 
      RowBox[{"rhoSI", "*", "vFreestreamSI", "*", 
       RowBox[{"LcharactSI", "/", "viscositySI"}]}]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{"characteristic", " ", "Reynolds", " ", "number"}], " ", "*)"}],
      "\[IndentingNewLine]", 
     RowBox[{"c1", " ", "=", " ", "0.332"}], ";", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{
      "dimensionless", " ", "inverse", " ", "velocity", " ", "profile", " ", 
       "gradient"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c2", " ", "=", " ", 
      FractionBox[
       RowBox[{"dC", " ", "v"}], 
       RowBox[{"c1", 
        SqrtBox["ReyC"]}]]}], ";", " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"coefficient", " ", "for", " ", "the", " ", "ratio", " ", 
         SubscriptBox["k", "1"], " ", "between", " ", "the", " ", "initial", 
         " ", "vortex", " ", "momentum"}], " ", "&"}], " ", "laminar", " ", 
       "momentum"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"c3", " ", "=", " ", 
      FractionBox[
       RowBox[{"9", "\[Pi]"}], 
       RowBox[{"1024", " "}]]}], ";"}], "   ", 
    RowBox[{"(*", " ", 
     RowBox[{
     "shortcut", " ", "for", " ", "the", " ", "numerical", " ", "prefactor", 
      " ", "in", " ", "the", " ", "differential", " ", "cross", " ", 
      "section"}], " ", "*)"}], "\[IndentingNewLine]", "*)"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Final", " ", "vortex", " ", "momentum", " ", "and", " ", "transferred", 
      " ", "momentum", " ", "at", " ", 
      SubscriptBox["\[Theta]", "max"]}], "=", 
     RowBox[{"180", 
      RowBox[{"\[Degree]", ":"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"thetaMax", "=", "Pi"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"P", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"k1", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Cos", "[", "theta", "]"}], "-", "1"}], ")"}]}]}], ")"}], 
      "^", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PMax", "=", 
     RowBox[{"P", "/.", 
      RowBox[{"{", 
       RowBox[{"theta", "\[Rule]", "thetaMax"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kFinal", "=", 
     RowBox[{"k", "*", "P"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kFinalMax", "=", 
     RowBox[{"k", "*", "PMax"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"deltap", "=", 
     RowBox[{"pVortexInit", "*", 
      RowBox[{"(", 
       RowBox[{"1", "-", "P"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"deltap", "=", 
     RowBox[{"FullSimplify", "[", "deltap", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Momentum transfer \[CapitalDelta]p = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"deltap", ",", "3"}], "]"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"deltapMax", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"deltap", "/.", 
       RowBox[{"{", 
        RowBox[{"theta", "\[Rule]", "thetaMax"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Max. momentum transfer \!\(\*SubscriptBox[\(\[CapitalDelta]p\), \
\(max\)]\)(\!\(\*SubscriptBox[\(\[Theta]\), \(max\)]\)=\>\"", ",", "thetaMax",
      ",", "\"\<) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"deltapMax", ",", "3"}], "]"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Differential", " ", "cross", " ", "section", " ", "d\[Sigma]", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["\[Theta]", "max"], "=", 
       RowBox[{"180", "\[Degree]"}]}], ")"}], " ", "and", " ", "probability", 
     " ", "of", " ", "angular", " ", "momentum", " ", 
     RowBox[{"transfer", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dsigma", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"q", "^", 
        RowBox[{"(", "4", ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{"8", "*", "Pi", "*", 
         RowBox[{"mEff", "^", 
          RowBox[{"(", "2", ")"}]}]}], ")"}]}], "*", 
      RowBox[{"P", "^", "2"}], " ", "*", 
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"Cos", "[", "theta", "]"}], "-", 
        RowBox[{
         RowBox[{"Cos", "[", "theta", "]"}], "^", "2"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dsigma", "=", 
     RowBox[{"dsigma", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{"9", "\[Pi]"}], "2048"], ")"}], "->", 
        FractionBox["c3", "2"]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Differential cross section \!\(\*FractionBox[\(d\[Sigma]\), \
SubscriptBox[\(d\[CapitalOmega]\), \(p\)]]\) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"dsigma", ",", "3"}], "]"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dsigmaMax", "=", 
     RowBox[{"dsigma", "/.", 
      RowBox[{"{", 
       RowBox[{"theta", "\[Rule]", "thetaMax"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dsigmaMax", "=", 
     RowBox[{"FullSimplify", "[", "dsigmaMax", "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Differential cross section at max. momentum transfer \
\!\(\*SubscriptBox[\(d\[Sigma]\), SubscriptBox[\(\[Theta]\), \(max\)]]\) = \>\
\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"dsigmaMax", ",", "3"}], "]"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"numberOfSteps", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"mEff", "/", "deltapMax"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ReyC", ">", "0"}], " ", ",", 
         RowBox[{"x1", ">", "0"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Number of steps s(\!\(\*SubscriptBox[\(\[Theta]\), \(max\)]\)=\>\"", 
     ",", "thetaMax", ",", "\"\<) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"numberOfSteps", ",", "3"}], "]"}], ",", "\"\<.\>\""}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"state", " ", "amplification", " ", "factor", " ", "n", 
      RowBox[{"(", 
       RowBox[{"k", ",", 
        SubscriptBox["x", "1"]}], ")"}]}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Phi", "=", 
     RowBox[{"dsigmaMax", "^", "numberOfSteps"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactor", "=", 
     RowBox[{"cA", "*", "cB", "*", "Sc", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "dC", "*", "hBar"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]}], "*", 
      RowBox[{"D", "[", 
       RowBox[{"Phi", ",", "k"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Print", " ", "the", " ", "state", " ", "amplification", " ", "factor", 
     " ", "in", " ", "a", " ", "readable", " ", "form", " ", "using", " ", 
     "some", " ", 
     RowBox[{"shortcuts", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Shortcuts", " ", "used", " ", "to", " ", "print", " ", "the", " ", 
     "state", " ", "amplification", " ", 
     RowBox[{"factor", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"k1", " ", "=", " ", 
      RowBox[{"c2", "*", "k", 
       SqrtBox["x1"]}]}], ";", "                      ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"ratio", " ", 
         SubscriptBox["k", "1"], " ", "between", " ", "the", " ", "initial", 
         " ", "vortex", " ", "momentum"}], " ", "&"}], " ", "laminar", " ", 
       "momentum"}], " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{"k2", " ", "=", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", "*", "k1"}]}], ")"}], " ", "=", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"2", "*", "c2", "*", "k", 
          SqrtBox["x1"]}]}], ")"}]}]}], ";", "     ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{
        SubscriptBox["k", "2"], " ", "approx", " ", 
        SubscriptBox["k", "1"], " ", "if", " ", "2", "*", "c2", "*", "k", 
        SqrtBox["x1"]}], " ", ">>", " ", "1"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"k3", "^", 
       RowBox[{"(", 
        RowBox[{"-", "2"}], ")"}]}], " ", "=", 
      RowBox[{
       FractionBox[
        RowBox[{"c3", " ", 
         SuperscriptBox["v", "2"], " ", "x1"}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c1", "+", 
            RowBox[{"2", " ", "c1", " ", "k1"}]}], ")"}], "2"], " ", 
         "ReyC"}]], "=", 
       FractionBox[
        RowBox[{"c3", " ", 
         SuperscriptBox["v", "2"], " ", "x1"}], 
        RowBox[{
         SuperscriptBox["c1", "2"], " ", 
         SuperscriptBox["k2", "2"], " ", "ReyC"}]]}]}], ";", "  ", 
     RowBox[{"(*", " ", 
      RowBox[{"factor", " ", "inside", " ", "the", " ", "logarithm"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{"s", " ", "=", " ", 
      FractionBox[
       RowBox[{"c1", " ", "k2", " ", 
        SqrtBox["ReyC"]}], 
       RowBox[{"c2", " ", "dC", " ", 
        SuperscriptBox["k", "2"], " ", "v", " ", "x1"}]]}], ";"}], 
    "                     ", 
    RowBox[{"(*", " ", 
     RowBox[{"s", " ", "=", " ", "numberOfSteps"}], " ", "*)"}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "stateAmplificationFactorPrint", "=", "stateAmplificationFactor"}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "print", " ", "in", " ", "terms", " ", "of", " ", "the", " ", "ratio", 
     " ", 
     RowBox[{"k1", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", "k1", "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorPrint", "=", 
     RowBox[{"stateAmplificationFactorPrint", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", "c2", " ", ")"}], "\[Rule]", 
        FractionBox["k1", 
         RowBox[{"k", " ", 
          SqrtBox["x1"]}]]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"print", " ", "in", " ", "terms", " ", "of", " ", "s"}], " ", 
      "=", " ", "numberOfSteps"}], ",", " ", 
     RowBox[{"using", " ", "s", " ", "as", " ", "a", " ", 
      RowBox[{"shortcut", ":"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorPrint", "=", 
     RowBox[{"stateAmplificationFactorPrint", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{"c1", " ", 
           RowBox[{"(", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", "k1"}]}], ")"}], " ", 
           SqrtBox[
            RowBox[{"ReyC", " "}]]}], 
          RowBox[{"dC", " ", "k", " ", "k1", " ", "v", " ", 
           SqrtBox["x1"]}]], ")"}], "\[Rule]", "s"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"simplify", "/", " ", "join"}], " ", "the", " ", 
     RowBox[{"logarithms", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorPrint", "=", 
     RowBox[{"stateAmplificationFactorPrint", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{"c3", " ", 
           SuperscriptBox["v", "2"], " ", "x1"}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c1", "+", 
              RowBox[{"2", " ", "c1", " ", "k1"}]}], ")"}], "2"], " ", 
           "ReyC"}]], " ", ")"}], "\[Rule]", 
        RowBox[{"k3", "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k3Print", "=", 
     RowBox[{
      RowBox[{"FullSimplify", "[", 
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"k3", "^", 
           RowBox[{"(", 
            RowBox[{"-", "2"}], ")"}]}], "==", 
          RowBox[{"(", 
           FractionBox[
            RowBox[{"c3", " ", 
             SuperscriptBox["v", "2"], " ", "x1"}], 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"c1", "+", 
                RowBox[{"2", " ", "c1", " ", "k1"}]}], ")"}], "2"], " ", 
             "ReyC"}]], " ", ")"}]}], ",", "k3", ",", "PositiveReals"}], 
        "]"}], "]"}], "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2", ",", "1"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<Check ratio \!\(\*SubscriptBox[\(k\), \(3\)]\) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"k3Print", ",", "3"}], "]"}], ",", "\"\<.\\n\>\""}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<\\n\\n--- Analytical results ---\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorPrint", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"stateAmplificationFactorPrint", ",", 
       RowBox[{"{", 
        RowBox[{"k3", ">", "0"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorSIPrint", "=", 
     RowBox[{"stateAmplificationFactorPrint", "/.", 
      RowBox[{"{", 
       RowBox[{"k", "\[Rule]", 
        RowBox[{"2", "*", "Pi", "*", 
         RowBox[{"(", 
          RowBox[{"x1", "*", "LcharactSI"}], ")"}], "*", 
         RowBox[{"nuSI", "/", 
          RowBox[{"(", 
           RowBox[{"v", "*", "vFreestreamSI"}], ")"}]}]}]}], "}"}]}]}], ";"}],
    "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<State amplification factor as a function of the wavenumber and of \
the frequency:\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<    n(k,\!\(\*SubscriptBox[\(x\), \(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"stateAmplificationFactorPrint", ",", "3"}], "]"}], ",", 
     "\"\<.\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    n(\!\(\*SuperscriptBox[\(\[Nu]\), \
\(SI\)]\),\!\(\*SubscriptBox[\(x\), \(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"stateAmplificationFactorSIPrint", ",", "3"}], "]"}], ",", 
     "\"\<.\\n\>\""}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"A2", ".", "  ", "Symbolic"}], " ", "calculation", " ", "of", 
     " ", "the", " ", "approximated", " ", "maximum", " ", "amplification", 
     " ", "curve"}], "     ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Approximate", " ", "calculation", " ", "of", " ", 
      SubscriptBox["k", "max"]}], ",", " ", 
     RowBox[{
      RowBox[{
      "version", " ", "with", " ", "Logarithm", " ", "held", " ", "together", 
       " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"approximations", " ", "implemented", " ", "before", " ", 
          RowBox[{"Simplify", "[", "]"}]}], ",", " ", 
         RowBox[{
         "c3", " ", "instead", " ", "of", " ", "numerical", " ", "values"}]}],
         ")"}]}], ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Approximation", " ", "1"}], ":", " ", 
      RowBox[{
      "expression", " ", "inside", " ", "the", " ", "logarithm", " ", 
       "constant"}]}], ",", " ", 
     RowBox[{
      RowBox[{"ln", 
       RowBox[{"(", 
        SubscriptBox["k", "3"], ")"}]}], " ", "->", " ", 
      RowBox[{"ln", 
       RowBox[{
        RowBox[{"(", 
         SubsuperscriptBox["k", "3", "0"], ")"}], "."}]}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Approximation", " ", "2"}], ":", " ", 
       RowBox[{"2", "*", "k1"}]}], " ", "=", " ", 
      RowBox[{"2", "*", "c2", "*", "k", 
       SqrtBox["x1"]}]}], " ", ">>", " ", "3."}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Approximation", " ", "3"}], ":", " ", 
      RowBox[{"2", "*", 
       RowBox[{"Log", "[", "k3", "]"}]}]}], " ", ">>", " ", "3."}], " ", 
    "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Derivative", " ", "of", " ", "the", " ", "state", " ", "amplification", 
     " ", "factor", " ", "with", " ", "respect", " ", "to", " ", "k", " ", 
     "to", " ", "find", " ", "the", " ", "local", " ", 
     RowBox[{"maximum", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DstateAmpl", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{"D", "[", 
       RowBox[{"stateAmplificationFactor", ",", "k"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Approximation", " ", "1"}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Approximation", " ", "1"}], ":", " ", 
      RowBox[{
      "expression", " ", "inside", " ", "the", " ", "logarithm", " ", 
       "constant"}]}], ",", " ", 
     RowBox[{
      RowBox[{"ln", 
       RowBox[{"(", 
        SubscriptBox["k", "3"], ")"}]}], " ", "->", " ", 
      RowBox[{
       RowBox[{"ln", 
        RowBox[{"(", 
         SubsuperscriptBox["k", "3", "0"], ")"}]}], ":"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DstateAmpl", "=", 
     RowBox[{"DstateAmpl", "/.", 
      RowBox[{"{", "  ", 
       RowBox[{
        RowBox[{"Log", "[", 
         FractionBox[
          RowBox[{"c3", " ", 
           SuperscriptBox["v", "2"], " ", "x1"}], 
          RowBox[{"ReyC", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"c1", "+", 
              RowBox[{"2", " ", "c1", " ", "c2", " ", "k", " ", 
               SqrtBox["x1"]}]}], ")"}], "2"]}]], "]"}], "\[Rule]", 
        RowBox[{"Log", "[", 
         RowBox[{"k3", "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}], "]"}]}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Approximation", " ", "2"}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "*", "k1"}], " ", "=", " ", 
      RowBox[{"2", "*", "c2", "*", "k", 
       SqrtBox["x1"]}]}], " ", ">>", " ", 
     RowBox[{"3", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "remove", " ", "all", " ", "small", " ", "coefficents", " ", "of", " ", 
       "the", " ", "form", " ", 
       RowBox[{"(", 
        RowBox[{"smallCoeff", " ", "+", " ", 
         RowBox[{"j", "*", "c2", "*", "k", "*", 
          SqrtBox["x1"]}]}], ")"}], " ", "with", " ", "j"}], "=", "1"}], ",", 
     "2", ",", 
     RowBox[{
      RowBox[{"3", " ", "and", " ", "smallCoeff"}], "=", "1"}], ",", "2", ",",
      "3"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", " ", 
     RowBox[{
      RowBox[{"smallCoeff", "=", "1"}], ",", " ", 
      RowBox[{"smallCoeff", "\[LessEqual]", "3"}], ",", 
      RowBox[{"smallCoeff", "++"}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"For", "[", " ", 
        RowBox[{
         RowBox[{"j", "=", "1"}], ",", " ", 
         RowBox[{"j", "\[LessEqual]", "3"}], ",", 
         RowBox[{"j", "++"}], ",", " ", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"DstateAmpl", "=", 
           RowBox[{"DstateAmpl", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"smallCoeff", "+", 
                RowBox[{"j", " ", "*", " ", "c2", " ", "k", " ", 
                 RowBox[{"Sqrt", "[", "x1", "]"}]}]}], ")"}], "\[Rule]", 
              RowBox[{"(", 
               RowBox[{"j", " ", "*", " ", "c2", " ", "k", " ", 
                RowBox[{"Sqrt", "[", "x1", "]"}]}], ")"}]}], "}"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"DstateAmpl", "=", 
           RowBox[{"DstateAmpl", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"smallCoeff", "*", "c1"}], "+", 
                RowBox[{"j", " ", "*", " ", "c1", " ", "c2", " ", "k", " ", 
                 RowBox[{"Sqrt", "[", "x1", "]"}]}]}], ")"}], "\[Rule]", 
              RowBox[{"(", 
               RowBox[{"j", " ", "*", " ", "c1", " ", "c2", " ", "k", " ", 
                RowBox[{"Sqrt", "[", "x1", "]"}]}], ")"}]}], "}"}]}]}], 
          ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Solve", " ", "for", " ", "the", " ", "local", " ", "maximum", " ", 
     RowBox[{
      SubscriptBox["k", "max"], ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Find the approx. max. wave vector and frequency (in Hz):\>\"", " ", 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DstateAmpl", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"DstateAmpl", ",", 
       RowBox[{"{", 
        RowBox[{"k3", ">", "0"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"DstateAmpl", "==", "0"}], "}"}], ",", "k"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kMax", "=", 
     RowBox[{"S", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Approximation", " ", "3"}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"2", "*", 
      RowBox[{"Log", "[", "k3", "]"}]}], " ", ">>", " ", "3"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kMax", "=", 
     RowBox[{"kMax", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"2", " ", 
           RowBox[{"Log", "[", "k3", "]"}]}]}], ")"}], "->", 
        RowBox[{"2", " ", 
         RowBox[{"Log", "[", "k3", "]"}]}]}], "}"}]}]}], ";"}], 
   RowBox[{"(*", " ", 
    RowBox[{"Approximation", "!"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kMax", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"kMax", ",", 
       RowBox[{"k3", ">", "0"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kMax", "=", 
     RowBox[{"kMax", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"Log", "[", "k3", "]"}]}], ")"}], "->", 
        RowBox[{"Log", "[", "k3", "]"}]}], "}"}]}]}], ";"}], 
   RowBox[{"(*", " ", 
    RowBox[{"Approximation", "!"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kMax", "=", 
     RowBox[{"Simplify", "[", 
      RowBox[{"kMax", ",", 
       RowBox[{"k3", ">", "0"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kMax", "=", 
     RowBox[{"kMax", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Log", "[", "k3", "]"}], "->", "L3"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "same", " ", "for", " ", "the", " ", "frequency", " ", "with",
      " ", "dimension", " ", 
     RowBox[{
      SubsuperscriptBox["\[Nu]", "max", "SI"], ":"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nuMaxSI", "=", 
     RowBox[{"kMax", "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"vFreestreamSI", "*", "v"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"2", "*", "Pi", "*", "x1", "*", "LcharactSI"}], ")"}]}]}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    \!\(\*SubscriptBox[\(k\), \(max\)]\)(\!\(\*SubscriptBox[\(x\), \
\(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "kMax", "]"}], ",", "3"}], "]"}], ",", 
     "\"\<,\>\""}], " ", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    \!\(\*SubsuperscriptBox[\(\[Nu]\), \(max\), \
\(SI\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "nuMaxSI", "]"}], ",", "3"}], "]"}], ",", 
     "\"\<,\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<    using L3 as the approx. constant logarithm L3 = \
ln(\!\(\*SubsuperscriptBox[\(k\), \(3\), \(0\)]\)).\\n\>\"", "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"A3", ".", "  ", "Symbolic"}], " ", "calculation", " ", "of", 
     " ", "the", " ", "approximated", " ", "transition", " ", "point"}], 
    "                ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Insert", " ", 
      SubscriptBox["k", "max"], " ", "back", " ", "into", " ", "the", " ", 
      "state", " ", "amplification", " ", "factor", " ", "n", 
      RowBox[{"(", 
       RowBox[{"k", ",", 
        SubscriptBox["x", "1"]}], ")"}]}], "->", 
     RowBox[{
      RowBox[{"n", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["k", "max"], ",", 
         SubscriptBox["x", "1"]}], ")"}], " ", "to", " ", "get", " ", "the", 
       " ", 
       RowBox[{"approx", ".", " ", "max", ".", " ", "amplification"}], " ", 
       "factor", " ", "N", 
       RowBox[{"(", 
        SubscriptBox["x", "1"], ")"}], " ", 
       RowBox[{"(", " ", 
        RowBox[{"called", " ", "\"\<stateAmplificationFactorMax\>\""}], " ", 
        ")"}]}], ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Approximation", ":", " ", 
       RowBox[{"2", "*", "k1"}]}], " ", "=", " ", 
      RowBox[{"2", "*", "c2", "*", "k", 
       SqrtBox["x1"]}]}], " ", ">>", " ", 
     RowBox[{"1", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "stateAmplificationFactorMax", "=", "stateAmplificationFactorPrint"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"stateAmplificationFactorMax", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Log", "[", "k3", "]"}], "\[Rule]", "L3"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"stateAmplificationFactorMax", "/.", 
      RowBox[{"{", 
       RowBox[{"s", "\[Rule]", 
        FractionBox[
         RowBox[{"c1", " ", "k2", " ", 
          SqrtBox[
           RowBox[{"ReyC", " "}]]}], 
         RowBox[{"c2", " ", "dC", " ", 
          SuperscriptBox["k", "2"], " ", "v", " ", "x1"}]]}], "}"}]}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k3Approx", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          FractionBox[
           RowBox[{"c3", " ", 
            SuperscriptBox["v", "2"], " ", "x1"}], 
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               RowBox[{"0", "*", "c1"}], "+", 
               RowBox[{"2", " ", "c1", " ", "k1"}]}], ")"}], "2"], " ", 
            "ReyC"}]], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "2"}], ")"}]}], "/.", 
        RowBox[{"{", 
         RowBox[{"k1", "\[Rule]", 
          RowBox[{
           FractionBox[
            RowBox[{"dC", " ", "v"}], 
            RowBox[{"c1", 
             SqrtBox[
              RowBox[{"ReyC", " "}]]}]], "*", "k", 
           SqrtBox["x1"]}]}], "}"}]}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"c3", ">", "0"}], ",", 
         RowBox[{"dC", ">", "0"}], ",", 
         RowBox[{"k", ">", "0"}]}], "}"}]}], "]"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Approximation", "!"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"stateAmplificationFactorMax", "/.", 
      RowBox[{"{", 
       RowBox[{"k3", "\[Rule]", "k3Approx"}], "}"}]}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"stateAmplificationFactorMax", "/.", 
      RowBox[{"{", 
       RowBox[{"k2", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"0", "*", "1"}], "+", 
          RowBox[{"2", "*", "c2", "*", "k", 
           SqrtBox["x1"]}]}], ")"}]}], "}"}]}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Approximation", "!"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"stateAmplificationFactorMax", "/.", 
      RowBox[{"{", 
       RowBox[{"k1", "\[Rule]", 
        RowBox[{"c2", "*", "k", 
         SqrtBox["x1"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"insert", " ", "the", " ", "approximated", " ", 
     SubscriptBox["k", "max"], " ", "into", " ", "the", " ", "state", " ", 
     "amplification", " ", 
     RowBox[{"factor", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"stateAmplificationFactorMax", "/.", 
      RowBox[{"{", 
       RowBox[{"k", "\[Rule]", "kMax"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"stateAmplificationFactorMax", "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Log", "[", "k3", "]"}], "\[Rule]", "L3"}], "}"}]}]}], ";"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "the", " ", "simplifications", " ", "work", " ", "better", " ", 
      "without", " ", "the", " ", "Log"}], "-", 
     RowBox[{"function", " ", "in", " ", 
      RowBox[{"it", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"stateAmplificationFactorMax", "/.", 
      RowBox[{"{", 
       RowBox[{"c2", "\[Rule]", " ", 
        FractionBox[
         RowBox[{"dC", " ", "v"}], 
         RowBox[{"c1", 
          SqrtBox["ReyC"]}]]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"FullSimplify", "[", "stateAmplificationFactorMax", "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorMax", "=", 
     RowBox[{"stateAmplificationFactorMax", "/.", 
      RowBox[{"{", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"2", " ", "L3"}]}], ")"}], "\[Rule]", 
        RowBox[{"2", "*", "L3"}]}], "}"}]}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"Approximation", "!"}], " ", "*)"}], 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Approximation", ":", " ", 
      RowBox[{"2", "*", 
       RowBox[{"Log", "[", "k3", "]"}]}]}], " ", ">>", " ", "1."}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Approx. max. amplification factor:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<    N(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"stateAmplificationFactorMax", ",", "3"}], "]"}], ",", 
     "\"\<.\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Short", " ", "check", " ", "if", " ", "this", " ", "expression", " ", 
     "is", " ", "the", " ", "same", " ", "as", " ", "the", " ", "one", " ", 
     "used", " ", "in", " ", "the", " ", 
     RowBox[{"article", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplMaxCheck", "=", 
     RowBox[{
      FractionBox[
       RowBox[{
       "3", "  ", "cA", " ", "cB", " ", "dC", " ", "ReyC", " ", "Sc", " ", 
        "v", "  ", "x1"}], 
       RowBox[{
        SqrtBox["c3"], " ", 
        SuperscriptBox["\[Pi]", "2"]}]], 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{
          SqrtBox["c3"], " ", "v", " ", 
          SqrtBox["x1"]}], 
         RowBox[{"2", " ", "c1", " ", "L3", " ", 
          SqrtBox["ReyC"]}]], ")"}], 
       FractionBox[
        RowBox[{
         InterpretationBox[
          StyleBox["\<\"2\"\>",
           ShowStringCharacters->False],
          2,
          Editable->False], "+", "L3"}], "L3"]]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplMaxCheckFlag", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       RowBox[{"stateAmplificationFactorMax", "==", "stateAmplMaxCheck"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ReyC", ">", "0"}], ",", 
         RowBox[{"L3", ">", "0"}], ",", 
         RowBox[{"c1", ">", "0"}], ",", 
         RowBox[{"c3", ">", "0"}], ",", 
         RowBox[{"Ntrans", ">", "0"}], ",", 
         RowBox[{"cA", ">", "0"}], ",", 
         RowBox[{"cB", ">", "0"}], ",", 
         RowBox[{"dC", ">", "0"}], ",", 
         RowBox[{"v", ">", "0"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<In the article, the expression for the max. amplification factor is \
used in the form: N(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = \
\!\(\*FractionBox[\(3\\\ \\\ cA\\\ cB\\\ dC\\\ ReyC\\\ Sc\\\ v\\\ \\\ x1\), \
\(\*SqrtBox[\(c3\)]\\\ \*SuperscriptBox[\(\[Pi]\), \
\(2\)]\)]\)(\!\(\*FractionBox[\(\*SqrtBox[\(c3\)]\\\ v\\\ \
\*SqrtBox[\(x1\)]\), \(2\\\ c1\\\ L3\\\ \
\*SqrtBox[\(ReyC\)]\)]\)\!\(\*SuperscriptBox[\")\", \
FractionBox[RowBox[{InterpretationBox[StyleBox[\"\\\"\<2\>\\\"\",\
ShowStringCharacters->False],2,Editable->False], \"+\", \"L3\"}], \"L3\"]]\) \
.\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Check if both expressions are the same: \>\"", ",", 
     "stateAmplMaxCheckFlag", ",", "\"\<.\\n\>\""}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Solve", " ", 
      SubscriptBox["N", "trans"]}], "==", 
     RowBox[{"stateAmplificationMax", " ", "for", " ", 
      SubscriptBox["x", "1"], " ", "to", " ", "get", " ", "the", " ", 
      "transition", " ", "point", " ", 
      RowBox[{
       SubscriptBox["x", "trans"], ":"}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Somehow", " ", "the", " ", "maximum", " ", "state", " ", "amplification",
      " ", "could", " ", "not", " ", "be", " ", "resolved", " ", "for", " ", 
     SubscriptBox["x", "1"], " ", 
     RowBox[{"directly", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Therefore", " ", "the", " ", "prefactor", " ", "of", " ", 
     "stateAmplificationFactorMax", " ", "is", " ", "first", " ", 
     "introduced", " ", "as", " ", "an", " ", "auxiliary", " ", "variable", 
     " ", 
     RowBox[{"Aux1", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"(", 
     RowBox[{"stateAmplificationFactorMax", " ", "=", " ", 
      RowBox[{"Aux1", "*", "f", 
       RowBox[{"(", 
        SubscriptBox["x", "1"], ")"}]}]}], ")"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S", "=", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"Ntrans", "==", 
        RowBox[{"Aux1", "*", 
         SqrtBox["x1"], "*", 
         SuperscriptBox[
          RowBox[{"(", "x1", ")"}], 
          RowBox[{"1", "+", 
           FractionBox["1", 
            RowBox[{"L3", " "}]]}]]}]}], ",", "x1", ",", "PositiveReals"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1Trans", "=", 
     RowBox[{"S", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2", ",", "1"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Calculation", " ", "and", " ", "insertion", " ", "of", " ", "the", " ", 
     RowBox[{"prefactor", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Aux1", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       RowBox[{"stateAmplificationFactorMax", "/", 
        RowBox[{"(", 
         RowBox[{
          SqrtBox[
           RowBox[{"x1", " "}]], "*", 
          SuperscriptBox[
           RowBox[{"(", "x1", ")"}], 
           RowBox[{"1", "+", 
            FractionBox["1", "L3"]}]]}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"x1", ">", "0"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1transitionPoint", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{"x1Trans", ",", "PositiveReals"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Approx. transition point:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    \!\(\*SubscriptBox[\(x\), \(\(trans\)\(\\\ \
\)\)]\)(\!\(\*SubscriptBox[\(N\), \(trans\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"x1transitionPoint", ",", "3"}], "]"}], ",", "\"\<.\>\""}], 
    "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Short", " ", "check", " ", "if", " ", "this", " ", "expression", " ", 
     "is", " ", "the", " ", "same", " ", "as", " ", "the", " ", "one", " ", 
     "used", " ", "in", " ", "the", " ", 
     RowBox[{"article", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1TransPCheck", "=", 
     RowBox[{
      SuperscriptBox["ReyC", 
       FractionBox[
        RowBox[{"2", "-", "L3", " "}], 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", "L3"}]}]]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"2", " ", "c1", " ", 
           SuperscriptBox["\[Pi]", "2"], "  ", "L3", " ", "Ntrans", " "}], 
          RowBox[{"3", " ", "cA", " ", "cB", " ", "dC", " ", "Sc", " ", 
           SuperscriptBox["v", "2"]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"2", " ", "c1", " ", "L3"}], 
            RowBox[{
             SqrtBox["c3"], " ", "v"}]], ")"}], 
          RowBox[{"2", "/", "L3"}]]}], ")"}], 
       FractionBox[
        RowBox[{"2", " ", "L3"}], 
        RowBox[{"2", "+", 
         RowBox[{"3", " ", "L3"}]}]]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1TransPCheckFlag", "=", 
     RowBox[{"FullSimplify", "[", 
      RowBox[{
       RowBox[{"x1transitionPoint", "==", "x1TransPCheck"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ReyC", ">", "0"}], ",", 
         RowBox[{"L3", ">", "0"}], ",", 
         RowBox[{"c1", ">", "0"}], ",", 
         RowBox[{"Ntrans", ">", "0"}], ",", 
         RowBox[{"cA", ">", "0"}], ",", 
         RowBox[{"cB", ">", "0"}], ",", 
         RowBox[{"dC", ">", "0"}], ",", 
         RowBox[{"v", ">", "0"}]}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<In the article, the expression for the transition point is used in \
the form: \!\(\*SubscriptBox[\(x\), \(\(trans\)\(\\\ \
\)\)]\)(\!\(\*SubscriptBox[\(N\), \(trans\)]\)) = \!\(\*SuperscriptBox[\(ReyC\
\), FractionBox[\(\(2\)\(-\)\(L3\)\(\\\ \)\), \(2 + 3\\\ \
L3\)]]\)(\!\(\*FractionBox[\(\(2\)\(\\\ \)\(c1\)\(\\\ \)\*SuperscriptBox[\(\
\[Pi]\), \(2\)]\(\\\ \\\ \)\(L3\)\(\\\ \)\(Ntrans\)\(\\\ \)\), \(3\\\ cA\\\ \
cB\\\ dC\\\ Sc\\\ \*SuperscriptBox[\(v\), \(2\)]\)]\)(\!\(\*FractionBox[\(2\\\
\ c1\\\ L3\), \(\*SqrtBox[\(c3\)]\\\ v\)]\)\!\(\*SuperscriptBox[\()\), \(2/L3\
\)]\)\!\(\*SuperscriptBox[\()\), FractionBox[\(2\\\ L3\), \(2 + 3\\\ L3\)]]\) \
.\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Check if both expressions are the same: \>\"", ",", 
     "x1TransPCheckFlag", ",", "\"\<.\\n\>\""}], "]"}], "\[IndentingNewLine]",
    "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"A4", ".", "  ", "Calculations"}], " ", "with", " ", "numerical",
      " ", "values", " ", "inserted", " ", "and", " ", "plots", " ", "of", 
     " ", "the", " ", "results"}], "     ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
     "**", "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", "\"\<\\n\\n--- Inserting numerical values ---\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"LoadParams", "[", 
     RowBox[{"params", ",", "\"\<all values\>\""}], "]"}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Set", " ", "the", " ", "constant", " ", "parameters", " ", 
      RowBox[{"(", 
       RowBox[{
       "may", " ", "have", " ", "to", " ", "be", " ", "adjusted", " ", "for", 
        " ", "different", " ", "geometries"}], ")"}]}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"v", "=", "0.220"}], ";"}], "             ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "dimensionless", " ", "velocity", " ", "along", " ", "scattering", " ", 
     "profile", " ", "at", " ", "momentum", " ", "thickness"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cA", "=", 
     RowBox[{"1", "/", "2"}]}], ";"}], "             ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"initial", " ", "number", " ", "fractions"}], ";", " ", 
      RowBox[{"cA", " ", "and", " ", "cB", " ", "correspond", " ", "to", " ", 
       SubscriptBox["c", "L"], " ", "and", " ", 
       SubscriptBox["c", "\[Omega]"]}]}], ",", " ", 
     RowBox[{
      RowBox[{"the", " ", "initial", " ", "laminar"}], "-", " ", 
      RowBox[{"and", " ", "vortex"}], "-", 
      RowBox[{
      "number", " ", "fractions", " ", "in", " ", "the", " ", "article"}]}]}],
     " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"cB", "=", 
     RowBox[{"1", "/", "2"}]}], ";"}], "            ", 
   RowBox[{"(*", " ", 
    RowBox[{"german", ":", " ", "Stoffmengenanteil"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Ntrans", "=", "9"}], ";"}], "         ", 
   RowBox[{"(*", " ", 
    RowBox[{"Exponential", " ", "of", " ", "the", " ", "assumed", " ", 
     RowBox[{"max", ".", " ", "amplification"}], " ", "factor", " ", "at", 
     " ", "transition", " ", "point", " ", 
     SuperscriptBox["e", "Ntrans"]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Set transition at \!\(\*SubscriptBox[\(N\), \(trans\)]\) = \>\"", 
     ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"Ntrans", ",", "3"}], "]"}], ",", "\"\<.\>\""}], "]"}], "\n", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<dyn. viscosity \!\(\*SuperscriptBox[\(\[Eta]\), \(SI\)]\) = \>\"", 
     ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"viscositySI", ",", "3"}], "]"}], ",", 
     "\"\< Pa\[CenterDot]s.\>\""}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Set", " ", "the", " ", "constants", " ", "at", " ", "which", " ", "the",
       " ", "logarithm", " ", "L3"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"ln", 
       RowBox[{"(", 
        SubsuperscriptBox["k", "3", "0"], ")"}], " ", "is", " ", "evaluated", 
       " ", 
       RowBox[{"(", 
        RowBox[{
        "may", " ", "have", " ", "to", " ", "be", " ", "adjusted", " ", "for",
          " ", "different", " ", "fluids"}], ")"}]}], ":"}]}], " ", "*)"}], 
   "\n", 
   RowBox[{
    RowBox[{"x1Zero", "=", "0.6"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"kZero", "=", "250"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Calculate", " ", "the", " ", "subsequent", " ", "fluid", " ", 
     RowBox[{"characteristics", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ReyC", "=", 
     RowBox[{"rhoSI", "*", "vFreestreamSI", "*", 
      RowBox[{"LcharactSI", "/", "viscositySI"}]}]}], " ", ";"}], "  ", 
   RowBox[{"(*", " ", 
    RowBox[{"Characteristic", " ", "Reynolds", " ", "number"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dC", "=", 
     RowBox[{"dBoxSI", "/", 
      RowBox[{"(", 
       RowBox[{"2", "*", "rParticleSI"}], ")"}]}]}], ";"}], 
   "                                                    ", 
   RowBox[{"(*", " ", 
    RowBox[{"dimensionless", " ", "box", " ", "length"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Coupling constant \!\(\*SubscriptBox[\(\[Alpha]\), \(Fl\)]\) = \>\"",
      " ", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"alpha", ",", "3"}], "]"}], ",", "\"\<.\\n\>\""}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Add", " ", "the", " ", "geometry", " ", "dependent", " ", "constants", 
     " ", "and", " ", 
     RowBox[{"parameters", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c1", " ", "=", " ", "0.332"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c2", " ", "=", " ", 
     FractionBox[
      RowBox[{"dC", " ", "v"}], 
      RowBox[{"c1", 
       SqrtBox["ReyC"]}]]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c3", " ", "=", " ", 
     FractionBox[
      RowBox[{"9", "\[Pi]"}], 
      RowBox[{"1024", " "}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k1", " ", "=", " ", 
     RowBox[{"c2", "*", "k", 
      SqrtBox["x1"]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k2", "  ", "=", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"2", "*", "c2", "*", "k", 
        SqrtBox["x1"]}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k3", " ", "=", 
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{"c3", " ", 
         SuperscriptBox["v", "2"], " ", "x1"}], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"c1", "+", 
            RowBox[{"2", " ", "c1", " ", "k1"}]}], ")"}], "2"], " ", 
         "ReyC"}]], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L3", "=", 
     RowBox[{"Log", "[", 
      RowBox[{
       RowBox[{"(", 
        FractionBox[
         RowBox[{"c3", " ", 
          SuperscriptBox["v", "2"], " ", "x1Zero"}], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"c1", "+", 
             RowBox[{"2", " ", "c1", " ", "c2", "*", "kZero", 
              SqrtBox["x1Zero"]}]}], ")"}], "2"], " ", "ReyC"}]], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "2"}], ")"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"s", " ", "=", " ", 
     FractionBox[
      RowBox[{"c1", " ", "k2", " ", 
       SqrtBox["ReyC"]}], 
      RowBox[{"c2", " ", "dC", " ", 
       SuperscriptBox["k", "2"], " ", "v", " ", "x1"}]]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{"=", " ", "numberOfSteps"}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Amplification", " ", "functions", " ", "expressed", " ", "in", " ", 
     "terms", " ", "of", " ", "SI", " ", 
     RowBox[{"units", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorSI", "=", 
     RowBox[{"stateAmplificationFactor", "/.", 
      RowBox[{"{", 
       RowBox[{"k", "\[Rule]", 
        RowBox[{"2", "*", "Pi", "*", 
         RowBox[{"(", 
          RowBox[{"x1", "*", "LcharactSI"}], ")"}], "*", 
         RowBox[{"nuSI", "/", 
          RowBox[{"(", 
           RowBox[{"v", "*", "vFreestreamSI"}], ")"}]}]}]}], "}"}]}]}], ";"}],
    "  ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"for", " ", "y"}], "-", 
     RowBox[{"axis", " ", "as", " ", "a", " ", "frequency", " ", 
      SuperscriptBox["\[Nu]", "SI"]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stateAmplificationFactorSIPrint", "=", 
     RowBox[{"stateAmplificationFactorPrint", "/.", 
      RowBox[{"{", 
       RowBox[{"k", "\[Rule]", 
        RowBox[{"2", "*", "Pi", "*", 
         RowBox[{"(", 
          RowBox[{"x1", "*", "LcharactSI"}], ")"}], "*", 
         RowBox[{"nuSI", "/", 
          RowBox[{"(", 
           RowBox[{"v", "*", "vFreestreamSI"}], ")"}]}]}]}], "}"}]}]}], ";"}],
    "  ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"instabilityZoneSI", "=", 
     RowBox[{"D", "[", 
      RowBox[{"stateAmplificationFactorSI", ",", "x1"}], "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"the", " ", "local", " ", "maxima", " ", "and", " ", 
      RowBox[{"approx", ".", " ", "transition"}], " ", "point", " ", "are", 
      " ", "given", " ", "in", " ", "SI"}], "-", 
     RowBox[{"units", " ", 
      RowBox[{"(", 
       RowBox[{
       "light", " ", "blue", " ", "line", " ", "and", " ", "blue", " ", 
        "arrows", " ", "in", " ", "the", " ", 
        RowBox[{"plot", ":"}]}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1SItransitionPoint", "=", 
     RowBox[{"x1transitionPoint", "*", "LcharactSI"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"nuSItransitionPoint", "=", 
     RowBox[{"nuMaxSI", "/.", 
      RowBox[{"{", 
       RowBox[{"x1", "\[Rule]", "x1transitionPoint"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ReyInfTransitionPoint", "=", 
     RowBox[{"ReyInf", "/.", 
      RowBox[{"{", 
       RowBox[{"x1", "\[Rule]", "x1transitionPoint"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"text", " ", "output", " ", "in", " ", "SI"}], "-", 
     RowBox[{"units", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Approx. max. frequency:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    \!\(\*SubsuperscriptBox[\(\[Nu]\), \(max\), \
\(SI\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"N", "[", "nuMaxSI", "]"}], ",", "3"}], "]"}], ",", 
     "\"\< Hz.\\n\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Approx. transition point:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"addText", "=", 
     RowBox[{"\"\< = \>\"", "<>", 
      RowBox[{"ToString", "[", 
       RowBox[{"NumberForm", "[", 
        RowBox[{"x1transitionPoint", ",", "3"}], "]"}], "]"}], "<>", 
      "\"\< \!\(\*SubscriptBox[\(l\), \(c\)]\),\>\""}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    \!\(\*SubsuperscriptBox[\(x\), \(trans\), \
\(SI\)]\)(\!\(\*SubscriptBox[\(N\), \(trans\)]\)=\>\"", ",", "Ntrans", ",", 
     "\"\<) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"x1SItransitionPoint", ",", "3"}], "]"}], ",", "\"\< m\>\"", 
     ",", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x1AxisScaling", "!=", "1"}], ",", "addText", ",", 
       "\"\<,\>\""}], "]"}]}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    \!\(\*SubscriptBox[\(Re\), \(\[Infinity]\)]\)( \
\!\(\*SubsuperscriptBox[\(x\), \(1\), \(SI\)]\) = \!\(\*SubsuperscriptBox[\(x\
\), \(trans\), \(SI\)]\) ) = \>\"", ",", 
     RowBox[{"ScientificForm", "[", "ReyInfTransitionPoint", "]"}], ",", 
     "\"\<.\\n\>\""}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", "plot", " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Scale", " ", "to", " ", "the", " ", "units", " ", "of", " ", "the", " ",
       "plot"}], ";", " ", 
     RowBox[{
      RowBox[{"at", " ", "the", " ", "time", " ", "only", " ", 
       SubsuperscriptBox["x", "1", "SI"], " ", "or", " ", 
       SubscriptBox["x", "1"]}], " ", "=", " ", 
      RowBox[{
       RowBox[{
        SubsuperscriptBox["x", 
         RowBox[{"1", " "}], "SI"], "/", 
        SubscriptBox["l", "c"]}], " ", "and", " ", 
       SuperscriptBox["\[Nu]", "SI"], " ", "axes", " ", "are", " ", 
       RowBox[{"implemented", ":"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"y", "-", 
      RowBox[{"axis", " ", "scaled", " ", "from", " ", "k", 
       RowBox[{"(", "dimensionless", ")"}], " ", "to", " ", "SI"}], "-", 
      RowBox[{"frequency", " ", 
       SuperscriptBox["\[Nu]", "SI"]}]}], ";", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["x", "1"], "-", 
       RowBox[{"axis", " ", "from", " ", 
        SubsuperscriptBox["x", "1", "SI"], " ", "to", " ", 
        SubscriptBox["x", "1"], 
        RowBox[{"(", "dimensionless", ")"}], " ", "if", " ", 
        "x1AxisScaling"}]}], " ", "\[NotEqual]", " ", "1"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{"1", "/", "x1AxisScaling"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      SubsuperscriptBox["x", 
       RowBox[{"1", " "}], "SI"], "-", 
      RowBox[{
      "axis", " ", "scaling", " ", "factor", " ", "for", " ", "alternate", 
       " ", "units"}]}], ";", " ", 
     RowBox[{
     "at", " ", "the", " ", "time", " ", "only", " ", "to", " ", "introduce", 
      " ", "a", " ", "standard", " ", "chord", " ", "length", " ", 
      SubscriptBox["l", "c"]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"b", "=", "1"}], ";"}], "                                 ", 
   RowBox[{"(*", " ", 
    RowBox[{"y", "-", 
     RowBox[{
     "axis", " ", "scaling", " ", "factor", " ", "for", " ", "alternate", " ",
       "units"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xMin", "=", 
     RowBox[{"a", "*", "xMin"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xMax", "=", 
     RowBox[{"a", "*", "xMax"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yMin", "=", 
     RowBox[{"b", "*", "yMin"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yMax", "=", 
     RowBox[{"b", "*", "yMax"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Define", " ", "the", " ", "colored", " ", "contours", " ", "of", " ", 
     "the", " ", 
     RowBox[{"stateAmplificationFactor", ":"}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zMin", "=", "0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "get", " ", "zMax", " ", "from", " ", "the", " ", "setup", " ", 
     "parameters", " ", "to", " ", "allow", " ", "different", " ", 
     RowBox[{"scaling", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zNoofContours", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zContourList", "=", 
     RowBox[{"zMin", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"zMax", "-", "zMin"}], ")"}], "/", "zNoofContours"}], "*", 
       RowBox[{"Range", "[", 
        RowBox[{"1", ",", "zNoofContours"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"zColorFunction", "=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Blend", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"White", ",", "Yellow", ",", "Orange", ",", 
           RowBox[{"Darker", "[", "Red", "]"}], ",", "Black"}], "}"}], ",", 
         "#1"}], "]"}], "&"}], ")"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Define", " ", "the", " ", "contours", " ", "of", " ", "the", " ", 
      "instability", " ", "zone", " ", 
      RowBox[{"(", 
       RowBox[{"black", " ", "lines"}], ")"}]}], ":"}], " ", "*)"}], "\n", 
   RowBox[{
    RowBox[{"z2Min", "=", "9"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z2Max", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z2NoofContours", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"z2ContourList", "=", 
     RowBox[{"z2Min", "+", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"z2Max", "-", "z2Min"}], ")"}], "/", "z2NoofContours"}], "*", 
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "z2NoofContours"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<The plotted contours of the instability zone (black solid lines) are \
at \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"N", "[", "z2ContourList", "]"}], ",", "3"}], "]"}], ",", 
     "\"\<.\\n\>\""}], "]"}], "\n", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "Find", " ", "local", " ", "maxima", " ", "of", " ", "the", " ", 
      "instability", " ", "zone", " ", "using", " ", "a", " ", "simple", " ", 
      "numeric", " ", "fit", " ", 
      RowBox[{"(", 
       RowBox[{"black", " ", "dashed", " ", "line"}], ")"}]}], ":"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "the", " ", "fit", " ", "starts", " ", "at", " ", "the", " ", "bottom", 
     " ", "right", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"highest", " ", 
        SubscriptBox["x", "1"]}], ",", " ", 
       RowBox[{"lowest", " ", 
        SuperscriptBox["\[Nu]", "SI"]}]}], ")"}], " ", "and", " ", "uses", 
     " ", "that", " ", "the", " ", "frequency", " ", "of", " ", "the", " ", 
     "maxima", " ", "increase", " ", "with", " ", "lower", " ", 
     RowBox[{
      SubscriptBox["x", "1"], "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "the", " ", "search", " ", "for", " ", "a", " ", "maximum", " ", "starts",
      " ", "for", " ", "each", " ", 
     SubscriptBox["x", "1"], " ", "at", " ", "the", " ", "previous", " ", 
     RowBox[{"max", ".", " ", "frequeny"}], " ", "and", " ", "stops", " ", 
     "as", " ", "soon", " ", "as", " ", "the", " ", "value", " ", "gets", " ",
      "lower", " ", 
     RowBox[{"again", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "this", " ", "ensures", " ", "a", " ", "fast", " ", "performance"}], ",",
      " ", 
     RowBox[{
     "but", " ", "may", " ", "be", " ", "instable", " ", "if", " ", 
      "different", " ", "geometries", " ", "are", " ", 
      RowBox[{"plotted", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataMax", "=", 
     RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"noOfPointsx", "=", "40"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"noOfPointsy", "=", "200"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"jStart", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"For", "[", " ", 
     RowBox[{
      RowBox[{"i", "=", "noOfPointsx"}], ",", " ", 
      RowBox[{"i", ">", "0"}], ",", 
      RowBox[{"i", "--"}], ",", " ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"deltax", "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"xMax", "-", "xMin"}], ")"}], "/", "noOfPointsx"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"xNum", "=", 
        RowBox[{"xMin", "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"i", "+", "1"}], ")"}], "*", "deltax"}]}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"valueMax", "=", "0"}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", " ", 
        RowBox[{
         RowBox[{"j", "=", "jStart"}], ",", " ", 
         RowBox[{"j", "\[LessEqual]", "noOfPointsy"}], ",", 
         RowBox[{"j", "++"}], ",", " ", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"deltay", "=", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"yMax", "-", "yMin"}], ")"}], "/", "noOfPointsy"}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"yNum", "=", 
           RowBox[{"yMin", "+", 
            RowBox[{"j", "*", "deltay"}]}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"value", "=", 
           RowBox[{"instabilityZoneSI", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x1", "\[Rule]", "xNum"}], ",", 
              RowBox[{"nuSI", "\[Rule]", "yNum"}]}], "}"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"(*", 
           RowBox[{
            RowBox[{"value", "=", 
             RowBox[{"stateAmplificationFactorSI", "/.", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x1", "\[Rule]", "xNum"}], ",", 
                RowBox[{"nuSI", "\[Rule]", "yNum"}]}], "}"}]}]}], ";"}], 
           "*)"}], 
          RowBox[{"(*", " ", 
           RowBox[{
           "alternative", " ", "to", " ", "show", " ", "the", " ", "maximum", 
            " ", "N", " ", "of", " ", "the", " ", "amplification", " ", 
            "factor", " ", "n", " ", "without", " ", "the", " ", 
            RowBox[{"approximations", "."}]}], " ", "*)"}], 
          "\[IndentingNewLine]", " ", 
          RowBox[{"yNumMax", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"value", ">", "valueMax"}], ",", "yNum", ",", 
             "yNumMax"}], "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"jStart", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"value", ">", "valueMax"}], ",", "j", ",", "jStart"}], 
            "]"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"valueMax", "=", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"value", ">=", "valueMax"}], ",", "value", ",", 
             RowBox[{"Break", "[", "]"}]}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"yNumMax", "\[GreaterEqual]", "yMax"}], ",", 
         RowBox[{"Break", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"dataMax", ",", 
         RowBox[{"{", 
          RowBox[{"xNum", ",", "yNumMax"}], "}"}]}], "]"}], ";"}]}], 
     "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"smooth", " ", "the", " ", 
     RowBox[{"line", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataMax", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"dataMax", "[", 
          RowBox[{"[", 
           RowBox[{"n", ",", "1"}], "]"}], "]"}], ",", 
         RowBox[{"Mean", "[", 
          RowBox[{"dataMax", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{
              RowBox[{"n", "-", "1"}], ";;", 
              RowBox[{"n", "+", "1"}]}], ",", "2"}], "]"}], "]"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "2", ",", 
         RowBox[{
          RowBox[{"Length", "@", "dataMax"}], "-", "1"}]}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"set", " ", "plot", " ", "range", " ", "and", " ", 
     RowBox[{"labels", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotRange", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"xMin", ",", "xMax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"yMin", ",", "yMax"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"frameLabelx", "=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"x1AxisScaling", "==", "1"}], ",", 
       "\"\<\!\(\*SubsuperscriptBox[\(x\), \(1\), \(SI\)]\) [m]\>\"", ",", 
       "\"\<\!\(\*SubscriptBox[\(x\), \(\(1\)\(\\\ \)\(=\)\(\\\ \
\)\)]\)\!\(\*SubsuperscriptBox[\(x\), \(1\), \(SI\)]\) / \
\!\(\*SubscriptBox[\(l\), \(c\)]\)\>\""}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
    "frameLabely", "=", 
     "\"\<\!\(\*SuperscriptBox[\(\[Nu]\), \(SI\)]\) [Hz]\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"frameLabels", "=", 
     RowBox[{"{", 
      RowBox[{"frameLabelx", ",", "frameLabely"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"state", " ", "amplification", " ", "factor", " ", 
      RowBox[{"(", 
       RowBox[{"colored", " ", "contours"}], ")"}]}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt1", "=", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{"stateAmplificationFactorSI", ",", 
       RowBox[{"{", 
        RowBox[{"x1", ",", "xMin", ",", "xMax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nuSI", ",", "yMin", ",", "yMax"}], "}"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", "stdLabelStyle"}], ",", 
       RowBox[{"Contours", "\[Rule]", "zContourList"}], ",", 
       RowBox[{"ContourStyle", "\[Rule]", "None"}], ",", 
       RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
       RowBox[{"ColorFunction", "\[Rule]", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"zColorFunction", "@", 
           RowBox[{"Rescale", "[", 
            RowBox[{"#1", ",", 
             RowBox[{"{", 
              RowBox[{"zMin", ",", "zMax"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", "1"}], "}"}]}], "]"}]}], "&"}], ")"}]}], ",", 
       RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plt1b", "=", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{"stateAmplificationFactor", ",", 
       RowBox[{"{", 
        RowBox[{"x1", ",", "xMin", ",", "xMax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "yMin", ",", "yMax"}], "}"}], ",", 
       RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], " ", "*)"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "separate", " ", "plot", " ", "to", " ", "show", " ", "the", " ", 
     "amplification", " ", "factor", " ", "as", " ", "a", " ", "function", 
     " ", "of", " ", 
     RowBox[{"k", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"instability", " ", "zone", " ", 
      RowBox[{"(", 
       RowBox[{"black", " ", "lines"}], ")"}]}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt2", "=", 
     RowBox[{"ContourPlot", "[", 
      RowBox[{"instabilityZoneSI", ",", 
       RowBox[{"{", 
        RowBox[{"x1", ",", "xMin", ",", "xMax"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"nuSI", ",", "yMin", ",", "yMax"}], "}"}], ",", 
       RowBox[{"Contours", "\[Rule]", "z2ContourList"}], ",", " ", 
       RowBox[{"ContourStyle", "\[Rule]", "Black"}], ",", 
       RowBox[{"ContourShading", "\[Rule]", "None"}], ",", 
       RowBox[{"PlotLegends", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"max", ".", " ", "instability"}], " ", 
      RowBox[{"(", 
       RowBox[{"black", " ", "dashed", " ", "line"}], ")"}]}], ":"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt3", "=", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{"dataMax", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", 
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{"0.03", ",", "0.01"}], "}"}], "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"max", ".", " ", "amplified"}], " ", "frequency", " ", 
      RowBox[{"(", 
       RowBox[{"light", " ", "blue", " ", "line"}], ")"}]}], ":"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt4", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"nuMaxSI", ",", 
       RowBox[{"{", 
        RowBox[{"x1", ",", "0.25", ",", "xMax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"LightBlue", ",", 
          RowBox[{"Dashing", "[", 
           RowBox[{"{", 
            RowBox[{"0.03", ",", "0.01"}], "}"}], "]"}], ",", 
          RowBox[{"Thickness", "[", "0.01", "]"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"transition", " ", "point", " ", 
      RowBox[{"(", 
       RowBox[{"blue", " ", "arrows"}], ")"}]}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "line", " ", "and", " ", "arrowhead", " ", "in", " ", "separate", " ", 
      "parts", " ", "for", " ", "better", " ", "pdf"}], "-", "export"}], " ", 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowLength", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"yMax", "-", "yMin"}], ")"}], "/", "5"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowLineOffset", "=", " ", "100"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"arrowTopOffset", " ", "=", " ", "15"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt5", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Lighter", "[", 
         RowBox[{"Lighter", "[", "Blue", "]"}], "]"}], ",", 
        RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1transitionPoint", ",", 
             RowBox[{"nuSItransitionPoint", "+", "arrowLength"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"x1transitionPoint", ",", 
             RowBox[{"nuSItransitionPoint", "+", "arrowLineOffset"}]}], 
            "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1transitionPoint", ",", 
             RowBox[{"nuSItransitionPoint", "-", "arrowLength"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"x1transitionPoint", ",", 
             RowBox[{"nuSItransitionPoint", "-", "arrowLineOffset"}]}], 
            "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt6", "=", 
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Lighter", "[", 
         RowBox[{"Lighter", "[", "Blue", "]"}], "]"}], ",", 
        RowBox[{"Thickness", "[", "0.00001", "]"}], ",", 
        RowBox[{"Arrowheads", "[", "0.05", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1transitionPoint", ",", 
             RowBox[{"nuSItransitionPoint", "+", "arrowLength"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"x1transitionPoint", ",", 
             RowBox[{"nuSItransitionPoint", "+", "arrowTopOffset"}]}], 
            "}"}]}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1transitionPoint", ",", 
             RowBox[{"nuSItransitionPoint", "-", "arrowLength"}]}], "}"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"x1transitionPoint", ",", 
             RowBox[{"nuSItransitionPoint", "-", "arrowTopOffset"}]}], 
            "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", " ", 
     RowBox[{"everything", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"plot", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "plt1", ",", "plt2", ",", "plt3", ",", "plt4", ",", "plt5", ",", "plt6", 
      ",", 
      RowBox[{"LabelStyle", "\[Rule]", "stdLabelStyle"}], ",", 
      RowBox[{"Frame", "\[Rule]", "stdFrame"}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", "frameLabels"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "plotRange"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"1", "/", "1.62"}]}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "450"}]}], "]"}]}], "\n", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "additional", " ", "plot", " ", "with", " ", "the", " ", "angular", " ", 
     "dependency", " ", "of", " ", "\[CapitalDelta]p", 
     RowBox[{"(", "\[Theta]", ")"}], " ", "and", " ", "d\[Sigma]", 
     RowBox[{"(", "\[Theta]", ")"}], " ", "at", " ", "specific", " ", 
     "points", " ", 
     SubscriptBox["x", "1"], " ", "and", " ", 
     RowBox[{"k", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x1", "=", "x1Zero"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"k", "=", "kZero"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotRange", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0.0001"}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FontSizeCrossection", "=", "stdFontSize"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "insert", " ", "a", " ", "different", " ", "font", " ", "size", " ", "if",
      " ", 
     RowBox[{"needed", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LabelStyleCrossection", "=", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontSize", "\[Rule]", "FontSizeCrossection"}], ",", 
       "stdFontColor", ",", 
       RowBox[{"FontFamily", "\[Rule]", "stdFontFamily"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"frameLabels", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<scattering angle \[Theta] [rad]\>\"", ",", 
       "\"\<\[CapitalDelta]p/\!\(\*SubscriptBox[\(p\), \(init\)]\)\>\"", ",", 
       "\"\<\>\"", ",", 
       "\"\<d\[Sigma]/\!\(\*SubscriptBox[\(d\[CapitalOmega]\), \
\(p\)]\)\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"legend", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<momentum transfer \[CapitalDelta]p/\!\(\*SubscriptBox[\(p\), \
\(init\)]\)\>\"", ",", 
       "\"\<cross section \!\(\*FractionBox[\(d\[Sigma]\), SubscriptBox[\(d\
\[CapitalOmega]\), \(p\)]]\)\>\""}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"padding", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"55", ",", "105"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"50", ",", "10"}], "}"}]}], "}"}]}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "in", " ", "order", " ", "to", " ", "show", " ", "the", " ", "legend", 
     " ", "on", " ", "the", " ", "right", " ", "axis", " ", 
     RowBox[{"correctly", ".", " ", 
      RowBox[{"Format", ":", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"left", ",", "right"}], "}"}], 
        RowBox[{"{", 
         RowBox[{"bottom", ",", "top"}], "}"}]}]}]}]}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"size", "=", 
     RowBox[{"450", "+", "160"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<\\n\\nAngular dependency of \[CapitalDelta]p(\[Theta]) and \
d\[Sigma](\[Theta]) at specific point \!\(\*SubscriptBox[\(x\), \
\(1\)]\)=\>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"N", "[", "x1", "]"}], ",", "3"}], "]"}], ",", 
     "\"\< and k=\>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"N", "[", "k", "]"}], ",", "3"}], "]"}], ",", "\"\<:\>\""}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt1b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"deltap", "/", "pVortexInit"}], ",", 
       RowBox[{"{", 
        RowBox[{"theta", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", "Red", "}"}]}], ",", 
       RowBox[{"ImagePadding", "->", "padding"}], ",", 
       RowBox[{"Frame", "->", 
        RowBox[{"{", 
         RowBox[{"True", ",", "True", ",", "True", ",", "False"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "->", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Black", ",", "Automatic", ",", "Automatic"}], 
         "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "stdFrame"}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", "frameLabels"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", "LabelStyleCrossection"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "plotRange"}], ",", 
       RowBox[{"AxesOrigin", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "size"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt2b", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{"dsigma", ",", 
       RowBox[{"{", 
        RowBox[{"theta", ",", "0", ",", 
         RowBox[{"2", "Pi"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Black", ",", "Dashed"}], "}"}]}], ",", 
       RowBox[{"ImagePadding", "->", "padding"}], ",", 
       RowBox[{"Axes", "->", "False"}], ",", 
       RowBox[{"Frame", "->", 
        RowBox[{"{", 
         RowBox[{"False", ",", "False", ",", "False", ",", "True"}], "}"}]}], 
       ",", 
       RowBox[{"FrameStyle", "->", 
        RowBox[{"{", 
         RowBox[{
         "Automatic", ",", "Automatic", ",", "Automatic", ",", "Black"}], 
         "}"}]}], ",", 
       RowBox[{"FrameTicks", "->", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"None", ",", "All"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"None", ",", "None"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "stdFrame"}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", "frameLabels"}], ",", 
       RowBox[{"LabelStyle", "\[Rule]", "LabelStyleCrossection"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "plotRange"}], ",", 
       RowBox[{"AxesOrigin", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "size"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot", "=", 
     RowBox[{"Overlay", "[", 
      RowBox[{"{", 
       RowBox[{"plt1b", ",", "plt2b"}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Legended", "[", 
    RowBox[{"plot", ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"Framed", "[", 
        RowBox[{
         RowBox[{"LineLegend", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Directive", "[", "Red", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"Black", ",", "Dashed"}], "}"}]}], "}"}], ",", "legend",
            ",", 
           RowBox[{"LabelStyle", "\[Rule]", "LabelStyleCrossection"}]}], 
          "]"}], ",", 
         RowBox[{"Background", "\[Rule]", "White"}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", "Thin"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.45", ",", "0.75"}], "}"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\n", "\n", "\[IndentingNewLine]", "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Clear", " ", "some", " ", "of", " ", "the", " ", "numerical", " ", 
     "values", " ", "to", " ", "get", " ", "some", " ", "formulae", " ", "in",
      " ", "a", " ", "simple", " ", "but", " ", "useful", " ", 
     RowBox[{"form", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<\\n\\n--- Formulae with some values cleared to show the main \
dependencies ---\>\"", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Clear", "[", 
    RowBox[{
    "k", ",", "x1", ",", "LcharactSI", ",", "Ntrans", ",", "ReyC", ",", 
     "vFreestreamSI"}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", 
    "\"\<Approx. max. wavenumber (dimensionless) and frequency (in Hz):\>\"", 
    " ", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    \!\(\*SubscriptBox[\(k\), \(max\)]\)(\!\(\*SubscriptBox[\(x\), \
\(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "kMax", "]"}], ",", "3"}], "]"}], ",", 
     "\"\<.\>\""}], " ", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    \!\(\*SubsuperscriptBox[\(\[Nu]\), \(max\), \(\(SI\)\(\\\ \
\)\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"FullSimplify", "[", "nuMaxSI", "]"}], ",", "3"}], "]"}], ",", 
     "\"\<.\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
   "Print", "[", "\"\<Approx. max. amplification factor:\>\"", " ", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"\"\<    N(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"PowerExpand", "[", "stateAmplificationFactorMax", "]"}], ",", 
       "3"}], "]"}], ",", "\"\<.\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<Approx. transition point:\>\"", "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<    \!\(\*SubscriptBox[\(x\), \(\(trans\)\(\\\ \
\)\)]\)(\!\(\*SubscriptBox[\(N\), \(trans\)]\)) = \>\"", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{
       RowBox[{"PowerExpand", "[", "x1transitionPoint", "]"}], ",", "3"}], 
      "]"}], ",", "\"\<.\>\""}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", "\"\<\\n\\n\>\"", "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.8166195271749687`*^9, 3.81661955521344*^9}, 
   3.81661980676755*^9, {3.816620076157399*^9, 3.8166200805574226`*^9}, {
   3.8166201450973415`*^9, 3.816620175744911*^9}, {3.816703767905548*^9, 
   3.8167038585070963`*^9}, 3.816703987207157*^9, {3.816704418804448*^9, 
   3.8167044502266903`*^9}, 3.816704684069146*^9, 3.8167047353760924`*^9, 
   3.8167047916950665`*^9, {3.8167048678345737`*^9, 3.816704868611332*^9}, 
   3.8167049257828803`*^9, 3.816705055117876*^9, {3.8167050942338257`*^9, 
   3.8167051629035206`*^9}, 3.816705263598325*^9, {3.8167052953271785`*^9, 
   3.8167052989221296`*^9}, {3.816705350180917*^9, 3.8167055795699377`*^9}, {
   3.816705619365537*^9, 3.816705620356825*^9}, {3.8167645231568036`*^9, 
   3.816764576654979*^9}, {3.816765000197669*^9, 3.816765022890676*^9}, {
   3.8167650873190804`*^9, 3.8167651112715535`*^9}, {3.8167651513817225`*^9, 
   3.8167651937691574`*^9}, {3.81676528256894*^9, 3.816765285746037*^9}, {
   3.816765322400622*^9, 3.8167653327539353`*^9}, {3.816765444947116*^9, 
   3.8167654516801453`*^9}, {3.8167654848634424`*^9, 3.816765515413443*^9}, {
   3.8167655872179537`*^9, 3.816765678733163*^9}, {3.8167661672124224`*^9, 
   3.8167662447466717`*^9}, {3.816766288135031*^9, 3.816766384965453*^9}, {
   3.8167664851814427`*^9, 3.816766592024791*^9}, {3.8167666261560187`*^9, 
   3.8167666580237203`*^9}, {3.816771014953449*^9, 3.8167710577136774`*^9}, {
   3.8167711019998446`*^9, 3.8167712956905775`*^9}, {3.8167713274910135`*^9, 
   3.816771446209262*^9}, {3.8167714884788885`*^9, 3.816771528728882*^9}, {
   3.8167716649603357`*^9, 3.8167717291648655`*^9}, {3.816774700666668*^9, 
   3.8167748609603057`*^9}, {3.8167749276400633`*^9, 
   3.8167751265238914`*^9}, {3.8167752217635565`*^9, 3.816775223356108*^9}, {
   3.8167753550132647`*^9, 3.816775389605071*^9}, {3.816775444849697*^9, 
   3.8167754600956726`*^9}, {3.8167755354108624`*^9, 
   3.8167758553119144`*^9}, {3.8167758980416565`*^9, 3.816776022941982*^9}, {
   3.8167761694217663`*^9, 3.8167761933307357`*^9}, {3.8167762487495193`*^9, 
   3.816776297241479*^9}, {3.816776353596321*^9, 3.8167764429061794`*^9}, {
   3.816776474697996*^9, 3.8167765203084793`*^9}, {3.8167767185688086`*^9, 
   3.8167767590406103`*^9}, {3.8167768678182917`*^9, 3.816776895626169*^9}, 
   3.8167770276472187`*^9, {3.8167770688385487`*^9, 3.8167771557084255`*^9}, {
   3.816777219426461*^9, 3.816777276467681*^9}, {3.816777398546847*^9, 
   3.8167774490108037`*^9}, {3.81677748440705*^9, 3.8167774905763693`*^9}, 
   3.816777548768838*^9, {3.816777657554753*^9, 3.816777679579337*^9}, {
   3.816777720628846*^9, 3.8167777220515833`*^9}, {3.8167777537074337`*^9, 
   3.8167778313206472`*^9}, {3.816777875945901*^9, 3.816777879890391*^9}, {
   3.816777941533331*^9, 3.8167779466158495`*^9}, 3.8167779869395747`*^9, {
   3.81677803695849*^9, 3.8167781574154854`*^9}, {3.816778187594638*^9, 
   3.8167781885214834`*^9}, {3.816778223820016*^9, 3.816778238130581*^9}, {
   3.8167782711938963`*^9, 3.816778287036583*^9}, {3.816778340283223*^9, 
   3.8167783591389823`*^9}, {3.8167784734542737`*^9, 3.81677851883949*^9}, {
   3.816778706439227*^9, 3.816778795467581*^9}, {3.8167789013697767`*^9, 
   3.816778947172907*^9}, {3.8167789794577007`*^9, 3.8167789894681015`*^9}, {
   3.816779300770603*^9, 3.8167793373668947`*^9}, 3.816783494649802*^9, {
   3.816783918573648*^9, 3.816783920285783*^9}, {3.8167839601384325`*^9, 
   3.816783979327485*^9}, {3.8167840103035555`*^9, 3.8167840210119257`*^9}, 
   3.816784094629591*^9, {3.8167844160437703`*^9, 3.8167844177805386`*^9}, {
   3.816784461382882*^9, 3.816784469550577*^9}, {3.8167845158627405`*^9, 
   3.8167845275378523`*^9}, {3.8167845592118673`*^9, 3.816784579152076*^9}, {
   3.8167846435392103`*^9, 3.816784667260543*^9}, {3.816784799338584*^9, 
   3.816784825137705*^9}, 3.8167850786287484`*^9, {3.816785229598446*^9, 
   3.8167852299922886`*^9}, {3.8167852614505434`*^9, 3.816785289301817*^9}, {
   3.816785326221343*^9, 3.8167853325007367`*^9}, {3.816785368053053*^9, 
   3.816785417496525*^9}, {3.8167854736698*^9, 3.8167854788468328`*^9}, {
   3.8167856308702884`*^9, 3.8167857063559866`*^9}, {3.8167857687500734`*^9, 
   3.8167857704312687`*^9}, {3.8167858132431154`*^9, 3.816785821994396*^9}, {
   3.8167859841255083`*^9, 3.816785992699479*^9}, {3.81678610441462*^9, 
   3.816786146056204*^9}, {3.816786228371227*^9, 3.8167862617921343`*^9}, {
   3.8167867114381*^9, 3.816786711769719*^9}, 3.8167871089711323`*^9, {
   3.81678725363179*^9, 3.8167872538842897`*^9}, {3.8167872966943583`*^9, 
   3.816787327873907*^9}, {3.8167873678941755`*^9, 3.8167873715112824`*^9}, {
   3.816787493287614*^9, 3.8167875077404275`*^9}, {3.816787543408877*^9, 
   3.816787588839447*^9}, {3.8167876236133423`*^9, 3.8167876509359894`*^9}, {
   3.816787682061202*^9, 3.816787684148549*^9}, {3.816787768320526*^9, 
   3.8167877793576574`*^9}, {3.816787812098383*^9, 3.8167878357794514`*^9}, {
   3.8167879029454637`*^9, 3.8167879510934634`*^9}, {3.8167879925851383`*^9, 
   3.816787993884492*^9}, {3.8167880473339396`*^9, 3.816788047711935*^9}, {
   3.816788080012375*^9, 3.816788125866831*^9}, {3.8167884730020075`*^9, 
   3.8167886180916357`*^9}, {3.8167886482395005`*^9, 
   3.8167886758701563`*^9}, {3.816858132490307*^9, 3.8168581331383643`*^9}, {
   3.8168582672942424`*^9, 3.8168582868803945`*^9}, {3.816858341827121*^9, 
   3.816858567695038*^9}, {3.8168586568695683`*^9, 3.816858657713292*^9}, {
   3.816858788580636*^9, 3.8168588549938245`*^9}, {3.81685888746275*^9, 
   3.816858891757286*^9}, {3.8168589397789416`*^9, 3.8168589782338486`*^9}, {
   3.8168590492594132`*^9, 3.8168590495345945`*^9}, {3.816861120300139*^9, 
   3.8168612175096846`*^9}, {3.8168613624365253`*^9, 
   3.8168614091500683`*^9}, {3.816861742212905*^9, 3.816861831439683*^9}, {
   3.816862446515606*^9, 3.8168624594775777`*^9}, {3.816862756967491*^9, 
   3.816862763277685*^9}, {3.816862825343748*^9, 3.8168628552751865`*^9}, {
   3.8168628999370127`*^9, 3.8168629531542034`*^9}, {3.8168633383442626`*^9, 
   3.8168633410574217`*^9}, {3.8168633744992504`*^9, 
   3.8168634006763926`*^9}, {3.8168634529654117`*^9, 3.816863496825493*^9}, {
   3.816863543893189*^9, 3.816863544279213*^9}, {3.8168638250175796`*^9, 
   3.816863891440378*^9}, {3.8168639793740587`*^9, 3.8168639796464095`*^9}, {
   3.81686442387024*^9, 3.816864481145572*^9}, {3.81686572430958*^9, 
   3.816865790127549*^9}, {3.8168675748365726`*^9, 3.816867598379322*^9}, {
   3.816867639152052*^9, 3.8168676814782104`*^9}, {3.8168677272306976`*^9, 
   3.8168677413361998`*^9}, {3.8168729199777393`*^9, 
   3.8168729990954895`*^9}, {3.8168730393997645`*^9, 3.816873039967984*^9}, {
   3.8168731027418184`*^9, 3.8168732380413723`*^9}, {3.8168732711484604`*^9, 
   3.8168733409932146`*^9}, {3.816873397709267*^9, 3.8168733987937236`*^9}, {
   3.8168735417156053`*^9, 3.8168735446602616`*^9}, {3.816873587982319*^9, 
   3.816873588128044*^9}, {3.8168736185954623`*^9, 3.8168736511478825`*^9}, {
   3.8168736839189177`*^9, 3.816873689033457*^9}, {3.8168737254775457`*^9, 
   3.816873756187727*^9}, {3.8168761542391677`*^9, 3.8168761797154408`*^9}, {
   3.8168762153822002`*^9, 3.8168762160024567`*^9}, {3.816876273219187*^9, 
   3.8168762845278797`*^9}, {3.816876514989414*^9, 3.816876532329773*^9}, {
   3.816876615274119*^9, 3.816876695908514*^9}, {3.8168767375568333`*^9, 
   3.8168767381336284`*^9}, {3.816876769064997*^9, 3.816876769250306*^9}, {
   3.816876805393076*^9, 3.8168768092521005`*^9}, {3.816878902900546*^9, 
   3.816878943522462*^9}, {3.816878977061079*^9, 3.8168790579615555`*^9}, {
   3.816879235910691*^9, 3.8168792360579386`*^9}, {3.8168792913439016`*^9, 
   3.816879321838767*^9}, {3.8168794615473747`*^9, 3.8168794625117235`*^9}, {
   3.8168795365565295`*^9, 3.816879584667488*^9}, {3.816879626101487*^9, 
   3.816879709041027*^9}, {3.8168797593549685`*^9, 3.8168797600782495`*^9}, {
   3.8168803227920113`*^9, 3.8168804841078477`*^9}, {3.8168807430187397`*^9, 
   3.8168807443397846`*^9}, {3.8168807823744297`*^9, 
   3.8168807826714535`*^9}, {3.816888988345521*^9, 3.8168892176196527`*^9}, {
   3.816889328345499*^9, 3.8168894590793524`*^9}, {3.8168905979206686`*^9, 
   3.8168906524709697`*^9}, {3.8168908420317025`*^9, 3.816890842431903*^9}, {
   3.8168949089388247`*^9, 3.8168949804275146`*^9}, {3.8168950298201265`*^9, 
   3.8168950359723706`*^9}, {3.8169002382316437`*^9, 3.816900388406011*^9}, {
   3.81690074202352*^9, 3.816900841470394*^9}, {3.8169008942750664`*^9, 
   3.8169011557390776`*^9}, {3.8169495820126047`*^9, 
   3.8169496125303593`*^9}, {3.8169496632458887`*^9, 
   3.8169497156077957`*^9}, {3.8169497457830563`*^9, 3.816949803950028*^9}, {
   3.8169498347872066`*^9, 3.8169498888609247`*^9}, {3.8169499361795397`*^9, 
   3.816950036264544*^9}, {3.816950068415143*^9, 3.8169501655602407`*^9}, {
   3.81695020422227*^9, 3.8169503069665327`*^9}, {3.816950446391597*^9, 
   3.8169504587859344`*^9}, {3.8169507245750847`*^9, 3.816950757646279*^9}, {
   3.8169507891416283`*^9, 3.816950824839487*^9}, {3.816952533234356*^9, 
   3.8169526766494236`*^9}, {3.816952723465513*^9, 3.8169529025847225`*^9}, {
   3.816952946043475*^9, 3.8169530344810257`*^9}, {3.816953077079364*^9, 
   3.816953336554332*^9}, {3.8169535503584533`*^9, 3.8169536651447287`*^9}, {
   3.816953717496043*^9, 3.816953869465557*^9}, {3.8169539011735144`*^9, 
   3.816953901405655*^9}, {3.8169557315634394`*^9, 3.8169557322530565`*^9}, {
   3.8169557731828213`*^9, 3.8169557944642477`*^9}, {3.8169558612266417`*^9, 
   3.816955893722804*^9}, {3.8169570496661544`*^9, 3.8169570742706933`*^9}, {
   3.816957122686183*^9, 3.816957142488408*^9}, {3.816957204671417*^9, 
   3.816957234139619*^9}, {3.816957512950388*^9, 3.816957543134062*^9}, {
   3.8169576197620697`*^9, 3.8169576276919217`*^9}, {3.8169576666586065`*^9, 
   3.816957737587728*^9}, 3.8169595245728593`*^9, {3.8169597421844068`*^9, 
   3.8169597432415614`*^9}, {3.816959832454685*^9, 3.8169599198532276`*^9}, {
   3.816960572743409*^9, 3.816960594212665*^9}, {3.8169606324427166`*^9, 
   3.8169606326734934`*^9}, {3.816960664168301*^9, 3.816960713261469*^9}, {
   3.816960874199293*^9, 3.8169608751530495`*^9}, {3.816960929486058*^9, 
   3.816960930052394*^9}, {3.816961336686552*^9, 3.816961336913958*^9}, {
   3.816961396508043*^9, 3.8169614565058436`*^9}, {3.816961546392293*^9, 
   3.816961547121122*^9}, {3.816961584231634*^9, 3.816961648199772*^9}, {
   3.816961703247306*^9, 3.816961726835024*^9}, {3.816961784191128*^9, 
   3.81696178894261*^9}, {3.816961904231619*^9, 3.81696194499772*^9}, {
   3.8169619964178123`*^9, 3.8169619987600985`*^9}, {3.8169620414115744`*^9, 
   3.81696205966539*^9}, {3.8169620984296784`*^9, 3.8169620992011003`*^9}, {
   3.816962134502247*^9, 3.8169622136321077`*^9}, {3.816962276135977*^9, 
   3.8169623323784685`*^9}, {3.816962388009158*^9, 3.8169623894269624`*^9}, {
   3.816962425986354*^9, 3.816962426506774*^9}, {3.8169624621640415`*^9, 
   3.8169624830924234`*^9}, {3.816962724374587*^9, 3.8169627756243095`*^9}, 
   3.81696282093087*^9, {3.816962882916239*^9, 3.8169629665029116`*^9}, {
   3.8169673780642853`*^9, 3.8169673788667707`*^9}, {3.8169676833176737`*^9, 
   3.8169678893562984`*^9}, {3.81696792805268*^9, 3.8169679282545776`*^9}, {
   3.8169679641497803`*^9, 3.8169679661042156`*^9}, {3.8169696112688513`*^9, 
   3.816969700543922*^9}, {3.816969733605445*^9, 3.816969773557485*^9}, {
   3.8169698105709257`*^9, 3.816969812988311*^9}, {3.816969869950757*^9, 
   3.816970159059287*^9}, {3.8169701922107725`*^9, 3.8169703328745856`*^9}, {
   3.8169703692358675`*^9, 3.816970392056673*^9}, {3.8169704585521016`*^9, 
   3.816970546732669*^9}, {3.816970620359477*^9, 3.8169706948532743`*^9}, {
   3.816970771001911*^9, 3.8169707713488226`*^9}, {3.81697082511382*^9, 
   3.8169708257721214`*^9}, {3.8169708916195927`*^9, 3.8169708942010756`*^9}, 
   3.8169709282228193`*^9, {3.8169779620574923`*^9, 3.8169779750666237`*^9}, {
   3.816978018754233*^9, 3.8169780190506277`*^9}, {3.816978050231023*^9, 
   3.816978073565834*^9}, {3.8169781489922605`*^9, 3.8169781503606577`*^9}, {
   3.816978210264328*^9, 3.8169782199079*^9}, {3.8169782540605307`*^9, 
   3.816978280666787*^9}, {3.816978319106801*^9, 3.816978321348363*^9}, {
   3.8169783541510153`*^9, 3.81697835441423*^9}, {3.8169783944624233`*^9, 
   3.8169784233463507`*^9}, {3.8169784576703205`*^9, 
   3.8169784627626143`*^9}, {3.8169784929474754`*^9, 3.816978517039879*^9}, {
   3.816978553714514*^9, 3.816978587512111*^9}, {3.8169786192650185`*^9, 
   3.8169786209488883`*^9}, {3.8169787928819046`*^9, 3.816978916646078*^9}, {
   3.8169789627360945`*^9, 3.8169789941771574`*^9}, {3.816979055737482*^9, 
   3.8169791606345873`*^9}, {3.8169792150221424`*^9, 
   3.8169792230541925`*^9}, {3.816979281431674*^9, 3.8169793392183695`*^9}, {
   3.8169810198736825`*^9, 3.8169810557477694`*^9}, {3.8169828112728696`*^9, 
   3.816982829981699*^9}, {3.8169828744519677`*^9, 3.8169828774445505`*^9}, {
   3.816982917641362*^9, 3.8169829775666075`*^9}, {3.8169830098018527`*^9, 
   3.8169830163531027`*^9}, {3.8169830904917307`*^9, 3.816983091833833*^9}, {
   3.816983130022832*^9, 3.8169831320736785`*^9}, 3.816983216912746*^9, {
   3.816984275918048*^9, 3.8169844244175158`*^9}, {3.816984464900384*^9, 
   3.816984465903861*^9}, {3.816984511776393*^9, 3.8169845128992233`*^9}, {
   3.817018521608817*^9, 3.8170185253093786`*^9}, 3.817018563802203*^9, {
   3.8170186305552464`*^9, 3.8170186915963545`*^9}, {3.81701872896008*^9, 
   3.817018734925262*^9}, {3.8170187695064907`*^9, 3.8170187831131287`*^9}, {
   3.8170188309031773`*^9, 3.817018845580829*^9}, {3.817018890816086*^9, 
   3.8170189100349293`*^9}, {3.8170203889963865`*^9, 3.817020390919925*^9}, {
   3.8170204606269865`*^9, 3.817020462258224*^9}, {3.817020503525315*^9, 
   3.8170205398917184`*^9}, {3.8170205874367037`*^9, 3.817020634495619*^9}, {
   3.8170206672634177`*^9, 3.817020675557276*^9}, {3.8170207117108746`*^9, 
   3.8170207161492004`*^9}, {3.8170207745855074`*^9, 
   3.8170207766856365`*^9}, {3.8170208234083853`*^9, 3.817020845086481*^9}, {
   3.8170208949245863`*^9, 3.8170209506025143`*^9}, {3.8170209816450925`*^9, 
   3.8170210947560835`*^9}, {3.817021170250201*^9, 3.8170212081238036`*^9}, {
   3.8170212442938976`*^9, 3.817021244476031*^9}, {3.8170212787907047`*^9, 
   3.8170213065380373`*^9}, {3.817021342826168*^9, 3.8170213954415975`*^9}, {
   3.8170214832354035`*^9, 3.8170215092951946`*^9}, {3.8170215439706383`*^9, 
   3.817021544715268*^9}, {3.8170216005033436`*^9, 3.817021739056815*^9}, {
   3.81702177663433*^9, 3.8170217947658215`*^9}, {3.817021834131009*^9, 
   3.8170218347212105`*^9}, {3.817021887112662*^9, 3.8170219070030203`*^9}, {
   3.817021955163389*^9, 3.8170219847109385`*^9}, {3.817022018400405*^9, 
   3.81702210207297*^9}, {3.8170221328848305`*^9, 3.8170221334047117`*^9}, 
   3.817022225292798*^9, {3.817022271924111*^9, 3.8170223777910624`*^9}, {
   3.8170242786609955`*^9, 3.817024335901683*^9}, 3.8170244046317315`*^9, {
   3.8170245325518866`*^9, 3.8170246072833233`*^9}, {3.8170246414121695`*^9, 
   3.8170246457710133`*^9}, {3.817024690428961*^9, 3.8170246912176266`*^9}, {
   3.8170247644840326`*^9, 3.817024847136346*^9}, {3.8170249137056637`*^9, 
   3.8170249256042137`*^9}, {3.8170249690652437`*^9, 
   3.8170249697445855`*^9}, {3.8170250174913883`*^9, 3.817025088240099*^9}, {
   3.8170251482936277`*^9, 3.817025162895173*^9}, 3.817025302190694*^9, {
   3.8170253609291406`*^9, 3.8170254512758813`*^9}, {3.8170286389196677`*^9, 
   3.8170287009854174`*^9}, {3.817028753120528*^9, 3.8170287572355356`*^9}, {
   3.817028798111125*^9, 3.8170288478132763`*^9}, {3.8170288788880396`*^9, 
   3.81702887941692*^9}, {3.8170289242736692`*^9, 3.8170289548683376`*^9}, 
   3.8170293952388363`*^9, 3.8170294699588656`*^9, 3.817029505778508*^9, {
   3.817029546689082*^9, 3.8170296563702188`*^9}, {3.8170296938482533`*^9, 
   3.8170297818575563`*^9}, {3.817029812685508*^9, 3.8170298138955994`*^9}, {
   3.817029936342227*^9, 3.817029948177348*^9}, {3.8170299889834185`*^9, 
   3.817030002840399*^9}, 3.8170305036143193`*^9, {3.81703060389369*^9, 
   3.817030604126186*^9}, {3.8170306715717616`*^9, 3.8170307257052345`*^9}, {
   3.817030778750795*^9, 3.817030799341307*^9}, {3.817030834445944*^9, 
   3.817030853678364*^9}, {3.817030885321043*^9, 3.81703094004021*^9}, 
   3.8170309897006536`*^9, {3.817031031904592*^9, 3.817031056964126*^9}, {
   3.81703111658424*^9, 3.8170311693505163`*^9}, {3.817031207814357*^9, 
   3.8170312110138626`*^9}, {3.817031291384374*^9, 3.81703139618591*^9}, {
   3.8170314274692383`*^9, 3.8170314487563953`*^9}, {3.81703149352079*^9, 
   3.81703151322558*^9}, 3.8170315480255027`*^9, {3.817031596496008*^9, 
   3.817031657038114*^9}, {3.8170316899930954`*^9, 3.8170317733798437`*^9}, {
   3.817031803498739*^9, 3.8170318583456316`*^9}, {3.817032024826165*^9, 
   3.8170320907400303`*^9}, {3.817032171044409*^9, 3.817032174129292*^9}, {
   3.817032216931423*^9, 3.817032248708644*^9}, {3.8170322915881643`*^9, 
   3.8170322922851615`*^9}, {3.81703233530058*^9, 3.817032335492751*^9}, {
   3.8170323735638447`*^9, 3.817032449775629*^9}, {3.81703252537224*^9, 
   3.8170325255221767`*^9}, 3.817032560897051*^9, {3.8170326175798645`*^9, 
   3.817032617805382*^9}, {3.8170327406658387`*^9, 3.8170327585948477`*^9}, {
   3.8170327898961124`*^9, 3.8170328584908686`*^9}, {3.8170328888289194`*^9, 
   3.8170328890956545`*^9}, {3.817032923883842*^9, 3.8170329246700563`*^9}, {
   3.8170329575765195`*^9, 3.8170329581961803`*^9}, {3.8170363256180162`*^9, 
   3.8170363506569424`*^9}, {3.81703639481275*^9, 3.8170363957870336`*^9}, {
   3.817037404680935*^9, 3.8170374962874007`*^9}, {3.817037530723493*^9, 
   3.8170375365340595`*^9}, {3.817037668453257*^9, 3.817037680581855*^9}, {
   3.8170379372383337`*^9, 3.817037947199241*^9}, {3.817038031744534*^9, 
   3.8170380480534587`*^9}, {3.8170381925625668`*^9, 
   3.8170382249884167`*^9}, {3.817038281214554*^9, 3.8170383876037874`*^9}, {
   3.817038437335493*^9, 3.817038510294285*^9}, {3.8170385778464217`*^9, 
   3.8170385780851173`*^9}, {3.8170386154481287`*^9, 3.817038696256372*^9}, {
   3.8170387585089912`*^9, 3.817038907856929*^9}, {3.817038959435054*^9, 
   3.817038960082589*^9}, {3.817039002524441*^9, 3.8170390038135633`*^9}, 
   3.8170453011599493`*^9, {3.817045334636467*^9, 3.817045361480541*^9}, {
   3.817045395395734*^9, 3.817045396612177*^9}, {3.817045427523226*^9, 
   3.8170454456995735`*^9}, {3.8171343093995857`*^9, 3.817134313634229*^9}, {
   3.817134383962644*^9, 3.8171343871233883`*^9}, 3.8171344758922663`*^9, {
   3.817134687164322*^9, 3.817134712548443*^9}, {3.8171348289966145`*^9, 
   3.817134829231411*^9}, {3.817134906289007*^9, 3.8171349111774187`*^9}, {
   3.8171349518093452`*^9, 3.817134966949972*^9}, {3.817135014641593*^9, 
   3.817135018594117*^9}, {3.8171350732909875`*^9, 3.817135137137513*^9}, {
   3.8171351750638633`*^9, 3.817135175222228*^9}, {3.8171352497058783`*^9, 
   3.8171352503415165`*^9}, {3.8171354485615005`*^9, 3.817135448793491*^9}, {
   3.817135725138133*^9, 3.817135798291428*^9}, {3.8171358305399976`*^9, 
   3.817135855634164*^9}, {3.8171360809403496`*^9, 3.817136130193314*^9}, {
   3.817136206007077*^9, 3.8171362416923327`*^9}, 3.8171363544568443`*^9, {
   3.8171364444172688`*^9, 3.817136460240279*^9}, {3.8171364906078806`*^9, 
   3.8171364913795905`*^9}, {3.8171365597135715`*^9, 3.817136561358117*^9}, 
   3.8171365936275043`*^9, {3.8171366437280006`*^9, 3.817136644554638*^9}, {
   3.8171368093358035`*^9, 3.817136838385761*^9}, {3.817136983468357*^9, 
   3.8171370024700184`*^9}, 3.8171373678513126`*^9, {3.8171374363647985`*^9, 
   3.8171374628550754`*^9}, {3.8171375531976094`*^9, 3.817137610616805*^9}, {
   3.8171376619122105`*^9, 3.817137768889105*^9}, {3.8171380076835394`*^9, 
   3.8171380381966815`*^9}, {3.8171380753794756`*^9, 3.817138076066577*^9}, 
   3.8171381428789744`*^9, {3.817138176167575*^9, 3.8171382766093683`*^9}, {
   3.817138337494667*^9, 3.817138364249321*^9}, {3.8171385179008307`*^9, 
   3.817138543817663*^9}, {3.8171385973597064`*^9, 3.8171385980159264`*^9}, {
   3.8171386296318407`*^9, 3.817138651337531*^9}, {3.8171387131843395`*^9, 
   3.817138797451186*^9}, {3.8171388277264853`*^9, 3.817138932923501*^9}, {
   3.817138990447486*^9, 3.817139024288031*^9}, {3.8171390606429963`*^9, 
   3.817139101968811*^9}, {3.817139155964719*^9, 3.817139226735157*^9}, {
   3.817139362088703*^9, 3.8171393669028797`*^9}, {3.817139459558957*^9, 
   3.8171394789509306`*^9}, {3.8171395268405795`*^9, 3.817139644976845*^9}, {
   3.8171397823294687`*^9, 3.8171398753590097`*^9}, {3.8171399506995277`*^9, 
   3.8171399624101505`*^9}, 3.817140038065827*^9, {3.817140084704279*^9, 
   3.8171401109414973`*^9}, {3.8171401480330296`*^9, 3.817140164570182*^9}, {
   3.817140363036889*^9, 3.8171405263387947`*^9}, {3.817140965804389*^9, 
   3.817141028804033*^9}, {3.8172177331502433`*^9, 3.8172177729595327`*^9}, {
   3.817217813262117*^9, 3.8172178236148105`*^9}, {3.8172178549608107`*^9, 
   3.8172179002596626`*^9}, {3.8172179793127074`*^9, 3.817218032495319*^9}, {
   3.8172180952260494`*^9, 3.8172181491542964`*^9}, {3.8172182100771465`*^9, 
   3.8172182180681686`*^9}, {3.8172182707832327`*^9, 3.817218271021315*^9}, {
   3.8172183020978127`*^9, 3.8172183154185715`*^9}, {3.8172183796322746`*^9, 
   3.817218449853367*^9}, {3.817218532052801*^9, 3.817218546072856*^9}, {
   3.817219031126679*^9, 3.8172190544573984`*^9}, {3.817219102957221*^9, 
   3.8172191251399083`*^9}, {3.817219255774171*^9, 3.817219256031684*^9}, {
   3.8172194069560013`*^9, 3.817219445844657*^9}, {3.8172194769851904`*^9, 
   3.817219500756133*^9}, {3.817219567163714*^9, 3.8172195768411884`*^9}, {
   3.8172196270938663`*^9, 3.8172196466779566`*^9}, {3.8172196808672476`*^9, 
   3.817219698608945*^9}, 3.8172198439517455`*^9, {3.8172198814457197`*^9, 
   3.817219902991516*^9}, {3.817219964933796*^9, 3.8172199774397955`*^9}, {
   3.8172200247908*^9, 3.8172200515523543`*^9}, {3.8172201045674925`*^9, 
   3.8172201111228347`*^9}, {3.8172201473549137`*^9, 
   3.8172202271704283`*^9}, {3.8172202606629963`*^9, 
   3.8172202625382767`*^9}, {3.8172202971826963`*^9, 3.817220340884669*^9}, {
   3.817220372866507*^9, 3.8172203741101756`*^9}, {3.817220431668863*^9, 
   3.817220451516699*^9}, {3.817220533870877*^9, 3.8172205619307165`*^9}, {
   3.8172206098751364`*^9, 3.8172206336136837`*^9}, {3.8172208669899864`*^9, 
   3.817220879079233*^9}, {3.8172291218177195`*^9, 3.817229150540821*^9}, {
   3.8172291849525433`*^9, 3.817229185157195*^9}, {3.8172303325439825`*^9, 
   3.8172303333555098`*^9}, {3.817230373027066*^9, 3.8172304773458943`*^9}, {
   3.8172305415278244`*^9, 3.8172305417403374`*^9}, {3.8172305868687143`*^9, 
   3.8172305875880437`*^9}, {3.8172306622087264`*^9, 3.817230667435226*^9}, {
   3.8172307361798425`*^9, 3.817230739309973*^9}, 3.8172308261091022`*^9, {
   3.817230863080351*^9, 3.817230863705139*^9}, {3.8172308946162443`*^9, 
   3.817230894747655*^9}, {3.817230997371936*^9, 3.8172310295398593`*^9}, {
   3.81723143535452*^9, 3.8172314550240045`*^9}, {3.81723152772101*^9, 
   3.8172315595460644`*^9}, {3.8172315920640125`*^9, 3.81723162310622*^9}, 
   3.817231674953767*^9, {3.8172317071552286`*^9, 3.8172317254999294`*^9}, {
   3.8172318350365477`*^9, 3.8172318353127766`*^9}, {3.8172318917992*^9, 
   3.8172319253584433`*^9}, 3.817231977476136*^9, {3.817232008128322*^9, 
   3.817232034554553*^9}, 3.8172320709389825`*^9, {3.817232195523376*^9, 
   3.8172322003211613`*^9}, {3.8172322365964537`*^9, 
   3.8172322898923264`*^9}, {3.8172323327105145`*^9, 3.817232332931774*^9}, {
   3.8172324388449593`*^9, 3.817232439738225*^9}, {3.817232472192669*^9, 
   3.8172324948128633`*^9}, {3.8172325594867077`*^9, 
   3.8172326036765485`*^9}, {3.817232636955388*^9, 3.8172326371808987`*^9}, {
   3.817232725345766*^9, 3.8172327262517405`*^9}, {3.8172327791739655`*^9, 
   3.8172328296504545`*^9}, {3.8172328967124796`*^9, 
   3.8172329185106926`*^9}, {3.8172329735704703`*^9, 3.817232973764635*^9}, {
   3.817236220615152*^9, 3.8172362228031425`*^9}, {3.8173921898267055`*^9, 
   3.817392332959465*^9}, {3.8173923919181156`*^9, 3.817392392134505*^9}, {
   3.8173924568198395`*^9, 3.8173924569834256`*^9}, {3.8173924990021486`*^9, 
   3.817392517619347*^9}, {3.817392569539956*^9, 3.817392633811711*^9}, {
   3.817473766760203*^9, 3.8174738167199297`*^9}, {3.817473848642257*^9, 
   3.8174738837963915`*^9}, {3.8174739488720894`*^9, 
   3.8174739647253304`*^9}, {3.817474039599646*^9, 3.8174741266292543`*^9}, {
   3.817474157449117*^9, 3.817474225551693*^9}, {3.8174742608098755`*^9, 
   3.817474330426487*^9}, 3.817474368694787*^9, {3.81747443115329*^9, 
   3.817474434494619*^9}, {3.817474522265994*^9, 3.81747463265518*^9}, {
   3.817474748748988*^9, 3.817474766291452*^9}, {3.8174748038807263`*^9, 
   3.817474850788578*^9}, {3.817475081024825*^9, 3.8174751150653877`*^9}, {
   3.8176569224064393`*^9, 3.8176570591262712`*^9}, {3.817657136805976*^9, 
   3.8176571590670443`*^9}, {3.81765722130649*^9, 3.8176574342759485`*^9}, {
   3.817657487458662*^9, 3.81765788399678*^9}, {3.8176582745135007`*^9, 
   3.81765828764904*^9}, {3.8176583371766424`*^9, 3.817658381826932*^9}, {
   3.817658421225134*^9, 3.8176584214503794`*^9}, {3.8176585229543433`*^9, 
   3.81765855880385*^9}, {3.8176586701952267`*^9, 3.817658732405184*^9}, {
   3.817658815520069*^9, 3.8176588931041584`*^9}, {3.817658933741994*^9, 
   3.8176590168356743`*^9}, {3.8176591530637856`*^9, 3.8176591534261365`*^9}, 
   3.8176592587039547`*^9, 3.8176592991542377`*^9, 3.8176593785241356`*^9, {
   3.8176594813806*^9, 3.817659643773875*^9}, {3.8176596889448767`*^9, 
   3.8176597848416405`*^9}, {3.8176599442184744`*^9, 
   3.8176599604913855`*^9}, {3.8176600174377203`*^9, 
   3.8176600334979167`*^9}, {3.817660395643075*^9, 3.817660399080926*^9}, 
   3.817660442734994*^9, {3.817660556699472*^9, 3.817660778186875*^9}, {
   3.8176613539472837`*^9, 3.817661463749029*^9}, {3.8176616758873415`*^9, 
   3.8176616921172886`*^9}, {3.8176617245073757`*^9, 3.817661725154274*^9}, {
   3.8176617590148926`*^9, 3.817661775621604*^9}, {3.8176619294322305`*^9, 
   3.81766203525216*^9}, {3.8176620707717056`*^9, 3.817662081596504*^9}, {
   3.8176623574157753`*^9, 3.8176624435205956`*^9}, 3.817662494753023*^9, {
   3.8176625895338836`*^9, 3.817662621124344*^9}, {3.8176627355734534`*^9, 
   3.8176627496438932`*^9}, {3.817662877580673*^9, 3.81766290222511*^9}, {
   3.8176629565171485`*^9, 3.8176629845356283`*^9}, {3.817663018840966*^9, 
   3.817663188623584*^9}, 3.8176632231661663`*^9, {3.8176633217778425`*^9, 
   3.81766332713879*^9}, {3.8176633900116487`*^9, 3.8176634475585084`*^9}, {
   3.8176678086040697`*^9, 3.8176678740329375`*^9}, {3.817667913579779*^9, 
   3.817667918667435*^9}, {3.8176679574607267`*^9, 3.817667983997547*^9}, {
   3.8176680681190834`*^9, 3.817668166305063*^9}, {3.8176698698811707`*^9, 
   3.817669931759592*^9}, {3.8176699769815946`*^9, 3.8176699817717047`*^9}, {
   3.817670047989766*^9, 3.8176701771281013`*^9}, {3.817670237269174*^9, 
   3.8176703594981656`*^9}, {3.817670460765101*^9, 3.817670537303466*^9}, {
   3.817701566258854*^9, 3.8177015811927896`*^9}, {3.817887542428325*^9, 
   3.817887545107828*^9}, {3.8178875783371253`*^9, 3.8178875789341097`*^9}, {
   3.8178877076502914`*^9, 3.8178877535291247`*^9}, {3.8178877878269434`*^9, 
   3.817887790790889*^9}, {3.817887827128866*^9, 3.8178878372995725`*^9}, {
   3.8178878848493567`*^9, 3.817887885062227*^9}, {3.8178879456312113`*^9, 
   3.8178879677713065`*^9}, {3.8178885792146063`*^9, 3.817888635420947*^9}, {
   3.8178886680413847`*^9, 3.817888696927676*^9}, {3.8178888220494986`*^9, 
   3.8178888841389256`*^9}, {3.8178889202255945`*^9, 3.817888927261049*^9}, {
   3.8178891727001057`*^9, 3.817889280420273*^9}, {3.8178953355106716`*^9, 
   3.8178953889258146`*^9}, {3.817895432844351*^9, 3.817895452311438*^9}, {
   3.8178954833330927`*^9, 3.817895491646652*^9}, {3.817895617090736*^9, 
   3.817895620619216*^9}, {3.81789566177989*^9, 3.8178956673590245`*^9}, {
   3.8178959019428883`*^9, 3.817895913286324*^9}, {3.8178959796761866`*^9, 
   3.8178960613893876`*^9}, {3.8179783591012306`*^9, 
   3.8179783639793825`*^9}, {3.81797839964629*^9, 3.817978408517867*^9}, {
   3.8179787740487986`*^9, 3.8179787994297533`*^9}, {3.817978848826255*^9, 
   3.817978849884181*^9}, {3.8179789706717954`*^9, 3.8179789735737805`*^9}, {
   3.8180597956960735`*^9, 3.8180597958458333`*^9}, 3.818060534886283*^9, {
   3.8180732922481627`*^9, 3.8180732941520023`*^9}, {3.8180733474899426`*^9, 
   3.8180734445265636`*^9}, {3.8180734889761477`*^9, 3.818073620805811*^9}, {
   3.818492092680091*^9, 3.8184921184202857`*^9}, 3.818492164032441*^9, {
   3.818496215410243*^9, 3.8184962709620514`*^9}, {3.818496561842126*^9, 
   3.818496569855092*^9}, {3.8184966027936854`*^9, 3.8184966584006667`*^9}, {
   3.818496689404066*^9, 3.818496729829115*^9}, {3.8184967860304394`*^9, 
   3.8184967862605267`*^9}, {3.8184968520205135`*^9, 
   3.8184968587472086`*^9}, {3.81850151212755*^9, 3.8185015668948493`*^9}, {
   3.818501805838319*^9, 3.8185018739312305`*^9}, {3.818501904530693*^9, 
   3.8185020142446012`*^9}, {3.8185020726772213`*^9, 3.818502074587472*^9}, {
   3.8185021472890806`*^9, 3.8185021554981585`*^9}, {3.818506151508753*^9, 
   3.8185062025065975`*^9}, {3.8185062325806227`*^9, 
   3.8185062376084766`*^9}, {3.818506275665066*^9, 3.8185063003037977`*^9}, {
   3.818506356565132*^9, 3.81850645594753*^9}, {3.818506490159054*^9, 
   3.8185065109179153`*^9}, 3.818506592478531*^9, {3.818506630534298*^9, 
   3.8185067539744344`*^9}, {3.8185068267264137`*^9, 3.818506829782296*^9}, {
   3.818506871016444*^9, 3.8185068874342175`*^9}, {3.818506918124428*^9, 
   3.81850705456089*^9}, {3.8185070957666583`*^9, 3.818507099550394*^9}, {
   3.818507181911975*^9, 3.818507258623947*^9}, {3.818507289508853*^9, 
   3.818507527589519*^9}, {3.818507570927973*^9, 3.818507615935399*^9}, {
   3.8185076918115873`*^9, 3.818507743941826*^9}, {3.818511320027589*^9, 
   3.8185114186467495`*^9}, {3.818511466961506*^9, 3.8185116014900866`*^9}, {
   3.8185118560627785`*^9, 3.8185118566488013`*^9}, {3.818511888163409*^9, 
   3.81851190867071*^9}, {3.818511974316244*^9, 3.818512008149522*^9}, {
   3.818512094228718*^9, 3.8185121233814425`*^9}, {3.8185121539515505`*^9, 
   3.818512154599058*^9}, {3.818512340705093*^9, 3.818512345015518*^9}, 
   3.8185133849490843`*^9, 3.8185134262395544`*^9, {3.8185134562782907`*^9, 
   3.8185135264890456`*^9}, {3.8185135832830086`*^9, 
   3.8185136910218315`*^9}, {3.8185143531242857`*^9, 
   3.8185145348027997`*^9}, {3.818514569788349*^9, 3.8185145700364256`*^9}, {
   3.818514634619173*^9, 3.818514661788251*^9}, {3.8185153359681864`*^9, 
   3.818515339810502*^9}, {3.818515379966303*^9, 3.81851541017288*^9}, {
   3.8185154661411576`*^9, 3.818515466375808*^9}, {3.818515501509572*^9, 
   3.818515562029875*^9}, {3.818582488988281*^9, 3.818582532779572*^9}, {
   3.8185825752228107`*^9, 3.818582620702071*^9}, {3.8185828573095427`*^9, 
   3.818582857877508*^9}, {3.818582905893242*^9, 3.8185829060880284`*^9}, {
   3.818582985207261*^9, 3.8185830355928946`*^9}, {3.8185832449602194`*^9, 
   3.8185832828766513`*^9}, {3.8185833540554113`*^9, 3.818583382866555*^9}, {
   3.8185834230388165`*^9, 3.8185834337413435`*^9}, {3.818583478759235*^9, 
   3.8185835113052645`*^9}, {3.818585032823183*^9, 3.8185850387590504`*^9}, {
   3.81858507450447*^9, 3.8185851433108387`*^9}, {3.81858644322194*^9, 
   3.818586463008587*^9}, {3.818587536100648*^9, 3.818587587624097*^9}, {
   3.8185881759401793`*^9, 3.81858819152843*^9}, {3.8187520058717422`*^9, 
   3.818752010538868*^9}, 3.818753023486536*^9, {3.8188489104201574`*^9, 
   3.8188489442855306`*^9}, {3.8188490233055096`*^9, 3.818849092421256*^9}, {
   3.8188491240889173`*^9, 3.8188492981349573`*^9}, {3.818865790852035*^9, 
   3.818865806612211*^9}, {3.8189773835541844`*^9, 3.818977518067086*^9}, 
   3.819013067306815*^9, {3.819017331958061*^9, 3.819017403457123*^9}, {
   3.8192703951106634`*^9, 3.8192704154393682`*^9}, {3.8192786912838945`*^9, 
   3.8192788698306375`*^9}, {3.8192789034224863`*^9, 3.819278903671012*^9}, {
   3.8192789415396338`*^9, 3.819278942162345*^9}, {3.8192789859203663`*^9, 
   3.8192789880025764`*^9}, {3.8192790369084024`*^9, 3.819279066447316*^9}, {
   3.819279219969898*^9, 3.8192792304157915`*^9}, {3.819279262509118*^9, 
   3.8192793031227636`*^9}, {3.8192820479388876`*^9, 3.8192820954345474`*^9}, 
   3.8192821357637615`*^9, {3.8192821829867506`*^9, 3.8192822192671366`*^9}, {
   3.8193740025394683`*^9, 3.819374010422819*^9}, {3.819374040442794*^9, 
   3.81937417713726*^9}, {3.8193742170573626`*^9, 3.81937423674597*^9}, {
   3.819374290704404*^9, 3.81937439667729*^9}, {3.819374479954099*^9, 
   3.8193744976139307`*^9}, {3.819374883862051*^9, 3.819374886124118*^9}, {
   3.819374917923704*^9, 3.8193750382557397`*^9}, {3.819375080405379*^9, 
   3.819375080636075*^9}, {3.8193758264250937`*^9, 3.8193758974195995`*^9}, {
   3.8193759517074833`*^9, 3.8193759849025483`*^9}, {3.8193760257866244`*^9, 
   3.8193761030061803`*^9}, 3.8193920036143703`*^9, {3.81939204289128*^9, 
   3.8193921141773973`*^9}, {3.819392154043087*^9, 3.819392154129513*^9}, {
   3.8193921867815948`*^9, 3.8193921889383388`*^9}, {3.819392228099296*^9, 
   3.8193922718018117`*^9}, 3.81939232053521*^9, {3.8193923646512713`*^9, 
   3.819392382445566*^9}, {3.819392421548049*^9, 3.819392454107172*^9}, {
   3.8193945682739496`*^9, 3.819394615831197*^9}, {3.819394678666705*^9, 
   3.819394698702735*^9}, {3.819394780109441*^9, 3.819394843676793*^9}, {
   3.8193960501275487`*^9, 3.819396091796008*^9}, {3.8193961361820564`*^9, 
   3.8193961650856504`*^9}, {3.8193962161699834`*^9, 3.819396275370669*^9}, {
   3.819397431031519*^9, 3.8193975348647594`*^9}, {3.8193975778532352`*^9, 
   3.8193975830298567`*^9}, {3.819397694048602*^9, 3.819397739865897*^9}, {
   3.8193978160535903`*^9, 3.819397816759368*^9}, {3.8193981084467273`*^9, 
   3.8193982575620975`*^9}, {3.8193983077024136`*^9, 3.819398320475643*^9}, {
   3.819398354543367*^9, 3.8193984402906246`*^9}, {3.8193984748929634`*^9, 
   3.819398475327549*^9}, {3.8193985104426346`*^9, 3.8193985413027525`*^9}, {
   3.8194007770605745`*^9, 3.819400973811523*^9}, {3.819404902738716*^9, 
   3.8194049754000835`*^9}, {3.8194050127135496`*^9, 
   3.8194050419064865`*^9}, {3.8194050797654877`*^9, 3.819405080051508*^9}, {
   3.8194051224649487`*^9, 3.8194051231833963`*^9}, {3.819405160486764*^9, 
   3.819405178376681*^9}, {3.8194052100481715`*^9, 3.819405216353367*^9}, 
   3.8194052473509083`*^9, {3.8194052784484997`*^9, 3.8194053008107276`*^9}, {
   3.8194716371628675`*^9, 3.8194716800903883`*^9}, {3.8194718528919907`*^9, 
   3.819471921651002*^9}, {3.81947195209797*^9, 3.8194721536815977`*^9}, {
   3.8194721871133184`*^9, 3.8194722090889816`*^9}, {3.8194731072242427`*^9, 
   3.8194731210791855`*^9}, {3.8194731763393507`*^9, 
   3.8194732728064623`*^9}, {3.8194733086512794`*^9, 
   3.8194733094949603`*^9}, {3.819473341026224*^9, 3.8194733676424317`*^9}, {
   3.81947377610312*^9, 3.81947396087072*^9}, {3.819474072427804*^9, 
   3.819474108755041*^9}, {3.8194742460805063`*^9, 3.8194742931107264`*^9}, {
   3.819476967268626*^9, 3.8194770310263925`*^9}, {3.8194770705929146`*^9, 
   3.8194771232117724`*^9}, {3.8194771697295637`*^9, 
   3.8194771942659783`*^9}, {3.819478671774432*^9, 3.8194787048000793`*^9}, {
   3.8194833455009513`*^9, 3.8194834264958916`*^9}, {3.819483496843769*^9, 
   3.8194834970736055`*^9}, {3.8194835277158165`*^9, 3.819483528374379*^9}, {
   3.819483577632929*^9, 3.819483626848959*^9}, {3.819483865258502*^9, 
   3.8194838722965937`*^9}, {3.819483958516944*^9, 3.8194839596599755`*^9}, {
   3.819484066611229*^9, 3.819484071201518*^9}, {3.8194841597200356`*^9, 
   3.819484161205926*^9}, {3.819484230420329*^9, 3.8194842439883385`*^9}, {
   3.819484277703086*^9, 3.819484296555275*^9}, {3.8194843370546403`*^9, 
   3.8194843381155577`*^9}, 3.819484376677189*^9, 3.8194844092528753`*^9, {
   3.819484448119855*^9, 3.819484468200343*^9}, {3.8194876492342196`*^9, 
   3.819487662425933*^9}, {3.819487900279102*^9, 3.819487970806288*^9}, {
   3.819488451702571*^9, 3.8194884628431635`*^9}, {3.819491733903241*^9, 
   3.8194917361995754`*^9}, 3.81949176910156*^9, {3.8194918079357624`*^9, 
   3.819491873071715*^9}, {3.819493525659686*^9, 3.819493610453461*^9}, {
   3.819493645033103*^9, 3.819493677263234*^9}, {3.819493708618099*^9, 
   3.819493708881215*^9}, {3.819493768790211*^9, 3.819493770047187*^9}, {
   3.8194938407273602`*^9, 3.8194938859948025`*^9}, {3.8194939169482756`*^9, 
   3.819493976842841*^9}, 3.8194940263412304`*^9, {3.819494116678539*^9, 
   3.8194941187858686`*^9}, 3.8194941867028728`*^9, {3.8194942402322793`*^9, 
   3.8194942983448625`*^9}, {3.8194943696185093`*^9, 3.819494399883211*^9}, {
   3.819494469223377*^9, 3.819494483491021*^9}, {3.819494558747101*^9, 
   3.819494580013341*^9}, {3.819494674952589*^9, 3.819494677123737*^9}, {
   3.8194947108993993`*^9, 3.81949474050898*^9}, {3.819494782795084*^9, 
   3.819494837837099*^9}, {3.8194948799956894`*^9, 3.8194949744980073`*^9}, {
   3.8194950204292517`*^9, 3.819495031599887*^9}, {3.8194952232317777`*^9, 
   3.8194952315546317`*^9}, 3.8195323482556286`*^9, {3.8195324297461915`*^9, 
   3.819532523355762*^9}, {3.819532561315366*^9, 3.8195326610284266`*^9}, {
   3.8195326950953684`*^9, 3.819532726785277*^9}, {3.8195327723199024`*^9, 
   3.8195328694755344`*^9}, {3.819532929751961*^9, 3.8195329299977765`*^9}, {
   3.819533132155596*^9, 3.819533144695315*^9}, {3.8195332046829605`*^9, 
   3.8195332147570763`*^9}, {3.8195332599328985`*^9, 
   3.8195332849147043`*^9}, {3.8195333540749445`*^9, 3.819533355156579*^9}, {
   3.8195334137891264`*^9, 3.8195336241310463`*^9}, {3.8195336897309527`*^9, 
   3.819533795691621*^9}, {3.8195339053688*^9, 3.819534007853488*^9}, {
   3.8195340393404646`*^9, 3.819534065063348*^9}, {3.8195341226215672`*^9, 
   3.819534177350151*^9}, {3.8195342394691744`*^9, 3.819534264958209*^9}, {
   3.819534378816599*^9, 3.8195345240778503`*^9}, {3.819534555381363*^9, 
   3.8195345759860687`*^9}, {3.8195346218916903`*^9, 
   3.8195346221237917`*^9}, {3.819534724211138*^9, 3.8195347488781433`*^9}, {
   3.8195348745313673`*^9, 3.819535067093212*^9}, {3.8195351363180027`*^9, 
   3.819535328888272*^9}, {3.819535404816265*^9, 3.819535559461132*^9}, {
   3.8195356130011435`*^9, 3.8195356308415546`*^9}, 3.819535662823058*^9, {
   3.819535714819352*^9, 3.8195357992018547`*^9}, {3.8195358386601143`*^9, 
   3.819535839644978*^9}, 3.8195358733188295`*^9, {3.81953591194514*^9, 
   3.819535912212976*^9}, {3.8195359541907825`*^9, 3.819535975867408*^9}, {
   3.8195360411386433`*^9, 3.8195360965762253`*^9}, 3.819536179922471*^9, {
   3.8195362173498535`*^9, 3.8195362175704584`*^9}, {3.819536254247498*^9, 
   3.8195363148718505`*^9}, {3.8195363600307055`*^9, 3.819536464766317*^9}, {
   3.819536505614914*^9, 3.819536516476324*^9}, {3.8195366056453886`*^9, 
   3.8195366297852926`*^9}, {3.819536660506079*^9, 3.8195366789012246`*^9}, {
   3.8195367988345003`*^9, 3.8195368526425505`*^9}, {3.819536887624408*^9, 
   3.819536944349151*^9}, {3.819537091790214*^9, 3.8195371906233006`*^9}, {
   3.8195372218975086`*^9, 3.819537263151459*^9}, {3.819537302148446*^9, 
   3.8195373601353025`*^9}, {3.8195407971402426`*^9, 3.819540799103278*^9}, {
   3.8195408317301464`*^9, 3.819540862137217*^9}, {3.8195409213775425`*^9, 
   3.8195410293146*^9}, {3.8195410640473795`*^9, 3.8195411531634502`*^9}, {
   3.8195411973522806`*^9, 3.819541224295332*^9}, 3.8195413017410183`*^9, {
   3.8195413372969294`*^9, 3.8195413379830756`*^9}, {3.8195413813696117`*^9, 
   3.81954141758049*^9}, 3.8195414587053003`*^9, {3.8195415153180103`*^9, 
   3.8195417445021234`*^9}, {3.819541803577734*^9, 3.819541804749313*^9}, {
   3.8195418483577814`*^9, 3.819541848722395*^9}, {3.819541971636897*^9, 
   3.8195420515903716`*^9}, {3.819542086957282*^9, 3.8195421149995036`*^9}, {
   3.819542147238741*^9, 3.8195422670150175`*^9}, {3.819542302597539*^9, 
   3.8195423261762238`*^9}, {3.819542364672668*^9, 3.8195423649104834`*^9}, {
   3.8195433442628756`*^9, 3.8195434270078726`*^9}, {3.8195434587621527`*^9, 
   3.8195435148298903`*^9}, {3.8195435533272524`*^9, 
   3.8195435549133673`*^9}, {3.819543590784831*^9, 3.8195435910793257`*^9}, {
   3.8195436681038523`*^9, 3.8195436690284414`*^9}, {3.8195440231168585`*^9, 
   3.8195440709639425`*^9}, {3.819544107354926*^9, 3.819544190215146*^9}, {
   3.8195442217082095`*^9, 3.819544314557809*^9}, {3.819544389509436*^9, 
   3.8195444203004527`*^9}, {3.8195444519445915`*^9, 
   3.8195444815000525`*^9}, {3.8195445295143747`*^9, 3.819544591100726*^9}, {
   3.8195522650427027`*^9, 3.8195522775594163`*^9}, {3.819552729203745*^9, 
   3.8195527331075583`*^9}, {3.819552813435012*^9, 3.819552823375866*^9}, {
   3.8195528653040876`*^9, 3.819552964109207*^9}, {3.819553013293764*^9, 
   3.8195530578560066`*^9}, {3.8195531500169487`*^9, 
   3.8195533831370773`*^9}, {3.819553469671318*^9, 3.8195534720199356`*^9}, {
   3.819553551232479*^9, 3.8195535734142*^9}, 3.81955363549296*^9, {
   3.819553669642494*^9, 3.819553673946971*^9}, {3.819553729403835*^9, 
   3.819553765445433*^9}, {3.8195538448955135`*^9, 3.8195540194568315`*^9}, {
   3.819554053863411*^9, 3.8195540987185555`*^9}, {3.819554139826338*^9, 
   3.8195542858376045`*^9}, {3.8195545000362234`*^9, 3.819554520485716*^9}, {
   3.8195545739149137`*^9, 3.8195545743172755`*^9}, {3.81955460668602*^9, 
   3.8195546428639145`*^9}, {3.819554898266838*^9, 3.819554983509598*^9}, {
   3.819557627227332*^9, 3.8195577364698534`*^9}, {3.819557907021355*^9, 
   3.819557941187107*^9}, {3.819558360243764*^9, 3.8195587326311283`*^9}, {
   3.819558764721478*^9, 3.8195588143193307`*^9}, {3.8195589052690563`*^9, 
   3.8195589426678715`*^9}, {3.8195589772852044`*^9, 3.819559223096633*^9}, {
   3.8195592634130893`*^9, 3.819559264481163*^9}, {3.8195593030864477`*^9, 
   3.8195593928115635`*^9}, {3.819559426005068*^9, 3.819559430409444*^9}, {
   3.819559472544454*^9, 3.8195595082158165`*^9}, {3.8195595842306223`*^9, 
   3.8195596116235695`*^9}, {3.8195596427696304`*^9, 
   3.8195596627851944`*^9}, {3.81955969559801*^9, 3.819559718307716*^9}, {
   3.8195598336215067`*^9, 3.8195600941078377`*^9}, {3.819560130772997*^9, 
   3.8195601317935047`*^9}, {3.8195602504025636`*^9, 3.819560250624883*^9}, {
   3.819560282075344*^9, 3.8195603316516657`*^9}, {3.819560376729049*^9, 
   3.8195604037525697`*^9}, {3.8195604443230314`*^9, 
   3.8195605250138025`*^9}, {3.819568153736174*^9, 3.8195681872520094`*^9}, 
   3.8195682278098927`*^9, {3.8195682802516346`*^9, 3.8195682852865553`*^9}, {
   3.8195683162738166`*^9, 3.8195683176257997`*^9}, 3.819568360259159*^9, {
   3.8195684202321653`*^9, 3.8195687831662483`*^9}, {3.819568832892454*^9, 
   3.8195689305271482`*^9}, {3.8196078657533283`*^9, 
   3.8196079865285864`*^9}, {3.8196080500865726`*^9, 
   3.8196081303074737`*^9}, {3.819608301033976*^9, 3.819608301247155*^9}, {
   3.819608362449651*^9, 3.819608419470332*^9}, {3.819608467961836*^9, 
   3.819608678103877*^9}, {3.8196087303799877`*^9, 3.819608784854595*^9}, {
   3.819608846146578*^9, 3.8196089238550873`*^9}, {3.8196093891816607`*^9, 
   3.8196093913664093`*^9}, {3.8196094566868467`*^9, 3.819609470318615*^9}, {
   3.8196095168268633`*^9, 3.819609657209533*^9}, {3.819609710677288*^9, 
   3.8196097161005507`*^9}, {3.8196118801394186`*^9, 
   3.8196119156237936`*^9}, {3.8196195604872265`*^9, 3.819619561407859*^9}, {
   3.8196218990088563`*^9, 3.819621952849913*^9}, {3.8196220592992945`*^9, 
   3.819622085757207*^9}, {3.8196221464314446`*^9, 3.8196222404160786`*^9}, {
   3.8196222792144203`*^9, 3.8196224079203405`*^9}, {3.8196224610865297`*^9, 
   3.8196224707742453`*^9}, 3.819622505588605*^9, {3.819622548900567*^9, 
   3.8196225754035597`*^9}, 3.8196227397069616`*^9, 3.8196227949120493`*^9, {
   3.81962290958683*^9, 3.8196229098525352`*^9}, {3.8196231368840265`*^9, 
   3.8196231852236757`*^9}, {3.8196232518677673`*^9, 
   3.8196232659546623`*^9}, {3.8196233178978434`*^9, 
   3.8196233449387646`*^9}, {3.8196233816690407`*^9, 
   3.8196234069974704`*^9}, {3.819623437708328*^9, 3.8196234386571274`*^9}, {
   3.8196235718766537`*^9, 3.819623593227991*^9}, {3.8196236417222557`*^9, 
   3.819623647159621*^9}, {3.8196236814170027`*^9, 3.8196236986447697`*^9}, {
   3.8196239148311987`*^9, 3.8196239219665923`*^9}, {3.8196241949648714`*^9, 
   3.8196242345459633`*^9}, {3.819633034965732*^9, 3.819633055221856*^9}, {
   3.819708897068447*^9, 3.819708948198221*^9}, {3.8197091198690968`*^9, 
   3.819709120103654*^9}, {3.8198898455989885`*^9, 3.8198898788158293`*^9}, {
   3.8199011023088927`*^9, 3.8199011488670073`*^9}, {3.8199026293647957`*^9, 
   3.8199026464531317`*^9}, {3.819909622854993*^9, 3.8199096452752724`*^9}, {
   3.8199097523184977`*^9, 3.8199097554858418`*^9}, {3.8199648904646325`*^9, 
   3.819964960752989*^9}, {3.8201513224833384`*^9, 3.820151338665926*^9}, {
   3.820215043178911*^9, 3.820215110750529*^9}, {3.8202151430093827`*^9, 
   3.8202151824203796`*^9}, {3.8202152218260746`*^9, 
   3.8202152740980763`*^9}, {3.8202153059650784`*^9, 
   3.8202153352841587`*^9}, {3.820219953107639*^9, 3.820220012388942*^9}, {
   3.820220051832591*^9, 3.820220074999411*^9}, {3.8202201161352882`*^9, 
   3.820220257366601*^9}, {3.820220305872952*^9, 3.820220352129758*^9}, {
   3.8202204638499928`*^9, 3.8202205088179045`*^9}, {3.820220572626564*^9, 
   3.8202206447583923`*^9}, {3.820415106794894*^9, 3.8204151077927136`*^9}, {
   3.820415204842013*^9, 3.8204152587556024`*^9}, {3.8204153451349363`*^9, 
   3.8204153655876627`*^9}, {3.8204154070435534`*^9, 
   3.8204154747424326`*^9}, {3.8204155080864553`*^9, 3.820415516505601*^9}, {
   3.8204155654224615`*^9, 3.8204156547777853`*^9}, {3.820415703242568*^9, 
   3.8204157080134497`*^9}, {3.8204157430860033`*^9, 3.820415824824645*^9}, {
   3.820415861142689*^9, 3.8204158765526094`*^9}, {3.820415938410175*^9, 
   3.8204159450971994`*^9}, {3.8204161663620305`*^9, 
   3.8204161682525587`*^9}, {3.82042723864893*^9, 3.8204274063001847`*^9}, {
   3.820427445560427*^9, 3.8204275024430532`*^9}, 3.8204276267318726`*^9, {
   3.8204276814704943`*^9, 3.8204276985445423`*^9}, {3.82042774769491*^9, 
   3.820427811911042*^9}, {3.8204278457658052`*^9, 3.8204278961298447`*^9}, {
   3.8204279472318068`*^9, 3.8204279480941396`*^9}, 3.8204342153427353`*^9, {
   3.8204342655659895`*^9, 3.820434294448639*^9}, {3.8204343454849415`*^9, 
   3.8204343498538265`*^9}, {3.820434393513609*^9, 3.820434437766546*^9}, 
   3.8204344708804207`*^9, {3.820434512966323*^9, 3.820434588385872*^9}, {
   3.8204346240238094`*^9, 3.8204346243660164`*^9}, {3.8204346920936174`*^9, 
   3.8204347591407614`*^9}, {3.820434794071168*^9, 3.820434794520854*^9}, {
   3.820434847346823*^9, 3.820434899063538*^9}, {3.820434951346383*^9, 
   3.820434975978527*^9}, {3.820435019015091*^9, 3.8204350224958134`*^9}, {
   3.8204351121987677`*^9, 3.820435112374334*^9}, {3.8204357440435104`*^9, 
   3.8204357897084875`*^9}, 3.8204358530889854`*^9, {3.820435924855419*^9, 
   3.820435943234169*^9}, 3.8204359849372234`*^9, {3.820436126721798*^9, 
   3.8204361553123217`*^9}, {3.820436319336717*^9, 3.8204363495321817`*^9}, {
   3.820436384434908*^9, 3.820436457366782*^9}, {3.8204364941219645`*^9, 
   3.8204364945120587`*^9}, {3.8204381143330116`*^9, 
   3.8204381430768547`*^9}, {3.820438204278058*^9, 3.8204382564011173`*^9}, {
   3.8204382993781834`*^9, 3.8204383467810335`*^9}, 3.820438381682759*^9, {
   3.82047165506681*^9, 3.8204717263569865`*^9}, {3.8204717781075134`*^9, 
   3.8204721223983355`*^9}, 3.820472164420216*^9, {3.8204723199958076`*^9, 
   3.8204723231864204`*^9}, {3.8204723677753644`*^9, 
   3.8204723962690945`*^9}, {3.8204724866077795`*^9, 3.820472486793661*^9}, {
   3.8204805870003023`*^9, 3.820480786824202*^9}, {3.82048083395739*^9, 
   3.8204808442230806`*^9}, {3.820480884187772*^9, 3.8204808953975425`*^9}, {
   3.8204809616578584`*^9, 3.8204809623401637`*^9}, {3.820481215818927*^9, 
   3.8204812243828917`*^9}, {3.820481270101946*^9, 3.820481297877659*^9}, 
   3.8204816229446573`*^9, {3.820484586796197*^9, 3.8204846208253374`*^9}, {
   3.8204846541173625`*^9, 3.8204846568496623`*^9}, {3.820484695603256*^9, 
   3.820484702322134*^9}, {3.8204847329767923`*^9, 3.820484801012638*^9}, {
   3.820501830904258*^9, 3.8205018838569283`*^9}, {3.8205019306804633`*^9, 
   3.8205019408045993`*^9}, {3.820504171930524*^9, 3.82050418868172*^9}, {
   3.8205042312406197`*^9, 3.820504359690914*^9}, {3.820504390580705*^9, 
   3.8205044778584576`*^9}, {3.8205780906538877`*^9, 
   3.8205781985542946`*^9}, {3.8205831883292603`*^9, 3.820583226544594*^9}, {
   3.820583286141553*^9, 3.8205834386555624`*^9}, {3.820593243702889*^9, 
   3.820593258639552*^9}, {3.8205932957660894`*^9, 3.820593310070655*^9}, {
   3.8205933451752434`*^9, 3.8205933457411346`*^9}, 3.820593379041186*^9, {
   3.8205934271208344`*^9, 3.8205935639315376`*^9}, {3.8205957785491*^9, 
   3.820595951651881*^9}, {3.820604289536376*^9, 3.8206043234819555`*^9}, {
   3.820605237395909*^9, 3.820605326453918*^9}, {3.820605370335977*^9, 
   3.820605439520532*^9}, {3.820605480970848*^9, 3.820605606962201*^9}, {
   3.8206484414519796`*^9, 3.820648500081749*^9}, {3.8206485301734157`*^9, 
   3.8206485694018183`*^9}, {3.8206486151610394`*^9, 3.820648687689396*^9}, {
   3.8206487185227904`*^9, 3.8206487194897914`*^9}, {3.8206488065689692`*^9, 
   3.8206488291853795`*^9}, {3.820649168641529*^9, 3.8206491823331623`*^9}, {
   3.820649783129217*^9, 3.8206498044738517`*^9}, {3.820649839274724*^9, 
   3.8206498404453497`*^9}, {3.8206499018848147`*^9, 3.8206500155576982`*^9}, 
   3.8206500560256047`*^9, {3.8206500894044447`*^9, 3.820650147236788*^9}, {
   3.8206502088586016`*^9, 3.8206502111230063`*^9}, {3.820651374446941*^9, 
   3.8206514990736446`*^9}, {3.8206515305574827`*^9, 3.820651550089117*^9}, {
   3.8206515805061626`*^9, 3.820651580912281*^9}, {3.820651642230935*^9, 
   3.8206517131042805`*^9}, {3.820651760439536*^9, 3.820651862801162*^9}, {
   3.820651914192275*^9, 3.820651951734209*^9}, {3.8206520195892773`*^9, 
   3.8206520450617237`*^9}, {3.820652146381635*^9, 3.8206521644077826`*^9}, {
   3.8206522291389823`*^9, 3.8206522293268094`*^9}, {3.8206522608631845`*^9, 
   3.820652269226379*^9}, {3.8206523009689355`*^9, 3.820652315068446*^9}, {
   3.820652534746304*^9, 3.8206526343658867`*^9}, {3.82065272552761*^9, 
   3.8206527743220606`*^9}, {3.8206528067836614`*^9, 3.820652839540696*^9}, {
   3.8206529230597267`*^9, 3.820653025007696*^9}, {3.820653075701451*^9, 
   3.8206530773732967`*^9}, {3.8206570028760433`*^9, 
   3.8206570383679123`*^9}, {3.8206570789614935`*^9, 3.820657129224473*^9}, {
   3.820660516034343*^9, 3.8206605361135654`*^9}, {3.8206805331350317`*^9, 
   3.820680561484832*^9}, {3.820680591754021*^9, 3.820680610582756*^9}, 
   3.8208241873266745`*^9, 3.8208242606286*^9, {3.8208252495527215`*^9, 
   3.820825254289153*^9}, {3.8208255380004854`*^9, 3.82082553866633*^9}, {
   3.8208359138959565`*^9, 3.820836205827113*^9}, {3.8208362387585707`*^9, 
   3.8208362904792275`*^9}, {3.8208366449658785`*^9, 
   3.8208366712497883`*^9}, {3.8208367391016827`*^9, 3.8208367568335805`*^9}, 
   3.8208368085532727`*^9, {3.820837096683236*^9, 3.8208371130376873`*^9}, {
   3.8208371945190315`*^9, 3.8208372212360153`*^9}, {3.8208372793050194`*^9, 
   3.8208372928687863`*^9}, {3.8208373805646353`*^9, 3.820837415099177*^9}, {
   3.8208374826795855`*^9, 3.820837500445628*^9}, {3.8208378411209683`*^9, 
   3.820837858172222*^9}, {3.820837894275363*^9, 3.820837909007085*^9}, {
   3.820837960004798*^9, 3.820838015729005*^9}, {3.8208380642632885`*^9, 
   3.820838071720986*^9}, {3.820838119234727*^9, 3.8208381244252005`*^9}, {
   3.8208381777012925`*^9, 3.8208382412769613`*^9}, {3.820838432604375*^9, 
   3.8208384852363424`*^9}, {3.820838609166887*^9, 3.8208386539151983`*^9}, {
   3.820838773450491*^9, 3.8208388793236256`*^9}, {3.820842543276417*^9, 
   3.8208425457441597`*^9}, {3.8208428653953524`*^9, 3.820842865590334*^9}, {
   3.8208429786165934`*^9, 3.820843127558262*^9}, {3.8208433933612795`*^9, 
   3.8208434469526324`*^9}, {3.8208434845513983`*^9, 3.8208434848161316`*^9}, 
   3.8208435232617717`*^9, 3.8208435603619347`*^9, 3.8208435924368563`*^9, {
   3.8208751863743553`*^9, 3.8208751876665773`*^9}, {3.820875218616767*^9, 
   3.8208752564277334`*^9}, {3.8208753064888573`*^9, 
   3.8208753247717004`*^9}, {3.820875358270975*^9, 3.820875393579418*^9}, {
   3.820875441350625*^9, 3.8208754592220125`*^9}, {3.820875521248685*^9, 
   3.8208755495470057`*^9}, {3.820875839978199*^9, 3.820875940043632*^9}, 
   3.820875973021433*^9, {3.820876010721727*^9, 3.8208760616728697`*^9}, {
   3.8208760976087456`*^9, 3.820876098028082*^9}, {3.8208762686615*^9, 
   3.820876291294077*^9}, {3.8208763273556376`*^9, 3.820876415031866*^9}, {
   3.8208764840830145`*^9, 3.820876494417709*^9}, {3.8208765249863443`*^9, 
   3.8208765289964485`*^9}, {3.8208767053474903`*^9, 3.820876729326001*^9}, {
   3.8208768315015144`*^9, 3.8208769084809527`*^9}, {3.820876954066622*^9, 
   3.8208770653756866`*^9}, {3.8208770992161827`*^9, 3.820877106051706*^9}, {
   3.820877161606661*^9, 3.820877190572707*^9}, {3.8208773306114845`*^9, 
   3.820877386203088*^9}, {3.820924078188179*^9, 3.8209241187500896`*^9}, {
   3.82092420529734*^9, 3.8209242319570704`*^9}, {3.8209242898454137`*^9, 
   3.8209243010658097`*^9}, {3.8209243391552253`*^9, 
   3.8209244056803846`*^9}, {3.820926230466712*^9, 3.8209263000985026`*^9}, {
   3.8209263471952243`*^9, 3.8209263480455065`*^9}, {3.8209263809784803`*^9, 
   3.8209263883615246`*^9}, {3.8209264432152195`*^9, 3.820926501915661*^9}, {
   3.8209265689689474`*^9, 3.820926585184435*^9}, {3.8209382721824303`*^9, 
   3.820938324280955*^9}, {3.820938376306284*^9, 3.820938411044826*^9}, {
   3.8209384457257166`*^9, 3.8209384612027197`*^9}, {3.8209384951813216`*^9, 
   3.8209385854792805`*^9}, {3.8209386196076183`*^9, 3.820938772048355*^9}, {
   3.820939614480462*^9, 3.82093964202565*^9}, {3.8210122271849117`*^9, 
   3.821012234249359*^9}, 3.8210122931705246`*^9, {3.8210162727781277`*^9, 
   3.821016307987356*^9}, {3.821016339530925*^9, 3.821016375794486*^9}, {
   3.8210164374814234`*^9, 3.8210164772210293`*^9}, {3.8210165782483654`*^9, 
   3.821016579221088*^9}, {3.8210166101143723`*^9, 3.821016611080646*^9}, {
   3.8210166426936855`*^9, 3.8210166428560696`*^9}, {3.8210166731685*^9, 
   3.821016756280438*^9}, 3.821016788666777*^9, {3.8210169380716505`*^9, 
   3.821016939302887*^9}, {3.821016981969103*^9, 3.8210169831542473`*^9}, {
   3.8210256768040104`*^9, 3.8210256811523*^9}, {3.8212113959481187`*^9, 
   3.8212114302437925`*^9}, {3.821211470085577*^9, 3.821211485258436*^9}, {
   3.821211530779982*^9, 3.8212115512559023`*^9}, {3.8212590436129894`*^9, 
   3.821259045189206*^9}, {3.821259085420705*^9, 3.8212591097270613`*^9}, {
   3.8212594110966854`*^9, 3.8212594339365764`*^9}, {3.821259464511897*^9, 
   3.8212594649669333`*^9}, 3.821259497720522*^9, {3.8213824957308245`*^9, 
   3.821382537561203*^9}, {3.8218521996472435`*^9, 3.8218522001549244`*^9}, 
   3.821852232115768*^9, {3.8218522686179967`*^9, 3.8218522717820387`*^9}, {
   3.8218523024854965`*^9, 3.8218523852255793`*^9}, 3.8220180747911987`*^9, 
   3.8220181104602375`*^9, {3.8220181660818095`*^9, 3.8220181907529597`*^9}, {
   3.822018251222975*^9, 3.8220183113235617`*^9}, {3.8220184276613626`*^9, 
   3.82201842830696*^9}, 3.8220184776332817`*^9, {3.822018527988822*^9, 
   3.8220185727965317`*^9}, {3.822018612218847*^9, 3.822018637231209*^9}, {
   3.8220186874707365`*^9, 3.822018689792178*^9}, {3.822019185487295*^9, 
   3.822019411041501*^9}, {3.822019497863099*^9, 3.822019500653947*^9}, {
   3.8220198151996117`*^9, 3.822019899118984*^9}, {3.822019937559367*^9, 
   3.822019937770094*^9}, {3.822020028050147*^9, 3.8220200447156696`*^9}, {
   3.822022074096051*^9, 3.822022079300493*^9}, {3.822022210054281*^9, 
   3.822022229202192*^9}, {3.8220222635529933`*^9, 3.822022270985999*^9}, {
   3.8220228507598333`*^9, 3.822022865060396*^9}, {3.822025736778472*^9, 
   3.8220257863258615`*^9}, {3.8220259830863504`*^9, 3.822026073620784*^9}, {
   3.822026113828026*^9, 3.822026116395156*^9}, {3.8220262289027786`*^9, 
   3.8220262319003477`*^9}, {3.8220263325128765`*^9, 
   3.8220263398284454`*^9}, {3.82203657408068*^9, 3.822036604680438*^9}, {
   3.8220472116604757`*^9, 3.822047214299779*^9}, {3.8220472687838764`*^9, 
   3.8220472706289806`*^9}, {3.8220476227970343`*^9, 3.822047685901536*^9}, {
   3.8220478571690917`*^9, 3.822047859995473*^9}, {3.822047931866088*^9, 
   3.8220479381537123`*^9}, {3.822048002528656*^9, 3.8220480162890873`*^9}, {
   3.822048093148329*^9, 3.822048097910994*^9}, {3.8220482447268944`*^9, 
   3.8220482950080004`*^9}, {3.8220483264822054`*^9, 3.8220483547481527`*^9}, 
   3.822048389057697*^9, {3.8220484237492733`*^9, 3.822048425951923*^9}, {
   3.822048479650366*^9, 3.822048487635389*^9}, {3.822052253597599*^9, 
   3.82205225710888*^9}, {3.8220522875460486`*^9, 3.822052333780898*^9}, {
   3.8220524437862816`*^9, 3.8220525236257906`*^9}, {3.82205327658259*^9, 
   3.8220533150018797`*^9}, {3.8220533457606564`*^9, 3.822053345940794*^9}, 
   3.8220533834350753`*^9, {3.8220534969422016`*^9, 3.8220535337294855`*^9}, {
   3.8221366667211475`*^9, 3.822136782819027*^9}, {3.822835913323887*^9, 
   3.822835962393944*^9}, {3.822835999226451*^9, 3.822836276219328*^9}, {
   3.8228363329534206`*^9, 3.8228363614756775`*^9}, {3.8228364082933764`*^9, 
   3.822836410583146*^9}, 3.8228368521412187`*^9, {3.82283688603586*^9, 
   3.822836969138629*^9}, {3.8228370418444653`*^9, 3.8228371311285286`*^9}, {
   3.8228372010229063`*^9, 3.8228372416721134`*^9}, {3.822837297052293*^9, 
   3.8228372977880754`*^9}, {3.8228382310434237`*^9, 
   3.8228383265944014`*^9}, {3.8228383605271654`*^9, 3.822838449170597*^9}, {
   3.822838507336235*^9, 3.822838507646039*^9}, {3.8228436562961893`*^9, 
   3.822843656815291*^9}, 3.8228443546782093`*^9, {3.8228445842284684`*^9, 
   3.8228445985906267`*^9}, {3.822914988330088*^9, 3.822915062918045*^9}, {
   3.82291738971094*^9, 3.822917487417025*^9}, {3.8229175518480597`*^9, 
   3.8229176138479776`*^9}, {3.822917645084646*^9, 3.822917658795266*^9}, {
   3.822917699682674*^9, 3.822917744573695*^9}, {3.8229177754605536`*^9, 
   3.8229177832259235`*^9}, {3.8229178160183306`*^9, 3.822917817688472*^9}, 
   3.8229178551288166`*^9, {3.8229180066593003`*^9, 3.8229180155167713`*^9}, {
   3.8229180826028843`*^9, 3.8229181741675367`*^9}, {3.82291821968266*^9, 
   3.8229182666072383`*^9}, {3.8229183066087313`*^9, 3.822918334941045*^9}, {
   3.8229184113191614`*^9, 3.822918457267807*^9}, {3.8229185039166603`*^9, 
   3.822918546107794*^9}, {3.8229185826083517`*^9, 3.8229185891360416`*^9}, {
   3.8229186385930367`*^9, 3.822918651112154*^9}, {3.822918932658841*^9, 
   3.8229190466371226`*^9}, {3.8229191024737453`*^9, 
   3.8229191862137356`*^9}, {3.82291934632547*^9, 3.822919357230523*^9}, {
   3.8229195899746914`*^9, 3.8229197107357035`*^9}, {3.8229197497163153`*^9, 
   3.822919770705586*^9}, {3.8229198846557302`*^9, 3.822919939635249*^9}, 
   3.822920000265362*^9, {3.8229200972831078`*^9, 3.82292015547631*^9}, {
   3.822920197612296*^9, 3.822920275692706*^9}, {3.8229203325082874`*^9, 
   3.8229203328568845`*^9}, {3.8229203724323373`*^9, 
   3.8229203959863033`*^9}, {3.822920437109559*^9, 3.822920464969555*^9}, {
   3.82292065304915*^9, 3.8229206957934628`*^9}, 3.822920727048339*^9, 
   3.822921208838917*^9, {3.8229213426616297`*^9, 3.822921349439601*^9}, {
   3.8229214248001766`*^9, 3.8229214253518996`*^9}, {3.8229219158428326`*^9, 
   3.8229219319617853`*^9}, {3.8229219799250736`*^9, 3.822922004653284*^9}, {
   3.822924123341341*^9, 3.8229241235538206`*^9}, {3.8229241541097918`*^9, 
   3.822924357033531*^9}, {3.8229243917184668`*^9, 3.8229245757090025`*^9}, {
   3.8229246080231934`*^9, 3.822924866863801*^9}, {3.822925816239849*^9, 
   3.822925870159624*^9}, {3.8229263008705177`*^9, 3.8229263304663506`*^9}, {
   3.8229264137240477`*^9, 3.822926459226445*^9}, {3.822926498857438*^9, 
   3.822926522742756*^9}, {3.8229266957523837`*^9, 3.8229268168391943`*^9}, {
   3.822927028115615*^9, 3.8229270292330184`*^9}, {3.8229273511396437`*^9, 
   3.82292738529078*^9}, {3.822927455218667*^9, 3.8229274846128793`*^9}, {
   3.8229275336934347`*^9, 3.8229275447704773`*^9}, {3.822927622097934*^9, 
   3.822927622349578*^9}, {3.8229323030170994`*^9, 3.8229324648464108`*^9}, {
   3.8229324962044144`*^9, 3.8229326494690733`*^9}, {3.8229327245006323`*^9, 
   3.8229327615331635`*^9}, {3.822932796936345*^9, 3.8229328273246756`*^9}, {
   3.8229329344921*^9, 3.822933074034281*^9}, {3.82293395447163*^9, 
   3.822934119204471*^9}, {3.822934184409373*^9, 3.8229342562490196`*^9}, {
   3.822934321884079*^9, 3.8229343230879784`*^9}, {3.822934378406666*^9, 
   3.822934473272182*^9}, {3.8229345187296677`*^9, 3.822934609701584*^9}, {
   3.8229346607377825`*^9, 3.8229346766458397`*^9}, {3.822935092922742*^9, 
   3.8229352587878275`*^9}, {3.822935292323465*^9, 3.822935319023135*^9}, {
   3.8229353690788565`*^9, 3.8229353710783787`*^9}, {3.8229354046588335`*^9, 
   3.822935415345481*^9}, {3.8229354534069967`*^9, 3.8229354819389195`*^9}, {
   3.8229355908107595`*^9, 3.822935673547146*^9}, {3.8229357093084145`*^9, 
   3.822935755374807*^9}, {3.8229358029669704`*^9, 3.8229358092991467`*^9}, {
   3.822935970181049*^9, 3.822936049652819*^9}, {3.8229361271918945`*^9, 
   3.82293616051682*^9}, {3.8229362293028507`*^9, 3.822936255269235*^9}, {
   3.8229363666740217`*^9, 3.822936484178008*^9}, 3.8229365403938203`*^9, {
   3.8229365716979675`*^9, 3.8229365718974876`*^9}, {3.822936649910027*^9, 
   3.8229366825482144`*^9}, {3.8229367255419273`*^9, 3.822936797995204*^9}, {
   3.8229369332345843`*^9, 3.8229369383702292`*^9}, {3.8229369940252466`*^9, 
   3.8229370166939774`*^9}, {3.8234298705891123`*^9, 3.823429888644868*^9}, {
   3.8234311164115257`*^9, 3.823431137329258*^9}, {3.823431174511648*^9, 
   3.823431267879324*^9}, {3.823431306106545*^9, 3.823431331332843*^9}, {
   3.8234313804151998`*^9, 3.823431438822302*^9}, {3.8234314801122403`*^9, 
   3.8234314805436296`*^9}, {3.8234316268578777`*^9, 3.823431630627489*^9}, {
   3.8234320286647644`*^9, 3.8234320468798647`*^9}, {3.8234320805827894`*^9, 
   3.823432124437076*^9}, 3.8234321971799574`*^9, {3.823432227741994*^9, 
   3.823432237209523*^9}, {3.82343245291428*^9, 3.8234326322727213`*^9}, {
   3.8234326741437855`*^9, 3.8234327160047064`*^9}, {3.8234327883105288`*^9, 
   3.823432794624725*^9}, 3.823432830700038*^9, {3.8234424114487524`*^9, 
   3.82344243642328*^9}, {3.823444416141587*^9, 3.8234444583214235`*^9}, {
   3.823447019078278*^9, 3.823447036684964*^9}, {3.823447075487904*^9, 
   3.8234470819898276`*^9}, {3.8234471142501793`*^9, 3.823447119499693*^9}, {
   3.823447328013794*^9, 3.82344742420549*^9}, {3.8234474610182376`*^9, 
   3.8234474944399624`*^9}, {3.8234475514257145`*^9, 
   3.8234475645086985`*^9}, {3.823447918772832*^9, 3.823447947191432*^9}, {
   3.823448238834309*^9, 3.8234482638550425`*^9}, {3.8234490809799795`*^9, 
   3.823449133375575*^9}, {3.8234495769395227`*^9, 3.823449661443486*^9}, 
   3.8234497477792463`*^9, 3.8234497823116636`*^9, {3.823450124449052*^9, 
   3.823450194621893*^9}, {3.8234502261844335`*^9, 3.823450270358781*^9}, {
   3.8234580391413355`*^9, 3.8234581213063765`*^9}, {3.823531112171873*^9, 
   3.8235311124196773`*^9}, {3.823531185586196*^9, 3.8235311862665834`*^9}, {
   3.8235319256492357`*^9, 3.8235319329991803`*^9}, {3.8235319684437246`*^9, 
   3.823531975981274*^9}, {3.8235320232164955`*^9, 3.8235320321467676`*^9}, {
   3.823532083617467*^9, 3.8235320860990696`*^9}, {3.8235321301409116`*^9, 
   3.8235321834672813`*^9}, {3.82353269327563*^9, 3.823532714888461*^9}, {
   3.823532843764489*^9, 3.82353288316323*^9}, {3.8235331834515324`*^9, 
   3.823533192137967*^9}, {3.8235332228213425`*^9, 3.823533275432782*^9}, {
   3.823606958523142*^9, 3.8236069913305597`*^9}, {3.8236070925119286`*^9, 
   3.8236071497069006`*^9}, {3.8236072196432505`*^9, 3.823607284723608*^9}, 
   3.8236073448392916`*^9, {3.8236073752756643`*^9, 3.8236075862663603`*^9}, {
   3.823607617776724*^9, 3.82360763188875*^9}, {3.8236076736651163`*^9, 
   3.823607673913827*^9}, {3.8236083798259044`*^9, 3.8236083984799356`*^9}, {
   3.8236084714048357`*^9, 3.823608474643424*^9}, {3.8236085133676524`*^9, 
   3.823608515636681*^9}, 3.8236085575845213`*^9, {3.8236095311952353`*^9, 
   3.8236095664735537`*^9}, {3.8236096062017555`*^9, 3.823609613111678*^9}, {
   3.823609686574416*^9, 3.8236097404164114`*^9}, {3.823761453872016*^9, 
   3.8237614785900087`*^9}, {3.8237626514874444`*^9, 
   3.8237626602350073`*^9}, {3.823762695175088*^9, 3.823762698310253*^9}, {
   3.823776387259294*^9, 3.8237764129992666`*^9}, {3.8237764561429625`*^9, 
   3.823776626040675*^9}, {3.8237767056755676`*^9, 3.823776795474934*^9}, {
   3.8237768286630135`*^9, 3.8237768289003787`*^9}, {3.823776861238881*^9, 
   3.823776868573691*^9}, {3.8237769107938757`*^9, 3.823777162664397*^9}, {
   3.8237772191051674`*^9, 3.8237772196791587`*^9}, {3.8237772598084364`*^9, 
   3.8237773567426753`*^9}, {3.823777387798933*^9, 3.8237774643127103`*^9}, {
   3.823777522108469*^9, 3.8237775234384513`*^9}, {3.823777564496584*^9, 
   3.823777647752817*^9}, {3.8237777797326603`*^9, 3.8237777835707703`*^9}, {
   3.823777836351264*^9, 3.8237778569708366`*^9}, {3.8237779226241703`*^9, 
   3.8237779363201475`*^9}, {3.8237779834737825`*^9, 
   3.8237780653164234`*^9}, {3.8237781048496466`*^9, 
   3.8237782066247883`*^9}, {3.8237782391232753`*^9, 3.823778239318777*^9}, {
   3.823778275473134*^9, 3.8237783334515567`*^9}, {3.8237783703206387`*^9, 
   3.8237783712255917`*^9}, {3.823778708545192*^9, 3.8237787096953425`*^9}, {
   3.823785177367061*^9, 3.8237852427489505`*^9}, {3.8237853391589994`*^9, 
   3.823785383488188*^9}, {3.8237854185887976`*^9, 3.8237855337733603`*^9}, {
   3.8237855863893538`*^9, 3.8237856444044695`*^9}, {3.8237857006760044`*^9, 
   3.823785839203753*^9}, 3.823791529435955*^9, {3.8237915813447337`*^9, 
   3.8237916055142746`*^9}, {3.8237919595439787`*^9, 
   3.8237919720792065`*^9}, {3.8237920519712534`*^9, 3.8237920629910984`*^9}, 
   3.8237921409313035`*^9, {3.8237922530762186`*^9, 3.8237925775599356`*^9}, 
   3.8237926652506857`*^9, {3.8237928090869837`*^9, 3.8237928885816655`*^9}, {
   3.8237930052247286`*^9, 3.8237931340290356`*^9}, {3.823793185389136*^9, 
   3.823793186771385*^9}, {3.823793220599863*^9, 3.8237932610619116`*^9}, 
   3.823793310862575*^9, 3.8237933525103087`*^9, 3.823793391018583*^9, {
   3.823793497919715*^9, 3.8237935526451807`*^9}, {3.8237935902814074`*^9, 
   3.823793643979226*^9}, {3.8237936801256533`*^9, 3.8237938082489758`*^9}, {
   3.823793838980192*^9, 3.8237941027850647`*^9}, {3.823794140320717*^9, 
   3.8237941604457827`*^9}, {3.82379420577672*^9, 3.8237942919844484`*^9}, {
   3.823794435010377*^9, 3.8237944489307127`*^9}, {3.823794503308609*^9, 
   3.8237945040145264`*^9}, {3.823794541716939*^9, 3.8237945461261635`*^9}, {
   3.8237945764752903`*^9, 3.8237946737402725`*^9}, {3.8237947100363913`*^9, 
   3.8237948550604973`*^9}, {3.823794891678585*^9, 3.8237949211682253`*^9}, {
   3.8237949895820637`*^9, 3.8237951056976976`*^9}, {3.8237951486447134`*^9, 
   3.8237951719599247`*^9}, {3.8237952081373186`*^9, 
   3.8237952189854183`*^9}, {3.823795270414569*^9, 3.8237954341522155`*^9}, {
   3.823795472433134*^9, 3.823795706181066*^9}, {3.823795880892764*^9, 
   3.8237959032220864`*^9}, {3.8237960013860292`*^9, 
   3.8237960675161343`*^9}, {3.8237961076611495`*^9, 
   3.8237961086555305`*^9}, {3.823796157468195*^9, 3.8237966298559275`*^9}, {
   3.8237966736746798`*^9, 3.823796693380692*^9}, {3.8237968791169786`*^9, 
   3.8237969185659604`*^9}, {3.8237969500880384`*^9, 
   3.8237970726095276`*^9}, {3.8237971033436794`*^9, 
   3.8237971073017635`*^9}, {3.8237971437545166`*^9, 
   3.8237972200239277`*^9}, {3.8237972544366274`*^9, 3.823797259514696*^9}, {
   3.8237973189658847`*^9, 3.8237973424057016`*^9}, {3.8237973878796597`*^9, 
   3.823797449895965*^9}, 3.8237974802864003`*^9, {3.8237975147445717`*^9, 
   3.8237975372361937`*^9}, 3.823797568482155*^9, {3.8237976035158463`*^9, 
   3.8237976400156565`*^9}, {3.8237976857466817`*^9, 
   3.8237977009897537`*^9}, {3.8237977807195983`*^9, 
   3.8237978334297485`*^9}, {3.823797864967266*^9, 3.823797895025683*^9}, {
   3.823798202175747*^9, 3.823798270958146*^9}, {3.8237983037360835`*^9, 
   3.823798334844015*^9}, {3.8237986049253693`*^9, 3.8237988656187253`*^9}, {
   3.823798906412176*^9, 3.823798909297553*^9}, {3.8237989412252827`*^9, 
   3.8237990116227784`*^9}, {3.823799052851179*^9, 3.8237992016352863`*^9}, {
   3.8237992815152965`*^9, 3.8237993675975885`*^9}, {3.823799403577075*^9, 
   3.8237994038247166`*^9}, {3.8237997010204144`*^9, 
   3.8237997322269635`*^9}, {3.8237997974999495`*^9, 3.823799869551312*^9}, 
   3.823799900367777*^9, {3.823799983739999*^9, 3.8237999922629833`*^9}, {
   3.8238012103524375`*^9, 3.8238012345703287`*^9}, {3.823801293380508*^9, 
   3.82380136221014*^9}, {3.8238014289847755`*^9, 3.823801455981495*^9}, {
   3.8238014919296184`*^9, 3.823801494562546*^9}, {3.8238015491137404`*^9, 
   3.823801554547789*^9}, {3.823801601237606*^9, 3.823801685311937*^9}, {
   3.823801717071351*^9, 3.82380172202535*^9}, {3.823801838597433*^9, 
   3.8238019842826366`*^9}, {3.823804100844453*^9, 3.8238042246296024`*^9}, {
   3.823804266913173*^9, 3.823804334932496*^9}, {3.8238044539900727`*^9, 
   3.8238045796694155`*^9}, {3.8238046354713507`*^9, 
   3.8238047037446623`*^9}, {3.823804742039244*^9, 3.8238047494619493`*^9}, {
   3.82380484767875*^9, 3.8238049339783807`*^9}, {3.823807708544679*^9, 
   3.823807724135294*^9}, {3.82380778599347*^9, 3.8238078632100067`*^9}, {
   3.8238078936081305`*^9, 3.823807893762883*^9}, 3.823807924213509*^9, {
   3.823807972259947*^9, 3.823807972503239*^9}, {3.8238080805428777`*^9, 
   3.8238081138041444`*^9}, {3.8238098437161684`*^9, 
   3.8238098439765644`*^9}, {3.823810267616559*^9, 3.823810268292901*^9}, {
   3.8238103000842752`*^9, 3.823810300371247*^9}, {3.8238103776763563`*^9, 
   3.8238104229236965`*^9}, {3.823810454091299*^9, 3.8238104548589067`*^9}, {
   3.823810752574489*^9, 3.823810752806628*^9}, {3.8238107858461957`*^9, 
   3.823810787797912*^9}, {3.8238504488575897`*^9, 3.8238504930453153`*^9}, 
   3.8238505920531797`*^9, {3.8238506804126577`*^9, 3.8238506805449514`*^9}, {
   3.823870109547078*^9, 3.8238701498744287`*^9}, {3.8238702082618427`*^9, 
   3.8238702139207764`*^9}, {3.8238704036007276`*^9, 
   3.8238704039942446`*^9}, {3.8238705755524344`*^9, 3.823870581098098*^9}, {
   3.8238707113822374`*^9, 3.8238707677746964`*^9}, {3.823870838266034*^9, 
   3.8238708539749002`*^9}, {3.8238709310729523`*^9, 
   3.8238709814447994`*^9}, {3.8238710444131513`*^9, 
   3.8238710469644136`*^9}, {3.8238711098810415`*^9, 3.823871325725211*^9}, {
   3.823871384249013*^9, 3.823871387210735*^9}, {3.8238714790121403`*^9, 
   3.823871543701084*^9}, {3.823871621692609*^9, 3.823871678942091*^9}, {
   3.8238717096703978`*^9, 3.8238717810361853`*^9}, {3.823871818086636*^9, 
   3.8238720026588326`*^9}, {3.823872049570204*^9, 3.8238722060872707`*^9}, {
   3.823872257709815*^9, 3.823872354735064*^9}, 3.8238724171063843`*^9, 
   3.823872514120472*^9, 3.823872631612596*^9, 3.8238727182687855`*^9, {
   3.82387276166522*^9, 3.823872949071202*^9}, {3.823872981466505*^9, 
   3.823873051719837*^9}, {3.823873118597328*^9, 3.823873145849311*^9}, {
   3.8238731862332*^9, 3.8238735315137568`*^9}, {3.8238735677619553`*^9, 
   3.82387361296592*^9}, {3.823873742342209*^9, 3.8238737431380296`*^9}, {
   3.8238737814235287`*^9, 3.823873832020249*^9}, {3.823876059095991*^9, 
   3.8238760872159595`*^9}, {3.823876145610209*^9, 3.823876153977701*^9}, {
   3.823876225359027*^9, 3.8238762260956287`*^9}, {3.8238762753626757`*^9, 
   3.823876303242637*^9}, {3.823876349355239*^9, 3.82387635090525*^9}, 
   3.8238764096085267`*^9, 3.8238764458433485`*^9, {3.8238765203931212`*^9, 
   3.8238766716212134`*^9}, {3.823876708152458*^9, 3.823876769228051*^9}, {
   3.823876802950779*^9, 3.82387689364476*^9}, {3.823876934576846*^9, 
   3.823876958355764*^9}, {3.823876988843481*^9, 3.8238770902866488`*^9}, {
   3.8238771236696725`*^9, 3.823877193711069*^9}, {3.823877230207956*^9, 
   3.8238772307627287`*^9}, 3.823877273464421*^9, {3.8238773478786087`*^9, 
   3.8238773480794683`*^9}, {3.8238780686160936`*^9, 3.823878229991146*^9}, {
   3.8238782798765616`*^9, 3.823878311459661*^9}, {3.8238785223941045`*^9, 
   3.823878632369134*^9}, {3.8238786730218005`*^9, 3.8238786746662107`*^9}, {
   3.823878718268969*^9, 3.8238787395241785`*^9}, {3.823878886156111*^9, 
   3.8238791148924007`*^9}, {3.823879525122285*^9, 3.8238795936389823`*^9}, {
   3.8238797335984282`*^9, 3.8238797342422085`*^9}, {3.8238798083536186`*^9, 
   3.8238798876227493`*^9}, {3.8238801841866183`*^9, 
   3.8238802105023203`*^9}, {3.8238802463301687`*^9, 
   3.8238802811527486`*^9}, {3.823880338583658*^9, 3.82388041719937*^9}, {
   3.823893906511911*^9, 3.8238940180521545`*^9}, {3.8238940509176426`*^9, 
   3.8238940529800105`*^9}, {3.823894132132451*^9, 3.8238941819725294`*^9}, {
   3.8238942172102427`*^9, 3.8238942571725206`*^9}, {3.823894387735214*^9, 
   3.823894421345257*^9}, {3.823894463581355*^9, 3.8238944957552032`*^9}, 
   3.8238945446905475`*^9, {3.823894588826372*^9, 3.8238946170459414`*^9}, {
   3.823894650574905*^9, 3.8238948607267904`*^9}, {3.8238949242762203`*^9, 
   3.8238949460163517`*^9}, {3.8238951280785675`*^9, 3.823895166369238*^9}, {
   3.8238952124866056`*^9, 3.823895333716918*^9}, {3.8238953682143154`*^9, 
   3.8238953686749935`*^9}, {3.82389542100226*^9, 3.8238955813468246`*^9}, {
   3.8238956370027423`*^9, 3.823895771098529*^9}, {3.8239527903431406`*^9, 
   3.823952799950756*^9}, 3.823952843948965*^9, {3.8239528745138817`*^9, 
   3.8239528992882557`*^9}, {3.8239529332071185`*^9, 3.823952934519825*^9}, {
   3.8239530022312045`*^9, 3.823953061126156*^9}, {3.823953099821086*^9, 
   3.8239531907273703`*^9}, {3.82395323330947*^9, 3.8239537886796074`*^9}, {
   3.8239538294349747`*^9, 3.8239539202064037`*^9}, {3.8239597033846793`*^9, 
   3.8239597327796855`*^9}, {3.8239597749612975`*^9, 3.823959816693342*^9}, {
   3.8242121501246424`*^9, 3.8242121574656863`*^9}, 3.824212191106477*^9, {
   3.8242122337473574`*^9, 3.824212248097704*^9}, {3.8242122842714133`*^9, 
   3.8242123007669935`*^9}, {3.824212478501466*^9, 3.8242125164070168`*^9}, {
   3.82422467560431*^9, 3.824224701928013*^9}, {3.8249009525695696`*^9, 
   3.8249009550247355`*^9}, {3.824900990771536*^9, 3.8249010167350907`*^9}, {
   3.824901110635441*^9, 3.824901113360564*^9}, {3.8249078570832396`*^9, 
   3.8249078638911734`*^9}, {3.8249079149163027`*^9, 3.824907915095375*^9}, {
   3.8249089174790416`*^9, 3.8249089354580135`*^9}, {3.8249863181589446`*^9, 
   3.8249863200093064`*^9}, {3.8249863510504293`*^9, 3.824986351255324*^9}, {
   3.824986391151997*^9, 3.8249863916443014`*^9}, {3.824986514858472*^9, 
   3.824986515012129*^9}, {3.8249970459222918`*^9, 3.8249970605478477`*^9}, {
   3.824997101075345*^9, 3.8249971212165995`*^9}, {3.824997153619586*^9, 
   3.824997154527031*^9}, {3.8249971871650157`*^9, 3.8249972253141446`*^9}, {
   3.825694151981763*^9, 3.825694179216509*^9}, {3.8257725996905537`*^9, 
   3.8257727909386053`*^9}, {3.8257729493577695`*^9, 
   3.8257729877689924`*^9}, {3.8257730339083214`*^9, 3.825773035181833*^9}, {
   3.8257730728695946`*^9, 3.825773120697481*^9}, {3.8257731680751514`*^9, 
   3.8257732426763444`*^9}, {3.8257735808830786`*^9, 
   3.8257735815870867`*^9}, {3.8264565493014235`*^9, 3.826456622612889*^9}, {
   3.8264567037323837`*^9, 3.8264567356217318`*^9}, {3.826457718398815*^9, 
   3.82645773256524*^9}, {3.8264577830486164`*^9, 3.8264577839734616`*^9}, {
   3.8264703155446978`*^9, 3.8264703299990683`*^9}, {3.826470371077613*^9, 
   3.8264703712800455`*^9}, {3.8264711100870943`*^9, 
   3.8264711150332127`*^9}, {3.826471225469352*^9, 3.8264712529213395`*^9}, {
   3.8264858181334467`*^9, 3.826485847548498*^9}, {3.8264859215288963`*^9, 
   3.8264859222894154`*^9}, {3.826485955585961*^9, 3.826485989012433*^9}, {
   3.82655267909365*^9, 3.826552682837103*^9}, {3.8265532564648495`*^9, 
   3.8265532771373587`*^9}, {3.82655333558305*^9, 3.826553336275387*^9}, {
   3.826554450377284*^9, 3.826554491186819*^9}, {3.826819824644045*^9, 
   3.826819827832385*^9}, {3.8268198814729414`*^9, 3.826819882658237*^9}, {
   3.8268199160495033`*^9, 3.826819922337214*^9}, {3.8268199708789716`*^9, 
   3.826819971081105*^9}, {3.8268200035212417`*^9, 3.8268200042424726`*^9}, {
   3.8268200734795895`*^9, 3.826820073886915*^9}, {3.8268201600322285`*^9, 
   3.826820160409807*^9}, {3.8268206948065896`*^9, 3.8268206985582113`*^9}, {
   3.8268207327708254`*^9, 3.826820810713952*^9}, {3.8268224616372805`*^9, 
   3.826822485341567*^9}, {3.8268225269718018`*^9, 3.8268225275588713`*^9}, {
   3.8268225601798344`*^9, 3.826822560665557*^9}, {3.8268226123013473`*^9, 
   3.8268226188637247`*^9}, {3.8268272077487803`*^9, 3.826827213767474*^9}, {
   3.8268273006806927`*^9, 3.826827360947815*^9}, {3.82682739682696*^9, 
   3.826827413354923*^9}, {3.8268290583911223`*^9, 3.8268290938911633`*^9}, {
   3.826857952107545*^9, 3.8268579527496896`*^9}, {3.8268582717878733`*^9, 
   3.826858272084769*^9}, {3.826858303345806*^9, 3.8268583038456326`*^9}, {
   3.826858340786316*^9, 3.826858354594199*^9}, {3.8268583970476737`*^9, 
   3.8268584148833947`*^9}, {3.826860646352828*^9, 3.826860667085415*^9}, {
   3.8268606974185715`*^9, 3.8268607635465775`*^9}, {3.826860794823618*^9, 
   3.826860811235342*^9}, {3.826879781276817*^9, 3.826879796469846*^9}, {
   3.8268798294868407`*^9, 3.826880061222973*^9}, {3.826880119366068*^9, 
   3.8268801703714075`*^9}, {3.8268802039584403`*^9, 
   3.8268802398572497`*^9}, {3.82688027318972*^9, 3.826880291816066*^9}, {
   3.8268804615841956`*^9, 3.826880462047407*^9}, {3.8268805161381955`*^9, 
   3.826880521258657*^9}, {3.8268806540170965`*^9, 3.826880658737029*^9}, {
   3.8268807894490147`*^9, 3.826880789653899*^9}, {3.826880923991889*^9, 
   3.8268809243530903`*^9}, {3.826902398499003*^9, 3.8269024795336294`*^9}, {
   3.826902518141283*^9, 3.82690257190818*^9}, 3.8269783550268416`*^9, {
   3.826978642640539*^9, 3.82697864285769*^9}, {3.826978719893078*^9, 
   3.826978756922922*^9}, {3.82697882275671*^9, 3.8269788229933453`*^9}, {
   3.8269788824113255`*^9, 3.8269789011316566`*^9}, {3.826978935951754*^9, 
   3.8269790647137833`*^9}, {3.827137027158156*^9, 3.8271370914819517`*^9}, {
   3.8271371270718837`*^9, 3.827137160559078*^9}, {3.827139811248214*^9, 
   3.8271398120663*^9}, {3.8271398460008545`*^9, 3.827139850948307*^9}, 
   3.8271399551620383`*^9, 3.827140031815751*^9, 3.8271401526605735`*^9, {
   3.8272319850908527`*^9, 3.827232040635368*^9}, {3.82723285096341*^9, 
   3.827233028498258*^9}, {3.827233083094741*^9, 3.8272331001103907`*^9}, 
   3.8272332960259476`*^9, {3.827235384946043*^9, 3.8272354538638043`*^9}, {
   3.827235510132265*^9, 3.8272355219804745`*^9}, {3.8272356025478463`*^9, 
   3.827235684740265*^9}, {3.8272359104737725`*^9, 3.8272359689989977`*^9}, {
   3.827236136054299*^9, 3.8272361376397667`*^9}, {3.827237485184383*^9, 
   3.8272375288731194`*^9}, {3.8272417063347683`*^9, 
   3.8272418230624866`*^9}, {3.8272418701341076`*^9, 
   3.8272419598460865`*^9}, {3.827242088540408*^9, 3.8272421038676624`*^9}, {
   3.827242204253556*^9, 3.8272422678940315`*^9}, {3.8272429465719433`*^9, 
   3.8272430303397846`*^9}, {3.8272464346003466`*^9, 
   3.8272464676107206`*^9}, {3.82725276151418*^9, 3.8272527847648344`*^9}, {
   3.8272528281103*^9, 3.827252828279787*^9}, {3.827252919467143*^9, 
   3.8272529511988816`*^9}, {3.827252996898491*^9, 3.8272530463274965`*^9}, {
   3.827253076355134*^9, 3.827253078327129*^9}, {3.8272531350780506`*^9, 
   3.827253236423068*^9}, {3.8272532826272573`*^9, 3.8272533597514706`*^9}, {
   3.8272533948524523`*^9, 3.827253441767332*^9}, {3.827253486357095*^9, 
   3.8272535102485867`*^9}, {3.827253644373918*^9, 3.8272536923845196`*^9}, {
   3.827253752533526*^9, 3.8272539310964193`*^9}, {3.8272539634536705`*^9, 
   3.827254031546234*^9}, {3.827254169884627*^9, 3.8272542454478383`*^9}, {
   3.827254275466508*^9, 3.8272542910609045`*^9}, {3.8272545286722383`*^9, 
   3.827254566823723*^9}, {3.8272546104850793`*^9, 3.8272547331089544`*^9}, {
   3.827254774131261*^9, 3.827254805660949*^9}, {3.828016335406551*^9, 
   3.828016335804055*^9}, 3.828016381447542*^9, {3.828016954736595*^9, 
   3.828016957672343*^9}, {3.8280173292918634`*^9, 3.82801732948213*^9}, {
   3.828018324159919*^9, 3.8280183244616137`*^9}, {3.8280183647417793`*^9, 
   3.8280183936875625`*^9}, {3.8280199487587023`*^9, 3.82801994899561*^9}, {
   3.828022558254879*^9, 3.8280225772238264`*^9}, {3.828022682820682*^9, 
   3.8280226834262586`*^9}, {3.828023033918476*^9, 3.828023047523599*^9}, {
   3.8280232436513753`*^9, 3.8280233240272474`*^9}, {3.828023380024785*^9, 
   3.8280234062335196`*^9}, {3.8280234910485983`*^9, 3.82802349128253*^9}, {
   3.8280241192136154`*^9, 3.828024119831958*^9}, {3.8280267140805845`*^9, 
   3.8280267260570436`*^9}, {3.8280267983981266`*^9, 
   3.8280268015917664`*^9}, {3.8280273749128923`*^9, 
   3.8280273756477995`*^9}, {3.8280287745708857`*^9, 3.828028800392736*^9}, {
   3.828028862010359*^9, 3.8280288999636436`*^9}, {3.82824885301077*^9, 
   3.8282488721743126`*^9}, 3.8282489151783476`*^9, 3.8282489520820894`*^9, 
   3.8282489960198193`*^9, {3.828249085581837*^9, 3.828249096321949*^9}, {
   3.828249130012079*^9, 3.8282491302591915`*^9}, {3.8282491734925466`*^9, 
   3.8282491865419235`*^9}, {3.828249390773584*^9, 3.828249425066181*^9}, {
   3.8306115938454337`*^9, 3.8306116302271748`*^9}, {3.8306117666319733`*^9, 
   3.830611766901688*^9}, {3.8306118185342445`*^9, 3.8306118211149225`*^9}, {
   3.830611857745651*^9, 3.830611859915468*^9}, {3.830623995165476*^9, 
   3.830623995872754*^9}, {3.831896674507144*^9, 3.831896755705962*^9}, {
   3.8318967883952274`*^9, 3.8318968252819633`*^9}, {3.831896931605631*^9, 
   3.8318969730947514`*^9}, {3.8318970612524443`*^9, 3.831897088689397*^9}, {
   3.8318971264540043`*^9, 3.83189719124485*^9}, {3.8319055212353888`*^9, 
   3.831905521691146*^9}, {3.8319055746098285`*^9, 3.831905648823558*^9}, 
   3.8342186118618655`*^9, {3.834218643645035*^9, 3.8342186440502844`*^9}, {
   3.8342186880817804`*^9, 3.834218722048252*^9}, {3.834218759028298*^9, 
   3.8342187676686745`*^9}, {3.834301032217862*^9, 3.834301032556534*^9}, {
   3.8343010773266277`*^9, 3.8343010774794474`*^9}, {3.8343049969584103`*^9, 
   3.834304998025734*^9}, {3.8343050764534197`*^9, 3.834305120988652*^9}, {
   3.8343070925704746`*^9, 3.8343071097945623`*^9}, {3.8347386321241856`*^9, 
   3.834738650179826*^9}, {3.83508787857736*^9, 3.8350879384807253`*^9}, {
   3.8350879698414555`*^9, 3.835087981617752*^9}, 3.835088021635086*^9, {
   3.835088070885634*^9, 3.835088071077376*^9}, {3.8350881295885715`*^9, 
   3.8350881310364428`*^9}, {3.8350881827873964`*^9, 
   3.8350882168875065`*^9}, {3.8350882794957943`*^9, 3.83508833513766*^9}, {
   3.8350883715169373`*^9, 3.8350883994146056`*^9}, {3.835088444767354*^9, 
   3.835088510210901*^9}, {3.8350890338623457`*^9, 3.835089036643992*^9}, {
   3.8350893367000437`*^9, 3.8350893525890846`*^9}, {3.8350893843144584`*^9, 
   3.835089386124364*^9}, {3.8350935227509065`*^9, 3.835093544027497*^9}, {
   3.835093576028883*^9, 3.8350935797791624`*^9}, {3.83509363672985*^9, 
   3.835093713928549*^9}, {3.8350938761445355`*^9, 3.8350939032083473`*^9}, 
   3.8350939529681625`*^9, {3.8350939942173853`*^9, 3.8350939944303875`*^9}, 
   3.835094026703515*^9, {3.8350940607039366`*^9, 3.8350941229638815`*^9}, {
   3.8350942350733004`*^9, 3.8350943128343587`*^9}, 3.8350943551392903`*^9, {
   3.8350944942459717`*^9, 3.83509459103459*^9}, {3.835094623098219*^9, 
   3.835094808626951*^9}, {3.8350948399861584`*^9, 3.8350948403299246`*^9}, {
   3.83509487626462*^9, 3.835094876479298*^9}, {3.8350949664031897`*^9, 
   3.835094980534989*^9}, {3.8350950206931086`*^9, 3.8350950240547595`*^9}, {
   3.835095054943088*^9, 3.8350951423147583`*^9}, {3.8350951728664556`*^9, 
   3.835095232713127*^9}, {3.835095278476631*^9, 3.835095306098377*^9}, {
   3.835095346277362*^9, 3.8350954778452506`*^9}, {3.8350955163258786`*^9, 
   3.8350955691131525`*^9}, {3.835095599722928*^9, 3.8350956165919905`*^9}, {
   3.8350956636260176`*^9, 3.8350956927605534`*^9}, {3.8350957310483522`*^9, 
   3.835095813128123*^9}, {3.8350960008628798`*^9, 3.83509603857427*^9}, {
   3.8350961680646133`*^9, 3.835096188043499*^9}, {3.8350962723191156`*^9, 
   3.835096272528781*^9}, {3.8350992304521*^9, 3.8350992321734324`*^9}, {
   3.8351022411227913`*^9, 3.8351022555355573`*^9}, {3.835102289142189*^9, 
   3.8351023396573935`*^9}, {3.835102376897352*^9, 3.8351023775047626`*^9}, {
   3.8351024120166187`*^9, 3.8351024121898355`*^9}, {3.835113888165908*^9, 
   3.8351139279895*^9}, {3.835113959203588*^9, 3.835113988863728*^9}, 
   3.835114028799537*^9, {3.835114071837639*^9, 3.8351140722353497`*^9}, {
   3.8351141124624486`*^9, 3.8351141126420174`*^9}, {3.8351141441386147`*^9, 
   3.835114172646731*^9}, {3.8351142819296074`*^9, 3.8351143390715714`*^9}, {
   3.8351143783983355`*^9, 3.8351145102265477`*^9}, {3.835114670584235*^9, 
   3.835114716114277*^9}, {3.835114760881465*^9, 3.8351147867254114`*^9}, {
   3.8351148306732254`*^9, 3.835114850052667*^9}, {3.8351148973329573`*^9, 
   3.8351148979954796`*^9}, {3.835114941772504*^9, 3.8351150206605487`*^9}, {
   3.8351150535733433`*^9, 3.8351150842790446`*^9}, {3.835115125452259*^9, 
   3.8351151257025585`*^9}, {3.8351151683049493`*^9, 3.835115244748459*^9}, {
   3.835115469587307*^9, 3.835115628824439*^9}, {3.835115694564045*^9, 
   3.8351157024711475`*^9}, {3.8351157414918427`*^9, 
   3.8351157685401125`*^9}, {3.8351158190580482`*^9, 3.835115821555336*^9}, {
   3.8351159233690615`*^9, 3.8351160085656815`*^9}, {3.8351162443204913`*^9, 
   3.8351162749631624`*^9}, {3.8351163057732973`*^9, 
   3.8351163077814054`*^9}, {3.8351163426863036`*^9, 
   3.8351163435369844`*^9}, {3.8351164718559217`*^9, 3.835116492933133*^9}, {
   3.83515354292315*^9, 3.835153555681054*^9}, {3.8351536232087283`*^9, 
   3.835153626782775*^9}, {3.8351537998760443`*^9, 3.835153827829119*^9}, {
   3.835153918516232*^9, 3.8351539187575827`*^9}, {3.8351554951305666`*^9, 
   3.8351554956110897`*^9}, 3.8351555340693836`*^9, {3.835156174498847*^9, 
   3.8351562142757397`*^9}, {3.8351563408588066`*^9, 
   3.8351563437559896`*^9}, {3.8351570498638954`*^9, 3.835157060298532*^9}, {
   3.835157093261671*^9, 3.835157093483816*^9}, {3.835157252667029*^9, 
   3.835157258478198*^9}, {3.8351572924774942`*^9, 3.835157294106867*^9}, {
   3.835157324319832*^9, 3.8351573313582287`*^9}, {3.835167156116685*^9, 
   3.835167311659768*^9}, {3.8351673518787117`*^9, 3.835167408701845*^9}, 
   3.835167460028947*^9, {3.8351693377051477`*^9, 3.8351693404128885`*^9}, {
   3.8351712551257524`*^9, 3.8351712557166786`*^9}, {3.8351739697810497`*^9, 
   3.8351740447777004`*^9}, {3.8351740847752953`*^9, 
   3.8351742253068943`*^9}, {3.8351742599825964`*^9, 3.835174260238801*^9}, {
   3.835174707731409*^9, 3.835174729772487*^9}, {3.835174831479155*^9, 
   3.8351748321686215`*^9}, {3.8351781599598975`*^9, 
   3.8351781768299875`*^9}, {3.835178216098055*^9, 3.8351782432002463`*^9}, {
   3.835178290464899*^9, 3.835178333472903*^9}, {3.8351783847487087`*^9, 
   3.8351783874345737`*^9}, {3.835178429088703*^9, 3.8351784293426285`*^9}, {
   3.835178492436801*^9, 3.8351784930218077`*^9}, {3.8351785985230303`*^9, 
   3.8351786792206836`*^9}, {3.8351787094468794`*^9, 3.835178737411489*^9}, {
   3.8351787695532207`*^9, 3.8351787772126007`*^9}, {3.835178910645383*^9, 
   3.8351789305229354`*^9}, {3.8351791717956567`*^9, 3.835179206639846*^9}, {
   3.835179253335821*^9, 3.835179309482682*^9}, {3.835179361257632*^9, 
   3.8351793615875998`*^9}, 3.835179396302986*^9, {3.835181587354371*^9, 
   3.8351815928794556`*^9}, {3.8351816372464676`*^9, 3.835181678517788*^9}, {
   3.835181787408523*^9, 3.8351817904331617`*^9}, {3.835198642872212*^9, 
   3.8351986527338467`*^9}, {3.8351992542511897`*^9, 3.835199262978007*^9}, 
   3.8352028175196505`*^9, {3.8352028632037926`*^9, 3.8352029256464214`*^9}, {
   3.835202981790428*^9, 3.8352030041667423`*^9}, {3.8352030366894293`*^9, 
   3.8352030951832657`*^9}, {3.8352031738606586`*^9, 
   3.8352031959515696`*^9}, {3.8352035304301243`*^9, 
   3.8352035509911175`*^9}, {3.8352036105784826`*^9, 
   3.8352036170735474`*^9}, {3.835203900054686*^9, 3.8352039022900457`*^9}, {
   3.8352039414865932`*^9, 3.835204033862688*^9}, {3.8352040641421556`*^9, 
   3.8352040814808846`*^9}, {3.8352042286594067`*^9, 
   3.8352042334651175`*^9}, {3.8352042757982664`*^9, 
   3.8352043133324695`*^9}, {3.835204344274105*^9, 3.8352043450974364`*^9}, {
   3.8352044109005375`*^9, 3.8352044112000523`*^9}, {3.8352044455378857`*^9, 
   3.8352044456932306`*^9}, 3.835204604384121*^9, {3.835204917948347*^9, 
   3.8352049181788497`*^9}, 3.8352049877634172`*^9, {3.8352050224452085`*^9, 
   3.8352050409031625`*^9}, {3.835205078170461*^9, 3.835205159136596*^9}, {
   3.835205318938436*^9, 3.8352053414998574`*^9}, {3.835205392002223*^9, 
   3.835205393097762*^9}, {3.835205569469657*^9, 3.8352055835648146`*^9}, 
   3.835205613778723*^9, {3.8352057306565433`*^9, 3.8352057413504333`*^9}, {
   3.8352057904409323`*^9, 3.8352057934303937`*^9}, {3.8352058770124707`*^9, 
   3.835205902459568*^9}, 3.835205935385935*^9, {3.8352059814081974`*^9, 
   3.835205981610358*^9}, {3.8352061107884865`*^9, 3.8352061378075433`*^9}, 
   3.835206211155396*^9, {3.835206248612818*^9, 3.835206262918135*^9}, {
   3.8352062992550354`*^9, 3.8352062998589706`*^9}, {3.835207207952016*^9, 
   3.8352072481282597`*^9}, {3.835207290482342*^9, 3.8352073374526634`*^9}, {
   3.835207409907381*^9, 3.83520741111478*^9}, {3.835207484071166*^9, 
   3.835207494900217*^9}, 3.8352085557288914`*^9, {3.835208592661813*^9, 
   3.8352086535749216`*^9}, {3.835208811634296*^9, 3.8352089045064993`*^9}, {
   3.835242810534004*^9, 3.8352428906586018`*^9}, {3.8352429219026403`*^9, 
   3.835242955606756*^9}, {3.8352429990186286`*^9, 3.8352429996429253`*^9}, 
   3.8352431874896693`*^9, {3.835243218667058*^9, 3.8352432291569195`*^9}, {
   3.835243304137128*^9, 3.83524330436976*^9}, {3.8352433564660807`*^9, 
   3.8352433570528364`*^9}, {3.8352434054057693`*^9, 
   3.8352434081045675`*^9}, {3.8352434397505693`*^9, 
   3.8352434399828153`*^9}, {3.8352434725637083`*^9, 
   3.8352435123095875`*^9}, {3.8352556468470263`*^9, 
   3.8352556846425886`*^9}, {3.835341757608678*^9, 3.835341757818735*^9}, {
   3.835341800949956*^9, 3.835341807490521*^9}, {3.835341840727948*^9, 
   3.8353418415608664`*^9}, 3.8353418788144703`*^9, {3.835413851235837*^9, 
   3.83541385130455*^9}, {3.8354339514857197`*^9, 3.835433979343178*^9}, {
   3.835434028233034*^9, 3.835434028413253*^9}, 3.8354340633584847`*^9, 
   3.835434098808154*^9, {3.835434331911517*^9, 3.8354343355662265`*^9}, 
   3.8354344125055046`*^9, {3.835514671280465*^9, 3.835514692431983*^9}, {
   3.836121491143813*^9, 3.8361214923832865`*^9}, 3.836121664099279*^9, {
   3.8361216948714085`*^9, 3.8361217017230854`*^9}, {3.836121741546666*^9, 
   3.8361217447434273`*^9}, {3.836208155756957*^9, 3.836208157439858*^9}, {
   3.837169311744417*^9, 3.837169311980697*^9}, 3.8371694106017447`*^9, 
   3.837232662396825*^9, 3.837232731066179*^9, {3.8401705770509386`*^9, 
   3.840170577759631*^9}, {3.840171587847636*^9, 3.8401715975121503`*^9}, {
   3.840171645936842*^9, 3.8401717465619535`*^9}, {3.8401717809873915`*^9, 
   3.840171983093245*^9}, {3.8401722445764537`*^9, 3.8401722676658697`*^9}, {
   3.840172300725619*^9, 3.8401723562547803`*^9}, {3.8401723892429867`*^9, 
   3.840172434886675*^9}, {3.8401724731308947`*^9, 3.840172476710397*^9}, {
   3.8401729928593454`*^9, 3.8401729951320696`*^9}, {3.8401730797587*^9, 
   3.8401731064025335`*^9}, 3.840174221242687*^9, {3.8401742673083315`*^9, 
   3.840174267536761*^9}, {3.8401743064066176`*^9, 3.8401743070936155`*^9}, {
   3.8401743394898653`*^9, 3.8401744200892544`*^9}, {3.840174457441553*^9, 
   3.840174485931705*^9}, {3.840175588558834*^9, 3.8401756511422772`*^9}, {
   3.8401761416783786`*^9, 3.840176176849223*^9}, {3.8401762169889355`*^9, 
   3.840176254272913*^9}, {3.8401763177152505`*^9, 3.8401764408961935`*^9}, {
   3.840176477915888*^9, 3.840176515736376*^9}, {3.8401772396127853`*^9, 
   3.8401772400146356`*^9}, {3.840177277517556*^9, 3.8401773804748363`*^9}, 
   3.8403523805633183`*^9, {3.8403524177848587`*^9, 3.8403525585792522`*^9}, {
   3.840353245866854*^9, 3.8403533418601284`*^9}, {3.840353907720281*^9, 
   3.8403539080784383`*^9}, {3.840353938145409*^9, 3.840353950675511*^9}, {
   3.8403556909373903`*^9, 3.840355712253806*^9}, {3.840358115839552*^9, 
   3.840358205691698*^9}, {3.840358244558651*^9, 3.8403583023917723`*^9}, {
   3.840360348106408*^9, 3.8403603844299483`*^9}, {3.840629306601095*^9, 
   3.8406293072511606`*^9}, {3.840897585567304*^9, 3.8408976433245463`*^9}, {
   3.8409449226454144`*^9, 3.8409449231090326`*^9}, {3.840945000945018*^9, 
   3.8409450519668393`*^9}, {3.8409450825274105`*^9, 
   3.8409451000256834`*^9}, {3.840946140039022*^9, 3.8409461503306303`*^9}, {
   3.8409564556521072`*^9, 3.840956576350786*^9}, {3.840956608947564*^9, 
   3.8409566555583572`*^9}, {3.8409566866917753`*^9, 
   3.8409566868770933`*^9}, {3.840956744577598*^9, 3.8409567523892097`*^9}, {
   3.8409568928530807`*^9, 3.840956893606923*^9}, {3.8409569380872717`*^9, 
   3.840957003538985*^9}, {3.840957101111027*^9, 3.84095710577356*^9}, {
   3.8409571358365364`*^9, 3.840957167673209*^9}, {3.8409572193052235`*^9, 
   3.8409572235888157`*^9}, {3.8409572606110697`*^9, 3.840957295629157*^9}, {
   3.8409623807467365`*^9, 3.8409623839184823`*^9}, 3.840962423933098*^9, {
   3.8409626832785263`*^9, 3.840962692013481*^9}, {3.8409658443572187`*^9, 
   3.8409658823348904`*^9}, {3.8409659281043725`*^9, 3.840966039764885*^9}, {
   3.8409660839660115`*^9, 3.840966206802274*^9}, {3.8409662413248405`*^9, 
   3.8409664044127135`*^9}, {3.8409665574687614`*^9, 3.840966612659137*^9}, {
   3.840966667393773*^9, 3.8409666860731564`*^9}, {3.840966729350535*^9, 
   3.8409667946845865`*^9}, {3.8409671202397513`*^9, 
   3.8409671953473186`*^9}, {3.8409686014563417`*^9, 
   3.8409686695878925`*^9}, {3.8409817472949467`*^9, 
   3.8409817879492445`*^9}, {3.841470374327634*^9, 3.841470374345089*^9}, {
   3.8414704294662113`*^9, 3.8414704457308273`*^9}, {3.8414705480596538`*^9, 
   3.841470548075018*^9}, {3.8414706416347356`*^9, 3.8414706455371437`*^9}, 
   3.8414714662011986`*^9, {3.8414714999147854`*^9, 3.8414715006724873`*^9}, {
   3.842709840872553*^9, 3.8427099298763604`*^9}, {3.842709998419383*^9, 
   3.842709998660166*^9}, {3.84271011846098*^9, 3.8427101540661745`*^9}, {
   3.842710215937435*^9, 3.8427102540180693`*^9}, {3.842710304606507*^9, 
   3.842710308814664*^9}, {3.8427103502733145`*^9, 3.8427103911352434`*^9}, {
   3.8427104761677017`*^9, 3.8427104805446515`*^9}, {3.8427105288452635`*^9, 
   3.842710529400161*^9}, {3.8427105613186197`*^9, 3.842710561553995*^9}, {
   3.8427106053101006`*^9, 3.84271072656985*^9}, {3.8427113976458225`*^9, 
   3.8427114717045765`*^9}, {3.8428520435352125`*^9, 3.842852068064509*^9}, {
   3.843286468253603*^9, 3.843286572532677*^9}, {3.8432866050032415`*^9, 
   3.8432866323693223`*^9}, {3.843288211127201*^9, 3.8432882474226093`*^9}, {
   3.843288335442445*^9, 3.843288359393611*^9}, {3.84328841740586*^9, 
   3.843288453601663*^9}, {3.843288499975108*^9, 3.8432885240859203`*^9}, {
   3.8432885807273226`*^9, 3.843288589073797*^9}, {3.8432888646933603`*^9, 
   3.8432889278409767`*^9}, {3.84329330402743*^9, 3.8432933343353615`*^9}, {
   3.8432933718533583`*^9, 3.843293418848928*^9}, {3.843293461124672*^9, 
   3.8432934864322476`*^9}, {3.84329357859369*^9, 3.843293615773777*^9}, {
   3.8432936582652597`*^9, 3.8432936813428297`*^9}, {3.8432937256012096`*^9, 
   3.8432937456689224`*^9}, {3.84329380892819*^9, 3.8432938574537516`*^9}, 
   3.8432939120979257`*^9, 3.843293966168765*^9, {3.8432969159910917`*^9, 
   3.843296942400293*^9}, {3.843296976711306*^9, 3.843296995348059*^9}, {
   3.843297085910262*^9, 3.84329715789568*^9}, {3.843300884806681*^9, 
   3.843301071372992*^9}, {3.8433011090327034`*^9, 3.8433011513679266`*^9}, {
   3.84330252467475*^9, 3.8433025395783215`*^9}, {3.8433025702293434`*^9, 
   3.8433025839388723`*^9}, {3.843309443224635*^9, 3.8433094712996597`*^9}, {
   3.843309503386565*^9, 3.8433095035712686`*^9}, {3.843311773835355*^9, 
   3.843311840473731*^9}, {3.8433291466369*^9, 3.8433291748173194`*^9}, {
   3.8433292209953794`*^9, 3.8433292405199585`*^9}, {3.843329275128626*^9, 
   3.843329292299923*^9}, {3.8433695634995346`*^9, 3.843369566215621*^9}, {
   3.843369683465784*^9, 3.843369683678188*^9}, {3.8433697714118595`*^9, 
   3.8433697721038413`*^9}, {3.8433698037749357`*^9, 3.84336980645212*^9}, {
   3.843369846198062*^9, 3.8433698729971757`*^9}, {3.8433699232718883`*^9, 
   3.8433699671688633`*^9}, {3.8433700316864853`*^9, 
   3.8433700438786993`*^9}, {3.8433700824531794`*^9, 3.843370159495618*^9}, {
   3.843383035732585*^9, 3.843383100988497*^9}, {3.8433831557943487`*^9, 
   3.8433832424730525`*^9}, {3.843383318585298*^9, 3.843383321307423*^9}, {
   3.8433838180991483`*^9, 3.8433838202637825`*^9}, 3.8433838910536137`*^9, {
   3.843383923848802*^9, 3.843383938528592*^9}, 3.843383992770918*^9, {
   3.843384025922727*^9, 3.843384026229738*^9}, {3.8433840568441734`*^9, 
   3.8433841016774454`*^9}, {3.8433842311219244`*^9, 
   3.8433842341851377`*^9}, {3.8433842676895733`*^9, 
   3.8433842802061615`*^9}, {3.843384320646228*^9, 3.843384378359748*^9}, {
   3.8433844411551743`*^9, 3.843384445771081*^9}, {3.8433845080162797`*^9, 
   3.843384587776396*^9}, {3.8433846299141912`*^9, 3.8433847089224825`*^9}, {
   3.843386597381494*^9, 3.843386631232966*^9}, {3.843387589355073*^9, 
   3.8433876746449604`*^9}, {3.8433877084322057`*^9, 
   3.8433877086293893`*^9}, {3.8433877699534063`*^9, 
   3.8433877706890807`*^9}, {3.8433879871902256`*^9, 3.843388054879174*^9}, {
   3.8433880879704227`*^9, 3.8433880885944233`*^9}, {3.843388119220667*^9, 
   3.843388172764373*^9}, {3.843388550927534*^9, 3.8433885537276616`*^9}, {
   3.843388589536318*^9, 3.843388618155861*^9}, {3.8433886484837065`*^9, 
   3.8433888360651608`*^9}, {3.8433889590928593`*^9, 3.84338895978858*^9}, {
   3.8433892662072296`*^9, 3.8433892710666566`*^9}, {3.843389366806309*^9, 
   3.843389378499033*^9}, {3.8433921968631506`*^9, 3.8433922159387474`*^9}, 
   3.8433922470373344`*^9, {3.843392305569996*^9, 3.84339232625019*^9}, {
   3.843392395527611*^9, 3.843392457689307*^9}, {3.8433925195062737`*^9, 
   3.843392564456608*^9}, {3.843393672890029*^9, 3.8433937030892954`*^9}, {
   3.84339373334867*^9, 3.843393789797694*^9}, {3.843393987641348*^9, 
   3.843394069826229*^9}, {3.843394118354602*^9, 3.8433941660547*^9}, {
   3.843394490745959*^9, 3.8433945365778522`*^9}, {3.843395316910776*^9, 
   3.8433953552568026`*^9}, {3.8433967216740117`*^9, 
   3.8433968067969947`*^9}, {3.84339685061015*^9, 3.843396889353713*^9}, {
   3.8433969224425583`*^9, 3.8433969256955957`*^9}, {3.8433972736952934`*^9, 
   3.84339728760329*^9}, {3.843397462211911*^9, 3.843397666205878*^9}, {
   3.8433978859376574`*^9, 3.843397937611183*^9}, 3.8433980180145473`*^9, {
   3.84339805671692*^9, 3.843398084824563*^9}, {3.843399130494562*^9, 
   3.8433991724767036`*^9}, {3.843399204649605*^9, 3.843399206904562*^9}, {
   3.843399248994644*^9, 3.8433992513938017`*^9}, {3.843405533295796*^9, 
   3.843405579933818*^9}, {3.8434056369226007`*^9, 3.843405685011407*^9}, 
   3.8434057166007853`*^9, {3.8434057897150445`*^9, 3.8434057916117616`*^9}, {
   3.8434058465262113`*^9, 3.843405904339462*^9}, 3.8434062034064665`*^9, {
   3.843406245604062*^9, 3.843406325715999*^9}, 3.8434068252112026`*^9, {
   3.843406924257209*^9, 3.843407325307824*^9}, {3.8434075339093*^9, 
   3.8434075342032566`*^9}, 3.8434076070168085`*^9, {3.8434076671793323`*^9, 
   3.843407712269085*^9}, {3.8434078075845537`*^9, 3.8434078077867336`*^9}, {
   3.843407852378846*^9, 3.843407948485535*^9}, {3.843407984238119*^9, 
   3.8434079984022474`*^9}, {3.8434080335153666`*^9, 
   3.8434081738446507`*^9}, {3.843408243736429*^9, 3.843408271826934*^9}, {
   3.8434094386782007`*^9, 3.843409467791896*^9}, {3.8434096199269347`*^9, 
   3.843409679313346*^9}, {3.8434097314545894`*^9, 3.843409750291381*^9}, {
   3.8434097863560505`*^9, 3.8434098256961856`*^9}, {3.843409917956749*^9, 
   3.8434100593691006`*^9}, {3.8434100959605308`*^9, 3.843410104895364*^9}, {
   3.84341014540342*^9, 3.8434101651533585`*^9}, {3.8434103595080633`*^9, 
   3.843410403489976*^9}, 3.8434105854022636`*^9, 3.8434107668208027`*^9, {
   3.8434108018719797`*^9, 3.843410833648918*^9}, {3.843410899185211*^9, 
   3.843410935805952*^9}, {3.843411009631265*^9, 3.843411029671404*^9}, {
   3.843411073011386*^9, 3.8434110902630777`*^9}, {3.843411197150955*^9, 
   3.843411197993988*^9}, {3.843411437884942*^9, 3.8434115456313596`*^9}, {
   3.8434115769679203`*^9, 3.8434115781735754`*^9}, {3.843411700631522*^9, 
   3.843411734036622*^9}, {3.843412061720229*^9, 3.843412089015108*^9}, {
   3.84341262315025*^9, 3.8434126759402475`*^9}, {3.8434127422803383`*^9, 
   3.843412742491008*^9}, {3.8434568176470137`*^9, 3.843456819965835*^9}, {
   3.843456857322134*^9, 3.843456882633763*^9}, {3.8434570915608053`*^9, 
   3.843457091932771*^9}, {3.8434571367299423`*^9, 3.843457148970194*^9}, {
   3.8434607879692955`*^9, 3.843460794537545*^9}, {3.8434608318633785`*^9, 
   3.8434608449437494`*^9}, {3.843460938940841*^9, 3.8434609670930595`*^9}, 
   3.8434610044730473`*^9, {3.84346110270308*^9, 3.843461140100004*^9}, 
   3.843461196796574*^9, {3.843461228501444*^9, 3.8434612941505747`*^9}, 
   3.843461329201338*^9, {3.8434613724997296`*^9, 3.843461387651241*^9}, {
   3.8434614338186827`*^9, 3.8434614503259697`*^9}, {3.8434695688403234`*^9, 
   3.843469569675121*^9}, {3.8434696503670692`*^9, 3.8434696647398224`*^9}, {
   3.8434697761338606`*^9, 3.8434697762593117`*^9}, {3.843469852594741*^9, 
   3.8434699369303055`*^9}, {3.8434700076660347`*^9, 3.843470026866911*^9}, {
   3.843470100498428*^9, 3.8434702207750797`*^9}, {3.8434702666529665`*^9, 
   3.8434703132081547`*^9}, {3.8434703676717997`*^9, 
   3.8434704989530954`*^9}, {3.843470537173562*^9, 3.843470582639028*^9}, {
   3.8434706610745983`*^9, 3.843470661274276*^9}, {3.843842717447771*^9, 
   3.843842773207602*^9}, {3.843842819509875*^9, 3.843842820495577*^9}, {
   3.843842860715198*^9, 3.843842889169708*^9}, {3.8445926639915257`*^9, 
   3.844592674167006*^9}, {3.8445968872020254`*^9, 3.8445969288920527`*^9}, {
   3.8445969636225843`*^9, 3.8445970395146904`*^9}, 3.844597151325872*^9, {
   3.8445972016451054`*^9, 3.8445972052636695`*^9}, {3.844597247728631*^9, 
   3.844597279471324*^9}, {3.844597391871457*^9, 3.8445974185192533`*^9}, {
   3.844597547242075*^9, 3.8445975544788756`*^9}, {3.844597613746851*^9, 
   3.844597620234278*^9}, {3.8445976817705455`*^9, 3.844597685614954*^9}, {
   3.8446786469517336`*^9, 3.844678647194496*^9}, {3.845789167109098*^9, 
   3.8457891671789875`*^9}, {3.8457892537049007`*^9, 
   3.8457892548169026`*^9}, {3.845790201341221*^9, 3.8457902014311094`*^9}, {
   3.8457902697953176`*^9, 3.845790277787465*^9}, {3.845790360597125*^9, 
   3.84579037476298*^9}, {3.845790418851864*^9, 3.845790420601557*^9}, {
   3.8457920050315895`*^9, 3.845792006279958*^9}, {3.845792048990425*^9, 
   3.845792077033614*^9}, {3.8457924977748456`*^9, 3.8457924977848334`*^9}, {
   3.8457983014243326`*^9, 3.845798304860403*^9}, {3.84579890417385*^9, 
   3.8457989064699287`*^9}, {3.8458227099021497`*^9, 
   3.8458227528434973`*^9}, {3.8458227920817623`*^9, 3.845822804539049*^9}, {
   3.8458228501959505`*^9, 3.8458228638729897`*^9}, {3.8458229768522635`*^9, 
   3.845822997204033*^9}, {3.8458230562552104`*^9, 3.8458231209371686`*^9}, {
   3.845823354764203*^9, 3.845823363480506*^9}, {3.845829592594843*^9, 
   3.8458300359324837`*^9}, {3.8458733110693645`*^9, 3.845873325512593*^9}, {
   3.8458765736189933`*^9, 3.845876602962697*^9}, {3.84588864521747*^9, 
   3.8458887096849823`*^9}, {3.8458887441633854`*^9, 
   3.8458887631213074`*^9}, {3.8458888844872756`*^9, 
   3.8458889620114856`*^9}, {3.845889502446437*^9, 3.845889503862924*^9}, {
   3.8458896033489447`*^9, 3.84588968611414*^9}, {3.8458897235987406`*^9, 
   3.8458897741231914`*^9}, {3.845890018137719*^9, 3.845890154285739*^9}, {
   3.845891746065899*^9, 3.8458917827279596`*^9}, {3.845892035348511*^9, 
   3.8458920689046373`*^9}, {3.845892122064905*^9, 3.8458921233984375`*^9}, {
   3.8458921709431076`*^9, 3.8458922326603413`*^9}, {3.845892288285668*^9, 
   3.8458922893850913`*^9}, {3.8459020313944373`*^9, 3.845902099598566*^9}, 
   3.8459021376879697`*^9, {3.8459040367596717`*^9, 3.8459040445086727`*^9}, {
   3.845907864085472*^9, 3.8459079293605647`*^9}, {3.845907996652341*^9, 
   3.845908025277733*^9}, {3.8459080556577425`*^9, 3.845908225950322*^9}, {
   3.845908276522524*^9, 3.8459083098064747`*^9}, {3.8459192113318076`*^9, 
   3.845919303262145*^9}, {3.845919355574989*^9, 3.845919363298863*^9}, 
   3.845919584625379*^9, 3.8459196251333466`*^9, {3.845920031648391*^9, 
   3.8459202862940507`*^9}, {3.8459217769503326`*^9, 
   3.8459218095324183`*^9}, {3.846001708104641*^9, 3.8460017103426075`*^9}, {
   3.8460017406237483`*^9, 3.8460017648623915`*^9}, {3.84600179859223*^9, 
   3.8460018764746904`*^9}, {3.8460019374962964`*^9, 3.846001963859692*^9}, {
   3.8460019992515507`*^9, 3.8460020010045867`*^9}, {3.8460020768139453`*^9, 
   3.8460021104588304`*^9}, {3.8460021453282166`*^9, 3.846002182908271*^9}, {
   3.8460022554041348`*^9, 3.8460023973838453`*^9}, {3.84600243785693*^9, 
   3.8460024519749126`*^9}, {3.846002514477106*^9, 3.8460025156471677`*^9}, {
   3.8460025539994807`*^9, 3.8460025776286097`*^9}, 3.8460026260817003`*^9, {
   3.846003090441636*^9, 3.846003091714245*^9}, {3.846003124774021*^9, 
   3.846003149015314*^9}, {3.8460031848648753`*^9, 3.846003185797387*^9}, {
   3.8460032392056417`*^9, 3.846003373692187*^9}, {3.846003411234783*^9, 
   3.8460035442117996`*^9}, {3.8460046616364584`*^9, 
   3.8460047182647243`*^9}, {3.8460047510792975`*^9, 3.846004788599265*^9}, 
   3.846004826254311*^9, {3.8460048752231874`*^9, 3.8460049710989294`*^9}, {
   3.8460050170688934`*^9, 3.846005057851859*^9}, {3.8460051101091576`*^9, 
   3.8460054827644*^9}, {3.8460055196613865`*^9, 3.8460055708402324`*^9}, {
   3.8460056144952607`*^9, 3.8460056420470095`*^9}, {3.846005695036463*^9, 
   3.8460057210442305`*^9}, 3.846005806153283*^9, {3.8460058465385766`*^9, 
   3.8460058837813683`*^9}, {3.846005969173687*^9, 3.846006032241808*^9}, {
   3.846006072776244*^9, 3.8460063687772937`*^9}, {3.8460064175423336`*^9, 
   3.846006573972853*^9}, {3.846006616968506*^9, 3.846006652083927*^9}, {
   3.846006804308077*^9, 3.8460069097493305`*^9}, {3.8460069501601024`*^9, 
   3.846007026544653*^9}, {3.846007088279829*^9, 3.8460071387985735`*^9}, {
   3.8460071814224524`*^9, 3.846007215197735*^9}, {3.8460072505076666`*^9, 
   3.8460078312079983`*^9}, {3.8460078628148384`*^9, 
   3.8460079116012154`*^9}, {3.8460079587388935`*^9, 3.846007970919303*^9}, {
   3.846008007331829*^9, 3.846008023893861*^9}, {3.846008066146347*^9, 
   3.8460081408530807`*^9}, {3.8460081963182335`*^9, 
   3.8460082503270206`*^9}, {3.846008331925752*^9, 3.8460083754388876`*^9}, {
   3.846008444110354*^9, 3.846008449333008*^9}, {3.8460084855227375`*^9, 
   3.8460085238643155`*^9}, {3.846008575915042*^9, 3.8460085938218975`*^9}, {
   3.846008644402992*^9, 3.846008761556435*^9}, {3.846008794720335*^9, 
   3.8460089556561413`*^9}, {3.84600918180352*^9, 3.84600923865244*^9}, {
   3.846009287971159*^9, 3.8460093260947046`*^9}, {3.8460093629442377`*^9, 
   3.846009423199792*^9}, {3.846009652970483*^9, 3.84600968428902*^9}, {
   3.846009718160426*^9, 3.846009721139061*^9}, {3.846009854413274*^9, 
   3.846010208943088*^9}, {3.8460109774619036`*^9, 3.8460109944391365`*^9}, {
   3.8460147010248203`*^9, 3.846014721374976*^9}, {3.846042641587447*^9, 
   3.8460426598988075`*^9}, {3.846042691280717*^9, 3.846042725405571*^9}, {
   3.846042789507145*^9, 3.8460428226694603`*^9}, {3.846042865263914*^9, 
   3.8460428816553698`*^9}, {3.8460429648237057`*^9, 
   3.8460429697690687`*^9}, {3.846043014232185*^9, 3.846043014492733*^9}, 
   3.846043104964901*^9, {3.8460431368629117`*^9, 3.846043153703458*^9}, 
   3.846043185027715*^9, 3.8460432223057137`*^9, {3.84604326530477*^9, 
   3.8460433623241377`*^9}, {3.846043395073165*^9, 3.8460434838689685`*^9}, {
   3.846043540547403*^9, 3.8460436027751555`*^9}, {3.8460436865600576`*^9, 
   3.8460438757561436`*^9}, {3.846043908340149*^9, 3.8460439217296076`*^9}, {
   3.8460439737350693`*^9, 3.8460439819080515`*^9}, {3.8460440603799505`*^9, 
   3.8460440779901648`*^9}, {3.8460441089054546`*^9, 3.846044116390721*^9}, {
   3.84604415971163*^9, 3.846044206007351*^9}, {3.846044276603163*^9, 
   3.8460443063928947`*^9}, {3.8460443917532845`*^9, 3.846044416316825*^9}, {
   3.8460444583201585`*^9, 3.846044526212112*^9}, 3.8460445626984715`*^9, {
   3.8460446008225327`*^9, 3.8460446292801514`*^9}, {3.8460446597258577`*^9, 
   3.8460448343303456`*^9}, {3.846044922183228*^9, 3.846044974173257*^9}, {
   3.846045007058384*^9, 3.8460450976558094`*^9}, 3.846045140243976*^9, {
   3.8460454240853567`*^9, 3.846045513153499*^9}, 3.8460455453000507`*^9, {
   3.8460455780025234`*^9, 3.8460456373965225`*^9}, {3.8460456680181293`*^9, 
   3.846045722221571*^9}, {3.8460457530698433`*^9, 3.84604586851171*^9}, {
   3.8460459088302965`*^9, 3.8460459090841866`*^9}, {3.8460459409887915`*^9, 
   3.8460460381804123`*^9}, 3.846046080430586*^9, {3.846046111153613*^9, 
   3.846046140450594*^9}, {3.846046189068691*^9, 3.8460462082425795`*^9}, {
   3.84604632591415*^9, 3.8460463401872954`*^9}, {3.846046387826023*^9, 
   3.8460465114829144`*^9}, {3.8460465566291056`*^9, 3.846046577233725*^9}, {
   3.846046614785056*^9, 3.8460466787352257`*^9}, {3.8460467141888924`*^9, 
   3.8460467580606303`*^9}, {3.8460510468404512`*^9, 
   3.8460511146418877`*^9}, {3.846051720887926*^9, 3.846051728051608*^9}, {
   3.8460518186489663`*^9, 3.8460518580463767`*^9}, {3.846051932513425*^9, 
   3.8460519333504057`*^9}, {3.846060400617655*^9, 3.8460604146787043`*^9}, {
   3.8460604788872194`*^9, 3.84606056290724*^9}, {3.8460606089576764`*^9, 
   3.8460606127003984`*^9}, 3.84606083757361*^9, {3.846060875406601*^9, 
   3.846060924980638*^9}, {3.8460612528409853`*^9, 3.8460612531908116`*^9}, 
   3.8460612927840624`*^9, {3.846061390769382*^9, 3.846061431932146*^9}, {
   3.846061533757512*^9, 3.8460615422336664`*^9}, {3.8460615739742365`*^9, 
   3.846061598775089*^9}, {3.846061635511948*^9, 3.846061656675778*^9}, {
   3.8460746534614472`*^9, 3.8460747886272464`*^9}, {3.846074825260746*^9, 
   3.84607489176912*^9}, {3.846074962566965*^9, 3.8460750134186587`*^9}, {
   3.84607504918744*^9, 3.846075053822919*^9}, {3.846075274768548*^9, 
   3.8460752771648254`*^9}, {3.8460767503595247`*^9, 3.846076849536785*^9}, {
   3.8460769033681116`*^9, 3.8460769063977547`*^9}, {3.846076943331485*^9, 
   3.8460770547675724`*^9}, {3.8460771500906315`*^9, 
   3.8460773078364305`*^9}, {3.8460845294619293`*^9, 3.846084538404707*^9}, {
   3.8460846379776907`*^9, 3.846084649955834*^9}, {3.846089244509637*^9, 
   3.8460892613691225`*^9}, {3.8460893003665075`*^9, 
   3.8460893236713233`*^9}, {3.846097590481971*^9, 3.8460976121912518`*^9}, {
   3.846097751680233*^9, 3.8460978210748425`*^9}, {3.846097870372225*^9, 
   3.8460979583185635`*^9}, {3.8460979901937046`*^9, 
   3.8460979927120037`*^9}, {3.8460980257499914`*^9, 3.846098054327691*^9}, {
   3.846098086526101*^9, 3.846098087506155*^9}, {3.846098190840583*^9, 
   3.846098191241635*^9}, {3.8460982258573117`*^9, 3.846098290243535*^9}, {
   3.84609832373219*^9, 3.846098424932457*^9}, {3.84609845931034*^9, 
   3.846098505106648*^9}, {3.846098539647728*^9, 3.846098564286994*^9}, {
   3.846098628699854*^9, 3.8460986419377623`*^9}, {3.8460991409720483`*^9, 
   3.84609914680007*^9}, {3.846099217735859*^9, 3.8460992272367506`*^9}, {
   3.846099289290884*^9, 3.8460992980861206`*^9}, 3.8460993360193825`*^9, {
   3.846099383188696*^9, 3.8460993948830843`*^9}, {3.846099449156432*^9, 
   3.846099450310134*^9}, 3.846099520248*^9, {3.846398283248095*^9, 
   3.846398284472929*^9}, {3.8463983321207867`*^9, 3.846398385895607*^9}, {
   3.8463984274821305`*^9, 3.846398574836534*^9}, {3.846398616080818*^9, 
   3.84639862680066*^9}, {3.846398712735383*^9, 3.846398723140941*^9}, 
   3.846398852737052*^9, {3.8463989119940376`*^9, 3.846398925529559*^9}, {
   3.8463989920988464`*^9, 3.84639904104631*^9}, {3.846399095445484*^9, 
   3.846399112238738*^9}, {3.846399159646391*^9, 3.8463991701313004`*^9}, {
   3.846399202623047*^9, 3.8463992700963664`*^9}, {3.8463993671346564`*^9, 
   3.8463994585510216`*^9}, 3.8463995144370904`*^9, {3.8463995694470234`*^9, 
   3.846399650566935*^9}, {3.8463997123513966`*^9, 3.8463997173625093`*^9}, {
   3.846399754193734*^9, 3.8463998323872747`*^9}, {3.8463998644158206`*^9, 
   3.846399909874035*^9}, {3.846399961379554*^9, 3.846399978787242*^9}, {
   3.8464000278142757`*^9, 3.846400028707041*^9}, {3.8464001365092597`*^9, 
   3.84640023031421*^9}, {3.846400268323104*^9, 3.846400514347928*^9}, {
   3.846401006027689*^9, 3.846401250678797*^9}, {3.84640131438494*^9, 
   3.846401316622208*^9}, 3.846401357342598*^9, {3.8464014002216654`*^9, 
   3.8464014278270025`*^9}, {3.84640154170155*^9, 3.8464018421600547`*^9}, {
   3.846401875831005*^9, 3.8464018828104*^9}, {3.8464019223137426`*^9, 
   3.8464021688855095`*^9}, {3.8464022218613634`*^9, 3.846402375810656*^9}, {
   3.8464024162909155`*^9, 3.8464028179588933`*^9}, {3.8464028490967336`*^9, 
   3.846402945292697*^9}, {3.8464029967434607`*^9, 3.8464030647032166`*^9}, {
   3.846403121646426*^9, 3.846403158991542*^9}, {3.8464031904846063`*^9, 
   3.846403217498082*^9}, {3.846403312024883*^9, 3.84640354336805*^9}, {
   3.8464036005463495`*^9, 3.846403693359764*^9}, {3.846403769499177*^9, 
   3.8464038059916754`*^9}, {3.846403839192339*^9, 3.8464040078845844`*^9}, {
   3.8464040396138406`*^9, 3.8464041253167343`*^9}, {3.8464041600520496`*^9, 
   3.8464042834550295`*^9}, {3.84640431382349*^9, 3.846404425603615*^9}, {
   3.8464044835567255`*^9, 3.8464046261507754`*^9}, {3.846404927213618*^9, 
   3.846404985401223*^9}, {3.846405020351455*^9, 3.846405106189601*^9}, {
   3.8464051522330217`*^9, 3.846405298638891*^9}, {3.846405338979521*^9, 
   3.8464053531670837`*^9}, 3.8464054719598265`*^9, 3.8464055333075385`*^9, {
   3.8464055677215633`*^9, 3.8464055700509105`*^9}, {3.846405627158332*^9, 
   3.8464056313916726`*^9}, {3.8464056697107534`*^9, 
   3.8464057125726376`*^9}, {3.8464057445184374`*^9, 3.846405749320196*^9}, 
   3.846405785959767*^9, {3.8464058663619804`*^9, 3.8464058948880157`*^9}, {
   3.8464059274414277`*^9, 3.8464059317048473`*^9}, {3.8464060079105616`*^9, 
   3.8464060339808364`*^9}, {3.846406079660247*^9, 3.846406088108712*^9}, {
   3.846406156548644*^9, 3.846406185874076*^9}, {3.846406434808277*^9, 
   3.8464064752603884`*^9}, {3.8464065288766265`*^9, 
   3.8464066731455784`*^9}, {3.846406706266111*^9, 3.846406787890044*^9}, {
   3.846406826116534*^9, 3.846406932855731*^9}, 3.8464070227879715`*^9, {
   3.846407064605996*^9, 3.846407182706606*^9}, {3.8464072286580625`*^9, 
   3.8464073297515545`*^9}, {3.8464073805313787`*^9, 
   3.8464073861592855`*^9}, {3.8464074306871185`*^9, 
   3.8464074347525153`*^9}, {3.846407477955919*^9, 3.8464075615987225`*^9}, {
   3.8464076751586256`*^9, 3.8464076817664523`*^9}, {3.846407805266267*^9, 
   3.8464078083737288`*^9}, {3.8464078392415533`*^9, 3.846407872550475*^9}, {
   3.8464079410124416`*^9, 3.8464079577306447`*^9}, {3.8464079975947857`*^9, 
   3.846408132154886*^9}, {3.8464085961947994`*^9, 3.8464086402811003`*^9}, {
   3.846408721617902*^9, 3.8464087341771655`*^9}, {3.84640877218471*^9, 
   3.8464088157022*^9}, 3.846408845918871*^9, {3.8464088822473116`*^9, 
   3.846408883657893*^9}, 3.846408918480261*^9, 3.846409098265348*^9, {
   3.846409129573022*^9, 3.846409360725958*^9}, {3.846409464473798*^9, 
   3.8464094812289767`*^9}, {3.8464095158788366`*^9, 
   3.8464095444513264`*^9}, {3.8464095847781057`*^9, 
   3.8464096560067883`*^9}, {3.8464097345820827`*^9, 
   3.8464098835910254`*^9}, {3.846409945355981*^9, 3.846409995427733*^9}, {
   3.8464100597950788`*^9, 3.846410251915921*^9}, {3.8464102996678762`*^9, 
   3.846410403274805*^9}, {3.8464122836496925`*^9, 3.846412462141524*^9}, {
   3.846412534698909*^9, 3.8464125438021603`*^9}, {3.8464157750456467`*^9, 
   3.846415796538199*^9}, {3.84641750790998*^9, 3.8464176104983225`*^9}, {
   3.846417659166855*^9, 3.846417734670371*^9}, {3.846417801691663*^9, 
   3.846417862108674*^9}, {3.8464179109781747`*^9, 3.8464179357676497`*^9}, {
   3.846417972735549*^9, 3.8464180429262953`*^9}, 3.8464181113204083`*^9, 
   3.84641819883289*^9, {3.8464182348686657`*^9, 3.8464183184567156`*^9}, {
   3.8464183545854425`*^9, 3.846418477099842*^9}, {3.846418508950782*^9, 
   3.846418614392434*^9}, {3.846418837461486*^9, 3.8464189228834686`*^9}, {
   3.846418960663275*^9, 3.8464189658639517`*^9}, {3.8464190001326084`*^9, 
   3.846419123297598*^9}, {3.846419206334882*^9, 3.84641925243223*^9}, {
   3.8464192846347504`*^9, 3.846419288689378*^9}, {3.846419484735793*^9, 
   3.8464195164578295`*^9}, {3.846425156398511*^9, 3.846425159016569*^9}, {
   3.846425199288077*^9, 3.8464252600288296`*^9}, {3.8464252949211125`*^9, 
   3.84642529686843*^9}, {3.8464253277594028`*^9, 3.8464253282514997`*^9}, {
   3.8464254488130846`*^9, 3.8464254784191804`*^9}, {3.8464255411163073`*^9, 
   3.8464256727387133`*^9}, {3.8464257044935207`*^9, 
   3.8464257556169643`*^9}, {3.846425799092351*^9, 3.8464258182684183`*^9}, {
   3.8464258546443987`*^9, 3.8464258550765686`*^9}, {3.846425905830249*^9, 
   3.846426002236825*^9}, {3.8464268205145674`*^9, 3.8464268282701936`*^9}, {
   3.8464268679169683`*^9, 3.846426955080998*^9}, {3.846427003016738*^9, 
   3.8464270549689465`*^9}, {3.84642711669442*^9, 3.846427179243541*^9}, {
   3.846427210761486*^9, 3.8464272125285788`*^9}, {3.846427244458064*^9, 
   3.8464273493625283`*^9}, {3.8464273839595523`*^9, 
   3.8464274150922737`*^9}, {3.8464274652328615`*^9, 3.846427525930069*^9}, {
   3.8464275734754753`*^9, 3.8464276567169275`*^9}, {3.8464393824696465`*^9, 
   3.846439414830632*^9}, 3.8464394611269326`*^9, {3.8464396373092203`*^9, 
   3.8464397123353534`*^9}, {3.846440191894884*^9, 3.846440214284788*^9}, {
   3.8464408168471017`*^9, 3.8464408312674694`*^9}, {3.8464408754217796`*^9, 
   3.8464408974178715`*^9}, {3.846440931706864*^9, 3.8464409717759986`*^9}, {
   3.8464410190320797`*^9, 3.846441074099531*^9}, {3.8464411050935116`*^9, 
   3.846441137043795*^9}, {3.846442135029915*^9, 3.8464421752995124`*^9}, {
   3.846442212188424*^9, 3.8464422136528215`*^9}, {3.8464425717898197`*^9, 
   3.8464425788539762`*^9}, {3.846442620631343*^9, 3.846442622945362*^9}, {
   3.846442655498933*^9, 3.8464426579801855`*^9}, {3.846442966468361*^9, 
   3.8464429961124125`*^9}, {3.8464430281804886`*^9, 
   3.8464430712960806`*^9}, {3.846443457561082*^9, 3.84644349680167*^9}, {
   3.846443547919072*^9, 3.8464436239803915`*^9}, {3.84644406322149*^9, 
   3.8464440906752186`*^9}, {3.8464449153520117`*^9, 3.8464449217207274`*^9}, 
   3.8464450004863415`*^9, {3.8464450459892683`*^9, 3.8464451258581686`*^9}, {
   3.8464452547052193`*^9, 3.846445288458033*^9}, 3.846445827973959*^9, 
   3.846445908920521*^9, 3.8464459607041016`*^9, 3.846446097328782*^9, {
   3.8464461410377927`*^9, 3.8464461580398407`*^9}, {3.8464462188517537`*^9, 
   3.846446220791684*^9}, {3.846446292196267*^9, 3.8464464092310543`*^9}, {
   3.846446445079785*^9, 3.8464464752350044`*^9}, {3.8464465105495253`*^9, 
   3.84644662630151*^9}, {3.8464807228269253`*^9, 3.8464808034466257`*^9}, {
   3.846482806949998*^9, 3.8464828926349354`*^9}, {3.846482947261924*^9, 
   3.8464830064017572`*^9}, 3.846483040071647*^9, {3.8464833141377487`*^9, 
   3.8464833150796*^9}, {3.846483372008709*^9, 3.8464834230542016`*^9}, 
   3.8464834645512657`*^9, {3.8464835001776543`*^9, 3.8464835314603896`*^9}, 
   3.8465004156526003`*^9, {3.846500509441284*^9, 3.846500528733922*^9}, {
   3.846500633488022*^9, 3.8465006345746436`*^9}, {3.846519104523863*^9, 
   3.8465191345962152`*^9}, {3.846519235335081*^9, 3.8465192709173393`*^9}, {
   3.84651931111749*^9, 3.846519325489251*^9}, {3.8465193634164267`*^9, 
   3.8465193687467766`*^9}, {3.846520002559202*^9, 3.8465200135939913`*^9}, {
   3.846520108915042*^9, 3.84652016495837*^9}, {3.846522572714191*^9, 
   3.8465225729868164`*^9}, 3.846522604841237*^9, 3.8465226368426905`*^9, 
   3.8465232790003357`*^9, {3.8465233321398835`*^9, 3.8465234197619967`*^9}, {
   3.846523791646574*^9, 3.8465238077350235`*^9}, {3.846523874997283*^9, 
   3.846523876650039*^9}, {3.846524004413453*^9, 3.846524004965392*^9}, {
   3.846524448995968*^9, 3.8465244495431223`*^9}, {3.8465255190931873`*^9, 
   3.846525522567645*^9}, {3.846525671062673*^9, 3.846525691169363*^9}, {
   3.8465257233822203`*^9, 3.8465257934604726`*^9}, {3.8465258255421257`*^9, 
   3.846525847924282*^9}, 3.8465259319961853`*^9, {3.8465260553008323`*^9, 
   3.846526055947702*^9}, {3.846526160997239*^9, 3.8465261990768847`*^9}, {
   3.846526256675438*^9, 3.8465263214695024`*^9}, {3.846528770392928*^9, 
   3.8465287954965*^9}, {3.8466016174853973`*^9, 3.8466017127788305`*^9}, {
   3.84660174616691*^9, 3.846601760200644*^9}, 3.8466019157228136`*^9, {
   3.8466045853063297`*^9, 3.8466045904886093`*^9}, {3.846604628918666*^9, 
   3.8466047637875834`*^9}, {3.846604797604923*^9, 3.8466048448104267`*^9}, 
   3.8466057187229843`*^9, {3.846606376929843*^9, 3.8466063797373047`*^9}, {
   3.8466067708319635`*^9, 3.846606771079426*^9}, {3.8466068024227047`*^9, 
   3.8466068248317723`*^9}, {3.8466069793387966`*^9, 3.846607030801883*^9}, {
   3.8466071671432505`*^9, 3.8466071674228*^9}, {3.8466072118214445`*^9, 
   3.846607240508732*^9}, 3.846607324022814*^9, {3.8466073745131345`*^9, 
   3.84660739278086*^9}, {3.8466074833136215`*^9, 3.846607612140839*^9}, {
   3.8466076671784487`*^9, 3.8466077156901455`*^9}, {3.8466077534815397`*^9, 
   3.846608006963458*^9}, {3.8466080750334196`*^9, 3.846608081862214*^9}, {
   3.8466081433718452`*^9, 3.8466081749970407`*^9}, {3.84660846148787*^9, 
   3.8466085104486237`*^9}, {3.8466085786812277`*^9, 3.8466086139578695`*^9}, 
   3.8466087022936754`*^9, {3.846608747102007*^9, 3.8466087591436777`*^9}, {
   3.8466088925642405`*^9, 3.846608896254489*^9}, {3.846608968550199*^9, 
   3.8466089689629087`*^9}, {3.846609020751052*^9, 3.84660904819668*^9}, {
   3.846609089064375*^9, 3.8466092291740613`*^9}, {3.8466092871966777`*^9, 
   3.8466093277582135`*^9}, {3.846609502096903*^9, 3.8466095172775908`*^9}, {
   3.846609732700328*^9, 3.846609741982617*^9}, {3.8466102226041613`*^9, 
   3.8466102699014883`*^9}, {3.8466123626910534`*^9, 3.846612386870612*^9}, {
   3.846612446085459*^9, 3.846612454028096*^9}, {3.8466139035313244`*^9, 
   3.8466139042337093`*^9}, {3.846616198719364*^9, 3.8466161994220085`*^9}, {
   3.846623122450796*^9, 3.8466231228887324`*^9}, {3.8466231959549875`*^9, 
   3.8466232733115335`*^9}, {3.846623315206049*^9, 3.846623318317485*^9}, 
   3.846623468096721*^9, {3.846623499370211*^9, 3.8466235383141823`*^9}, {
   3.8466235721105947`*^9, 3.8466235947164583`*^9}, 3.846624271085913*^9, 
   3.84662431885349*^9, {3.8466263605861225`*^9, 3.84662636083552*^9}, {
   3.846648854650011*^9, 3.846648879690382*^9}, {3.8466489497720623`*^9, 
   3.8466489672335405`*^9}, {3.846649029344101*^9, 3.846649029571434*^9}, {
   3.8466492693144636`*^9, 3.8466492727655053`*^9}, {3.8466493709673586`*^9, 
   3.846649407603774*^9}, {3.846649521873869*^9, 3.846649522399297*^9}, {
   3.8466518646675835`*^9, 3.8466518722771854`*^9}, {3.8466520868938885`*^9, 
   3.8466520875592794`*^9}, {3.8466570259380407`*^9, 3.846657041399163*^9}, {
   3.8466571736082764`*^9, 3.8466571844055634`*^9}, {3.84668026200726*^9, 
   3.8466803463301535`*^9}, {3.8466928330459113`*^9, 3.846692955651614*^9}, {
   3.846693016440553*^9, 3.8466930179411325`*^9}, {3.8466930682711725`*^9, 
   3.8466930824481535`*^9}, {3.8466931133673053`*^9, 
   3.8466931346465263`*^9}, {3.846708925970793*^9, 3.846709028141409*^9}, {
   3.8467090855562315`*^9, 3.846709132402862*^9}, 3.846709172659603*^9, {
   3.846709220453621*^9, 3.8467092619138823`*^9}, {3.846710284388981*^9, 
   3.8467102994135313`*^9}, {3.846710342069231*^9, 3.8467103657406263`*^9}, {
   3.846710398546859*^9, 3.846710436486133*^9}, {3.846710467978583*^9, 
   3.8467105058786554`*^9}, {3.8467105629614196`*^9, 
   3.8467105864058876`*^9}, {3.846710634656933*^9, 3.8467106455644207`*^9}, {
   3.8467106904372125`*^9, 3.8467107181431556`*^9}, {3.8467107813440046`*^9, 
   3.8467108416664815`*^9}, {3.8467108757800756`*^9, 
   3.8467108987981396`*^9}, {3.8467109374652615`*^9, 
   3.8467110976385098`*^9}, {3.846711175315278*^9, 3.846711215553342*^9}, {
   3.846711391468799*^9, 3.8467114088612995`*^9}, {3.846734701169371*^9, 
   3.8467347017789063`*^9}, {3.8467347543847704`*^9, 
   3.8467347570262413`*^9}, {3.8467349238851376`*^9, 
   3.8467349240882006`*^9}, {3.846780783508993*^9, 3.8467807853629475`*^9}, {
   3.8467808431580873`*^9, 3.8467808434106293`*^9}, {3.846780941007023*^9, 
   3.846780941632519*^9}, {3.8467884448745785`*^9, 3.846788452878994*^9}, {
   3.846788579622301*^9, 3.846788601849757*^9}, {3.846788637086182*^9, 
   3.846788641732342*^9}, {3.846788713116441*^9, 3.846788766253709*^9}, {
   3.8467888269010687`*^9, 3.846788827247837*^9}, {3.846788884733526*^9, 
   3.8467889349882936`*^9}, {3.8467889868923597`*^9, 
   3.8467890056779056`*^9}, {3.8467890516596546`*^9, 3.846789051950303*^9}, {
   3.846830366096161*^9, 3.846830457767414*^9}, 3.8468305215291953`*^9, {
   3.8468305665068626`*^9, 3.846830625641386*^9}, {3.846830665079854*^9, 
   3.8468307350841217`*^9}, {3.846830769528754*^9, 3.846830821909643*^9}, {
   3.84683090658302*^9, 3.8468309475409794`*^9}, {3.846830980923949*^9, 
   3.8468310464799404`*^9}, {3.8468310928019104`*^9, 
   3.8468311076371813`*^9}, {3.8469209223567367`*^9, 3.846920922597159*^9}, {
   3.846920957452387*^9, 3.8469209912137423`*^9}, 3.846921037565917*^9, 
   3.8469211695267177`*^9, {3.8469212487053823`*^9, 3.8469213863363743`*^9}, {
   3.846921416633177*^9, 3.8469215167625885`*^9}, {3.846921605348152*^9, 
   3.846921608234954*^9}, {3.8469216959751406`*^9, 3.8469218048262362`*^9}, {
   3.846921900103754*^9, 3.84692191885708*^9}, {3.8469219496307697`*^9, 
   3.846921975839851*^9}, {3.8469220147597933`*^9, 3.8469220479022455`*^9}, {
   3.846922376365288*^9, 3.8469223908887305`*^9}, 3.8469274135100403`*^9, {
   3.8469274561904116`*^9, 3.846927456837782*^9}, {3.8469275845511093`*^9, 
   3.8469275876399293`*^9}, {3.846927620426762*^9, 3.846927620617675*^9}, {
   3.8469278200993958`*^9, 3.8469278229293156`*^9}, {3.846927858674553*^9, 
   3.8469278593370934`*^9}, {3.8469278939217215`*^9, 
   3.8469279650073233`*^9}, {3.8469280172240496`*^9, 
   3.8469280391759834`*^9}, {3.8469281099654922`*^9, 
   3.8469281407856894`*^9}, {3.8469284340268283`*^9, 3.846928466621228*^9}, {
   3.8469285103342276`*^9, 3.8469285105738287`*^9}, {3.846929256500558*^9, 
   3.8469296950814185`*^9}, {3.846929788921775*^9, 3.846929820568144*^9}, {
   3.846933580006667*^9, 3.8469335808757105`*^9}, {3.8469337040551033`*^9, 
   3.84693370708757*^9}, {3.8469342150526304`*^9, 3.8469342158825397`*^9}, 
   3.8469344882404127`*^9, {3.8469642301992674`*^9, 3.8469642312782774`*^9}, {
   3.846964268911618*^9, 3.8469642741597357`*^9}, 3.846964337237979*^9, {
   3.8469643814963517`*^9, 3.8469643968068995`*^9}, {3.8470198472867765`*^9, 
   3.8470199200756874`*^9}, {3.8470199535928373`*^9, 
   3.8470199767106113`*^9}, {3.847020015935192*^9, 3.8470200183115234`*^9}, {
   3.84702021098263*^9, 3.847020211193123*^9}, {3.8470204195249977`*^9, 
   3.8470204674073644`*^9}, {3.8470205499859805`*^9, 3.847020610567681*^9}, {
   3.847020663521522*^9, 3.8470207515331593`*^9}, {3.847020797036257*^9, 
   3.847020824543555*^9}, {3.8470208948864284`*^9, 3.84702089507411*^9}, {
   3.847021415365317*^9, 3.8470214481771617`*^9}, {3.847021750717722*^9, 
   3.847021838098323*^9}, {3.847045111459629*^9, 3.84704513369217*^9}, {
   3.847045175186852*^9, 3.8470454501778593`*^9}, {3.847045521287368*^9, 
   3.8470455912881203`*^9}, {3.847045649890093*^9, 3.84704580075369*^9}, {
   3.847045853785695*^9, 3.847045857848675*^9}, {3.8470597432148633`*^9, 
   3.847059796431737*^9}, {3.847059835946183*^9, 3.8470598868997374`*^9}, {
   3.8470599260512953`*^9, 3.847059942327125*^9}, {3.847060042481942*^9, 
   3.8470600430140924`*^9}, {3.847060135442916*^9, 3.8470601599026427`*^9}, 
   3.8470602354593515`*^9, {3.847060268557953*^9, 3.8470602687887793`*^9}, {
   3.847060469414931*^9, 3.847060470418352*^9}, {3.8470854063961616`*^9, 
   3.847085406695451*^9}, {3.847085445186471*^9, 3.847085510597335*^9}, {
   3.8470855625645647`*^9, 3.84708556277015*^9}, {3.847085608716833*^9, 
   3.847085613247252*^9}, {3.847085690577217*^9, 3.8470857409685755`*^9}, {
   3.8470857734837985`*^9, 3.8470859519993668`*^9}, {3.8470860477236643`*^9, 
   3.847086047911708*^9}, {3.847086080275606*^9, 3.8470860810005507`*^9}, {
   3.8470861297958345`*^9, 3.847086131225452*^9}, {3.8470861657797084`*^9, 
   3.847086165925317*^9}, {3.847086878947869*^9, 3.847086879608226*^9}, {
   3.8470869559143057`*^9, 3.8470871017239633`*^9}, {3.8470880214989243`*^9, 
   3.8470880991452475`*^9}, {3.8470881349793463`*^9, 
   3.8470881625173335`*^9}, {3.8470901265087337`*^9, 
   3.8470901351059847`*^9}, {3.8470902047829475`*^9, 3.847090221166195*^9}, {
   3.847090343502087*^9, 3.8470903700344934`*^9}, {3.847090401001027*^9, 
   3.847090424677082*^9}, {3.847090464179579*^9, 3.847090464368435*^9}, {
   3.8470905076019325`*^9, 3.8470905082902427`*^9}, {3.847091749196701*^9, 
   3.8470917599206095`*^9}, {3.8471061720988903`*^9, 3.847106172428729*^9}, {
   3.8471122366625814`*^9, 3.8471123180507317`*^9}, {3.847112349487014*^9, 
   3.84711236329187*^9}, {3.847112396214738*^9, 3.8471125355064616`*^9}, {
   3.847114339075255*^9, 3.8471144646896725`*^9}, {3.847114500680155*^9, 
   3.84711457513656*^9}, {3.847117069297183*^9, 3.8471171027653027`*^9}, {
   3.847117133856286*^9, 3.847117134075392*^9}, {3.847117165630693*^9, 
   3.8471172026515007`*^9}, {3.8471185312929373`*^9, 3.847118539577421*^9}, {
   3.847118614652891*^9, 3.8471186219890375`*^9}, {3.8471207021583853`*^9, 
   3.847120703787715*^9}, {3.8471207486660194`*^9, 3.8471207612401023`*^9}, {
   3.8471208227429485`*^9, 3.847120823434304*^9}, 3.847120921878149*^9, {
   3.8471209966494102`*^9, 3.8471209982261524`*^9}, {3.847121029474697*^9, 
   3.84712105933517*^9}, {3.8471210918639154`*^9, 3.847121237288969*^9}, {
   3.847121270227481*^9, 3.847121283156928*^9}, {3.8471266439987535`*^9, 
   3.847126686962287*^9}, {3.847305553551616*^9, 3.8473055540683813`*^9}, {
   3.847305585599434*^9, 3.8473056891657457`*^9}, {3.8473057269885087`*^9, 
   3.847305728104952*^9}, {3.847345558825198*^9, 3.847345559036398*^9}, {
   3.8473455900698323`*^9, 3.847345706529154*^9}, {3.8473457374163823`*^9, 
   3.8473457939569077`*^9}, {3.8473459340368085`*^9, 
   3.8473459346516476`*^9}, {3.847374132449728*^9, 3.847374163501812*^9}, {
   3.8473742670748463`*^9, 3.8473742780862646`*^9}, {3.847374580912922*^9, 
   3.8473746325644627`*^9}, {3.8473752850713778`*^9, 3.847375311739541*^9}, {
   3.847375463574893*^9, 3.847375463829517*^9}, {3.847376204340386*^9, 
   3.8473762328423004`*^9}, {3.847376364885863*^9, 3.8473764028761406`*^9}, {
   3.8473778321894927`*^9, 3.8473778332188797`*^9}, {3.8473778751522655`*^9, 
   3.8473778753847075`*^9}, {3.8473784874359837`*^9, 3.8473785560297456`*^9}, 
   3.847378705719813*^9, {3.847380977022859*^9, 3.8473809997386312`*^9}, {
   3.847384154093497*^9, 3.8473841931739726`*^9}, {3.8473866953329954`*^9, 
   3.847386703201665*^9}, 3.8473867773042326`*^9, 3.8473868140303164`*^9, {
   3.847386859016571*^9, 3.8473868759664316`*^9}, {3.847388964530238*^9, 
   3.847388976361663*^9}, {3.8473890191767445`*^9, 3.8473890193471303`*^9}, {
   3.847436520042019*^9, 3.8474365635180674`*^9}, 3.84743660449823*^9, {
   3.847444137415286*^9, 3.847444155939187*^9}, {3.847444211773057*^9, 
   3.8474442132900405`*^9}, {3.847444273894333*^9, 3.8474442916992016`*^9}, {
   3.847444326741954*^9, 3.847444464613924*^9}, {3.8474445056525393`*^9, 
   3.84744461273339*^9}, {3.8474446553583755`*^9, 3.8474446580778265`*^9}, {
   3.8474447516112146`*^9, 3.8474447568560357`*^9}, {3.8474448151927032`*^9, 
   3.8474448478587484`*^9}, {3.8474448950930796`*^9, 
   3.8474448980948133`*^9}, {3.847445046625121*^9, 3.8474451221299334`*^9}, {
   3.8474451702785683`*^9, 3.847445183948967*^9}, {3.8474452220676794`*^9, 
   3.8474452293647585`*^9}, {3.8474453456247573`*^9, 
   3.8474453509844265`*^9}, {3.847446221437069*^9, 3.8474462453786716`*^9}, {
   3.847446388627624*^9, 3.847446415529388*^9}, {3.8474464472566767`*^9, 
   3.847446469158552*^9}, {3.8474465133086863`*^9, 3.84744651931157*^9}, {
   3.8474466477496653`*^9, 3.8474467227105627`*^9}, 3.8474467610861115`*^9, {
   3.847446802999303*^9, 3.8474469067628202`*^9}, 3.8474469433231373`*^9, {
   3.8474470204979897`*^9, 3.847447028028378*^9}, {3.847447395897905*^9, 
   3.847447480451497*^9}, {3.8474477038284483`*^9, 3.847447721505409*^9}, {
   3.847447894139882*^9, 3.8474479104025826`*^9}, {3.847448017822582*^9, 
   3.847448019572998*^9}, {3.8474482226317945`*^9, 3.847448230314872*^9}, 
   3.8474482800421114`*^9, {3.8474484527268543`*^9, 3.847448463027484*^9}, {
   3.847448625024782*^9, 3.8474486278133106`*^9}, {3.8474486606586866`*^9, 
   3.8474487067200212`*^9}, {3.847448998090023*^9, 3.847449036626491*^9}, 
   3.8474494445947523`*^9, 3.847474170512819*^9, {3.8474742157265863`*^9, 
   3.8474742251756163`*^9}, {3.8474744069153576`*^9, 
   3.8474744492984843`*^9}, {3.8474746532511873`*^9, 
   3.8474746764800377`*^9}, {3.84747471154298*^9, 3.8474747142131805`*^9}, {
   3.847478130058364*^9, 3.8474781318809357`*^9}, 3.847481316485815*^9, {
   3.8474813468168917`*^9, 3.8474813478987904`*^9}, {3.847520043290852*^9, 
   3.847520050719135*^9}, {3.8475202509734597`*^9, 3.847520252452859*^9}, {
   3.8475203014618807`*^9, 3.8475203104038987`*^9}, 3.8475204127428856`*^9, {
   3.8475204703466263`*^9, 3.8475206122954407`*^9}, {3.8475211529176645`*^9, 
   3.847521250936846*^9}, {3.8475212980805144`*^9, 3.847521332725197*^9}, {
   3.8475213738540134`*^9, 3.847521387059809*^9}, 3.8475214335751166`*^9, {
   3.8475226556950593`*^9, 3.8475226970097647`*^9}, {3.847534191456636*^9, 
   3.8475342112304764`*^9}, {3.8475342536293554`*^9, 3.847534272008305*^9}, {
   3.847534336751069*^9, 3.847534342283043*^9}, {3.8475344486647253`*^9, 
   3.8475344490128665`*^9}, {3.847535392737775*^9, 3.847535399487635*^9}, {
   3.8475391669878592`*^9, 3.847539205414163*^9}, {3.847539237139219*^9, 
   3.8475392404208927`*^9}, {3.847539468201988*^9, 3.8475395379010878`*^9}, {
   3.8475421979191666`*^9, 3.847542233997595*^9}, {3.8475424002534504`*^9, 
   3.8475424610152736`*^9}, 3.8475424975875463`*^9, {3.8475425302236423`*^9, 
   3.847542534084491*^9}, {3.8475425687440376`*^9, 3.847542569001856*^9}, {
   3.8475426549421997`*^9, 3.847542729688019*^9}, {3.8475427649549074`*^9, 
   3.847542916241453*^9}, {3.8475430197102246`*^9, 3.8475430629210043`*^9}, 
   3.847543100689478*^9, {3.847543291684683*^9, 3.847543364549927*^9}, {
   3.8475433964348803`*^9, 3.8475434464544287`*^9}, {3.847543488677998*^9, 
   3.8475435020342937`*^9}, 3.847543566722655*^9, {3.847545337895879*^9, 
   3.847545360057493*^9}, {3.8475455005959406`*^9, 3.847545603162412*^9}, {
   3.847545656975726*^9, 3.847545747807779*^9}, {3.8475493127750626`*^9, 
   3.8475493405369945`*^9}, {3.8475493737109284`*^9, 3.847549374395993*^9}, {
   3.8475494244022694`*^9, 3.8475495672569895`*^9}, {3.847549601643544*^9, 
   3.847549697540609*^9}, {3.847549776072938*^9, 3.847549849301073*^9}, {
   3.847549953310105*^9, 3.847550044545368*^9}, {3.8475501462599416`*^9, 
   3.8475501853664055`*^9}, {3.847550234755725*^9, 3.847550267938068*^9}, {
   3.8475503141014156`*^9, 3.847550359075974*^9}, {3.8475508002337637`*^9, 
   3.84755083012267*^9}, 3.847550862567766*^9, {3.8475508953028316`*^9, 
   3.8475508967780733`*^9}, 3.8475509323696547`*^9, {3.847550964867447*^9, 
   3.8475511362183366`*^9}, {3.8475529350389276`*^9, 
   3.8475530493560085`*^9}, {3.847553175667039*^9, 3.8475532407570744`*^9}, 
   3.847553276625306*^9, {3.8475534310643687`*^9, 3.847553526933724*^9}, {
   3.847553558850833*^9, 3.8475535774688063`*^9}, {3.847553610655955*^9, 
   3.8475536676790533`*^9}, {3.8475537060097246`*^9, 3.847553760908346*^9}, {
   3.847553848366018*^9, 3.8475538489891567`*^9}, {3.8475559568994856`*^9, 
   3.8475559780642347`*^9}, {3.8475560570446568`*^9, 
   3.8475562265066366`*^9}, {3.847556348406762*^9, 3.8475563493708506`*^9}, {
   3.8475570657398376`*^9, 3.847557070233081*^9}, {3.8475571086549177`*^9, 
   3.847557113752845*^9}, {3.847557337457235*^9, 3.8475573503703194`*^9}, {
   3.847558303821995*^9, 3.8475583190586896`*^9}, {3.84755838665746*^9, 
   3.8475584210828853`*^9}, {3.847558538207958*^9, 3.8475585421597385`*^9}, {
   3.8475646719296727`*^9, 3.8475647066409245`*^9}, {3.8475647411674943`*^9, 
   3.847564777510826*^9}, {3.8475648165804*^9, 3.847564817012479*^9}, {
   3.8476049470182886`*^9, 3.8476049538476667`*^9}, {3.847604984878416*^9, 
   3.8476049945120497`*^9}, 3.847605043481779*^9, {3.847605136081457*^9, 
   3.847605145239802*^9}, {3.8476051915364723`*^9, 3.8476051927878504`*^9}, {
   3.8476052286063275`*^9, 3.8476052604987125`*^9}, {3.847605403718154*^9, 
   3.847605425628147*^9}, {3.84761022537037*^9, 3.8476102933529377`*^9}, {
   3.847610338874178*^9, 3.8476103773836203`*^9}, {3.8476104130643034`*^9, 
   3.847610438606505*^9}, {3.8476109517931986`*^9, 3.84761095308287*^9}, {
   3.8476109928930035`*^9, 3.8476110294217286`*^9}, {3.847611553968063*^9, 
   3.8476116544592705`*^9}, {3.8477128746762238`*^9, 
   3.8477129102374587`*^9}, {3.84771294709557*^9, 3.8477129473107376`*^9}, {
   3.847712986535144*^9, 3.847712993456653*^9}, {3.847713057336997*^9, 
   3.8477130578801684`*^9}, {3.8477240031166744`*^9, 3.847724062889203*^9}, {
   3.847724094525238*^9, 3.847724128019842*^9}, {3.84772416737494*^9, 
   3.847724173818552*^9}, {3.847724504859726*^9, 3.8477245179283066`*^9}, {
   3.847724586724241*^9, 3.8477246015029907`*^9}, {3.847726311038623*^9, 
   3.8477263707712383`*^9}, 3.847726403216514*^9, {3.8477272108988276`*^9, 
   3.8477272148091564`*^9}, {3.847727653315878*^9, 3.847727679661412*^9}, {
   3.84772783156396*^9, 3.8477278319291735`*^9}, 3.8477278742865477`*^9, 
   3.847727907024757*^9, 3.847727948219263*^9, {3.847728011297968*^9, 
   3.847728017719923*^9}, {3.8477281646839347`*^9, 3.847728193068116*^9}, 
   3.847728223434451*^9, {3.8477282649402933`*^9, 3.8477282651451826`*^9}, {
   3.8477283252092266`*^9, 3.8477283662544813`*^9}, {3.847729160887391*^9, 
   3.8477292387008443`*^9}, {3.847729402480899*^9, 3.847729404705756*^9}, {
   3.847729648101929*^9, 3.8477296487301025`*^9}, {3.8477296816226625`*^9, 
   3.847729725894822*^9}, {3.847729782724332*^9, 3.8477298557927365`*^9}, 
   3.8477299628958364`*^9, 3.8477301544247875`*^9, {3.8477302859989424`*^9, 
   3.8477303104761767`*^9}, {3.8477304049827847`*^9, 
   3.8477304116915855`*^9}, {3.847731624433319*^9, 3.847731649403025*^9}, {
   3.847731680384777*^9, 3.847731680609274*^9}, {3.847731723312152*^9, 
   3.8477317235108*^9}, {3.847731753686486*^9, 3.847731787287048*^9}, {
   3.8477318222324038`*^9, 3.847731853573841*^9}, 3.847731888680976*^9, {
   3.84773254027124*^9, 3.84773259175768*^9}, {3.847732676805479*^9, 
   3.8477326798320217`*^9}, 3.8477327520486093`*^9, {3.847732800743252*^9, 
   3.847732831227905*^9}, {3.8477328636465964`*^9, 3.8477329311694603`*^9}, {
   3.8477329786425695`*^9, 3.847733001108169*^9}, {3.8477344485774617`*^9, 
   3.847734449040657*^9}, {3.847735548921444*^9, 3.8477355539918585`*^9}, 
   3.8477356092948833`*^9, {3.8477356648636427`*^9, 3.847735696665759*^9}, {
   3.847735732514182*^9, 3.8477357683967323`*^9}, {3.847735798881852*^9, 
   3.847735827537175*^9}, {3.8477358620697975`*^9, 3.847735895880817*^9}, {
   3.847736758558835*^9, 3.8477367741287103`*^9}, {3.8477368313837757`*^9, 
   3.8477368398856983`*^9}, {3.8477368885043383`*^9, 
   3.8477368913443365`*^9}, {3.847737036839753*^9, 3.847737039953023*^9}, {
   3.8477372575931854`*^9, 3.8477372616724477`*^9}, {3.8477372942804537`*^9, 
   3.8477373209559608`*^9}, {3.8477373540100584`*^9, 
   3.8477373548286095`*^9}, {3.8477374283321295`*^9, 3.847737448875146*^9}, {
   3.8477385723208*^9, 3.847738572943763*^9}, {3.8477386163779135`*^9, 
   3.8477386376275473`*^9}, {3.847738676899056*^9, 3.8477387171264935`*^9}, {
   3.847738755837926*^9, 3.8477388275199356`*^9}, {3.847738858505788*^9, 
   3.8477388642734365`*^9}, {3.8477431391586447`*^9, 
   3.8477431674828725`*^9}, {3.847743225146303*^9, 3.8477432325461226`*^9}, {
   3.847743273783062*^9, 3.847743275009992*^9}, {3.8477433505535383`*^9, 
   3.8477433960323944`*^9}, {3.8477434971480293`*^9, 
   3.8477434990780554`*^9}, {3.8477436102896643`*^9, 3.847743629616536*^9}, {
   3.8477447277977376`*^9, 3.847744729292574*^9}, {3.847744779810004*^9, 
   3.8477447816438203`*^9}, {3.8477448152183466`*^9, 3.847744934133616*^9}, {
   3.8477449645496264`*^9, 3.847744967575861*^9}, {3.847745131566255*^9, 
   3.847745135933857*^9}, {3.847745173527743*^9, 3.847745211957642*^9}, {
   3.847745328258037*^9, 3.847745387968842*^9}, {3.8477454209320955`*^9, 
   3.8477454983399353`*^9}, {3.8477789467542706`*^9, 3.847778962668648*^9}, {
   3.8477790190147567`*^9, 3.847779045136408*^9}, {3.84777907945718*^9, 
   3.8477791122688255`*^9}, {3.84777914690348*^9, 3.8477792190757217`*^9}, {
   3.8477792500496044`*^9, 3.8477792720776176`*^9}, {3.847779767130761*^9, 
   3.847779768166646*^9}, {3.847779800553321*^9, 3.8477798009825726`*^9}, {
   3.8477798415581756`*^9, 3.847779895084185*^9}, {3.847780889401723*^9, 
   3.847780929852502*^9}, {3.847782747384061*^9, 3.847782783480502*^9}, {
   3.8477842621096497`*^9, 3.847784275820633*^9}, {3.847784331324417*^9, 
   3.847784351821968*^9}, {3.847784583322559*^9, 3.847784583844537*^9}, 
   3.8477885130074224`*^9, {3.847791148733573*^9, 3.847791279692131*^9}, {
   3.8477913948642073`*^9, 3.8477913973714085`*^9}, {3.8477914319003057`*^9, 
   3.847791454252021*^9}, {3.84786774433186*^9, 3.847867847342385*^9}, {
   3.847867902589425*^9, 3.8478679027925076`*^9}, {3.8478679412337627`*^9, 
   3.847867986885682*^9}, 3.847868270518171*^9, {3.847868308634478*^9, 
   3.8478683089339952`*^9}, {3.8478714054578495`*^9, 
   3.8478714264370747`*^9}, {3.847879964499645*^9, 3.8478799651319532`*^9}, {
   3.847879999423381*^9, 3.847880022487602*^9}, {3.847880063476407*^9, 
   3.8478800879646473`*^9}, {3.8478801652908697`*^9, 3.8478801745588837`*^9}, 
   3.8478856158001842`*^9, {3.8478856569282093`*^9, 3.8478856856127243`*^9}, {
   3.8478857413575573`*^9, 3.847885741703433*^9}, {3.8478858318954372`*^9, 
   3.8478858579175863`*^9}, {3.8478858921149406`*^9, 3.847885934201924*^9}, {
   3.847900933330883*^9, 3.8479009497437716`*^9}, {3.8479052501429844`*^9, 
   3.84790527187921*^9}, {3.847908230498436*^9, 3.8479082692543287`*^9}, {
   3.8479083071990523`*^9, 3.847908307672818*^9}, {3.8479091803458414`*^9, 
   3.8479091897719193`*^9}, {3.8479092303705177`*^9, 3.847909308825135*^9}, {
   3.8479093498332725`*^9, 3.847909442436017*^9}, {3.847910581639266*^9, 
   3.847910680751054*^9}, {3.847913163759246*^9, 3.8479131682300076`*^9}, 
   3.8479132421046553`*^9, {3.8479132982247057`*^9, 3.847913299286954*^9}, {
   3.847981548192832*^9, 3.847981551429047*^9}, {3.8479816104475813`*^9, 
   3.84798161122038*^9}, {3.8479846678927345`*^9, 3.8479847801044226`*^9}, {
   3.847987388354062*^9, 3.847987467449986*^9}, {3.8479875383525333`*^9, 
   3.8479875422863646`*^9}, {3.847987596662923*^9, 3.847987635955453*^9}, {
   3.8479890217398815`*^9, 3.8479891451671734`*^9}, {3.8479968172070103`*^9, 
   3.8479968326766806`*^9}, {3.8479968647167344`*^9, 3.847997011842245*^9}, {
   3.848134351932253*^9, 3.848134352671308*^9}, {3.8481343886346827`*^9, 
   3.8481344001456523`*^9}, {3.8481344466410933`*^9, 3.848134480254094*^9}, {
   3.848134515628718*^9, 3.8481345510903425`*^9}, 3.8481346028768816`*^9, {
   3.848134643306771*^9, 3.848134646274991*^9}, {3.848134680858839*^9, 
   3.8481347343745146`*^9}, {3.848134782850252*^9, 3.848134782991598*^9}, {
   3.8481348192843*^9, 3.84813483223247*^9}, {3.8481356395188074`*^9, 
   3.848135644386082*^9}, 3.8481356757576923`*^9, {3.8481487256843367`*^9, 
   3.848148726632927*^9}, {3.848148756883463*^9, 3.8481487769058514`*^9}, {
   3.848148910383609*^9, 3.848148935023984*^9}, {3.8481613841433897`*^9, 
   3.8481614207093515`*^9}, 3.848161460809745*^9, {3.848161546977355*^9, 
   3.848161561343178*^9}, {3.8481616383399467`*^9, 3.8481616505855026`*^9}, {
   3.8481616921656466`*^9, 3.8481616957564144`*^9}, {3.84816177491439*^9, 
   3.848161791622007*^9}, {3.8481618218816743`*^9, 3.848161857284233*^9}, {
   3.8481618942379766`*^9, 3.848161977165616*^9}, {3.848162013230503*^9, 
   3.84816202500681*^9}, {3.8481620586703796`*^9, 3.84816206750392*^9}, 
   3.8481621107655053`*^9, {3.84816214104641*^9, 3.8481621812862954`*^9}, {
   3.848162359897614*^9, 3.8481625081699166`*^9}, {3.84816254744195*^9, 
   3.8481628624589005`*^9}, 3.8481628956147285`*^9, {3.848162931721955*^9, 
   3.848162989525977*^9}, {3.848211124763425*^9, 3.8482111472956476`*^9}, {
   3.8482170420537586`*^9, 3.848217053750538*^9}, {3.8482175475028267`*^9, 
   3.8482175587890477`*^9}, {3.848218024380687*^9, 3.848218081265561*^9}, {
   3.8482181760615573`*^9, 3.848218183680344*^9}, {3.8482184755204167`*^9, 
   3.8482185103945527`*^9}, {3.8482185982826705`*^9, 3.848218629121423*^9}, {
   3.848218709470146*^9, 3.848218738341649*^9}, {3.8482187704019527`*^9, 
   3.8482188379934072`*^9}, {3.8482188802020855`*^9, 3.848218880986233*^9}, {
   3.8482190391080723`*^9, 3.8482190675354476`*^9}, {3.848219157370944*^9, 
   3.8482191578982506`*^9}, {3.8482192067411256`*^9, 
   3.8482192134033794`*^9}, {3.84821926180707*^9, 3.8482193737817936`*^9}, {
   3.8482195316001244`*^9, 3.8482195413109617`*^9}, {3.8482196075364394`*^9, 
   3.848219632720646*^9}, {3.8482197439381957`*^9, 3.8482197512769384`*^9}, {
   3.8482198506218443`*^9, 3.8482199825688357`*^9}, {3.8482201077613387`*^9, 
   3.8482201081470995`*^9}, {3.848220146083031*^9, 3.848220177122289*^9}, {
   3.848220338059208*^9, 3.8482204753233185`*^9}, {3.8482205397666326`*^9, 
   3.848220557764063*^9}, {3.8482206557443047`*^9, 3.8482206788122425`*^9}, {
   3.848220759337453*^9, 3.8482207907268205`*^9}, {3.84822082727052*^9, 
   3.848220843831151*^9}, {3.8482210626441307`*^9, 3.8482213982314835`*^9}, {
   3.848223749589416*^9, 3.8482238255349894`*^9}, {3.8482238558040605`*^9, 
   3.84822386104963*^9}, {3.848223896333542*^9, 3.8482239014442005`*^9}, {
   3.8482239833178563`*^9, 3.848224046423258*^9}, {3.84822410974829*^9, 
   3.8482244197018147`*^9}, {3.8482244992258005`*^9, 
   3.8482245006091723`*^9}, {3.848224534235218*^9, 3.848224551368987*^9}, {
   3.848224643530056*^9, 3.8482250201685405`*^9}, {3.8482252906356735`*^9, 
   3.848225294990923*^9}, {3.8482253431571646`*^9, 3.8482253436420336`*^9}, {
   3.8482254599865913`*^9, 3.848225488944186*^9}, {3.848230620896928*^9, 
   3.8482306606554136`*^9}, 3.8482307379690704`*^9, 3.8482307830274363`*^9, {
   3.8482308309992704`*^9, 3.84823095794773*^9}, {3.848231139944684*^9, 
   3.8482312540640244`*^9}, {3.8482320669071865`*^9, 3.848232220082368*^9}, {
   3.848232339078987*^9, 3.84823233940972*^9}, {3.8482324547348137`*^9, 
   3.8482324775699067`*^9}, {3.84823256365687*^9, 3.8482326008655624`*^9}, {
   3.848236441961539*^9, 3.848236476953825*^9}, {3.8482365241936088`*^9, 
   3.8482365397667575`*^9}, {3.8482366491788836`*^9, 
   3.8482366611012025`*^9}, {3.848236707789988*^9, 3.848236725918551*^9}, {
   3.8482367586175613`*^9, 3.848236778386981*^9}, {3.848236854582548*^9, 
   3.8482368567442074`*^9}, 3.848236959635877*^9, {3.848237005649067*^9, 
   3.848237023787304*^9}, {3.8482371001782455`*^9, 3.848237164849023*^9}, {
   3.8482371971773553`*^9, 3.84823721774537*^9}, {3.8482373909331684`*^9, 
   3.8482374036755657`*^9}, {3.8482375118481894`*^9, 
   3.8482375371414833`*^9}, {3.8482376407840595`*^9, 
   3.8482377938990164`*^9}, {3.848237831143131*^9, 3.8482378414276247`*^9}, 
   3.8482378751819096`*^9, {3.8482379485147285`*^9, 3.848238132632264*^9}, {
   3.848238173651384*^9, 3.848238175008146*^9}, {3.8482382488699894`*^9, 
   3.848238250724456*^9}, {3.8482383296082697`*^9, 3.8482384201545467`*^9}, {
   3.8482384569787426`*^9, 3.8482385311949716`*^9}, {3.8482385630594745`*^9, 
   3.848238675808525*^9}, {3.8482387661117926`*^9, 3.848238784121192*^9}, {
   3.8482388452856083`*^9, 3.8482388470273547`*^9}, {3.848238937327699*^9, 
   3.848238939915019*^9}, {3.848239016655217*^9, 3.848239055257209*^9}, {
   3.8482391876600847`*^9, 3.848239192842037*^9}, {3.8482392452804046`*^9, 
   3.8482393154539003`*^9}, 3.8482393599931283`*^9, {3.848239464754718*^9, 
   3.8482394777509403`*^9}, {3.8482396288367815`*^9, 
   3.8482396363761187`*^9}, {3.848239790919952*^9, 3.848239803671554*^9}, {
   3.8482398451674423`*^9, 3.848240013126849*^9}, {3.848240050145351*^9, 
   3.8482401582396593`*^9}, {3.8482403174096594`*^9, 3.848240360821004*^9}, {
   3.8482446040230827`*^9, 3.8482447245301805`*^9}, {3.8482448295148077`*^9, 
   3.8482448689840107`*^9}, {3.848244910796685*^9, 3.848245058819092*^9}, {
   3.848245092310795*^9, 3.8482451251919427`*^9}, {3.8482451686592803`*^9, 
   3.8482451697848873`*^9}, {3.848245228227812*^9, 3.848245242662896*^9}, 
   3.8482453036187797`*^9, 3.848245373071596*^9, {3.848245408566481*^9, 
   3.8482454399392896`*^9}, {3.8482454886294165`*^9, 3.848245497173318*^9}, {
   3.8482455985536356`*^9, 3.84824561958615*^9}, {3.848245664706713*^9, 
   3.8482456809687033`*^9}, {3.848249711065043*^9, 3.8482497715938797`*^9}, {
   3.84824983342348*^9, 3.8482499212432046`*^9}, {3.8482506142823706`*^9, 
   3.848250724035468*^9}, {3.848250782115301*^9, 3.848251044585989*^9}, {
   3.8482510751134624`*^9, 3.848251122542879*^9}, {3.8482936244041977`*^9, 
   3.8482936640782604`*^9}, {3.8482937265947323`*^9, 
   3.8482938679358163`*^9}, {3.848293900300599*^9, 3.8482939550357747`*^9}, {
   3.8482940411374583`*^9, 3.8482940494988565`*^9}, {3.848294101727869*^9, 
   3.848294229768239*^9}, {3.848294299590808*^9, 3.8482943006835494`*^9}, {
   3.8482943804550886`*^9, 3.848294420155674*^9}, {3.848294482030948*^9, 
   3.8482946005172577`*^9}, {3.8482946550524797`*^9, 3.848294665604249*^9}, {
   3.8482947300394287`*^9, 3.8482947326759806`*^9}, 3.848294766863244*^9, {
   3.8482948001853676`*^9, 3.848294833990514*^9}, {3.8482951700146704`*^9, 
   3.8482952407369947`*^9}, {3.848295297750139*^9, 3.8482953270072966`*^9}, {
   3.8482953583115377`*^9, 3.84829536355941*^9}, {3.84829544455939*^9, 
   3.8482954470402265`*^9}, 3.8482956404281344`*^9, {3.8482956799052896`*^9, 
   3.8482956879428244`*^9}, {3.848297597950692*^9, 3.8482976174588594`*^9}, 
   3.848297671643611*^9, 3.848298888304626*^9, {3.8482989902167873`*^9, 
   3.848298990406315*^9}, {3.848299075374566*^9, 3.848299125406086*^9}, {
   3.8482994417692566`*^9, 3.848299473998143*^9}, {3.848299724013857*^9, 
   3.8482997548770156`*^9}, 3.8482998807915893`*^9, {3.848299928478659*^9, 
   3.848299953270003*^9}, {3.848300013773196*^9, 3.8483000253683805`*^9}, 
   3.8483004116815987`*^9, {3.848301180200698*^9, 3.848301187151841*^9}, {
   3.8483027754316993`*^9, 3.848302801018673*^9}, {3.848305349149164*^9, 
   3.848305364196805*^9}, {3.848305572129678*^9, 3.8483056301307945`*^9}, {
   3.8483068658795176`*^9, 3.848306889898988*^9}, {3.8483085574227543`*^9, 
   3.848308650635723*^9}, {3.8483087187717505`*^9, 3.8483087757406607`*^9}, {
   3.8483088074191656`*^9, 3.8483088095239377`*^9}, {3.8483090759528656`*^9, 
   3.84830908380173*^9}, {3.8483091550153203`*^9, 3.8483091668977356`*^9}, {
   3.8483092364042583`*^9, 3.848309239178625*^9}, {3.848309304285286*^9, 
   3.8483093312917013`*^9}, {3.8483093790338936`*^9, 
   3.8483093855929613`*^9}, {3.848309445264988*^9, 3.848309452260968*^9}, {
   3.8483095181728277`*^9, 3.848309545030476*^9}, {3.8483095851331387`*^9, 
   3.848309668754512*^9}, {3.848311464473199*^9, 3.848311498744421*^9}, {
   3.8483115374199333`*^9, 3.848311578125615*^9}, {3.8483159922233706`*^9, 
   3.848316048987984*^9}, {3.8483160844335313`*^9, 3.8483161211007133`*^9}, {
   3.8483161511356783`*^9, 3.848316169669032*^9}, 3.848316225991009*^9, 
   3.8483163439103155`*^9, {3.8483164321855016`*^9, 3.84831648106818*^9}, 
   3.848316527644351*^9, {3.848316586211298*^9, 3.848316656829791*^9}, {
   3.848316736095016*^9, 3.8483167389449854`*^9}, {3.84831680019977*^9, 
   3.8483168653919926`*^9}, 3.848316972517074*^9, {3.8483170780387177`*^9, 
   3.848317217189049*^9}, {3.848317261629712*^9, 3.848317262116639*^9}, {
   3.848317304875121*^9, 3.848317323355801*^9}, {3.848317375198634*^9, 
   3.848317377079444*^9}, {3.848317449788577*^9, 3.8483175527682247`*^9}, {
   3.848317583116257*^9, 3.8483177145357904`*^9}, {3.8483177520122824`*^9, 
   3.8483177650666904`*^9}, {3.8483186232068167`*^9, 3.848318817013752*^9}, {
   3.8483235939092307`*^9, 3.8483236409981136`*^9}, {3.848323674015129*^9, 
   3.8483236742611103`*^9}, {3.848323715005082*^9, 3.848323738740689*^9}, 
   3.848323778421914*^9, {3.8483238768149366`*^9, 3.8483239212727137`*^9}, {
   3.848323964106099*^9, 3.848323975135182*^9}, {3.8483240122336454`*^9, 
   3.8483240193630424`*^9}, 3.8483240540472937`*^9, {3.8483241142465763`*^9, 
   3.8483241174503603`*^9}, {3.848324197345604*^9, 3.8483241984718046`*^9}, {
   3.8483243254807024`*^9, 3.8483243369579306`*^9}, {3.8483244312001405`*^9, 
   3.848324438323295*^9}, {3.8483246559080586`*^9, 3.8483246638001933`*^9}, {
   3.848324700679841*^9, 3.8483247208429756`*^9}, 3.848324927341714*^9, {
   3.848325413037062*^9, 3.8483254175079517`*^9}, {3.848325560261938*^9, 
   3.848325562310277*^9}, {3.8483259887989798`*^9, 3.8483260060467463`*^9}, {
   3.848326415397194*^9, 3.84832641600952*^9}, {3.8483273260539083`*^9, 
   3.848327411500415*^9}, {3.8483277908431787`*^9, 3.8483277999953094`*^9}, {
   3.8483278598372803`*^9, 3.8483278778564153`*^9}, {3.8483279286165667`*^9, 
   3.8483279300216017`*^9}, {3.848327984756909*^9, 3.8483279936914763`*^9}, {
   3.848328065120105*^9, 3.8483280733916554`*^9}, {3.848328114165437*^9, 
   3.8483281160931897`*^9}, {3.8483281615227737`*^9, 3.8483281694680333`*^9}, 
   3.8483282085321445`*^9, {3.8483283139501143`*^9, 3.8483283150571275`*^9}, {
   3.8483283569504557`*^9, 3.8483283716291575`*^9}, {3.8483284384393573`*^9, 
   3.848328438719716*^9}, {3.848328500897355*^9, 3.84832850747604*^9}, {
   3.8483285492880583`*^9, 3.848328552934374*^9}, {3.84832859876681*^9, 
   3.848328655044897*^9}, {3.848328709539692*^9, 3.8483287180336795`*^9}, {
   3.8483288509286017`*^9, 3.8483289073185606`*^9}, {3.848328953335873*^9, 
   3.8483289892497272`*^9}, {3.848329033083598*^9, 3.848329035750063*^9}, {
   3.8483290862140265`*^9, 3.8483290887845416`*^9}, {3.8483291426364117`*^9, 
   3.8483291638482647`*^9}, 3.8483291986226144`*^9, {3.848329229308565*^9, 
   3.8483292863744707`*^9}, 3.8483293325305815`*^9, {3.8483293689331336`*^9, 
   3.8483293732451286`*^9}, {3.8483294248780036`*^9, 3.848329425352457*^9}, {
   3.848329488417652*^9, 3.8483294890032377`*^9}, {3.848329530852127*^9, 
   3.848329610585925*^9}, 3.8483296598419275`*^9, {3.848329786705555*^9, 
   3.8483298019235415`*^9}, {3.8483298426981153`*^9, 3.848329871265401*^9}, {
   3.8483302245085173`*^9, 3.8483302499459696`*^9}, {3.848330310426591*^9, 
   3.8483303480193377`*^9}, {3.8483304116215625`*^9, 3.84833041241956*^9}, {
   3.8483304515226517`*^9, 3.848330480774692*^9}, {3.848337003327963*^9, 
   3.848337019452553*^9}, {3.8483371089336452`*^9, 3.8483371252421923`*^9}, {
   3.8483388681282845`*^9, 3.8483388848943963`*^9}, 3.8483389399356165`*^9, {
   3.848339392731176*^9, 3.8483394298923435`*^9}, {3.8483394804954576`*^9, 
   3.8483394811367044`*^9}, {3.848339549430208*^9, 3.8483395563834224`*^9}, {
   3.8483400302850485`*^9, 3.848340036183568*^9}, {3.848474036531733*^9, 
   3.8484740924139028`*^9}, {3.848476482459578*^9, 3.848476484713914*^9}, {
   3.8484765243064694`*^9, 3.848476550654108*^9}, {3.8484765992827234`*^9, 
   3.8484766075198703`*^9}, {3.8484863514498124`*^9, 3.8484863787280884`*^9}, 
   3.8484864220057225`*^9, {3.8484864540592813`*^9, 3.848486509900319*^9}, {
   3.848486559426716*^9, 3.8484865691523333`*^9}, 3.8484866055102797`*^9, {
   3.848486668737956*^9, 3.8484867000177526`*^9}, {3.848487467330676*^9, 
   3.84848749385662*^9}, {3.848487571989177*^9, 3.848487577532448*^9}, {
   3.848487657163397*^9, 3.8484876605094337`*^9}, {3.848487690943945*^9, 
   3.8484876993675156`*^9}, {3.848487930287774*^9, 3.848488045972069*^9}, {
   3.848489839043494*^9, 3.84848994431314*^9}, {3.848489978553337*^9, 
   3.848490020562164*^9}, {3.8484900506943645`*^9, 3.848490050907216*^9}, {
   3.848490148564951*^9, 3.848490171610921*^9}, {3.8484906770477333`*^9, 
   3.8484907207140293`*^9}, {3.8484907621341906`*^9, 3.848490784014199*^9}, {
   3.8484908751102886`*^9, 3.8484909407525845`*^9}, {3.848490970793152*^9, 
   3.8484910431140466`*^9}, {3.848492555544419*^9, 3.848492630434865*^9}, {
   3.8488142713658824`*^9, 3.848814272048498*^9}, {3.8488144234860053`*^9, 
   3.848814427796878*^9}, {3.848814471860606*^9, 3.8488145476753883`*^9}, {
   3.8488145920450096`*^9, 3.848814601619645*^9}, {3.8488147360334196`*^9, 
   3.8488147792400484`*^9}, {3.8488149410822425`*^9, 3.848814945477758*^9}, 
   3.8488151852413197`*^9, {3.8488152636403832`*^9, 3.8488153392720766`*^9}, {
   3.848815404827515*^9, 3.848815456725973*^9}, {3.848815511823121*^9, 
   3.8488156281320734`*^9}, {3.8488157388533387`*^9, 3.848815753571541*^9}, {
   3.848815787317117*^9, 3.8488158194334655`*^9}, {3.848827172662015*^9, 
   3.8488272086816683`*^9}, {3.84882724684731*^9, 3.8488272990217123`*^9}, {
   3.848827356415456*^9, 3.848827385429083*^9}, 3.848827492289002*^9, {
   3.8488276528087482`*^9, 3.8488277224866548`*^9}, 3.848828058773244*^9, {
   3.8488280925485415`*^9, 3.8488281328605695`*^9}, {3.848828203286748*^9, 
   3.8488282119416304`*^9}, {3.8488282898840437`*^9, 
   3.8488283044708986`*^9}, {3.848828342856423*^9, 3.848828384156522*^9}, {
   3.848828432343317*^9, 3.8488284351551127`*^9}, {3.8488284838185625`*^9, 
   3.848828513671213*^9}, {3.848828546415145*^9, 3.8488285531062803`*^9}, {
   3.848828636156002*^9, 3.8488286385826545`*^9}, {3.8488287286877594`*^9, 
   3.8488287619847116`*^9}, {3.8488288030094247`*^9, 
   3.8488288033827333`*^9}, {3.848830382034147*^9, 3.8488303917095814`*^9}, {
   3.848830802948531*^9, 3.8488308104808817`*^9}, {3.848830951090414*^9, 
   3.848830953744997*^9}, {3.8488397628908596`*^9, 3.848839775839322*^9}, {
   3.8488398157972336`*^9, 3.8488398161337185`*^9}, {3.848839852779092*^9, 
   3.848839877915741*^9}, {3.8488399321334066`*^9, 3.8488399402557273`*^9}, {
   3.848840011688241*^9, 3.8488400218632917`*^9}, {3.848840119108008*^9, 
   3.848840229149686*^9}, {3.848840264863616*^9, 3.8488403231900244`*^9}, {
   3.848840383530751*^9, 3.8488403920495434`*^9}, 3.8488405039573717`*^9, {
   3.848840551551078*^9, 3.8488405992477217`*^9}, {3.8488406476847377`*^9, 
   3.848840759056447*^9}, {3.848840812971117*^9, 3.848840813931553*^9}, {
   3.848840938598999*^9, 3.8488409451108713`*^9}, {3.8488411205888767`*^9, 
   3.8488411399736395`*^9}, {3.8488479030350122`*^9, 3.848847914893098*^9}, {
   3.8488479654122744`*^9, 3.848848093695451*^9}, {3.8488481572952876`*^9, 
   3.848848187691225*^9}, {3.848848230542222*^9, 3.848848275062008*^9}, 
   3.8488483150852427`*^9, {3.848848499266724*^9, 3.8488486213176928`*^9}, {
   3.848848679824917*^9, 3.8488487046346807`*^9}, {3.8488487393941708`*^9, 
   3.848848755636638*^9}, 3.848848802965518*^9, 3.8488488344607286`*^9, {
   3.8488488779438324`*^9, 3.8488488816989756`*^9}, {3.8488490346723576`*^9, 
   3.8488490527368755`*^9}, {3.8488491697076187`*^9, 3.848849191965683*^9}, {
   3.848849286154056*^9, 3.848849339629618*^9}, {3.8488493864582415`*^9, 
   3.848849404632621*^9}, {3.848849436579245*^9, 3.8488494488520255`*^9}, {
   3.848849480960241*^9, 3.8488494904118404`*^9}, {3.8488495554097958`*^9, 
   3.8488496684406905`*^9}, {3.848850018006305*^9, 3.8488500229637136`*^9}, {
   3.848850070264492*^9, 3.8488501082422724`*^9}, 3.8488501431021647`*^9, {
   3.8488501952605853`*^9, 3.848850206457876*^9}, {3.8488505578141704`*^9, 
   3.848850581630031*^9}, {3.848850620808145*^9, 3.8488506710866675`*^9}, {
   3.848850727505411*^9, 3.848850770300502*^9}, {3.848850803838212*^9, 
   3.8488508193839893`*^9}, 3.848851967234456*^9, {3.8488524210786057`*^9, 
   3.8488524536622953`*^9}, {3.8488524884432745`*^9, 
   3.8488525769570036`*^9}, {3.848852611677209*^9, 3.848852658016685*^9}, {
   3.8488537178100257`*^9, 3.8488537830937877`*^9}, {3.8488538739035187`*^9, 
   3.8488539538800306`*^9}, {3.8488543625482492`*^9, 3.848854432362477*^9}, {
   3.848854473618061*^9, 3.8488545000130725`*^9}, {3.8488546482068634`*^9, 
   3.848854665700192*^9}, {3.8488547157636423`*^9, 3.8488548074334893`*^9}, {
   3.8488548625257163`*^9, 3.8488549031233826`*^9}, {3.8488549426127853`*^9, 
   3.848854949763935*^9}, {3.848856930062063*^9, 3.848856935052995*^9}, {
   3.8488569717825775`*^9, 3.848856972042163*^9}, {3.8488570195699444`*^9, 
   3.848857054542126*^9}, {3.8488572931902885`*^9, 3.848857318966341*^9}, {
   3.848901009308069*^9, 3.848901142273347*^9}, {3.848901331490687*^9, 
   3.8489013317478456`*^9}, {3.8489014390607395`*^9, 
   3.8489014557270036`*^9}, {3.8489015379703226`*^9, 
   3.8489016617130156`*^9}, {3.8489028264877553`*^9, 
   3.8489028445605774`*^9}, {3.8489031401986856`*^9, 
   3.8489032643584266`*^9}, {3.8489033366436896`*^9, 
   3.8489034035462294`*^9}, {3.8489034794958787`*^9, 3.8489035327777042`*^9}, 
   3.8489035908167796`*^9, {3.848903665488962*^9, 3.848903796035419*^9}, {
   3.8489038549763575`*^9, 3.8489038608789597`*^9}, {3.848903890929725*^9, 
   3.8489039917872343`*^9}, {3.8489040851151133`*^9, 
   3.8489041111354346`*^9}, {3.8489041898726425`*^9, 3.848904242426923*^9}, {
   3.8489042765376525`*^9, 3.8489043577679796`*^9}, {3.848904402920041*^9, 
   3.8489044078970385`*^9}, {3.8489058133129992`*^9, 3.848905868982856*^9}, {
   3.8489059034611387`*^9, 3.8489059376792326`*^9}, {3.848906008912464*^9, 
   3.848906030048065*^9}, 3.8489061109252434`*^9, {3.8489061421223316`*^9, 
   3.8489061448414335`*^9}, {3.8489061809877853`*^9, 
   3.8489061834916763`*^9}, {3.8489062245246935`*^9, 3.848906228898402*^9}, {
   3.848906268508518*^9, 3.848906285595052*^9}, {3.848906326370392*^9, 
   3.8489063308855953`*^9}, {3.848906380507181*^9, 3.848906380845016*^9}, {
   3.8489064331250916`*^9, 3.848906436597402*^9}, {3.8489064728465033`*^9, 
   3.8489064838341627`*^9}, {3.8489065180976076`*^9, 3.848906538458138*^9}, {
   3.84890660883316*^9, 3.848906669823145*^9}, 3.8489067121560397`*^9, {
   3.84890679723598*^9, 3.848906849832997*^9}, {3.8489071482100425`*^9, 
   3.8489072175982904`*^9}, {3.848907260682404*^9, 3.848907293750167*^9}, {
   3.8489073410195775`*^9, 3.8489073946298447`*^9}, {3.848907452240204*^9, 
   3.8489074656048765`*^9}, {3.8489075175376606`*^9, 
   3.8489075219947424`*^9}, {3.8489075561042986`*^9, 3.848907560234953*^9}, {
   3.8489076581975965`*^9, 3.848907665754428*^9}, {3.8489077485024533`*^9, 
   3.848907758367206*^9}, {3.848907855205586*^9, 3.8489078621804843`*^9}, 
   3.8489079553176575`*^9, {3.848908021298498*^9, 3.8489080428426943`*^9}, {
   3.848908367834581*^9, 3.8489083804926753`*^9}, {3.848908413706523*^9, 
   3.84890841383881*^9}, {3.8489085587111154`*^9, 3.8489086359370127`*^9}, {
   3.848908686578658*^9, 3.8489087251944695`*^9}, {3.8489087877971296`*^9, 
   3.8489088043219633`*^9}, {3.848908873198659*^9, 3.8489088757622223`*^9}, {
   3.8489089371086173`*^9, 3.8489089442706375`*^9}, {3.848908980497106*^9, 
   3.8489090095609818`*^9}, 3.8489090459172554`*^9, {3.8489090881933775`*^9, 
   3.848909096760427*^9}, {3.84890913326644*^9, 3.8489091636795297`*^9}, 
   3.8489092542908897`*^9, {3.8489093222608223`*^9, 3.848909373074642*^9}, {
   3.8489094139387274`*^9, 3.8489094830563164`*^9}, {3.848909944489108*^9, 
   3.8489099597073956`*^9}, {3.8489099997460856`*^9, 3.8489100591193542`*^9}, 
   3.848910263374172*^9, {3.8489103496791334`*^9, 3.8489103499922533`*^9}, 
   3.8489104491032457`*^9, {3.848910529599459*^9, 3.8489105439842415`*^9}, {
   3.8489105772232003`*^9, 3.8489106443435926`*^9}, {3.848910680697529*^9, 
   3.848910708397292*^9}, {3.848910745975148*^9, 3.8489107705274963`*^9}, {
   3.848910820713842*^9, 3.8489108268781805`*^9}, {3.848910876161916*^9, 
   3.8489110165889463`*^9}, {3.848911119989789*^9, 3.848911120442112*^9}, {
   3.8489111508227324`*^9, 3.8489112060104303`*^9}, {3.8489112436350384`*^9, 
   3.848911333357443*^9}, {3.8489124745404797`*^9, 3.8489125148240767`*^9}, {
   3.8489125481502295`*^9, 3.8489126008029957`*^9}, {3.848912796275871*^9, 
   3.8489128079364347`*^9}, {3.8489128722122*^9, 3.8489128748323154`*^9}, {
   3.848912920636716*^9, 3.8489129221150413`*^9}, {3.848912969257455*^9, 
   3.848912981601875*^9}, 3.8489130120936995`*^9, 3.848913175059579*^9, 
   3.8489132383289623`*^9, {3.848913274374623*^9, 3.848913278383238*^9}, {
   3.848913315815654*^9, 3.8489133464520054`*^9}, {3.848913389329391*^9, 
   3.8489134083869677`*^9}, {3.848913457006069*^9, 3.848913475618537*^9}, {
   3.8489135191986074`*^9, 3.848913545688697*^9}, {3.848913590522838*^9, 
   3.848913631241064*^9}, {3.8489136709074*^9, 3.848913712975113*^9}, {
   3.848913743924128*^9, 3.848913748643517*^9}, {3.848913797171541*^9, 
   3.84891381647547*^9}, {3.84891384681927*^9, 3.848914031814376*^9}, {
   3.848914072926709*^9, 3.8489141096908154`*^9}, 3.8489141423397055`*^9, {
   3.8489141853262205`*^9, 3.8489143138910923`*^9}, {3.848914401837454*^9, 
   3.848914453866949*^9}, {3.8489144846357923`*^9, 3.8489145030357494`*^9}, {
   3.848914632217679*^9, 3.848914702753607*^9}, {3.848915450705512*^9, 
   3.8489154839255896`*^9}, 3.8489155413555326`*^9, 3.8489156006016817`*^9, 
   3.848915726994594*^9, {3.8489158171820602`*^9, 3.8489158279021254`*^9}, 
   3.848915888013923*^9, {3.8489159570331426`*^9, 3.8489159734294357`*^9}, {
   3.8489160143801003`*^9, 3.848916031979935*^9}, {3.8489160865667715`*^9, 
   3.848916132164173*^9}, {3.848916245244833*^9, 3.8489162749030747`*^9}, {
   3.8489164333271837`*^9, 3.8489164432804413`*^9}, 3.8489166978263516`*^9, {
   3.8489168842105317`*^9, 3.8489168930807753`*^9}, {3.848916958655188*^9, 
   3.848916960465525*^9}, {3.848917670754263*^9, 3.848917687020523*^9}, {
   3.848917751756464*^9, 3.8489177594681864`*^9}, {3.8489177908083467`*^9, 
   3.8489177910137367`*^9}, {3.8489178770946207`*^9, 
   3.8489179462571516`*^9}, {3.848918183270671*^9, 3.8489181859514027`*^9}, {
   3.848918278268078*^9, 3.8489182878832865`*^9}, {3.8489183296989565`*^9, 
   3.848918332787624*^9}, {3.848920556343182*^9, 3.848920567468388*^9}, {
   3.848922252533842*^9, 3.8489222613764863`*^9}, {3.8489254195647006`*^9, 
   3.8489254201326714`*^9}, 3.8489256681505413`*^9, {3.848925720631141*^9, 
   3.8489257240066805`*^9}, {3.848925756071916*^9, 3.848925760833295*^9}, {
   3.8489257953751907`*^9, 3.8489258057217827`*^9}, 3.848925865781641*^9, {
   3.8489261007908993`*^9, 3.848926168277937*^9}, {3.84892654580978*^9, 
   3.8489266368810396`*^9}, {3.848926686907522*^9, 3.8489267411213856`*^9}, {
   3.848926772994913*^9, 3.84892677899006*^9}, {3.8489268092688303`*^9, 
   3.848926817575962*^9}, {3.848926852881112*^9, 3.8489269261927013`*^9}, {
   3.848926973593492*^9, 3.8489269841365805`*^9}, {3.848927282990345*^9, 
   3.8489272894139066`*^9}, {3.8489301839319963`*^9, 3.848930189429911*^9}, {
   3.8489302696469784`*^9, 3.8489303149548683`*^9}, 3.848930370494291*^9, {
   3.8489310234662914`*^9, 3.8489310277936063`*^9}, {3.8489312702702775`*^9, 
   3.848931297565383*^9}, {3.848931383449619*^9, 3.848931402980327*^9}, {
   3.8489314444837055`*^9, 3.8489314680310836`*^9}, {3.848931545314633*^9, 
   3.848931627853956*^9}, {3.8489355034943237`*^9, 3.8489355111309395`*^9}, 
   3.8489356386279607`*^9, {3.8489411932534018`*^9, 3.848941290246137*^9}, {
   3.8489413717801576`*^9, 3.848941391029398*^9}, {3.848941454942054*^9, 
   3.8489415022373037`*^9}, {3.84894158585985*^9, 3.8489415991690335`*^9}, {
   3.8489416447692375`*^9, 3.8489416898986287`*^9}, {3.848941723466543*^9, 
   3.8489417459888983`*^9}, {3.848946844453006*^9, 3.8489468592531743`*^9}, 
   3.848946912851969*^9, {3.848946944040741*^9, 3.848946944505613*^9}, {
   3.848957831006092*^9, 3.848957843031386*^9}, 3.848957910475198*^9, {
   3.8489892931306834`*^9, 3.8489892980629168`*^9}, {3.848989518566285*^9, 
   3.8489895209530673`*^9}, 3.8489895659572687`*^9, {3.8490301235691175`*^9, 
   3.849030136792436*^9}, {3.849030167833536*^9, 3.849030174800626*^9}, {
   3.849030267077447*^9, 3.849030267396347*^9}, {3.8490304353115377`*^9, 
   3.849030480907096*^9}, {3.8490305403972845`*^9, 3.849030543424717*^9}, {
   3.8490306508306093`*^9, 3.8490306800275106`*^9}, {3.8490308612931623`*^9, 
   3.8490308619225883`*^9}, {3.8490308968682423`*^9, 3.849030920969692*^9}, {
   3.8490309538199644`*^9, 3.8490309820785074`*^9}, {3.8490310156175604`*^9, 
   3.8490310213407326`*^9}, {3.8496764373151474`*^9, 3.849676561165482*^9}, {
   3.8496766244051137`*^9, 3.8496767581764584`*^9}, {3.84967686480434*^9, 
   3.849676866376013*^9}, {3.849676926772871*^9, 3.849676930914501*^9}, {
   3.849677056065419*^9, 3.8496771191261725`*^9}, {3.84967731631702*^9, 
   3.849677392798496*^9}, {3.849677505258733*^9, 3.8496775330038223`*^9}, {
   3.8496775765557785`*^9, 3.849677759517486*^9}, {3.8496797650179443`*^9, 
   3.8496797854392633`*^9}, {3.8496801364680157`*^9, 3.849680143172207*^9}, {
   3.849680220893072*^9, 3.849680267486101*^9}, {3.849680415590899*^9, 
   3.8496804220309954`*^9}, {3.8496804797303457`*^9, 3.849680591151844*^9}, {
   3.8496806508462687`*^9, 3.8496806610146937`*^9}, {3.8496806959444447`*^9, 
   3.8496807288215275`*^9}, {3.849680761833004*^9, 3.8496807847077365`*^9}, {
   3.8496809155217323`*^9, 3.8496809316942964`*^9}, {3.8496809656628904`*^9, 
   3.8496809735834365`*^9}, {3.849681012381901*^9, 3.8496810239764166`*^9}, {
   3.8496810757579794`*^9, 3.8496810864967937`*^9}, {3.8496811204864583`*^9, 
   3.8496811206597013`*^9}, {3.8496811638784065`*^9, 
   3.8496811658806067`*^9}, {3.849681209041199*^9, 3.8496812170022063`*^9}, {
   3.8496812509561396`*^9, 3.849681261747094*^9}, {3.8496812956354227`*^9, 
   3.849681333607966*^9}, {3.8496813862163367`*^9, 3.8496814080205812`*^9}, {
   3.8496814644904*^9, 3.8496815038972206`*^9}, {3.849681570784769*^9, 
   3.8496816269858823`*^9}, {3.8496816675050697`*^9, 3.8496816696204405`*^9}, 
   3.8496867589308343`*^9, {3.849686850364151*^9, 3.8496868846645975`*^9}, {
   3.8496869369631615`*^9, 3.849686974443706*^9}, {3.8496872823910666`*^9, 
   3.8496872875741124`*^9}, {3.849687549956668*^9, 3.849687568027878*^9}, {
   3.84968772719757*^9, 3.84968773584862*^9}, 3.8496878096044006`*^9, {
   3.849687854248826*^9, 3.8496879077391877`*^9}, {3.8496879858856*^9, 
   3.8496880272474723`*^9}, {3.8496883548800535`*^9, 3.849688368305721*^9}, {
   3.849688675628378*^9, 3.849688683021755*^9}, {3.849691585698665*^9, 
   3.8496915946372585`*^9}, {3.84969167245205*^9, 3.8496916762170863`*^9}, {
   3.849691732394679*^9, 3.8496918213598237`*^9}, {3.849691861113226*^9, 
   3.849691863726529*^9}, {3.8496921445641584`*^9, 3.849692186256037*^9}, {
   3.8496923745821705`*^9, 3.849692427312993*^9}, {3.849692477507874*^9, 
   3.849692490148341*^9}, {3.849692521088513*^9, 3.8496925688314466`*^9}, {
   3.84969260618332*^9, 3.8496926227093925`*^9}, {3.8496926624505806`*^9, 
   3.849692704326677*^9}, 3.849692744268014*^9, {3.849761436384231*^9, 
   3.8497614510209475`*^9}, {3.8497615482531996`*^9, 3.849761549650751*^9}, {
   3.8497616767065134`*^9, 3.849761684433888*^9}, {3.849761724794228*^9, 
   3.849761735849598*^9}, {3.8497617732303333`*^9, 3.849761783042904*^9}, {
   3.849761834711321*^9, 3.8497619816095967`*^9}, {3.8497620706875296`*^9, 
   3.849762100192486*^9}, {3.8497621829545326`*^9, 3.849762196902032*^9}, {
   3.849762230683427*^9, 3.8497622539750304`*^9}, {3.8497623084020205`*^9, 
   3.849762317919467*^9}, {3.8497624410345488`*^9, 3.8497624422520046`*^9}, {
   3.849762534191582*^9, 3.849762615964599*^9}, {3.8497626514525146`*^9, 
   3.849762657385311*^9}, {3.8497627434204473`*^9, 3.849762810081519*^9}, {
   3.8497628487744365`*^9, 3.8497628622852564`*^9}, {3.8497629019861326`*^9, 
   3.849762906918946*^9}, {3.849762977712636*^9, 3.849762990958295*^9}, {
   3.8497636733095894`*^9, 3.849763738608299*^9}, {3.849763792222435*^9, 
   3.8497638607005286`*^9}, {3.8497638985196943`*^9, 
   3.8497639000234776`*^9}, {3.849763993559433*^9, 3.849763995026165*^9}, {
   3.8497642087244377`*^9, 3.8497642203307543`*^9}, {3.8497642605259495`*^9, 
   3.8497642787385893`*^9}, {3.8497643375447865`*^9, 
   3.8497644026114798`*^9}, {3.849764435974805*^9, 3.8497644672758646`*^9}, {
   3.849764544691249*^9, 3.8497645641704493`*^9}, {3.849764648845251*^9, 
   3.8497646732986655`*^9}, {3.8497647196335125`*^9, 
   3.8497647224972267`*^9}, {3.8497648198994274`*^9, 
   3.8497649007827435`*^9}, {3.8497650103378377`*^9, 
   3.8497650387308087`*^9}, {3.8497686512258763`*^9, 3.849768656609145*^9}, {
   3.8497705296471663`*^9, 3.8497705831266327`*^9}, {3.8497706402843065`*^9, 
   3.849770648567564*^9}, {3.8497706993985796`*^9, 3.8497707315772047`*^9}, 
   3.849770775945176*^9, {3.849770835131421*^9, 3.849770839079353*^9}, {
   3.8497709787543736`*^9, 3.849771055137104*^9}, {3.8497710932737603`*^9, 
   3.8497711063176856`*^9}, 3.8497712783093777`*^9, {3.8497713620125084`*^9, 
   3.8497714439759226`*^9}, {3.8497715070237603`*^9, 3.849771519042424*^9}, {
   3.8497715571666827`*^9, 3.849771578636737*^9}, 3.849771643753462*^9, {
   3.849771677163535*^9, 3.8497717029546447`*^9}, 3.8497718138199587`*^9, {
   3.849771850778716*^9, 3.849771855341331*^9}, {3.8497718965576487`*^9, 
   3.8497719803509097`*^9}, {3.849772459074053*^9, 3.8497725383413577`*^9}, {
   3.8497725709183645`*^9, 3.849772594260913*^9}, {3.8497726281962566`*^9, 
   3.8497726432848806`*^9}, {3.849772677294363*^9, 3.849772704940559*^9}, {
   3.8497727385221643`*^9, 3.8497727602677555`*^9}, {3.849772833946726*^9, 
   3.849772850631151*^9}, {3.849772906710285*^9, 3.8497729272814*^9}, {
   3.8497729804950066`*^9, 3.8497730068859777`*^9}, 3.849773077062065*^9, {
   3.849773145579509*^9, 3.8497731533662195`*^9}, {3.8497732236507516`*^9, 
   3.849773245380493*^9}, {3.849773361766876*^9, 3.8497734090432262`*^9}, {
   3.8497734870611224`*^9, 3.8497735220616612`*^9}, {3.849773704850134*^9, 
   3.849773832076127*^9}, {3.8497740385545015`*^9, 3.849774045175739*^9}, 
   3.849775276440895*^9, {3.849775880851593*^9, 3.849775929061994*^9}, 
   3.8497772060706563`*^9, {3.8497780018872776`*^9, 3.8497780266571445`*^9}, {
   3.8497780669343643`*^9, 3.849778104084404*^9}, {3.8497782248740253`*^9, 
   3.8497782381365995`*^9}, {3.849780299039507*^9, 3.8497803164319963`*^9}, {
   3.8497806183741302`*^9, 3.8497807180343146`*^9}, {3.8497817262702713`*^9, 
   3.849781732090615*^9}, {3.8497819419115353`*^9, 3.8497819631882935`*^9}, {
   3.849784811051957*^9, 3.8497848165781546`*^9}, {3.8497848518068*^9, 
   3.849784871729497*^9}, {3.849785988208962*^9, 3.849785999953029*^9}, {
   3.849786032267099*^9, 3.849786094863212*^9}, {3.849786489203232*^9, 
   3.8497865531651*^9}, {3.8498486254339285`*^9, 3.849848638294402*^9}, {
   3.84984876181512*^9, 3.8498487768425713`*^9}, {3.8498488222678165`*^9, 
   3.8498488432123466`*^9}, {3.849849003779914*^9, 3.8498490391448097`*^9}, {
   3.8498490772009788`*^9, 3.8498491167044477`*^9}, {3.84984917785332*^9, 
   3.8498492095217347`*^9}, {3.849849302783803*^9, 3.8498493296621323`*^9}, {
   3.849849398266094*^9, 3.849849406260415*^9}, {3.8498494878008747`*^9, 
   3.8498494946544905`*^9}, {3.849849572711581*^9, 3.8498495902857533`*^9}, {
   3.849849668634513*^9, 3.849849673684351*^9}, {3.849849716120864*^9, 
   3.8498497607776384`*^9}, {3.8498498174132605`*^9, 
   3.8498498991015606`*^9}, {3.8498499537194605`*^9, 
   3.8498499704996815`*^9}, {3.849850285232168*^9, 3.8498503059242387`*^9}, {
   3.849850371964187*^9, 3.8498503922082787`*^9}, {3.8498505594207506`*^9, 
   3.8498505985906386`*^9}, {3.849850654896624*^9, 3.8498506774093704`*^9}, {
   3.849850774390463*^9, 3.8498507823505836`*^9}, {3.849851178983018*^9, 
   3.849851182311552*^9}, {3.84985125519203*^9, 3.8498512569249687`*^9}, {
   3.8498514789048767`*^9, 3.8498515488762264`*^9}, {3.849851644181012*^9, 
   3.849851685544956*^9}, {3.8498517272310796`*^9, 3.84985172954465*^9}, {
   3.849851783224674*^9, 3.849851785871725*^9}, {3.849851833880516*^9, 
   3.849851856114583*^9}, {3.849851898604149*^9, 3.849851911077338*^9}, {
   3.849855778124922*^9, 3.849855780338552*^9}, {3.849856527709165*^9, 
   3.849856529158924*^9}, {3.849856585969305*^9, 3.8498565928783207`*^9}, {
   3.849856685440506*^9, 3.8498567016090918`*^9}, {3.8498567800102096`*^9, 
   3.8498567855030684`*^9}, {3.8498568582013273`*^9, 
   3.8498568669229083`*^9}, {3.8498601810876017`*^9, 3.849860265885556*^9}, {
   3.8498603329142485`*^9, 3.849860403900851*^9}, {3.849860534866346*^9, 
   3.8498605570579925`*^9}, {3.849860719357281*^9, 3.8498608024083233`*^9}, {
   3.8498609982407675`*^9, 3.8498610152063227`*^9}, {3.8498610554532633`*^9, 
   3.849861058692237*^9}, 3.8498610893277397`*^9, {3.8498722013123326`*^9, 
   3.849872287360138*^9}, {3.8498724817780027`*^9, 3.84987250578995*^9}, {
   3.8498725623201866`*^9, 3.8498726105601945`*^9}, {3.849872655784936*^9, 
   3.8498726827136946`*^9}, {3.849872840885666*^9, 3.8498728874772167`*^9}, {
   3.849872993885679*^9, 3.8498730513007545`*^9}, {3.8498731363268976`*^9, 
   3.8498731890410147`*^9}, {3.849873222835144*^9, 3.8498732279679623`*^9}, {
   3.8498732752491727`*^9, 3.8498732955179143`*^9}, {3.849873340252467*^9, 
   3.849873351285946*^9}, {3.849873389385026*^9, 3.849873426069163*^9}, {
   3.849873684946648*^9, 3.849873700956641*^9}, {3.84987375105182*^9, 
   3.8498737609572897`*^9}, {3.8498738301527925`*^9, 3.849873831382205*^9}, {
   3.8498738748720284`*^9, 3.8498738896754694`*^9}, {3.8498740285570765`*^9, 
   3.8498740308918753`*^9}, {3.8498816584780774`*^9, 3.84988165917457*^9}, {
   3.8498816986033697`*^9, 3.849882045532957*^9}, {3.849882101713972*^9, 
   3.8498821029571447`*^9}, {3.849882165624076*^9, 3.8498821855067973`*^9}, 
   3.8498822624484973`*^9, {3.8498823076153564`*^9, 3.8498823096022005`*^9}, {
   3.849882362271558*^9, 3.849882383305481*^9}, {3.8498824462729673`*^9, 
   3.849882467912717*^9}, {3.8498825223620434`*^9, 3.8498825413797045`*^9}, {
   3.849882588639922*^9, 3.8498826317725797`*^9}, {3.849882665453353*^9, 
   3.8498826749999456`*^9}, {3.8498827404134226`*^9, 
   3.8498827474916277`*^9}, {3.8498857085722103`*^9, 
   3.8498857347357883`*^9}, {3.8498857730625997`*^9, 
   3.8498858206807284`*^9}, {3.8498858554871817`*^9, 3.8498858567625093`*^9}, 
   3.849885889181526*^9, {3.8498859307421346`*^9, 3.849885964847548*^9}, {
   3.8498860226218386`*^9, 3.849886067262042*^9}, {3.8498861381479588`*^9, 
   3.8498861401734624`*^9}, {3.8498863636860175`*^9, 
   3.8498863638831663`*^9}, {3.8498866502841616`*^9, 3.8498866518212795`*^9}, 
   3.8498868115814075`*^9, {3.849886891998204*^9, 3.849886892140479*^9}, {
   3.8498869255998945`*^9, 3.8498869737250504`*^9}, {3.849887014821803*^9, 
   3.8498870379094324`*^9}, {3.849887397026386*^9, 3.8498874055620966`*^9}, {
   3.849887448511347*^9, 3.849887536460473*^9}, {3.8498876542761965`*^9, 
   3.849887669548505*^9}, {3.849887741142972*^9, 3.8498878276236677`*^9}, {
   3.849887858132958*^9, 3.8498878630929613`*^9}, {3.8498879307955427`*^9, 
   3.8498879392897167`*^9}, {3.8498879862489595`*^9, 3.8498880294427433`*^9}, 
   3.8498880635704374`*^9, {3.8498881408218217`*^9, 3.8498881699356833`*^9}, {
   3.8498882395837493`*^9, 3.849888252331875*^9}, {3.8498882913405437`*^9, 
   3.849888317238868*^9}, 3.849888371822074*^9, 3.849888404542158*^9, 
   3.849888438862295*^9, 3.849888469853876*^9, 3.8498885017241974`*^9, 
   3.8498885445422087`*^9, {3.849888577338464*^9, 3.849888609173721*^9}, {
   3.8498886619285603`*^9, 3.849888662412866*^9}, {3.849888802996334*^9, 
   3.849888812911166*^9}, {3.849888853267866*^9, 3.8498888871166296`*^9}, {
   3.8499406747636347`*^9, 3.849940676975012*^9}, {3.8499407228528423`*^9, 
   3.8499407261273546`*^9}, {3.8499408229643946`*^9, 3.8499408350111504`*^9}, 
   3.849940885271174*^9, {3.8499409221051087`*^9, 3.849941046839429*^9}, {
   3.8499411047146173`*^9, 3.8499411049597673`*^9}, {3.8499411686115527`*^9, 
   3.849941197257782*^9}, {3.8499412409732723`*^9, 3.849941245687851*^9}, 
   3.8499412886722903`*^9, {3.849941341922741*^9, 3.849941390919405*^9}, {
   3.8499414503810797`*^9, 3.849941527946871*^9}, {3.8499415620548697`*^9, 
   3.8499416252343025`*^9}, {3.849941657897417*^9, 3.849941672344417*^9}, {
   3.849941726337247*^9, 3.84994172977432*^9}, {3.849941760593748*^9, 
   3.8499419014374685`*^9}, 3.8499419758806286`*^9, {3.849942007779984*^9, 
   3.84994204597711*^9}, {3.8499420996652913`*^9, 3.8499421415791464`*^9}, {
   3.8499421764781876`*^9, 3.849942177684765*^9}, {3.8499422291363063`*^9, 
   3.8499422578880143`*^9}, {3.8499422960387383`*^9, 
   3.8499423166296163`*^9}, {3.8499432116168766`*^9, 3.849943221554842*^9}, {
   3.849943253947466*^9, 3.8499432592202654`*^9}, {3.84994330875401*^9, 
   3.8499433219110737`*^9}, {3.849943372524208*^9, 3.849943400548864*^9}, {
   3.849943464992627*^9, 3.8499434822421923`*^9}, {3.8499435283166027`*^9, 
   3.849943605835907*^9}, {3.8499436913195252`*^9, 3.849943712255533*^9}, {
   3.849943816993574*^9, 3.849943819249677*^9}, {3.849946616417919*^9, 
   3.849946633940449*^9}, {3.84994673261504*^9, 3.8499468128298316`*^9}, {
   3.8499468637008133`*^9, 3.849946870153615*^9}, 3.849946910608184*^9, {
   3.849946972674326*^9, 3.849946976444454*^9}, 3.8499470087915163`*^9, {
   3.8499470645844774`*^9, 3.849947064824081*^9}, {3.849947112838972*^9, 
   3.8499471316266155`*^9}, {3.8499471661365204`*^9, 
   3.8499471677351274`*^9}, {3.849947199634508*^9, 3.84994720671789*^9}, {
   3.8499472503535786`*^9, 3.849947254233336*^9}, {3.8499473018160863`*^9, 
   3.8499473138664637`*^9}, {3.8499478882836432`*^9, 3.8499479244281416`*^9}, 
   3.8499479638032837`*^9, {3.84994806048497*^9, 3.849948073346675*^9}, {
   3.849951193322137*^9, 3.849951198942337*^9}, {3.849951257998618*^9, 
   3.8499512935580025`*^9}, {3.8499513488005347`*^9, 3.849951349655318*^9}, {
   3.8499517233413134`*^9, 3.8499517236864257`*^9}, {3.849951769662041*^9, 
   3.849951769860054*^9}, {3.849954108408109*^9, 3.8499542890748067`*^9}, {
   3.8499545120219507`*^9, 3.849954512199135*^9}, {3.8499545458085117`*^9, 
   3.849954597949986*^9}, {3.8499546340455217`*^9, 3.849954634251952*^9}, {
   3.849954671534998*^9, 3.8499546721145267`*^9}, {3.8499547438638706`*^9, 
   3.849954762163437*^9}, {3.8499548096872053`*^9, 3.8499548185278807`*^9}, {
   3.849954933327391*^9, 3.8499549378141675`*^9}, {3.8499551449878035`*^9, 
   3.849955145512293*^9}, {3.849955196169095*^9, 3.849955289802188*^9}, {
   3.8499553299347773`*^9, 3.8499553433928757`*^9}, {3.8499556719187245`*^9, 
   3.849955675200858*^9}, 3.849957473434106*^9, 3.8499575334130583`*^9, {
   3.8499576190007763`*^9, 3.8499576698976574`*^9}, {3.8499577201508884`*^9, 
   3.84995773123707*^9}, {3.849957762521601*^9, 3.8499577626918993`*^9}, 
   3.8499579437076674`*^9, {3.8499583690184927`*^9, 3.8499583692256513`*^9}, {
   3.8501043107133636`*^9, 3.8501044172336597`*^9}, {3.8501045046649165`*^9, 
   3.8501045220201983`*^9}, {3.850104645044194*^9, 3.850104668225754*^9}, {
   3.850104700786703*^9, 3.8501047185010324`*^9}, 3.8501047627170897`*^9, {
   3.8501048464882402`*^9, 3.8501048803786535`*^9}, {3.8501049367913895`*^9, 
   3.8501049751074543`*^9}, {3.8501050407444077`*^9, 
   3.8501050696533904`*^9}, {3.850105109470391*^9, 3.8501051366511025`*^9}, {
   3.850105168335854*^9, 3.8501051981564703`*^9}, {3.8501053324273806`*^9, 
   3.8501053615397015`*^9}, {3.850105400401814*^9, 3.850105508978056*^9}, {
   3.850105539854487*^9, 3.8501055673703017`*^9}, {3.850107607736515*^9, 
   3.8501076284864197`*^9}, {3.8501078742500286`*^9, 3.850107879957934*^9}, {
   3.8501079120162697`*^9, 3.8501079364203053`*^9}, {3.85013159559346*^9, 
   3.8501316355603356`*^9}, {3.8501316672616477`*^9, 
   3.8501317703853917`*^9}, {3.8501318017540226`*^9, 
   3.8501323294825335`*^9}, {3.8501323664745655`*^9, 
   3.8501323924405446`*^9}, {3.8501324447350006`*^9, 3.850132466096014*^9}, {
   3.8501325056537237`*^9, 3.8501326551231823`*^9}, {3.8501327127345095`*^9, 
   3.8501328169985375`*^9}, {3.850132850179561*^9, 3.850132853512422*^9}, {
   3.8501328947513037`*^9, 3.850132900214654*^9}, {3.8501329546928988`*^9, 
   3.850133188774183*^9}, {3.850133236787222*^9, 3.8501332606078825`*^9}, {
   3.850133570374729*^9, 3.85013363009138*^9}, {3.850133667392167*^9, 
   3.850133759997203*^9}, {3.8501428089757566`*^9, 3.8501429359429827`*^9}, {
   3.8501429698824563`*^9, 3.8501429935927315`*^9}, {3.8501431614214897`*^9, 
   3.850143334986249*^9}, {3.850143435442969*^9, 3.8501434380852747`*^9}, 
   3.850143469772215*^9, {3.850639795338806*^9, 3.8506398587355113`*^9}, {
   3.850639994112317*^9, 3.8506400119514875`*^9}, 3.850640048612939*^9, {
   3.8506400955655975`*^9, 3.850640114264375*^9}, {3.8506401833433228`*^9, 
   3.8506401840465145`*^9}, {3.850640256926922*^9, 3.850640264417822*^9}, {
   3.850640333234104*^9, 3.850640431500765*^9}, {3.850640659144122*^9, 
   3.85064067655167*^9}, 3.8506425335844183`*^9, {3.850644652804536*^9, 
   3.8506447082858205`*^9}, {3.850644739724722*^9, 3.8506447556396184`*^9}, {
   3.850644852157618*^9, 3.8506449307486753`*^9}, {3.850645021559546*^9, 
   3.850645051810904*^9}, 3.8506451745929756`*^9, {3.8506454059851084`*^9, 
   3.850645472280143*^9}, {3.8506455227129555`*^9, 3.8506455382001405`*^9}, {
   3.850648697242369*^9, 3.850648990708414*^9}, 3.850649047277828*^9, {
   3.8506490939076376`*^9, 3.8506491330006275`*^9}, {3.850649210424656*^9, 
   3.8506492515210867`*^9}, 3.850649316089172*^9, {3.8506493510999327`*^9, 
   3.850649366652563*^9}, {3.8506519548128242`*^9, 3.850651965439147*^9}, {
   3.850652006326825*^9, 3.8506520109533606`*^9}, {3.8506560450232954`*^9, 
   3.8506561574367533`*^9}, {3.8506562188149137`*^9, 3.850656228365095*^9}, {
   3.850656267955429*^9, 3.8506562943062277`*^9}, {3.850660050363703*^9, 
   3.8506600793317685`*^9}, {3.8506601195736284`*^9, 
   3.8506601200204124`*^9}, {3.8506601703782654`*^9, 
   3.8506603117573557`*^9}, {3.850660345742996*^9, 3.8506603482037983`*^9}, {
   3.8506603860553207`*^9, 3.850660415859827*^9}, {3.850660458983363*^9, 
   3.8506604711348295`*^9}, {3.8506605140955873`*^9, 3.850660519753228*^9}, {
   3.8506605926251545`*^9, 3.8506605950924478`*^9}, {3.8506607955481653`*^9, 
   3.850661058847083*^9}, {3.850661096713722*^9, 3.8506611264587173`*^9}, {
   3.850661169518036*^9, 3.8506612683848143`*^9}, {3.850661320501401*^9, 
   3.850661355509112*^9}, {3.850664611753438*^9, 3.850664613515751*^9}, {
   3.8507108716073713`*^9, 3.8507108970396805`*^9}, {3.850711037604869*^9, 
   3.8507110537197943`*^9}, {3.850711162061118*^9, 3.8507111869800777`*^9}, {
   3.850712634553444*^9, 3.8507126366037955`*^9}, {3.8508845161618733`*^9, 
   3.8508845623367558`*^9}, {3.8508847463285384`*^9, 
   3.8508848727673283`*^9}, {3.850884974411666*^9, 3.8508850260341125`*^9}, {
   3.8508850618513246`*^9, 3.8508851413654213`*^9}, {3.850885179572095*^9, 
   3.850885198451885*^9}, {3.850885244627684*^9, 3.8508852861840982`*^9}, {
   3.8510587892670665`*^9, 3.8510587899995537`*^9}, {3.851058835834567*^9, 
   3.8510588824346004`*^9}, {3.85105895190691*^9, 3.851058989331723*^9}, {
   3.851059060790227*^9, 3.851059089817482*^9}, {3.8510591679073787`*^9, 
   3.8510592237062173`*^9}, {3.8510592578107796`*^9, 
   3.8510593507034636`*^9}, {3.851059396338833*^9, 3.8510594701037273`*^9}, {
   3.851059512088109*^9, 3.8510595133020945`*^9}, {3.851059551904111*^9, 
   3.8510597537814045`*^9}, {3.8510598866704626`*^9, 
   3.8510599172316017`*^9}, {3.851059969494137*^9, 3.8510600659142604`*^9}, {
   3.851060113017846*^9, 3.851060759128477*^9}, {3.851060818789263*^9, 
   3.8510610014894333`*^9}, {3.8510610376529675`*^9, 3.851061104577525*^9}, {
   3.8510611519164658`*^9, 3.8510612649786577`*^9}, {3.851061352662007*^9, 
   3.8510614121961756`*^9}, 3.851061444981343*^9, {3.8510614754392304`*^9, 
   3.8510614922785177`*^9}, {3.851229666932901*^9, 3.85122972619792*^9}, {
   3.851229769277892*^9, 3.8512297775349865`*^9}, {3.8512312640602612`*^9, 
   3.8512312683491096`*^9}, {3.8512313082387686`*^9, 3.851231356472885*^9}, {
   3.8512319961136456`*^9, 3.8512321122198257`*^9}, {3.851232303502862*^9, 
   3.8512323049394135`*^9}, {3.8512364650807943`*^9, 3.851236465680994*^9}, {
   3.8512365002225833`*^9, 3.851236585257956*^9}, {3.8512366263036776`*^9, 
   3.8512366399415255`*^9}, {3.8512366701688404`*^9, 
   3.8512366850304155`*^9}, {3.8513229522789493`*^9, 
   3.8513229558972387`*^9}, {3.8513230007937307`*^9, 3.851323036442171*^9}, {
   3.851323159658568*^9, 3.851323184465205*^9}, {3.851323302455982*^9, 
   3.8513234125647955`*^9}, {3.851323506110834*^9, 3.8513235729661846`*^9}, {
   3.851323858819327*^9, 3.8513239917737455`*^9}, {3.851324025726816*^9, 
   3.8513241119816027`*^9}, {3.8513241594731207`*^9, 3.851324163835734*^9}, {
   3.851324203751698*^9, 3.8513242040689936`*^9}, {3.8513242341905727`*^9, 
   3.8513242431242647`*^9}, 3.851324375072874*^9, {3.8513244464081335`*^9, 
   3.851324456525893*^9}, {3.8513245070444574`*^9, 3.8513245102091227`*^9}, {
   3.8513245940023355`*^9, 3.8513245965041723`*^9}, 3.8513246707195983`*^9, 
   3.851324704462185*^9, {3.8513247555344553`*^9, 3.851324756082491*^9}, {
   3.85132698578996*^9, 3.85132698626937*^9}, {3.8513270354997087`*^9, 
   3.851327041545909*^9}, {3.8513270776968718`*^9, 3.851327080624795*^9}, 
   3.851327131426403*^9, {3.8513273982832317`*^9, 3.8513274983425026`*^9}, {
   3.851327609004337*^9, 3.8513278053301115`*^9}, {3.8513278552630134`*^9, 
   3.8513278693356934`*^9}, 3.851327958658337*^9, {3.851327993882185*^9, 
   3.851327996218788*^9}, {3.8513280841120358`*^9, 3.851328096361006*^9}, {
   3.851328147927904*^9, 3.851328177522663*^9}, {3.8513282133181467`*^9, 
   3.851328240329322*^9}, {3.851328277944002*^9, 3.8513283155390477`*^9}, {
   3.8513283791503496`*^9, 3.851328384857311*^9}, {3.8513284731584363`*^9, 
   3.8513285018148527`*^9}, {3.851328544523075*^9, 3.8513285572792006`*^9}, {
   3.851328608615561*^9, 3.851328680272001*^9}, {3.851328784292909*^9, 
   3.851328788467951*^9}, 3.8513288214559193`*^9, {3.851329007275149*^9, 
   3.8513290479793215`*^9}, {3.8513291024518347`*^9, 
   3.8513291815940638`*^9}, {3.851329293678714*^9, 3.85132931041168*^9}, {
   3.85132938488159*^9, 3.851329420680532*^9}, 3.851329558186611*^9, 
   3.8513296477033095`*^9, {3.8513297345215597`*^9, 3.851329753619157*^9}, {
   3.8513298095404124`*^9, 3.851329856517376*^9}, 3.8513312945985155`*^9, 
   3.851331471200194*^9, {3.85133150534067*^9, 3.8513315638612423`*^9}, {
   3.851332277702922*^9, 3.8513322885281935`*^9}, 3.851332338085888*^9, 
   3.8513323909775133`*^9, {3.851332424227212*^9, 3.8513324248168573`*^9}, {
   3.8513324581981916`*^9, 3.851332458293372*^9}, {3.8513326074203568`*^9, 
   3.851332607798843*^9}, {3.851333051524307*^9, 3.8513330540741234`*^9}, {
   3.851333820421054*^9, 3.8513338538701982`*^9}, {3.8513339189863462`*^9, 
   3.8513339383337083`*^9}, {3.851333987325512*^9, 3.85133400014664*^9}, 
   3.851334031394637*^9, {3.8513340871515913`*^9, 3.8513341086296406`*^9}, {
   3.8513342257886515`*^9, 3.8513342262589655`*^9}, {3.851334271896188*^9, 
   3.851334298861699*^9}, {3.851343583291768*^9, 3.8513436201338215`*^9}, {
   3.851343668020404*^9, 3.8513437786811686`*^9}, {3.851343813484293*^9, 
   3.851343828029807*^9}, {3.8513438676317844`*^9, 3.851343868268433*^9}, {
   3.8513439275736923`*^9, 3.8513439277888327`*^9}, {3.851344041380413*^9, 
   3.8513440420021963`*^9}, {3.851344485481472*^9, 3.8513444924227304`*^9}, {
   3.8518379178111744`*^9, 3.8518379276372614`*^9}, {3.8518381358636885`*^9, 
   3.8518381359386063`*^9}, {3.851838175475527*^9, 3.8518381922884502`*^9}, {
   3.8518382351289682`*^9, 3.851838242365205*^9}, {3.8518383517247047`*^9, 
   3.8518383980961742`*^9}, {3.8518384645062757`*^9, 3.85183846451626*^9}, {
   3.8518385325237656`*^9, 3.8518385364942694`*^9}, {3.8518385729287224`*^9, 
   3.8518385993842845`*^9}, {3.8518386605227246`*^9, 3.85183866671994*^9}, {
   3.851838721976438*^9, 3.85183876503227*^9}, {3.85183879931199*^9, 
   3.851838812839878*^9}, {3.851838880034952*^9, 3.851838928876609*^9}, {
   3.851838976916545*^9, 3.8518389918996615`*^9}, {3.851839087823432*^9, 
   3.851839152500163*^9}, {3.851839581533025*^9, 3.8518395934825983`*^9}, {
   3.8518396477464466`*^9, 3.8518397190739803`*^9}, {3.851839752947607*^9, 
   3.851839800408229*^9}, {3.851839882163287*^9, 3.8518398844660773`*^9}, {
   3.8518399757090516`*^9, 3.8518400304304357`*^9}, {3.8518400834711*^9, 
   3.8518400846812296`*^9}, {3.8518403312683945`*^9, 
   3.8518403376524353`*^9}, {3.8518403991817884`*^9, 
   3.8518404080034294`*^9}, {3.851840466115939*^9, 3.851840474033512*^9}, {
   3.851840505483709*^9, 3.851840582576028*^9}, {3.8518407918537984`*^9, 
   3.851840826545921*^9}, {3.851841096841073*^9, 3.8518411018962975`*^9}, {
   3.851841201449382*^9, 3.8518412021838303`*^9}, {3.85184183713078*^9, 
   3.8518418703301105`*^9}, 3.851841953223958*^9, 3.851841990995189*^9, {
   3.851842061118701*^9, 3.851842061688119*^9}, 3.8518420953116927`*^9, 
   3.851842132457471*^9, {3.8518421778976974`*^9, 3.8518422865257854`*^9}, {
   3.8518423190808954`*^9, 3.851842412755762*^9}, {3.8518424705289726`*^9, 
   3.851842470781089*^9}, {3.851842518587451*^9, 3.851842521023017*^9}, {
   3.8518426137645426`*^9, 3.851842675201659*^9}, 3.851842718919424*^9, {
   3.8518427602804933`*^9, 3.8518427635869093`*^9}, {3.8518446650386305`*^9, 
   3.8518446740374126`*^9}, {3.851844714658618*^9, 3.851844714849104*^9}, {
   3.851844762742834*^9, 3.8518447633907566`*^9}, {3.8518448301092463`*^9, 
   3.8518448305530443`*^9}, {3.8518449118320475`*^9, 
   3.8518449396770825`*^9}, {3.851845054081632*^9, 3.851845118153825*^9}, {
   3.851845161292926*^9, 3.8518451920130777`*^9}, {3.8518452248283257`*^9, 
   3.851845230205727*^9}, {3.8518452915870495`*^9, 3.851845293352631*^9}, {
   3.851845335593807*^9, 3.851845387004069*^9}, {3.8518454286127925`*^9, 
   3.8518454599324923`*^9}, 3.8518474527976627`*^9, 3.851847515856535*^9, {
   3.851847557192752*^9, 3.851847559880514*^9}, {3.851847591464224*^9, 
   3.8518475917752323`*^9}, 3.851847641904605*^9, {3.8518477182436447`*^9, 
   3.851847748019499*^9}, 3.8518477875816116`*^9, {3.8518478697675953`*^9, 
   3.851847870640188*^9}, {3.8518479526873837`*^9, 3.851847952883398*^9}, {
   3.8518480127729816`*^9, 3.8518480468911843`*^9}, {3.851848098712083*^9, 
   3.8518481564151726`*^9}, 3.8518482137579937`*^9, {3.8518482572468195`*^9, 
   3.851848279178997*^9}, {3.8518483327484407`*^9, 3.8518483919809203`*^9}, {
   3.8518484243187456`*^9, 3.851848472416974*^9}, {3.8518485620505667`*^9, 
   3.8518485641095514`*^9}, {3.851848720535965*^9, 3.851848720867078*^9}, 
   3.8518487691501603`*^9, {3.8518488380951705`*^9, 3.851848838331419*^9}, {
   3.8518490440362763`*^9, 3.8518490696830416`*^9}, {3.851855910312048*^9, 
   3.8518559176692333`*^9}, {3.8518559915616465`*^9, 
   3.8518559922093463`*^9}, {3.851857730223997*^9, 3.8518577307091303`*^9}, 
   3.851857768490622*^9, 3.8518578083486347`*^9, {3.851857871646901*^9, 
   3.8518578750327187`*^9}, 3.851857933461384*^9, {3.8518579748137884`*^9, 
   3.8518579902810097`*^9}, 3.8518580331480637`*^9, {3.8518580716193485`*^9, 
   3.8518580722786736`*^9}, 3.851858212662507*^9, {3.8518664325275555`*^9, 
   3.8518664464495*^9}, 3.8518664996606674`*^9, {3.851866540672678*^9, 
   3.8518665558382998`*^9}, {3.8518666219098167`*^9, 
   3.8518666223507037`*^9}, {3.8518693079777985`*^9, 
   3.8518693146860013`*^9}, {3.8518693750008125`*^9, 3.851869375015873*^9}, {
   3.851869416182099*^9, 3.851869431891138*^9}, 3.8518694729201775`*^9, {
   3.8518695221261163`*^9, 3.8518695826579866`*^9}, 3.851870030413108*^9, 
   3.8518702657189026`*^9, 3.8518789057005367`*^9, 3.8518813541645727`*^9, 
   3.851931021898473*^9, {3.851931068071731*^9, 3.851931078321677*^9}, {
   3.851932130869697*^9, 3.851932133487463*^9}, {3.8519323644390936`*^9, 
   3.8519323959903183`*^9}, 3.8519326077585096`*^9, 3.851932915070511*^9, {
   3.851934014783264*^9, 3.851934016219406*^9}, {3.8519342751577296`*^9, 
   3.8519342948801317`*^9}, {3.8519344138475*^9, 3.851934436159458*^9}, {
   3.8519346458956327`*^9, 3.851934663779066*^9}, {3.851934817829672*^9, 
   3.8519348217971864`*^9}, {3.8519351953775063`*^9, 
   3.8519352239165893`*^9}, {3.8519355441823187`*^9, 
   3.8519355485174494`*^9}, {3.851938926306096*^9, 3.8519389273261733`*^9}, {
   3.8519389717864203`*^9, 3.8519389732256975`*^9}, {3.8519390048974714`*^9, 
   3.85193903294571*^9}, {3.8519415123167048`*^9, 3.851941514466215*^9}, {
   3.8519415464057755`*^9, 3.851941564897109*^9}, {3.85194251454529*^9, 
   3.8519425146999674`*^9}, {3.8519425542345314`*^9, 
   3.8519425544772506`*^9}, {3.8519511840183697`*^9, 3.851951278815096*^9}, {
   3.8519570230833535`*^9, 3.8519570261455636`*^9}, {3.8519662627477474`*^9, 
   3.851966263206109*^9}, 3.8519662964589815`*^9, 3.851966331353877*^9, {
   3.8519714117488766`*^9, 3.8519714170260687`*^9}, 3.85200977113669*^9, 
   3.8520098132699633`*^9, {3.852012171120328*^9, 3.8520121725438633`*^9}, 
   3.8520122358860908`*^9, 3.8520123107486725`*^9, {3.8520168304297028`*^9, 
   3.852016843049257*^9}, {3.852017684307499*^9, 3.8520176886804314`*^9}, 
   3.8520177210662947`*^9, 3.8520177586930575`*^9, {3.8520178101910667`*^9, 
   3.852017883995827*^9}, {3.8520179145281467`*^9, 3.8520179151508045`*^9}, {
   3.8520315215872006`*^9, 3.852031550338603*^9}, {3.8522770908769865`*^9, 
   3.852277113252431*^9}, {3.8522771467445297`*^9, 3.852277147094632*^9}, {
   3.852277190874529*^9, 3.8522772011902027`*^9}, {3.852282355055172*^9, 
   3.852282389074385*^9}, {3.852282589523785*^9, 3.8522826153666973`*^9}, {
   3.8522831870247684`*^9, 3.852283255597026*^9}, {3.852285855321143*^9, 
   3.852285863640952*^9}, {3.852444194486685*^9, 3.852444271021325*^9}, {
   3.852444367094002*^9, 3.8524444235528917`*^9}, {3.8524444624993553`*^9, 
   3.8524445408532805`*^9}, {3.852444578356631*^9, 3.852444598941326*^9}, {
   3.852444630130806*^9, 3.8524446750357027`*^9}, {3.8524447389845543`*^9, 
   3.852444812810648*^9}, {3.8524448485981855`*^9, 3.852445056988313*^9}, 
   3.852445112030021*^9, {3.8524451755375214`*^9, 3.8524452551474886`*^9}, {
   3.852445285399251*^9, 3.852445301654945*^9}, {3.852445334489396*^9, 
   3.8524453346347823`*^9}, {3.8524453718471317`*^9, 3.852445372477537*^9}, {
   3.8524454164826937`*^9, 3.8524454745766687`*^9}, {3.8524469643770895`*^9, 
   3.8524471288386674`*^9}, {3.8524472040814724`*^9, 3.85244720715438*^9}, {
   3.852447539327344*^9, 3.852447595311473*^9}, {3.8524476306871386`*^9, 
   3.852447680704064*^9}, {3.8524477156745195`*^9, 3.8524477238853884`*^9}, {
   3.8524479799006042`*^9, 3.8524480527078495`*^9}, {3.8524480955078835`*^9, 
   3.8524483689698176`*^9}, 3.852448414848126*^9, {3.852448511255041*^9, 
   3.8524485907383156`*^9}, {3.8524486374981475`*^9, 
   3.8524486407240343`*^9}, {3.8524486722581787`*^9, 3.852448721898861*^9}, {
   3.8524602638772163`*^9, 3.852460270533081*^9}, {3.852460400251702*^9, 
   3.852460401491993*^9}, {3.852526466584388*^9, 3.852526475728548*^9}, {
   3.8525265059730577`*^9, 3.8525265935947247`*^9}, {3.85252685744125*^9, 
   3.8525268913736105`*^9}, {3.852526925818907*^9, 3.8525270195582714`*^9}, {
   3.8525270659621167`*^9, 3.8525270698647456`*^9}, {3.852527125309167*^9, 
   3.852527125900145*^9}, {3.8525271592291975`*^9, 3.8525272700218444`*^9}, 
   3.852527305497348*^9, {3.8525273502525325`*^9, 3.8525273871346827`*^9}, {
   3.852527434250126*^9, 3.8525274666914997`*^9}, {3.8525275057321453`*^9, 
   3.852527512048141*^9}, 3.852527694344597*^9, {3.852527757965639*^9, 
   3.852527758333908*^9}, {3.852527861750864*^9, 3.8525280104039464`*^9}, 
   3.852534452727213*^9, {3.852535221896947*^9, 3.852535222036538*^9}, {
   3.8525354708050637`*^9, 3.8525355928367195`*^9}, {3.8525466609295053`*^9, 
   3.85254671342564*^9}, {3.852558395747987*^9, 3.852558427205872*^9}, {
   3.8525584962082005`*^9, 3.8525585881123915`*^9}, {3.852558670828271*^9, 
   3.852558754780281*^9}, {3.8525587995155225`*^9, 3.8525588136528683`*^9}, {
   3.8525588654117246`*^9, 3.852558978938304*^9}, {3.852559087972982*^9, 
   3.8525591602740216`*^9}, 3.852559199687934*^9, {3.8525592436989827`*^9, 
   3.8525592561181526`*^9}, {3.852559286937688*^9, 3.852559316262434*^9}, {
   3.852569549649065*^9, 3.8525695609234276`*^9}, {3.8525695954605055`*^9, 
   3.8525696187859163`*^9}, {3.852569666585756*^9, 3.8525696844385495`*^9}, {
   3.852569755028117*^9, 3.8525697924309855`*^9}, {3.8525698392883716`*^9, 
   3.8525698461222024`*^9}, {3.8525699138185225`*^9, 
   3.8525699144144096`*^9}, {3.852569966336279*^9, 3.8525699952951317`*^9}, {
   3.852570026826604*^9, 3.8525700559954453`*^9}, {3.8525701942906637`*^9, 
   3.852570206402858*^9}, {3.852570346663201*^9, 3.8525703686024733`*^9}, {
   3.8525704088392825`*^9, 3.8525704094699855`*^9}, 3.8525704624772663`*^9, {
   3.8525764309662113`*^9, 3.8525764648541517`*^9}, {3.8526442272136025`*^9, 
   3.8526442335837183`*^9}, {3.852644267893095*^9, 3.852644268130498*^9}, {
   3.8526443201890464`*^9, 3.85264432030636*^9}, {3.8526443815229096`*^9, 
   3.8526445298415403`*^9}, {3.852644613823905*^9, 3.8526446144487166`*^9}, {
   3.8526447269482107`*^9, 3.852644727094622*^9}, {3.8526448014575057`*^9, 
   3.8526448119787645`*^9}, {3.8526450619367456`*^9, 
   3.8526450698385816`*^9}, {3.8526451148146205`*^9, 
   3.8526452014627476`*^9}, {3.8526452512872906`*^9, 3.852645262931902*^9}, {
   3.852724206664488*^9, 3.8527242273028927`*^9}, {3.8527242832549863`*^9, 
   3.8527243889078407`*^9}, {3.852724440080138*^9, 3.8527244459437914`*^9}, {
   3.852724483374961*^9, 3.852724498347274*^9}, {3.852732464164485*^9, 
   3.8527324681974583`*^9}, {3.852732507210086*^9, 3.852732596760354*^9}, {
   3.8527327300966997`*^9, 3.85273278161891*^9}, {3.8527328247001963`*^9, 
   3.852732827047763*^9}, {3.8527328635749083`*^9, 3.8527328877623453`*^9}, {
   3.8527329204277115`*^9, 3.852732954683341*^9}, {3.852785299944714*^9, 
   3.8527853430451612`*^9}, {3.8527853856823583`*^9, 
   3.8527856199898915`*^9}, {3.8527856679651623`*^9, 
   3.8527857192528505`*^9}, {3.8527857496184855`*^9, 3.85278592840777*^9}, {
   3.8527859871356773`*^9, 3.852786003876102*^9}, {3.8527860491055975`*^9, 
   3.852786050215328*^9}, {3.852786148722062*^9, 3.8527861632577553`*^9}, {
   3.8527862180255375`*^9, 3.852786262550557*^9}, {3.8527862982423077`*^9, 
   3.852786300569953*^9}, {3.852873167245139*^9, 3.8528731678425255`*^9}, {
   3.8528732383064594`*^9, 3.8528732428652067`*^9}, {3.852873321473971*^9, 
   3.8528733322761602`*^9}, {3.852901974161915*^9, 3.852901974332615*^9}, {
   3.8529020068149605`*^9, 3.85290205523028*^9}, {3.852902172214736*^9, 
   3.8529022098281417`*^9}, {3.8529022440373955`*^9, 
   3.8529022747506304`*^9}, {3.852902305909896*^9, 3.8529023095896645`*^9}, {
   3.85290234760448*^9, 3.8529023709239545`*^9}, {3.8529024123145037`*^9, 
   3.8529024451058235`*^9}, {3.8529024867472954`*^9, 3.852902488956602*^9}, {
   3.8529025339467735`*^9, 3.852902591637229*^9}, {3.8529026273814754`*^9, 
   3.852902672300619*^9}, {3.852906408445053*^9, 3.85290642724079*^9}, {
   3.8529064764197063`*^9, 3.8529065056778355`*^9}, {3.8529065504687996`*^9, 
   3.852906554793287*^9}, {3.8529065961558123`*^9, 3.852906690598728*^9}, {
   3.852906727920057*^9, 3.8529067410800037`*^9}, {3.852906788638042*^9, 
   3.8529067941703386`*^9}, {3.852907150073498*^9, 3.8529072277111826`*^9}, {
   3.8529598941791763`*^9, 3.8529599032168603`*^9}, {3.852959935417235*^9, 
   3.8529599634678216`*^9}, {3.8529600060845156`*^9, 3.852960034813551*^9}, {
   3.852960064824518*^9, 3.85296007921142*^9}, {3.8529601383637233`*^9, 
   3.852960141676201*^9}, 3.852960181343641*^9, {3.852960233707695*^9, 
   3.8529602376295753`*^9}, {3.852960290085347*^9, 3.8529603198749976`*^9}, {
   3.852960361707575*^9, 3.8529604277224655`*^9}, {3.852961074985696*^9, 
   3.8529610751554575`*^9}, {3.85296111884344*^9, 3.8529611606329255`*^9}, {
   3.852961205393672*^9, 3.852961205953301*^9}, {3.852961241100797*^9, 
   3.8529612450429115`*^9}, {3.852961294561764*^9, 3.852961297727624*^9}, {
   3.852961495643343*^9, 3.8529615205245104`*^9}, {3.8529655209286613`*^9, 
   3.852965629712739*^9}, {3.8529657290584497`*^9, 3.8529657657753706`*^9}, {
   3.852965802554407*^9, 3.852965811037213*^9}, {3.85296586889965*^9, 
   3.852965908394479*^9}, {3.8529663092523804`*^9, 3.8529663595029154`*^9}, {
   3.852972882091031*^9, 3.852973071817398*^9}, {3.8529731568389525`*^9, 
   3.852973560716658*^9}, {3.853072574413502*^9, 3.853072576055975*^9}, {
   3.8530726349491186`*^9, 3.853072635960186*^9}, {3.853072677994176*^9, 
   3.8530727551250734`*^9}, {3.8530728185804787`*^9, 
   3.8530728435613227`*^9}, {3.8530728985963774`*^9, 3.853072913400387*^9}, {
   3.8530729689093423`*^9, 3.8530729828177996`*^9}, {3.853073074884108*^9, 
   3.853073086716195*^9}, {3.8530731899775248`*^9, 3.8530731978925605`*^9}, {
   3.8530732487206087`*^9, 3.853073317217846*^9}, {3.853171825711093*^9, 
   3.853171953141551*^9}, {3.85317198460035*^9, 3.8531719871534495`*^9}, {
   3.853172040971541*^9, 3.85317204113249*^9}, {3.8532599791887107`*^9, 
   3.8532600858724146`*^9}, {3.853260149647401*^9, 3.853260203146495*^9}, {
   3.8532602441043477`*^9, 3.8532602525916386`*^9}, {3.8532603369844055`*^9, 
   3.8532603664512105`*^9}, {3.8532604184792786`*^9, 3.8532604484834137`*^9}, 
   3.8532604898062096`*^9, 3.853260580869504*^9, {3.853260775802414*^9, 
   3.853260800387627*^9}, {3.8532608645450587`*^9, 3.8532609431961412`*^9}, {
   3.8532609783670235`*^9, 3.853260983461255*^9}, 3.853261055365977*^9, {
   3.8532611042169557`*^9, 3.8532611076890745`*^9}, {3.8532611588911476`*^9, 
   3.8532611606942625`*^9}, {3.853261217079138*^9, 3.853261236978463*^9}, 
   3.853261282971354*^9, 3.8532614024335036`*^9, {3.8532614522026215`*^9, 
   3.8532614645950203`*^9}, {3.8532615161434336`*^9, 3.853261519681104*^9}, {
   3.8532615642051744`*^9, 3.853261616943416*^9}, {3.8532617073936796`*^9, 
   3.8532617078708963`*^9}, {3.8532617399470162`*^9, 3.853261754403495*^9}, {
   3.85355896305042*^9, 3.853558970609645*^9}, {3.853559041918388*^9, 
   3.8535590487978053`*^9}, 3.8535591180003533`*^9, {3.8535591526092463`*^9, 
   3.853559153114499*^9}, {3.8535592387817545`*^9, 3.853559540884695*^9}, {
   3.857967607649228*^9, 3.857967608109536*^9}, {3.857967684280856*^9, 
   3.85796768480552*^9}, {3.85796771743992*^9, 3.8579677179830704`*^9}, {
   3.857973972695857*^9, 3.8579739733756065`*^9}, {3.8586912747439213`*^9, 
   3.8586912751716723`*^9}, {3.8586914028970413`*^9, 
   3.8586914030569563`*^9}, {3.8586948695001125`*^9, 3.858694932031636*^9}, 
   3.858694978670319*^9, 3.858695009454975*^9, {3.858695118182643*^9, 
   3.858695118385144*^9}, {3.8586951727413797`*^9, 3.858695172873677*^9}, {
   3.858695207471652*^9, 3.858695210703681*^9}, {3.858695261338064*^9, 
   3.858695285966623*^9}, {3.858695316183837*^9, 3.8586953192700443`*^9}, 
   3.8586953743181877`*^9, {3.859635751294883*^9, 3.8596357555703273`*^9}, 
   3.8596358560075064`*^9, {3.8596358955709543`*^9, 3.859636105939265*^9}, {
   3.8596362255588303`*^9, 3.859636230715404*^9}, {3.8596362669114013`*^9, 
   3.8596362698904233`*^9}, {3.8596363024593816`*^9, 
   3.8596363182387066`*^9}, {3.8596363691771774`*^9, 3.859636369365399*^9}, {
   3.859636415859827*^9, 3.859636436719077*^9}, {3.8596364724704375`*^9, 
   3.859636491330242*^9}, {3.8596365394775743`*^9, 3.8596365537645288`*^9}, {
   3.859636598495668*^9, 3.859636599573963*^9}, {3.859636651175406*^9, 
   3.859636653458932*^9}, {3.859636700657961*^9, 3.859636701879946*^9}, 
   3.8596367604930305`*^9, {3.8596368335495806`*^9, 3.8596368650529222`*^9}, {
   3.8596369262735696`*^9, 3.8596369509532113`*^9}, {3.8596370046312265`*^9, 
   3.859637011069415*^9}, {3.8596370554963665`*^9, 3.859637059839363*^9}, {
   3.8596372090004187`*^9, 3.8596372092171173`*^9}, 3.8596373038161907`*^9, {
   3.859637348025303*^9, 3.859637348200618*^9}, {3.8596374065383196`*^9, 
   3.859637424454502*^9}, {3.8596374801530666`*^9, 3.85963752386521*^9}, 
   3.8596375675121627`*^9, {3.8596376166387143`*^9, 3.8596376488290057`*^9}, {
   3.8596376927507*^9, 3.8596376938193464`*^9}, {3.8596379564917755`*^9, 
   3.8596379609644613`*^9}, {3.8596380178941107`*^9, 3.859638042445819*^9}, {
   3.859638076237174*^9, 3.8596380772117233`*^9}, {3.8596381204398236`*^9, 
   3.8596381610018516`*^9}, {3.859638198414377*^9, 3.8596382156730704`*^9}, {
   3.859638261773386*^9, 3.859638276324542*^9}, {3.859638323433014*^9, 
   3.859638325710273*^9}, {3.8596383615841627`*^9, 3.859638371147989*^9}, {
   3.8596384259340053`*^9, 3.8596386293908825`*^9}, {3.8596386648861485`*^9, 
   3.859638679634406*^9}, 3.859638731526886*^9, {3.8596467281676064`*^9, 
   3.859646728435603*^9}, {3.859647050306698*^9, 3.859647108379776*^9}, {
   3.859647141456666*^9, 3.8596471617792945`*^9}, {3.8596473304691086`*^9, 
   3.859647330898236*^9}, {3.859647387232585*^9, 3.8596474299382744`*^9}, {
   3.8596478617451773`*^9, 3.859647861937556*^9}, {3.860739394371004*^9, 
   3.860739398465014*^9}, {3.8607394408558044`*^9, 3.8607394414485035`*^9}, 
   3.8607394849367304`*^9, {3.861181297316951*^9, 3.8611813000912547`*^9}, {
   3.861181470993021*^9, 3.861181471456324*^9}, {3.8611815071539226`*^9, 
   3.861181513234008*^9}, {3.8611820196350317`*^9, 3.861182022328005*^9}, {
   3.8611820694325013`*^9, 3.861182069737903*^9}, {3.86118220099837*^9, 
   3.8611822074820952`*^9}, {3.861182261873725*^9, 3.861182307356748*^9}, {
   3.8611825188140173`*^9, 3.861182577418338*^9}, {3.8611826316752477`*^9, 
   3.8611826336286097`*^9}, 3.861183204324669*^9, {3.8611835187472343`*^9, 
   3.8611835189399223`*^9}, {3.861183599499612*^9, 3.8611836000389357`*^9}, {
   3.861183743048706*^9, 3.861183743220649*^9}, {3.8611846587768774`*^9, 
   3.8611846597085085`*^9}, {3.86118480316076*^9, 3.8611848283065557`*^9}, {
   3.8611866115568085`*^9, 3.861186612646653*^9}, {3.861186648175481*^9, 
   3.8611866491516733`*^9}, 3.86118673069493*^9, {3.8611868295374374`*^9, 
   3.861186834259407*^9}, 3.8611870662072964`*^9, {3.8611872155282216`*^9, 
   3.8611873099792356`*^9}, {3.861187357478339*^9, 3.8611873578915777`*^9}, {
   3.861187413087998*^9, 3.861187413190301*^9}, {3.8611884062008*^9, 
   3.8611884092685194`*^9}, 3.8611884672296886`*^9, {3.8611885068901677`*^9, 
   3.861188525708023*^9}, {3.861188634969264*^9, 3.8611886384316516`*^9}, {
   3.8611887819623175`*^9, 3.8611887821576433`*^9}, {3.861189174702568*^9, 
   3.861189197089279*^9}, {3.861189321631485*^9, 3.861189330865961*^9}, {
   3.8611894568280506`*^9, 3.861189458296104*^9}, {3.8611895048660336`*^9, 
   3.861189508706058*^9}, {3.861189860180767*^9, 3.861189943265944*^9}, {
   3.861190008763695*^9, 3.86119001196404*^9}, {3.861192631925825*^9, 
   3.8611926343127003`*^9}, {3.8611926644658585`*^9, 
   3.8611926861307125`*^9}, {3.8611927434828033`*^9, 3.861192769965005*^9}, {
   3.861193713196365*^9, 3.8611937415038147`*^9}, {3.86119378699751*^9, 
   3.8611938049116077`*^9}, {3.8611938349901237`*^9, 
   3.8611938843758607`*^9}, {3.8612740057764997`*^9, 3.861274006459816*^9}, {
   3.861274049412244*^9, 3.861274049557012*^9}, {3.861274095751278*^9, 
   3.8612741001646156`*^9}, {3.8612741327489033`*^9, 3.861274160928685*^9}, {
   3.861333631913108*^9, 3.8613336335117784`*^9}, {3.861333676296171*^9, 
   3.8613336917201896`*^9}, {3.861333896718897*^9, 3.8613338969357243`*^9}, {
   3.861333937964943*^9, 3.8613339524912558`*^9}, {3.8613340133272247`*^9, 
   3.8613340779644766`*^9}, {3.861334180207636*^9, 3.8613342093219213`*^9}, {
   3.8613342513235545`*^9, 3.861334251550847*^9}, {3.861334335087386*^9, 
   3.8613343396631365`*^9}, {3.8613344061354637`*^9, 
   3.8613344069162245`*^9}, {3.8613344920999584`*^9, 
   3.8613344948945484`*^9}, {3.8613347018996234`*^9, 
   3.8613347020973797`*^9}, {3.8613347815261354`*^9, 
   3.8613347961289153`*^9}, {3.861335190602889*^9, 3.8613351908680716`*^9}, {
   3.861341493616827*^9, 3.861341514778068*^9}, 3.8613430874923563`*^9, {
   3.8613431747341895`*^9, 3.861343205182599*^9}, {3.861343280214287*^9, 
   3.8613432874822626`*^9}, {3.861343347139919*^9, 3.861343347275258*^9}, {
   3.861343416766263*^9, 3.8613434431955605`*^9}, {3.861343518008455*^9, 
   3.861343518250569*^9}, {3.8613448502778525`*^9, 3.8613448507116165`*^9}, {
   3.8613454119156837`*^9, 3.8613455049117126`*^9}, {3.861345566752797*^9, 
   3.861345569615834*^9}, {3.8613456256902013`*^9, 3.861345632302225*^9}, {
   3.86134572681326*^9, 3.8613457297307396`*^9}, 3.8613457620023365`*^9, {
   3.861345830762925*^9, 3.861345835806952*^9}, {3.8613459258607907`*^9, 
   3.861345927250907*^9}, {3.8613459969880047`*^9, 3.8613460197052236`*^9}, {
   3.861346054044314*^9, 3.861346057962468*^9}, {3.8613462181705847`*^9, 
   3.8613462184031377`*^9}, 3.861346350080811*^9, {3.8613464193454084`*^9, 
   3.861346463202139*^9}, {3.861349589732862*^9, 3.8613495903187637`*^9}, {
   3.8616855084154887`*^9, 3.861685508667609*^9}, {3.861685541595967*^9, 
   3.861685578263705*^9}, {3.861685614370657*^9, 3.8616856697402644`*^9}, {
   3.861685792409486*^9, 3.8616857929762974`*^9}, {3.861686714004095*^9, 
   3.861686724236595*^9}, 3.861686775303775*^9, {3.861883477199983*^9, 
   3.8618835571007175`*^9}, {3.8618835927004232`*^9, 3.8618836331840925`*^9}, 
   3.8618836663890524`*^9, 3.8618837462095356`*^9, {3.8620527197089567`*^9, 
   3.8620527664364924`*^9}, {3.8621223857849407`*^9, 
   3.8621224185556006`*^9}, {3.862122451810829*^9, 3.8621224605835557`*^9}, {
   3.862122501889369*^9, 3.8621225049504538`*^9}, {3.8621241969078674`*^9, 
   3.8621242292854185`*^9}, {3.8621242614800687`*^9, 
   3.8621242618008137`*^9}, {3.862124318477487*^9, 3.862124324225712*^9}, {
   3.8621243955484457`*^9, 3.862124403421612*^9}, {3.862124620162164*^9, 
   3.8621246304524937`*^9}, {3.862199835438366*^9, 3.8621998355980077`*^9}, {
   3.8622000891366434`*^9, 3.862200095398985*^9}, {3.862200305903019*^9, 
   3.862200306825387*^9}, {3.862200703631716*^9, 3.8622007037865195`*^9}, {
   3.8622008102384653`*^9, 3.8622008108202753`*^9}, {3.862203992096491*^9, 
   3.8622039922516675`*^9}, {3.8622054547748375`*^9, 3.862205467593816*^9}, {
   3.8622055288453493`*^9, 3.862205614956419*^9}, 3.8622056605631585`*^9, 
   3.8622056913488436`*^9, {3.8622057240032663`*^9, 3.8622057452620325`*^9}, {
   3.8622058420642385`*^9, 3.862205845628196*^9}, {3.8622058764969716`*^9, 
   3.862205947237302*^9}, {3.8622059889724255`*^9, 3.8622059905553055`*^9}, {
   3.862206034921259*^9, 3.8622060786019125`*^9}, {3.862206138852295*^9, 
   3.86220615392447*^9}, {3.862206192231818*^9, 3.862206216898239*^9}, {
   3.862206247267668*^9, 3.8622062537519655`*^9}, {3.8622063311599956`*^9, 
   3.8622064012580876`*^9}, {3.8622064320828037`*^9, 3.862206477496951*^9}, {
   3.8622065142200937`*^9, 3.8622065249604025`*^9}, {3.862206557787097*^9, 
   3.8622065703340516`*^9}, {3.862206614322362*^9, 3.8622066321547565`*^9}, {
   3.862206680481691*^9, 3.8622066929682875`*^9}, {3.862206729367922*^9, 
   3.8622067503122063`*^9}, {3.8622067974118624`*^9, 
   3.8622067999358125`*^9}, {3.862206864537875*^9, 3.8622069148774724`*^9}, {
   3.8622069452712903`*^9, 3.862206978196535*^9}, {3.8622070314675455`*^9, 
   3.8622070570556955`*^9}, {3.8622070926587176`*^9, 
   3.8622071347186203`*^9}, {3.8622072086759825`*^9, 
   3.8622072093085804`*^9}, {3.8622072406894045`*^9, 
   3.8622072428697987`*^9}, {3.862207299456504*^9, 3.8622074573578806`*^9}, {
   3.8622075147912226`*^9, 3.8622075669254947`*^9}, {3.8622075990025144`*^9, 
   3.862207652952578*^9}, 3.8622076879668674`*^9, {3.8622078405484*^9, 
   3.8622078718994613`*^9}, {3.8622079640248613`*^9, 3.862207969756686*^9}, 
   3.8622138953038273`*^9, {3.8622139877961273`*^9, 3.862214035236543*^9}, 
   3.862214250883749*^9, 3.862214372233836*^9, {3.862215256323412*^9, 
   3.86221525886338*^9}, {3.862217336367421*^9, 3.862217337700093*^9}, {
   3.862217375339017*^9, 3.8622173767320523`*^9}, {3.8622174082195053`*^9, 
   3.8622174095326347`*^9}, {3.862217457349468*^9, 3.8622174646358223`*^9}, {
   3.8622176545354595`*^9, 3.862217683516094*^9}, {3.862217809167169*^9, 
   3.8622178180679827`*^9}, 3.862217929887761*^9, {3.8622179752947206`*^9, 
   3.8622180092339115`*^9}, {3.8622180903512793`*^9, 3.862218090776716*^9}, {
   3.8622181303231363`*^9, 3.862218156213148*^9}, {3.862218200718502*^9, 
   3.862218204707572*^9}, {3.8622182493357363`*^9, 3.8622182941008434`*^9}, {
   3.862218344433545*^9, 3.862218363871704*^9}, {3.8622184481940613`*^9, 
   3.8622185324531193`*^9}, {3.862223804649455*^9, 3.862223805291072*^9}, {
   3.86222492799696*^9, 3.8622250052047305`*^9}, {3.862225576391521*^9, 
   3.8622256107132406`*^9}, {3.862228518223428*^9, 3.8622285216507063`*^9}, {
   3.8622286167811775`*^9, 3.8622286170584307`*^9}, 3.86222867321491*^9, {
   3.8622287516370907`*^9, 3.862228833441812*^9}, {3.862229066954672*^9, 
   3.862229086526006*^9}, {3.8622292117062197`*^9, 3.862229211863435*^9}, {
   3.862229243023361*^9, 3.8622292434135528`*^9}, {3.862229481238717*^9, 
   3.8622294890759287`*^9}, {3.8622297902389517`*^9, 
   3.8622297904432173`*^9}, {3.8622299153710866`*^9, 
   3.8622299159841604`*^9}, {3.8622374695592194`*^9, 
   3.8622374697414284`*^9}, {3.862237921146799*^9, 3.8622379217612576`*^9}, {
   3.862238104617197*^9, 3.862238104792429*^9}, {3.8622381436245995`*^9, 
   3.8622381441813097`*^9}, {3.8622382576378813`*^9, 3.862238280051217*^9}, {
   3.8622384999341893`*^9, 3.8622385323099427`*^9}, {3.8622385664017572`*^9, 
   3.862238590083934*^9}, {3.8622386312843456`*^9, 3.862238633559701*^9}, {
   3.8622386701208353`*^9, 3.862238670731924*^9}, {3.862239233161296*^9, 
   3.862239233769038*^9}, {3.862239573573881*^9, 3.862239574214306*^9}, {
   3.8628486546108484`*^9, 3.8628486552146935`*^9}, {3.8628486982289743`*^9, 
   3.862848698911764*^9}, {3.862848743629337*^9, 3.8628487481475587`*^9}, 
   3.8628489649533796`*^9, 3.862849027100348*^9, {3.86292407471585*^9, 
   3.862924080222613*^9}, {3.8629241272282*^9, 3.862924133070135*^9}, 
   3.8629241891573715`*^9, {3.8629242303866024`*^9, 3.862924240924653*^9}, 
   3.862924306338426*^9, {3.8629249131433*^9, 3.862924918878271*^9}, 
   3.862924986723414*^9, 3.8629262792046633`*^9, 3.8629263826520324`*^9, {
   3.86293216064637*^9, 3.862932166270192*^9}, {3.8629322138248987`*^9, 
   3.8629322147564087`*^9}, {3.862932249019225*^9, 3.8629322491290464`*^9}, {
   3.862932289206641*^9, 3.862932320341682*^9}, {3.8629323513864465`*^9, 
   3.8629323759376554`*^9}, {3.8629324122100945`*^9, 3.862932462087591*^9}, 
   3.8629325032574425`*^9, {3.8629375062846575`*^9, 3.862937561268789*^9}, {
   3.8629376003306866`*^9, 3.8629376120582843`*^9}, {3.8629377319366226`*^9, 
   3.8629377634834485`*^9}, {3.8629377960407352`*^9, 3.862937800699263*^9}, {
   3.8629378790609636`*^9, 3.8629378797823796`*^9}, {3.8630031786503334`*^9, 
   3.8630031839443674`*^9}, 3.863003224559984*^9, 3.8630032691869016`*^9, 
   3.863003318171569*^9, {3.8630042569273386`*^9, 3.8630042621872835`*^9}, 
   3.863004319253631*^9, {3.8630059439846582`*^9, 3.8630059499528923`*^9}, 
   3.863006154193196*^9, {3.86301102499743*^9, 3.8630110308419523`*^9}, {
   3.8630110701415977`*^9, 3.863011074971159*^9}, {3.863011123954398*^9, 
   3.8630111286190834`*^9}, 3.863011159818143*^9, {3.8630122949567404`*^9, 
   3.8630123370815964`*^9}, {3.8630124386534925`*^9, 3.863012439145405*^9}, {
   3.863012760439355*^9, 3.8630127676299067`*^9}, {3.863012831935686*^9, 
   3.863012832210251*^9}, {3.863014552583645*^9, 3.863014561018648*^9}, {
   3.8630145932866907`*^9, 3.8630145980228224`*^9}, {3.8633450895718412`*^9, 
   3.863345099361083*^9}, {3.8633451702893105`*^9, 3.8633451705117784`*^9}, 
   3.8633452379820547`*^9, {3.8633452743896074`*^9, 3.863345288119908*^9}, {
   3.863345341938776*^9, 3.8633453769661827`*^9}, {3.863345482234582*^9, 
   3.863345490573427*^9}, {3.8633455799025*^9, 3.8633455864050655`*^9}, {
   3.8633456441980104`*^9, 3.863345644483568*^9}, {3.863358522822911*^9, 
   3.8633585473908443`*^9}, {3.863358578476083*^9, 3.863358579193616*^9}, {
   3.8634199110826526`*^9, 3.8634199121228323`*^9}, {3.86341999738783*^9, 
   3.863420001668578*^9}, 3.863420050889275*^9, {3.8634201444352503`*^9, 
   3.8634201474324093`*^9}, 3.8634201880749655`*^9, {3.863420227395072*^9, 
   3.8634202386407156`*^9}, {3.8634223181752667`*^9, 3.863422325830064*^9}, {
   3.8636670922949133`*^9, 3.8636671269754405`*^9}, {3.8636672267093973`*^9, 
   3.8636672498365126`*^9}, 3.8636673182827945`*^9, {3.863667394817521*^9, 
   3.8636674303998156`*^9}, 3.8637912189838257`*^9, {3.863791258323123*^9, 
   3.863791259063732*^9}, {3.863791684035413*^9, 3.8637916847951717`*^9}, {
   3.8637919370534725`*^9, 3.863791954540927*^9}, 3.8637920130708914`*^9, {
   3.863792052249879*^9, 3.863792086950983*^9}, {3.86379213302752*^9, 
   3.863792142027272*^9}, {3.8637921813542356`*^9, 3.863792267617003*^9}, {
   3.8637924369369926`*^9, 3.863792437418288*^9}, {3.864727266164936*^9, 
   3.8647272663597145`*^9}, {3.864727301708951*^9, 3.864727330556269*^9}, {
   3.864727419594493*^9, 3.8647274203099623`*^9}, {3.864727464141446*^9, 
   3.864727542627857*^9}, {3.8647286897717433`*^9, 3.864728775619858*^9}, {
   3.8647288073817387`*^9, 3.8647288086083965`*^9}, {3.865255871782384*^9, 
   3.8652558719814253`*^9}, {3.865255912947565*^9, 3.8652559187558727`*^9}, {
   3.8652559698706913`*^9, 3.8652559717719483`*^9}, {3.8652561094947605`*^9, 
   3.865256133206663*^9}, {3.865341850576931*^9, 3.8653418511721363`*^9}, {
   3.873977598166683*^9, 3.873977598347064*^9}, {3.8739777628806553`*^9, 
   3.8739779120099754`*^9}, {3.8739804976262054`*^9, 3.87398049819631*^9}, {
   3.874141691105731*^9, 3.8741416913305426`*^9}, {3.874142169097003*^9, 
   3.874142169737014*^9}, {3.874144787049199*^9, 3.874144787270913*^9}, {
   3.874144832787086*^9, 3.8741448337501297`*^9}, {3.874145010927895*^9, 
   3.874145014849514*^9}, {3.874155316636466*^9, 3.8741553190449047`*^9}, {
   3.879171006902033*^9, 3.87917100901531*^9}, {3.879171460931744*^9, 
   3.87917146153948*^9}, {3.8791715213687997`*^9, 3.8791715216315985`*^9}, {
   3.8960675306277623`*^9, 3.8960675312863617`*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"a544a711-39a2-40b2-972b-2df50604db20"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Flight-parameters loaded: geometry only.\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075742601968*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"01e78d50-d635-465a-9e90-c42d8f34b688"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Geometry type: \"\>", 
   "\[InvisibleSpace]", "\<\"flat plate\"\>", 
   "\[InvisibleSpace]", "\<\".\\n\"\>"}],
  SequenceForm["Geometry type: ", "flat plate", ".\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757426269584`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"e74442f6-d022-48f2-b454-ec8baea967ef"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Reynolds number at infinite height above the plate \
\\!\\(\\*SubscriptBox[\\(Re\\), \
\\(\[Infinity]\\)]\\)(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"ReyC", " ", "x1"}],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\",\"\>"}],
  SequenceForm[
  "Reynolds number at infinite height above the plate \!\(\*SubscriptBox[\(Re\
\), \(\[Infinity]\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = ", 
   NumberForm[$CellContext`ReyC $CellContext`x1, 3], ","],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.89607574263696*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"4b06bb11-dd69-4338-8d09-c191addb71a8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"using ReyC = \\!\\(\\*SubscriptBox[\\(Re\\), \\(c\\)]\\) = \
\"\>", "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{"LcharactSI", " ", "rhoSI", " ", "vFreestreamSI"}], 
     "viscositySI"],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["using ReyC = \!\(\*SubscriptBox[\(Re\), \(c\)]\) = ", 
   NumberForm[$CellContext`LcharactSI $CellContext`rhoSI \
$CellContext`vFreestreamSI/$CellContext`viscositySI, 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075742641961*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"a0a8b152-9eeb-467a-809b-04ca969eb1d6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Fluid quantum of action \\!\\(\\*SubscriptBox[\\(\[HBar]\\), \
\\(Fl\\)]\\) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"2\"\>",
        ShowStringCharacters->False],
       2,
       Editable->False], " ", "\[Pi]"}], 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"3\"\>",
        ShowStringCharacters->False],
       3,
       Editable->False], " ", "dC", " ", "ReyC", " ", "v", " ", "x1"}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Fluid quantum of action \!\(\*SubscriptBox[\(\[HBar]\), \(Fl\)]\) = ", 
   NumberForm[
   Rational[2, 3] $CellContext`dC^(-1) 
    Pi $CellContext`ReyC^(-1) $CellContext`v^(-1)/$CellContext`x1, 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757426494617`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"1f9931c3-9037-4789-8522-8bb6822abd14"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Coupling constant \\!\\(\\*SubscriptBox[\\(\[Alpha]\\), \
\\(Fl\\)]\\) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     InterpretationBox[
      StyleBox["\<\"3\"\>",
       ShowStringCharacters->False],
      3,
      Editable->False], 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"64\"\>",
        ShowStringCharacters->False],
       64,
       Editable->False], " ", "dC", " ", "v"}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Coupling constant \!\(\*SubscriptBox[\(\[Alpha]\), \(Fl\)]\) = ", 
   NumberForm[Rational[3, 64] $CellContext`dC^(-1)/$CellContext`v, 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.89607574265446*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"96748a81-4aa2-4b34-9f0a-4b3825b0b5ae"],

Cell[BoxData["\<\"\\n\\n------\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.89607574265946*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"b1bbcef8-facd-413a-96e9-2a300715cf1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Effective mass \\!\\(\\*SubscriptBox[\\(m\\), \
\\(eff\\)]\\)(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"2\"\>",
        ShowStringCharacters->False],
       2,
       Editable->False], " ", "c1", " ", "\[Pi]", " ", "ReyC"}], 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"3\"\>",
        ShowStringCharacters->False],
       3,
       Editable->False], " ", 
      SuperscriptBox["dC", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", 
      SuperscriptBox["v", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"ReyC", " ", "x1"}], ")"}], 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"3\"\>",
          ShowStringCharacters->False],
         3,
         Editable->False], "/", 
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False]}]]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\",\"\>"}],
  SequenceForm[
  "Effective mass \!\(\*SubscriptBox[\(m\), \(eff\)]\)(\!\(\*SubscriptBox[\(x\
\), \(1\)]\)) = ", 
   NumberForm[
   Rational[2, 3] $CellContext`c1 $CellContext`dC^(-2) 
    Pi $CellContext`ReyC $CellContext`v^(-2) ($CellContext`ReyC \
$CellContext`x1)^Rational[-3, 2], 3], ","],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075742706972*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"9fe942ae-7514-4e65-a962-05709a82261e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Initial momentum ratio \\!\\(\\*SubscriptBox[\\(k\\), \\(1\\)]\
\\)(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\),k) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"c2", " ", "k", " ", 
     SqrtBox["x1"]}],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\",\"\>"}],
  SequenceForm[
  "Initial momentum ratio \!\(\*SubscriptBox[\(k\), \
\(1\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\),k) = ", 
   NumberForm[$CellContext`c2 $CellContext`k $CellContext`x1^Rational[1, 2], 
    3], ","],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757427145047`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"0ce7b3ec-850e-472a-a920-6ad40b0d31db"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"using \\!\\(\\*SubscriptBox[\\(c\\), \\(2\\)]\\) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{"dC", " ", "v"}], 
     RowBox[{"c1", " ", 
      SqrtBox["ReyC"]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["using \!\(\*SubscriptBox[\(c\), \(2\)]\) = ", 
   NumberForm[$CellContext`c1^(-1) $CellContext`dC $CellContext`ReyC^
     Rational[-1, 2] $CellContext`v, 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075742761567*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"a2b81855-c6ad-49f4-bc73-d671edab0462"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Momentum transfer \[CapitalDelta]p = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"2\"\>",
        ShowStringCharacters->False],
       2,
       Editable->False], " ", "c2", " ", 
      SuperscriptBox["k", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", "\[Pi]", " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"-1\"\>",
          ShowStringCharacters->False],
         -1,
         Editable->False], "+", 
        RowBox[{"Cos", "[", "theta", "]"}]}], ")"}]}], 
     RowBox[{
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"-3\"\>",
         ShowStringCharacters->False],
        -3,
        Editable->False], " ", "dC", " ", "ReyC", " ", "v", " ", 
       SqrtBox["x1"]}], "-", 
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"3\"\>",
         ShowStringCharacters->False],
        3,
        Editable->False], " ", "c2", " ", "dC", " ", "k", " ", "ReyC", " ", 
       "v", " ", "x1"}], "+", 
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"3\"\>",
         ShowStringCharacters->False],
        3,
        Editable->False], " ", "c2", " ", "dC", " ", "k", " ", "ReyC", " ", 
       "v", " ", "x1", " ", 
       RowBox[{"Cos", "[", "theta", "]"}]}]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Momentum transfer \[CapitalDelta]p = ", 
   NumberForm[
   2 $CellContext`c2 $CellContext`k^2 
    Pi (-1 + Cos[$CellContext`theta])/((-3) $CellContext`dC $CellContext`ReyC \
$CellContext`v $CellContext`x1^Rational[1, 2] - 
    3 $CellContext`c2 $CellContext`dC $CellContext`k $CellContext`ReyC \
$CellContext`v $CellContext`x1 + 
    3 $CellContext`c2 $CellContext`dC $CellContext`k $CellContext`ReyC \
$CellContext`v $CellContext`x1 Cos[$CellContext`theta]), 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075743012165*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"6352d422-49f4-4825-9c2f-5051ce73e7fc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Max. momentum transfer \
\\!\\(\\*SubscriptBox[\\(\[CapitalDelta]p\\), \
\\(max\\)]\\)(\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \\(max\\)]\\)=\"\>", 
   "\[InvisibleSpace]", "\[Pi]", "\[InvisibleSpace]", "\<\") = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"4\"\>",
         ShowStringCharacters->False],
        4,
        Editable->False], " ", "c2", " ", 
       SuperscriptBox["k", 
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False]], " ", "\[Pi]"}], 
      RowBox[{
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"-3\"\>",
          ShowStringCharacters->False],
         -3,
         Editable->False], " ", "dC", " ", "ReyC", " ", "v", " ", 
        SqrtBox["x1"]}], "-", 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"6\"\>",
          ShowStringCharacters->False],
         6,
         Editable->False], " ", "c2", " ", "dC", " ", "k", " ", "ReyC", " ", 
        "v", " ", "x1"}]}]]}],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Max. momentum transfer \!\(\*SubscriptBox[\(\[CapitalDelta]p\), \
\(max\)]\)(\!\(\*SubscriptBox[\(\[Theta]\), \(max\)]\)=", Pi, ") = ", 
   NumberForm[(-4) $CellContext`c2 $CellContext`k^2 
    Pi/((-3) $CellContext`dC $CellContext`ReyC $CellContext`v $CellContext`x1^
      Rational[1, 2] - 
    6 $CellContext`c2 $CellContext`dC $CellContext`k $CellContext`ReyC \
$CellContext`v $CellContext`x1), 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757430721645`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"7a5c5861-c001-49ae-be40-cbd7c13c9031"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Differential cross section \
\\!\\(\\*FractionBox[\\(d\[Sigma]\\), SubscriptBox[\\(d\[CapitalOmega]\\), \
\\(p\\)]]\\) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{"c3", " ", 
      SuperscriptBox["v", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", "x1", " ", 
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"Cos", "[", "theta", "]"}], "-", 
        SuperscriptBox[
         RowBox[{"Cos", "[", "theta", "]"}], 
         InterpretationBox[
          StyleBox["\<\"2\"\>",
           ShowStringCharacters->False],
          2,
          Editable->False]]}], "]"}]}], 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"2\"\>",
        ShowStringCharacters->False],
       2,
       Editable->False], " ", 
      SuperscriptBox["c1", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", "ReyC", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         InterpretationBox[
          StyleBox["\<\"1\"\>",
           ShowStringCharacters->False],
          1,
          Editable->False], "-", 
         RowBox[{"c2", " ", "k", " ", 
          SqrtBox["x1"], " ", 
          RowBox[{"(", 
           RowBox[{
            InterpretationBox[
             StyleBox["\<\"-1\"\>",
              ShowStringCharacters->False],
             -1,
             Editable->False], "+", 
            RowBox[{"Cos", "[", "theta", "]"}]}], ")"}]}]}], ")"}], 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Differential cross section \!\(\*FractionBox[\(d\[Sigma]\), \
SubscriptBox[\(d\[CapitalOmega]\), \(p\)]]\) = ", 
   NumberForm[
   Rational[1, 
      2] $CellContext`c1^(-2) $CellContext`c3 $CellContext`ReyC^(-1) \
$CellContext`v^2 $CellContext`x1 
    Abs[Cos[$CellContext`theta] - Cos[$CellContext`theta]^2] (
      1 - $CellContext`c2 $CellContext`k $CellContext`x1^Rational[1, 2] (-1 + 
       Cos[$CellContext`theta]))^(-2), 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075743079666*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"aaf97b79-c900-40a2-bcd8-db7e123719b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Differential cross section at max. momentum transfer \
\\!\\(\\*SubscriptBox[\\(d\[Sigma]\\), SubscriptBox[\\(\[Theta]\\), \
\\(max\\)]]\\) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{"c3", " ", 
      SuperscriptBox["v", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", "x1"}], 
     RowBox[{"ReyC", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"c1", "+", 
         RowBox[{
          InterpretationBox[
           StyleBox["\<\"2\"\>",
            ShowStringCharacters->False],
           2,
           Editable->False], " ", "c1", " ", "c2", " ", "k", " ", 
          SqrtBox["x1"]}]}], ")"}], 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Differential cross section at max. momentum transfer \
\!\(\*SubscriptBox[\(d\[Sigma]\), SubscriptBox[\(\[Theta]\), \(max\)]]\) = ", 
   NumberForm[$CellContext`c3 $CellContext`ReyC^(-1) $CellContext`v^2 \
($CellContext`c1 + 
      2 $CellContext`c1 $CellContext`c2 $CellContext`k $CellContext`x1^
        Rational[1, 2])^(-2) $CellContext`x1, 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757431171637`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"db2d7bed-512a-4e5c-b4cf-f79b586e84b2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Number of steps s(\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \\(max\
\\)]\\)=\"\>", "\[InvisibleSpace]", "\[Pi]", 
   "\[InvisibleSpace]", "\<\") = \"\>", "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{"c1", " ", 
      SqrtBox["ReyC"], " ", 
      RowBox[{"(", 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"1\"\>",
          ShowStringCharacters->False],
         1,
         Editable->False], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox["\<\"2\"\>",
           ShowStringCharacters->False],
          2,
          Editable->False], " ", "c2", " ", "k", " ", 
         SqrtBox["x1"]}]}], ")"}]}], 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"2\"\>",
        ShowStringCharacters->False],
       2,
       Editable->False], " ", "c2", " ", "dC", " ", 
      SuperscriptBox["k", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", "v", " ", "x1"}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "Number of steps s(\!\(\*SubscriptBox[\(\[Theta]\), \(max\)]\)=", Pi, 
   ") = ", 
   NumberForm[
   Rational[1, 
      2] $CellContext`c1 $CellContext`c2^(-1) $CellContext`dC^(-1) \
$CellContext`k^(-2) $CellContext`ReyC^Rational[1, 2] $CellContext`v^(-1) (1 + 
     2 $CellContext`c2 $CellContext`k $CellContext`x1^
       Rational[1, 2])/$CellContext`x1, 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757431221676`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"dfc91636-9bf8-43d6-8353-916d8a6c9bea"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check ratio \\!\\(\\*SubscriptBox[\\(k\\), \\(3\\)]\\) = \"\>",
    "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c1", "+", 
        RowBox[{
         InterpretationBox[
          StyleBox["\<\"2\"\>",
           ShowStringCharacters->False],
          2,
          Editable->False], " ", "c1", " ", "k1"}]}], ")"}], " ", 
      SqrtBox[
       FractionBox["ReyC", 
        RowBox[{"c3", " ", "x1"}]]]}], "v"],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\\n\"\>"}],
  SequenceForm["Check ratio \!\(\*SubscriptBox[\(k\), \(3\)]\) = ", 
   NumberForm[($CellContext`c1 + 
     2 $CellContext`c1 $CellContext`k1) $CellContext`v^(-1) \
($CellContext`c3^(-1) $CellContext`ReyC/$CellContext`x1)^Rational[1, 2], 3], 
   ".\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075743189664*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"3eda43a5-7e46-4eb0-9ac1-390fbca7cf9e"],

Cell[BoxData["\<\"\\n\\n--- Analytical results ---\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075743194664*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"3a18d7b9-bc33-4474-b6e1-74a0f03c14f5"],

Cell[BoxData["\<\"State amplification factor as a function of the wavenumber \
and of the frequency:\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757433756156`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"03d1f2b2-0ef2-4848-af07-a3f6ccbd5380"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    n(k,\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"3\"\>",
        ShowStringCharacters->False],
       3,
       Editable->False], " ", "c1", " ", "cA", " ", "cB", " ", 
      SuperscriptBox["k3", 
       RowBox[{"-", "s"}]], " ", 
      SuperscriptBox["ReyC", 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"3\"\>",
          ShowStringCharacters->False],
         3,
         Editable->False], "/", 
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False]}]], " ", "Sc", " ", 
      SqrtBox["x1"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "k1"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           InterpretationBox[
            StyleBox["\<\"1\"\>",
             ShowStringCharacters->False],
            1,
            Editable->False], "+", "k1"}], ")"}], " ", 
         RowBox[{"Log", "[", "k3", "]"}]}]}], ")"}]}], 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"2\"\>",
        ShowStringCharacters->False],
       2,
       Editable->False], " ", "dC", " ", 
      SuperscriptBox["k", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", "k1", " ", 
      SuperscriptBox["\[Pi]", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["    n(k,\!\(\*SubscriptBox[\(x\), \(1\)]\)) = ", 
   NumberForm[
   Rational[3, 
      2] $CellContext`c1 $CellContext`cA $CellContext`cB $CellContext`dC^(-1)
       $CellContext`k^(-2) $CellContext`k1^(-1) \
$CellContext`k3^(-$CellContext`s) 
    Pi^(-2) $CellContext`ReyC^Rational[3, 2] $CellContext`Sc $CellContext`x1^
     Rational[1, 2] (-$CellContext`k1 + (1 + $CellContext`k1) 
      Log[$CellContext`k3]), 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075743383415*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"26a67767-95a2-48f6-b735-297c3e973f55"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    n(\\!\\(\\*SuperscriptBox[\\(\[Nu]\\), \\(SI\\)]\\),\\!\\(\
\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"3\"\>",
        ShowStringCharacters->False],
       3,
       Editable->False], " ", "c1", " ", "cA", " ", "cB", " ", 
      SuperscriptBox["k3", 
       RowBox[{"-", "s"}]], " ", 
      SuperscriptBox["ReyC", 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"3\"\>",
          ShowStringCharacters->False],
         3,
         Editable->False], "/", 
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False]}]], " ", "Sc", " ", 
      SuperscriptBox["v", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", 
      SuperscriptBox["vFreestreamSI", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "k1"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           InterpretationBox[
            StyleBox["\<\"1\"\>",
             ShowStringCharacters->False],
            1,
            Editable->False], "+", "k1"}], ")"}], " ", 
         RowBox[{"Log", "[", "k3", "]"}]}]}], ")"}]}], 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"8\"\>",
        ShowStringCharacters->False],
       8,
       Editable->False], " ", "dC", " ", "k1", " ", 
      SuperscriptBox["LcharactSI", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", 
      SuperscriptBox["nuSI", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]], " ", 
      SuperscriptBox["\[Pi]", 
       InterpretationBox[
        StyleBox["\<\"4\"\>",
         ShowStringCharacters->False],
        4,
        Editable->False]], " ", 
      SuperscriptBox["x1", 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"3\"\>",
          ShowStringCharacters->False],
         3,
         Editable->False], "/", 
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False]}]]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\\n\"\>"}],
  SequenceForm[
  "    n(\!\(\*SuperscriptBox[\(\[Nu]\), \(SI\)]\),\!\(\*SubscriptBox[\(x\), \
\(1\)]\)) = ", 
   NumberForm[
   Rational[3, 
      8] $CellContext`c1 $CellContext`cA $CellContext`cB $CellContext`dC^(-1) \
$CellContext`k1^(-1) $CellContext`k3^(-$CellContext`s) \
$CellContext`LcharactSI^(-2) $CellContext`nuSI^(-2) 
    Pi^(-4) $CellContext`ReyC^
     Rational[3, 
       2] $CellContext`Sc $CellContext`v^2 $CellContext`vFreestreamSI^2 \
$CellContext`x1^
     Rational[-3, 2] (-$CellContext`k1 + (1 + $CellContext`k1) 
      Log[$CellContext`k3]), 3], ".\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075743395918*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"76a468eb-1117-4739-ac4d-4f2601130eaf"],

Cell[BoxData["\<\"Find the approx. max. wave vector and frequency (in \
Hz):\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075743685905*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"4161d216-16e2-449b-bdf1-7f26643b1494"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
  "Solve", "ifun", 
   "\"Inverse functions are being used by \
\\!\\(\\*RowBox[{\\\"Solve\\\"}]\\), so some solutions may not be found; use \
Reduce for complete solution information.\"", 2, 79, 1, 33597458101780971034, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{
  3.863667254865848*^9, 3.863667323393462*^9, 3.8636674051487784`*^9, 
   3.8637911281005883`*^9, 3.863791225133277*^9, 3.863791263527809*^9, {
   3.863791614057905*^9, 3.863791638022667*^9}, 3.863791689145666*^9, 
   3.863792022414687*^9, 3.86379205652872*^9, 3.8637920912192583`*^9, 
   3.8637921498167124`*^9, 3.863792186595606*^9, {3.863792219298915*^9, 
   3.863792272245392*^9}, 3.8647272714219637`*^9, {3.864727306535505*^9, 
   3.8647273352911587`*^9}, 3.8647274246831427`*^9, {3.8647274738659124`*^9, 
   3.864727492884469*^9}, 3.86472754687941*^9, 3.8647275774524746`*^9, 
   3.8647286986363883`*^9, {3.8647287659960513`*^9, 3.864728780151417*^9}, 
   3.864728813459119*^9, 3.8648862993459153`*^9, 3.865139389059354*^9, 
   3.8652557630229645`*^9, 3.8652558766182632`*^9, 3.8652559234392233`*^9, 
   3.865255977165805*^9, 3.8652560679314103`*^9, {3.8652561141089077`*^9, 
   3.86525613894582*^9}, {3.865341827865255*^9, 3.8653418557524414`*^9}, 
   3.87397656947209*^9, 3.8739776029848733`*^9, 3.8739803930045815`*^9, 
   3.8739805026490326`*^9, 3.874141696306289*^9, 3.8741421744961643`*^9, 
   3.874144791878034*^9, {3.874144838111*^9, 3.8741448462366962`*^9}, {
   3.8791710134927673`*^9, 3.879171028035443*^9}, {3.8791714711699543`*^9, 
   3.879171484449946*^9}, {3.879171526091278*^9, 3.8791715368783445`*^9}, {
   3.8791718320808706`*^9, 3.8791718456929708`*^9}, 3.879171996758796*^9, {
   3.896067516393947*^9, 3.896067535740881*^9}, 3.8960757471562614`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"8a47f104-d8f6-43e6-a863-d0e080f5afa9"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \\!\\(\\*SubscriptBox[\\(k\\), \
\\(max\\)]\\)(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{"c1", " ", "L3", " ", 
      SqrtBox["ReyC"]}], 
     RowBox[{"dC", " ", "v", " ", 
      SqrtBox["x1"]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\",\"\>"}],
  SequenceForm[
  "    \!\(\*SubscriptBox[\(k\), \(max\)]\)(\!\(\*SubscriptBox[\(x\), \
\(1\)]\)) = ", 
   NumberForm[$CellContext`c1 $CellContext`dC^(-1) $CellContext`L3 \
$CellContext`ReyC^Rational[1, 2] $CellContext`v^(-1) $CellContext`x1^
     Rational[-1, 2], 3], ","],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075747198723*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"fb1bf7e1-627e-40c7-984b-f289b7aa1b7d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \\!\\(\\*SubsuperscriptBox[\\(\[Nu]\\), \\(max\\), \
\\(SI\\)]\\)(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{"c1", " ", "L3", " ", 
      SqrtBox["ReyC"], " ", "vFreestreamSI"}], 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"2\"\>",
        ShowStringCharacters->False],
       2,
       Editable->False], " ", "dC", " ", "LcharactSI", " ", "\[Pi]", " ", 
      SuperscriptBox["x1", 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"3\"\>",
          ShowStringCharacters->False],
         3,
         Editable->False], "/", 
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False]}]]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\",\"\>"}],
  SequenceForm[
  "    \!\(\*SubsuperscriptBox[\(\[Nu]\), \(max\), \
\(SI\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = ", 
   NumberForm[
   Rational[1, 
      2] $CellContext`c1 $CellContext`dC^(-1) $CellContext`L3 \
$CellContext`LcharactSI^(-1) 
    Pi^(-1) $CellContext`ReyC^
     Rational[1, 2] $CellContext`vFreestreamSI $CellContext`x1^
     Rational[-3, 2], 3], ","],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075747236223*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"ba6d0f7f-a14b-46a7-8c19-664e4aa5f3f5"],

Cell[BoxData["\<\"    using L3 as the approx. constant logarithm L3 = \
ln(\\!\\(\\*SubsuperscriptBox[\\(k\\), \\(3\\), \\(0\\)]\\)).\\n\"\>"], \
"Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757472462225`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"334b5c27-7cd6-4173-af62-c82a4bc5397d"],

Cell[BoxData["\<\"Approx. max. amplification factor:\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757473487487`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"898c85e9-f633-4afd-beb1-7fcf48051169"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    N(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"3\"\>",
        ShowStringCharacters->False],
       3,
       Editable->False], " ", 
      SuperscriptBox[
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          InterpretationBox[
           StyleBox["\<\"2\"\>",
            ShowStringCharacters->False],
           2,
           Editable->False], "+", "L3"}], "L3"]}]], " ", "cA", " ", "cB", " ",
       "dC", " ", "ReyC", " ", "Sc", " ", "v", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"c1", " ", "L3", " ", 
          SqrtBox["ReyC"]}], 
         RowBox[{
          SqrtBox["c3"], " ", "v", " ", 
          SqrtBox["x1"]}]], ")"}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{
          InterpretationBox[
           StyleBox["\<\"2\"\>",
            ShowStringCharacters->False],
           2,
           Editable->False], "+", "L3"}], "L3"]}]], " ", "x1"}], 
     RowBox[{
      SqrtBox["c3"], " ", 
      SuperscriptBox["\[Pi]", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["    N(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = ", 
   NumberForm[
   3 2^(-$CellContext`L3^(-1) (2 + $CellContext`L3)) $CellContext`c3^
     Rational[-1, 2] $CellContext`cA $CellContext`cB $CellContext`dC 
    Pi^(-2) $CellContext`ReyC $CellContext`Sc $CellContext`v ($CellContext`c1 \
$CellContext`c3^Rational[-1, 2] $CellContext`L3 $CellContext`ReyC^
       Rational[1, 2] $CellContext`v^(-1) $CellContext`x1^
       Rational[-1, 2])^(-$CellContext`L3^(-1) (
       2 + $CellContext`L3)) $CellContext`x1, 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757473561983`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"8528c8de-b03e-4a08-ab6f-02e5e2e1d5b1"],

Cell[BoxData["\<\"In the article, the expression for the max. amplification \
factor is used in the form: N(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \
\\!\\(\\*FractionBox[\\(3\\\\ \\\\ cA\\\\ cB\\\\ dC\\\\ ReyC\\\\ Sc\\\\ v\\\\ \
\\\\ x1\\), \\(\\*SqrtBox[\\(c3\\)]\\\\ \\*SuperscriptBox[\\(\[Pi]\\), \
\\(2\\)]\\)]\\)(\\!\\(\\*FractionBox[\\(\\*SqrtBox[\\(c3\\)]\\\\ v\\\\ \
\\*SqrtBox[\\(x1\\)]\\), \\(2\\\\ c1\\\\ L3\\\\ \\*SqrtBox[\\(ReyC\\)]\\)]\\)\
\\!\\(\\*SuperscriptBox[\\\")\\\", \
FractionBox[RowBox[{InterpretationBox[StyleBox[\\\"\\\\\\\"2\\\\\\\"\\\",\
ShowStringCharacters->False],2,Editable->False], \\\"+\\\", \\\"L3\\\"}], \
\\\"L3\\\"]]\\) .\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075747573909*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"04696031-da8e-49db-a031-93f4d4a93f38"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check if both expressions are the same: \"\>", 
   "\[InvisibleSpace]", "True", "\[InvisibleSpace]", "\<\".\\n\"\>"}],
  SequenceForm["Check if both expressions are the same: ", True, ".\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075747578906*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"a6a5fcd2-18bf-46a0-8a72-d15242a3ddc1"],

Cell[BoxData["\<\"Approx. transition point:\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075748990883*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"e4fbc667-55fe-467f-8191-cec10de5e5f5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \\!\\(\\*SubscriptBox[\\(x\\), \\(\\(trans\\)\\(\\\\ \
\\)\\)]\\)(\\!\\(\\*SubscriptBox[\\(N\\), \\(trans\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{
     SuperscriptBox[
      InterpretationBox[
       StyleBox["\<\"9\"\>",
        ShowStringCharacters->False],
       9,
       Editable->False], 
      RowBox[{"-", 
       FractionBox["L3", 
        RowBox[{
         InterpretationBox[
          StyleBox["\<\"2\"\>",
           ShowStringCharacters->False],
          2,
          Editable->False], "+", 
         RowBox[{
          InterpretationBox[
           StyleBox["\<\"3\"\>",
            ShowStringCharacters->False],
           3,
           Editable->False], " ", "L3"}]}]]}]], " ", 
     SuperscriptBox["\[Pi]", 
      FractionBox[
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"4\"\>",
          ShowStringCharacters->False],
         4,
         Editable->False], " ", "L3"}], 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox["\<\"3\"\>",
           ShowStringCharacters->False],
          3,
          Editable->False], " ", "L3"}]}]]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          InterpretationBox[
           StyleBox["\<\"2\"\>",
            ShowStringCharacters->False],
           2,
           Editable->False], 
          FractionBox[
           RowBox[{
            InterpretationBox[
             StyleBox["\<\"2\"\>",
              ShowStringCharacters->False],
             2,
             Editable->False], "+", "L3"}], "L3"]], " ", "c1", " ", "L3", " ",
          "Ntrans", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"c1", " ", "L3", " ", 
             SqrtBox["ReyC"]}], 
            RowBox[{
             SqrtBox["c3"], " ", "v"}]], ")"}], 
          RowBox[{
           InterpretationBox[
            StyleBox["\<\"2\"\>",
             ShowStringCharacters->False],
            2,
            Editable->False], "/", "L3"}]]}], 
        RowBox[{"cA", " ", "cB", " ", "dC", " ", 
         SqrtBox["ReyC"], " ", "Sc", " ", 
         SuperscriptBox["v", 
          InterpretationBox[
           StyleBox["\<\"2\"\>",
            ShowStringCharacters->False],
           2,
           Editable->False]]}]], ")"}], 
      FractionBox[
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False], " ", "L3"}], 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False], "+", 
        RowBox[{
         InterpretationBox[
          StyleBox["\<\"3\"\>",
           ShowStringCharacters->False],
          3,
          Editable->False], " ", "L3"}]}]]]}],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    \!\(\*SubscriptBox[\(x\), \(\(trans\)\(\\ \
\)\)]\)(\!\(\*SubscriptBox[\(N\), \(trans\)]\)) = ", 
   NumberForm[
   9^(-$CellContext`L3/(2 + 3 $CellContext`L3)) 
    Pi^(4 $CellContext`L3/(2 + 3 $CellContext`L3)) (
      2^($CellContext`L3^(-1) (
         2 + $CellContext`L3)) $CellContext`c1 $CellContext`cA^(-1) \
$CellContext`cB^(-1) $CellContext`dC^(-1) $CellContext`L3 $CellContext`Ntrans \
$CellContext`ReyC^
       Rational[-1, 2] $CellContext`Sc^(-1) ($CellContext`c1 $CellContext`c3^
         Rational[-1, 2] $CellContext`L3 $CellContext`ReyC^
         Rational[1, 2]/$CellContext`v)^(
        2/$CellContext`L3) $CellContext`v^(-2))^(2 $CellContext`L3/(2 + 
      3 $CellContext`L3)), 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757489983935`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"0e53bb34-7bc5-426f-9460-f0b9c59d97d2"],

Cell[BoxData["\<\"In the article, the expression for the transition point is \
used in the form: \\!\\(\\*SubscriptBox[\\(x\\), \\(\\(trans\\)\\(\\\\ \
\\)\\)]\\)(\\!\\(\\*SubscriptBox[\\(N\\), \\(trans\\)]\\)) = \
\\!\\(\\*SuperscriptBox[\\(ReyC\\), \
FractionBox[\\(\\(2\\)\\(-\\)\\(L3\\)\\(\\\\ \\)\\), \\(2 + 3\\\\ L3\\)]]\\)(\
\\!\\(\\*FractionBox[\\(\\(2\\)\\(\\\\ \\)\\(c1\\)\\(\\\\ \
\\)\\*SuperscriptBox[\\(\[Pi]\\), \\(2\\)]\\(\\\\ \\\\ \\)\\(L3\\)\\(\\\\ \\)\
\\(Ntrans\\)\\(\\\\ \\)\\), \\(3\\\\ cA\\\\ cB\\\\ dC\\\\ Sc\\\\ \
\\*SuperscriptBox[\\(v\\), \\(2\\)]\\)]\\)(\\!\\(\\*FractionBox[\\(2\\\\ c1\\\
\\ L3\\), \\(\\*SqrtBox[\\(c3\\)]\\\\ \
v\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), \
\\(2/L3\\)]\\)\\!\\(\\*SuperscriptBox[\\()\\), FractionBox[\\(2\\\\ L3\\), \
\\(2 + 3\\\\ L3\\)]]\\) .\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075749582365*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"1eb296ac-7b89-460c-b0a9-064389d261e4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Check if both expressions are the same: \"\>", 
   "\[InvisibleSpace]", "True", "\[InvisibleSpace]", "\<\".\\n\"\>"}],
  SequenceForm["Check if both expressions are the same: ", True, ".\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757495848637`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"3582515a-dd6c-4541-9cf4-a70837311d3f"],

Cell[BoxData["\<\"\\n\\n--- Inserting numerical values ---\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757495873632`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"67eb0404-1a51-436a-a8ec-2e5d20dbfbf8"],

Cell[BoxData["\<\"Flight-parameters loaded: all values.\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757495923643`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"6a2c4748-72fe-4776-9609-82c3698dca74"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Set transition at \\!\\(\\*SubscriptBox[\\(N\\), \
\\(trans\\)]\\) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"9\"\>",
      ShowStringCharacters->False],
     9,
     Editable->False],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["Set transition at \!\(\*SubscriptBox[\(N\), \(trans\)]\) = ", 
   NumberForm[9, 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075749594864*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"92833faa-506e-49fd-bd70-e685b7b53fdd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"dyn. viscosity \\!\\(\\*SuperscriptBox[\\(\[Eta]\\), \\(SI\\)]\
\\) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.0000149\"\>",
      ShowStringCharacters->False],
     0.000014863320000000002`,
     AutoDelete->True],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\" Pa\[CenterDot]s.\"\>"}],
  SequenceForm["dyn. viscosity \!\(\*SuperscriptBox[\(\[Eta]\), \(SI\)]\) = ", 
   NumberForm[0.000014863320000000002`, 3], " Pa\[CenterDot]s."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757495973635`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"fccf01df-5874-473d-a115-1140a5b51901"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Coupling constant \\!\\(\\*SubscriptBox[\\(\[Alpha]\\), \
\\(Fl\\)]\\) = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.000957\"\>",
      ShowStringCharacters->False],
     0.0009574915824915827,
     AutoDelete->True],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\\n\"\>"}],
  SequenceForm[
  "Coupling constant \!\(\*SubscriptBox[\(\[Alpha]\), \(Fl\)]\) = ", 
   NumberForm[0.0009574915824915827, 3], ".\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757496023645`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"b43bcde8-05a6-47b3-8706-93bb1963b4c0"],

Cell[BoxData["\<\"Approx. max. frequency:\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075749604864*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"c3fe4473-cd09-4412-bb09-0faa8a47725c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \\!\\(\\*SubsuperscriptBox[\\(\[Nu]\\), \\(max\\), \
\\(SI\\)]\\)(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     InterpretationBox[
      StyleBox["\<\"188.\"\>",
       ShowStringCharacters->False],
      187.7977359150289,
      AutoDelete->True], 
     SuperscriptBox["x1", 
      RowBox[{
       InterpretationBox[
        StyleBox["\<\"3\"\>",
         ShowStringCharacters->False],
        3,
        Editable->False], "/", 
       InterpretationBox[
        StyleBox["\<\"2\"\>",
         ShowStringCharacters->False],
        2,
        Editable->False]}]]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\" Hz.\\n\"\>"}],
  SequenceForm[
  "    \!\(\*SubsuperscriptBox[\(\[Nu]\), \(max\), \
\(SI\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = ", 
   NumberForm[187.7977359150289 $CellContext`x1^Rational[-3, 2], 3], " Hz.\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075749609864*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"ae2ac0fc-9cb5-4e5c-8d63-466aa793f6bb"],

Cell[BoxData["\<\"Approx. transition point:\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075749612363*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"8bc92492-e203-4b53-88f4-9c130fdf3970"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \\!\\(\\*SubsuperscriptBox[\\(x\\), \\(trans\\), \\(SI\\)]\
\\)(\\!\\(\\*SubscriptBox[\\(N\\), \\(trans\\)]\\)=\"\>", "\[InvisibleSpace]",
    "9", "\[InvisibleSpace]", "\<\") = \"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.698\"\>",
      ShowStringCharacters->False],
     0.6980627851672276,
     AutoDelete->True],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\" m\"\>", 
   "\[InvisibleSpace]", "\<\" = 0.517 \\!\\(\\*SubscriptBox[\\(l\\), \\(c\\)]\
\\),\"\>"}],
  SequenceForm[
  "    \!\(\*SubsuperscriptBox[\(x\), \(trans\), \
\(SI\)]\)(\!\(\*SubscriptBox[\(N\), \(trans\)]\)=", 9, ") = ", 
   NumberForm[0.6980627851672276, 3], " m", 
   " = 0.517 \!\(\*SubscriptBox[\(l\), \(c\)]\),"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757496148624`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"ba4b692a-272f-4423-aff2-09448b103164"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \\!\\(\\*SubscriptBox[\\(Re\\), \\(\[Infinity]\\)]\\)( \\!\
\\(\\*SubsuperscriptBox[\\(x\\), \\(1\\), \\(SI\\)]\\) = \
\\!\\(\\*SubsuperscriptBox[\\(x\\), \\(trans\\), \\(SI\\)]\\) ) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox[
      RowBox[{"\<\"1.93906\"\>", "\[Times]", 
       SuperscriptBox["10", "\<\"6\"\>"]}],
      ShowStringCharacters->False],
     1.9390632921311879`*^6,
     AutoDelete->True],
    ScientificForm], "\[InvisibleSpace]", "\<\".\\n\"\>"}],
  SequenceForm[
  "    \!\(\*SubscriptBox[\(Re\), \(\[Infinity]\)]\)( \
\!\(\*SubsuperscriptBox[\(x\), \(1\), \(SI\)]\) = \!\(\*SubsuperscriptBox[\(x\
\), \(trans\), \(SI\)]\) ) = ", 
   ScientificForm[1.9390632921311879`*^6], ".\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757496173644`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"3d36daa8-4d04-4bd1-aabc-00adb6cd2784"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The plotted contours of the instability zone (black solid \
lines) are at \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"{", 
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"9.\"\>",
        ShowStringCharacters->False],
       9.,
       AutoDelete->True], ",", 
      InterpretationBox[
       StyleBox["\<\"9.5\"\>",
        ShowStringCharacters->False],
       9.5,
       AutoDelete->True], ",", 
      InterpretationBox[
       StyleBox["\<\"10.\"\>",
        ShowStringCharacters->False],
       10.,
       AutoDelete->True]}], "}"}],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\\n\"\>"}],
  SequenceForm[
  "The plotted contours of the instability zone (black solid lines) are at ", 
   NumberForm[{9., 9.5, 10.}, 3], ".\n"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075749622364*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"e8bc8e9a-074e-4ac9-a251-d53cde27e0dc"]
}, Open  ]],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{
      GraphicsComplexBox[CompressedData["
1:eJxsXQVYVU0Txi7sblFUMLALlF27sbuwsJFQCQHpkrzABQzsVmxERSwEREBA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       "], {{{
          EdgeForm[], 
          RGBColor[1., 1., 1.], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJxNmVtwltUVhr/vI3/y5//AcNaqSCLUqxbFE6i0gBfWYyGUgAqoaWfUMRwc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             "]], 
            PolygonBox[CompressedData["
1:eJwlkz9sjWEUxk96fb3f/d42omKRKKWDREgQtx1qaGMgEkH8CaYiDHXvDYbG
ZmLxZ1BLhcQgiqJSEd1MYqqlIk0t1N/QobWifk+e5DvJc85zzvud8z7n7Tje
2F9viogebAnWVUQsAhYIVsGjecQ0uFGKOIk/lSK2wq/Dn4X7nBv3ExuC/wF/
vzlinJrv4A5sL3wf/FrwLfJfNzl2gPwRYjXy66qBa8efyiLeYavBOdZZ8j8r
4GlqhuCekV+uRAy0RHwscy5nXqD+L/xL+AnsH/gcOXzRxhnnAcuxV9Ruhj8N
f4gzf1E7SOw5+BT8Tv41gd8KXs+Zl6ndTWwPuJecGyXfUR94A7Gr+CvI35e7
J/U2hs3DLxIbbfZMmu0g/V6kdpaea+At8C8yx+5SO5k8i2Z4C76DnaD+Hv5j
crdjPeQOE5uBe0/NUv4/Q6yVedrh5zLPsCv3DJrlJ7Fq8gya5RI1K+EahbXT
GZNwm/AHS9Z8I/gsOZ/KvmPd9Z+y/6We1fvt5N5Us4zch/gjYU0fgQty3mTu
Wb3v4MxqybE23U9hraSRtPqQPNs2cp7CzefGA9SP4T9I3hVpKC3XJO9KL/XX
8X8n3712bAHcX/HuSQNp0ZV8FzXyV+GPJ2svjaX14WQttRPajWu5d1k9q/eb
hXvRTn7J/Sb0NnTn3dKu4rvVHQyDj8B3Zt7ZK/BHC/9bsWOF35jeWjd+Hfwk
925Kc2n/NXk2valveiuFc7Vz2r0zLd4laSSt/gMt7X+W
             "]]}]}, {
          EdgeForm[], 
          RGBColor[1., 1., 0.3999999999999999], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJxFV21ollUYfvR9n3fnOWeCa8ooSDNxRKGWLjcsoSx/2A/T5b4sEIdftbk5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             "]], 
            PolygonBox[CompressedData["
1:eJwtlVtslUUUhSc95z/9z/zVWKWSaCxUUp7kYoq2eLeGB3xQaVqwqFGbCCql
FTWARhPABzVRwEhbpWAEDBdBgbYK+mAEEyqK4INYoIUYENFY0WqiD0r1W1k+
7GTty+yZ2bP3mqqW9oa2khDCi0ge2VIM4V7AOoybwfOQtlwIz+GbmYZwO3IP
+NskhKuzEDrxLyF+GP0qfE9Gr+3B9hS4KnNsJdKI3o7cAN5IzDLi32L9GvL3
k3M9+BTx3YUQarHtJnY6+gjxn2D7G3w5tjPk3ob+I/r75DhJrueJn4+vEf0o
uUZZU4//V3J+Svwc9LP4ThDTAe5CiviGiFkArmHNIHgVMX3kqyPfDGJHsX3G
Xqew1aAvx99CvhtZ8wT6Bfz7Co6pIN8f6D3gB1k/Ah7AtivvOx/W/kXX5mb0
r9HrkGr23qfzEH8NOf/E/xcyCfwy/lbwXPxvou9An5w4RrFTkBOcbQq2eeAj
+G9KvIf2+g6p4Cy3YVscvaf2nqP3wXc/tjb2n4jtAXB36rf6Gf949Ji6NmXY
LuV8i6LvXk7OY6yvQh/O+86/41+IfkD1x9YGXpl67Wn0CvS5SDX628g58L/R
Z7mEfKPgD4ifptqSbwf5KlP3nu5chz7Enr3EExoWgxP8+/FNwzYdfC2OpTnX
ZCp4PjEz8b1DzMXgNHOt1RPqjQulIXyMPgm9hvWbsK0Az0aeSX1H3VUxgbW/
oU/Mec+Ivi1z751mv17ib1F98+7hk/geiX6b88g4fAvQ95LqOvRW8EbyLc97
5p4GZ8QcTJxDudSD6kXZLsv8Jnob1Vy1b0Ia8A/gn5C5xqq1ZkSz8rpi8HVw
njOpa6baqSeWgN9lTTu+A0hJGW+BPqbgN5xF/Fn0GcRuxXYOXJt51sUJ14O3
Zr67cmzXrIsTwNX4O9moR/2VuIfVyxuQQ8Q3EvMKsc3RWD1xH/hKzvQV+iEk
4TxfYluReCa/AHchzYlnULN4/P95Uk8Mgl8lZxNrO8Ux+LuxPZt3TuV+iJzL
Sn0GnaW1zG/djG0heAwx+wueac22OEfc04KUF10j1Uo51xbNYeKy2ey3hrP1
Er8nuIZ94FT9WjDniHt+ysxdqqlquxp/PfEv4D+I/4fMtV5E/lX4jkdzic6s
s9+KpKXmlIvw/QMeG2yTb33ms4oT30vd8+r9Ac1M9Mxp9sTZ4u6xSH/BM/dY
dI+qVzUzd6bmBHGDarqS3N9k7iVxlrjrF/xbEudQrsnR3CXOFncPRr+FaqBa
jKa+q970c3xTxYnE34U0gYexbU78BnoLnVlnP4Zk4Newzcq5Zqqd1mit/pBK
9LXRXKkZ1ax2RHP/durxErHfp34rzYRmYx16f4lnSLOknlPv6Q2vYP3O1Nwv
TnkUf3nqWbuDPevBj0fPsmqwW71X5l7Sm2xg/fnMsTpzKHomNBvq4TfAtdFc
qT9Lf5c4T9ynGvSJO6PvLo7uYv3DyN05/8H6i4ei/zLdYQJ4D+uXFswxH2bm
NHGbOEZcM6KeT/zn7dT/Fc29q1lzhPi9mf9i5fgoc81UO63ZFc2x4lrN+FH8
hzOv1R4NRYuwOFRcqj9cf7k4oBc8PnNv6w7jwP8BgAIelg==
             "]]}]}, {
          EdgeForm[], 
          RGBColor[1., 1., 0.], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJxFV1tsVVUQPbT39p6zdwGVoiQmEgPYmhgFERNMrA+UDyIqWEyRRwjEB2oF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             "]], 
            PolygonBox[CompressedData["
1:eJwtlUls1lUUxR/f0L7v/T8kylQ2MtQIK5RBEl1gEMICFAIiEYOoCDggAgWR
NqghdEOQyQVtCYUoqBuJUmkVdIE7LINhEDBAi4BYE9sFhEQlNP5OThc3Offd
+d173xu5eOXcd3MhhBqoAC0ph7ClMoQbHB6OIRyBusDvVYRwKAvh7WQ8qRjC
O+BRUDeGPVA1+Ht06pCfg0r4WlwKYRqyrejnwLvR+Qn+K3w2gY/h/y54e55z
bCuwOY1tLdQG3wp15+zzCPg6PtqwB4Za8BvQKmw/gJ+Br8fw+Q/yf6HHwWVo
fcE6GfgEVE8u0+GPg3diX4P8Y876gTtxPBn+SeS38XcNnUZkx8mhE5zQOVzh
s6vw36DTiawW/X2ZfcjXFui84lPPRfQvkN/DyH6DBqI7Gfma5DvR3ZwmZj/4
2fj4KG+fs8A1ybpjkT+Pbhf8p0XX1AA/F5169G+iPwf8ArQZ/i/4eeCz5DcF
/QXov49+A/b7kb3IWSN4JvIZyGqwGYC8F5t78B/CD4ZvSe7VCvS/BbdBzdRz
An6I+hM9K5vQfwvZXmw2YH8JneHgpdS/rdIzpFmaic1l8CLkDeDx2PxXcMwJ
8h9di+7gIPLBUHvRMRX7aHRtqrkFWXN0b+bBz0d+jZitBdes2l/KPFs96CxQ
bHRehd9ITq+VnaNyVY/Uq+7kWpSzcs+wGQP/BD7L4GHI/yh4htrBFzPLRqNz
K9qnfJ8i3mfw98FV9P6Qlitzj9XrX6Cc7gtaUXCMLvR70DlILnNQfwZ+IfLR
Rfdcvb9Sci81Q5fBT6F/G9l46E3tJmeD8o65FnySs6ngAchPJc+kZlMxQsk7
pF2qwqZOvPqb8x3WyV+yXPw68AhyWpP3zGh2PsdmU18+67U/ffevHf0d3FTy
bK3ERyN4XPJuKmflXh29OyXyeS7ah3wphzr43uhd1Y7+jO3y5LdHb4Teiq+j
a9cMaZa+xL6+4DvQXXRw1lT0zmp3OzLP8kTyuQremrlXuuNt4F2ZZ1M1qtYH
o3sxHHk1sonRu6iaD+DvTvRboR62Ju+o5MrhC/B25P2xvQk/FPnLipH3m7cQ
vDp5NrSTq8B/Rs/S65w1w+eTZ0U9/AR/P0bPsnb8aOY3Vm+tdq655BiKpRnV
rFb18Q+Qww5sn81819pB7eKV5LdbO1HC/u/k3dcfoL+gHL3rehOfjt4x7dol
zh7B/kLmt+RR8vsVXIzGeuOTdg+aX+Ee7Ee2Nrk29ecM/CvwY4rW2YFuR9/8
/qD3GH5n9OyqBtWiGlSL3oRByB+KzkV/zFTwd5n/Dv0Z+juWJv8N+hOWaZaj
e6+eDETeW+lY6pl6uyh5VpWTctsT3Xv9cfrr/gcnOe41
             "]]}]}, {
          EdgeForm[], 
          RGBColor[1., 0.7999999999999999, 0.], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJxNmX2Q1lUVx3+7++zze3vA1Wp5UZStBMnUGRObsRccXURZBIPQSXwFVkUx
0V0sQcU0bSIzopkUWBVQVCaZnCY1QEXFKRFY0XASUhFTXnRyESpJRPt+OF/H
/rh7z3N/55577nk/d1smXjX2h/VJkozXnwbN89Ikma/xin7PzZOko6L1Iknu
Enyd4Hman68mSZPGw8I/Qd/eFe7KLEnGaOwXzlCtratLkvUarwlng9ZGiHir
4OHa3yX4y5q/q3OuakySb+v3ucLpo7mfcE7W/qrWby6TpFnjasGPaW2H6J8v
+B7BLwkeJrhT8Bl1cd4n2tsuvgqNOwRP19orGlsFfyraTTpjveA2nbtJY7/g
rmrwMFTwWXngrNM8U3eaoZFqPKozpglnTxa48A3+3DRg+H8wDT5ZfzuPu9SL
969p7UR9uzgJPPYvE81cY5zGqXWxNs3rvxbOLs0bhL9RdG4SPF3nzhKtpeLt
Za3dnAbNbn0bX4n13dp3htZGaiwTzTrh/1Hrbwh/eH3IB13MyELWP0afGhME
v6V5oNZv1PfflsEX/LVqz6ui97Dm0zSuF855wp8p/Hma5+jM2RrNkuFK7X1B
4xbhTNa3GySz1zUu1vdC+Fdnwes0wS2aB2ps0rdVOudszWO196s6e6DkcLb2
dei8tRp/1/o5ReAcqe/HZiGjk8uQ01zBLwnniErMb2qsFs/PpsFbWkuS2zUf
pnNfNr/wukffd1hWH9QHzmqtT/G53P25NGhxz2t0x14ad8OnaL4v+FjNSSX4
QV+TtWekxsuC+2tfvzRs/Sbxerrwf1KGfWGLCzSeKmMvd7pKY5fgkaJ5qHD6
a5xeZ9tpCPtZm8e+FvsQuv6dcDbp2ymaN2v+mWiO0Vm3ab42C/vBjvDXKcJf
IZxU8CTBv0xCTuxFd83GQT7Mlxu/v9b7abyahG+xF/9inmw6XdLbOdWw97Ia
6+Beqvky+BTOwdWA4QX9jrONjUrDJ5fWha1w3zek83m6wyzt+6iM72OM83RD
wJn2n6l5tOXQYvl8w7rGRmcb9yzvfSYPPZ+VBX/t6CiJfaOMgx4WV+IcfOpM
019iuKZz1+SB87zjWKd9v7fthPtuToMm/rNA3x+thh6v1O92jRF1Qe8M04SX
S8wPOlpRjfsvsi1hqyu9jq/29Xq34Amif6HGYPNwdTXo8L2/cfAVbB0/WV2J
+EC8HWkeuCN8ABNLFxZB813J6q8azdr/I629pu8PaO/mhtDj8LqIY2OsR/Sy
qAwb+VjzdsloufC3af6Uu2r9hjzw2hyHsb0rBK8R/G+d9S3Rvl0429OI7/DT
y/aEbJsMP+z7Irdelj1yxE8P2GE17POAru2/RX2c3Wpf77C/31sG/iPOLcjn
/vqIn+2OgVvzkMOWPO483H63TWdOrAtfwlfwJ/zyoDx01Wb/xqbWJWGPyIvf
U5x3yD93iYcLtX++5oVl8Ly4jHhN3F6ieWsR9vS25x6tr6mPuPp+GnrpVR9x
hnzXncY68fbPojVbNJ/X3Eier0YMe1FwT/o5bo/pMPhOfBtt+39Ma4McA4mF
jxehL/TWYrsAHzuB7jv6fXQ1bAb4jSR42YLfpeGrxJy9jeGz/O4xH/CzOI27
4EcjRGeH4BfJj2nA0CSvkF8Wal6q3ysaIndPLQPnJPHZJjjT/lGaL83C3ocK
f5zzEDmor+7yKHlY31vzkN/YLHxip/1iu3PHJO3fq/m/acRq1vb83/qHGq8n
n/8G3pcGDD4x/iPDHzQEHXBZ2+d1aPAbmR1VjXtxv0oRdVVjEfT2+TxyMzn6
Hc1fLOMuc8T/8XnEtksEH5vH3ZHBDcLZI3o3llFDAI+uj/qMHHNcHjlim/ME
d9xuOey0HICxfXDWJpEHjm6MXDBHdIcQm4rIpbudm3dYnsQ0/Hu75bPNONA5
3HUN/PyiGv6D75yQhw0eWYvvyI74Nt743Y6Ne0wfuYJzun29rA+/JQYQC6D5
QBrx/Z/VqKeQA7QOq0Q+hodLdZf9+n68zj1Ro07436yFTYJHrmWt0hj7qaFm
uoacYZiYgaxmGN4iucwX/pua788ij06CdhF2Wa+7DqtE7bjMdRzxiFj0GV1k
1e51arzHRadDPP1e/N6qvce5tt6m9Tu1/rcy8gB5kFplbxn6ukhnLm4MfV0u
/FuqkTOos07Ogo83hTs0C5obyugTwJ0mOl9vjN/ArcIZLpxJ4v89wRfp2yJs
lrogjVp5dxb195YyeIVnksOzlYgn3HdVGXw8rXlmJeo0eKdOwh7a8uhX6FvI
i/Qo8AMfSx0DDshH+weTJzSfp3Go4PPL0EluXYzW75rWx2j+gUZfweeW0Uf0
JldpviiLWHZZGbZCnCVG5LYl8gi16hrHE2RwtuPLac6v+MucNPDZ1+H+aJVz
M/dDL9jFrkrUQ4OKoHmPzr+4CFm/V0RM7GXa3xdPh4in8ZqfdH28Kot4/3ON
Hv0+qhLrnDM3i7qlTxk2h+29VYT8uq1H9uW24e8J7yD9Hqt5ZRn0nswiX6Wu
VfI07kLcoXYlBkDrsjx0NyAPGeF75P07HZOJzfsd++knyYuZfRPaF7qnoyZH
r+gUvVMPoWv6lE2utTiPc+GfuwwxD+3uZ5AVeWmjcxP7XnUdQq5gnfwCzmvO
g9Rxm9PPe8fNPmtIJWR6hGMPMYtYM6ASMHGD+E2sJ4b/Jwtf3lpG/mMfPQvx
ET4vKCI30h/xfYh7JfJpp+tGfJy+Fruk5+hyrKW2BLfF+Budf7kLPofvNTVG
r7rBPsi+oy2rHuNzX3Jvi3s04t8A34V6sq/jKjKDH+RW031WU/uX4b+rXYs2
lBEriBnEF85akoW/YsOzXCdvsmx3uhaF/glZ1KefWH7drmEm2f7xg4bGiL3w
1uYell6WPoP6sMm9CL0KNSByR/59y6hHEtcryGdpGvbLeCiN94ozs6gfv6L5
ROcd8g81/BTfnXy12jmL+TnDu503n3X9gp9iM8Oy6BVqWfgrfRF9FrXPvsbo
N6n5qcsP9Hl1YSP4LPc62P1Fp3UJLfI6+f0k1z/wAJ215pM+Gj0iK+xhgPMa
ORE59fJ7TrdlDU5/4wB/ZtPgEwN6mwfq7t7uNR6yDLGxdsubejtzfECO/3Jt
T82IXkqvQ6fdfHS5Br7L8bg0fWx7iH3tRdeG8HaU17F5cji5HD2tYV8a71X3
u5Ze6LgNHrG4r2sD6i5se5Fljr6oO+kL6Xup6annyRv93QsTExY7Dkx3r/0d
8ngedov9nuL+nH5gahp76XHIRdRzS93HL7LNl36/6jI+PRFnk78nu1/7aR4w
by306H1sP9TS3Jf4SR5c7DxOjJzv/IgswKPe5jd+OMs1LTKgBiMGLzAdavwH
XBfxhkGtwz1n+O3oOve/vIVhjwOtH2IX+bOP78ubDm87d2fRQyyxjt4tIvZ8
WIZPww/xnPj0oG2Jtz9i1ZeEc28e9d24LOy61T440T0ovRg1Gjn6HfcBPc5f
1IF7fU/i1pXeS/8Eb2Nt85vco5CfydPkIGox8jQ5mpzIOnlxVC3kwhvPFNOk
rz/CeQGf3eW8i31OcUxC/uiO3/S+v8kj3nQXYTMTfRfqO2DiyX1Z5LFfleHb
xBreNzZWw55Yu8L0sDdgbAj5Y3dTbUucwVkjiogH6BQ/Il/ztki9McL6Jh+u
c+9L3UI9SB1GjfIP1ySDNa/XuFUyXFeEnICpA5DtAucm3j+6DD/hWu2ArjXf
0RiyrXc/NtH97q2uXelpbqvE20FWCx668rg/8ZX7Uj/QQ2K//cqoV6lbD3f+
ws95c+qwrWC/rY3Rz19fBDyzCHvH7rHP0vjET/oo6hp6ROL0RsucPEIvTS6h
1qJXwWZ4kzmvMd4Qylr02kUtavAJzo9THZ9H2CY7Da+xrxKTeQfnPXyYzl2e
hu1hg/QZrJMD8bPLrXt0/VP73WTXCeQQcJq9Tk4+1XcnPjzhOmpGEevXFSED
/H696wfyIvdvMm/Y8DG1+E6vfHcR992eRWzb4X6VWLXasYv3e+oDantyRWEf
JzfWXMeyVro+oW/HBttqkTfYi9zu1VkX6PvOLOxsg32TmNacRh1Qmj48fyEL
m8fPeNe5wHpBZ+iFd9i/uKZ9Srj17r/ow8hJ11gXHYbJa/Q0E0zn8Frcd0At
enFqPvrxZWW8xT2WhQ7anMunG2btQcdO5MAdh1k+9AB8J4YsdU2CDvi/yjr3
zc+UoeunRf/TMvi6rwx5ojtkCm3ehKG/gp4HfQv/D7wRo6Ms+ht42qr9p2YR
Cw/JIr+Nch7E1/Az9D7Yvj/Ib/wH+pQk7HO27b/HsZLYCy6xALrDyvCfY7Ko
y1LX9tjnTOcyfIramxhObBhu/UJ7ue0fPVNboOtBZeDQd+Ifyx238a2p9l/8
n3xP/tjjOpZcQM7E38h3g52T8euP/Ya5oAycBa4lKtLxC5r75bHvBe99RHid
gv+UhY102mawz9z1JLVbk++InSEjeqmP/NY9sQica11fIdcey3ZjFrGQ/y/x
voD/U/dmlkXqmNDgdWI7MPl6gPsv/h9CDrjCMbPZdQF7/wc+LJ8X
             "]], 
            PolygonBox[CompressedData["
1:eJwtlmlsVkUUhge+pffe+SKICi0u0UhBZDGiYMJWIiAYlmILIrRQLIuQGEul
wUBZFFkSQLT9IUJbCqUoBDHEUNRSBG2CVIGggvoHCriwJVLRKMagPi/n+3Fy
3zNnmblztnmguCTvpfbOufegOLQvcq4k4Vx10rnrgXM/wVfBt6D0Izg/5dyE
DOcOx5wbFPL1zr2Obhvyg+APoJfhF0AfYZ8Pfzu4EzQRPAG6DdwBega8GSoC
L2fvTeAl+CzkIGug77A/x56b2f959jsDzkRnMDgHeRa41dtZ+2Ofg34VOgXo
b2TtF/gtgZ39WWwmI0tAJ7Edgf4dyJ7kf7ryP9XIR7J3DL4F2/eRZ8K3x38X
ZI9gEwNne/M1Er47+Aw6+8DN0HVwAWtdsb8bKgRvY78ZnKeeM0xBXgafk+ZX
sP9vrH2O7TTWLsFPxSYT2xb27w0/Dt7Dp6Dx4ArWGrAdxRmewtdrrI1G9ipr
C5EdhK6BG5E3ISvmf1bwfydY245smrez/YD/R+G74eMa+7dB2eA65LORb0C+
DTyG87Xhax1rR9A/FFisK1j7FPkm5IuwbULeEfw09DOyS9CLyK/iszf/Nh9/
V8BzWOuB7iloKDiP843nfPvRHyDbdPxZdv+xPgdQmWEx/5O9L+CjGn8N2Ht0
q9Px1h1fRX4Un2uTdgdfgI+h0xF/Vdh/Be6P/k34K8gfBz+n+CbtzqeAz6bj
qRh9jb/T0Oq4nUm5OTO02G9AHgstBorFKvjj4IfRv5GwPXLBreh0Rj6ctcXI
F0WGlU8TkQ2Fj8EnoWHgVyLTHwG/BDwYioPbcQcDuIvyyGQF2Jfj/yJUmLA7
UO4rp5RbWquJbA/ttQraCc71lkvV3G82uutY6wEuQn8r+t97qx2tDUS+K7Ra
vPX/gdWkeO2/ODSf8j1VfGAxUWzUM87jr5G1hUnrAeoFt3oG/1eHfov2Rr7b
mc6HyA+ztilud6i7VM4p9xTTI8h7wjeiXw7fCH8lsLPr/5ULTYHJFFPFVjWk
WloJ/5n8B4ZVo6rVj+HLktaz1LtUo7q/6firxd/lwLByQrXeCT4Pf/ez1g39
N73VVk/4t9TfkDcjX88/zkX/sdByb1c75/opFsgrY9YzD6E/FgrAb2AzDlkx
Ovkx22M4/DLkv8ue/ZeD50K90L8JvaD6Qee4sxyfJ/+h9bLd7NcX/Je32uvF
+W6Ap0d21jroMvie0M5ajn1AfsVYWxC3M7QHF0fWm1XDM8GTvPVyxUCx2BGY
78msVSDLiSyXlbPK3TxvvV4xVqyVswXp/q7cqgnsLtWD1Iu2sjYJfAL9WvBJ
b/mrmvgW3XmccSe10BGb0ehfCM2f5OfBWyLrpXuIyVrNA2+9TDOm2tsZdVb1
kPrA7kB3oR72DvbfhHbXOkMp8hPw78btzmfA/8veWc7yoR2++qUsFup56n1j
Utb71JPHgiPoNDiB3RDwvZLDPwQV4W9paL3uE/xdBA/z1ltl41P2j/rXXPg1
3nqOeo9mWDyyGlWtNrOW0qzwhjVTNFu0h/ZSz52N7G1ombOc2wjug/yfhNWc
am9HaLWsf6zXeTiDz7CZcyf6T6SsFyknlyo3sZ+fsDeD3g7HIuuFyqHK0Gai
ZuMsaCVYP6u3QY36u7cYKVby0YBtKrBZXgrfGfnSyGw1g08FNjM0O3TmHG8z
S7NLb4RW8H50SpP2xtBbY7W3uytDXhnYjNKsOgD97a0HqhfKZg/80dB6k2Ze
SWBvAL0F1CP2Iu/L+X9NWs31Ae9FZ1bSZrRm9YOB1bLWauG3e/tXzdR6vVVC
qzX1APWC9fCDYhZD9WLliHJFOafcu8vbXSgGioVmuma7cug++AOBzbIv4ePw
WaFhvWH0lslO2WzVmbuDz0b2ltKbQG+DgaH1Jr3p9Lbr4tN3lZ69+YHVot5I
eiud8/b20pn/UKxC6zWa4ZrlQyJ7i2imabaNiuytpZpV7erOdffKwQ7Y/g96
1k1d
             "]]}]}, {
          EdgeForm[], 
          RGBColor[1., 0.6, 0.], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJxNmguwVtV1x88933e/77ywU9spkD5NG+QlyEOM8lIQwssaZdLajq9iahJQ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             "]], 
            PolygonBox[CompressedData["
1:eJwtlmmwjmUYxx/ve87rWd4+pKZCqiOEorKcyhLJEo5sKR9SnCNkOcp6iiMU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             "]]}]}, {
          EdgeForm[], 
          RGBColor[0.9333333333333332, 0.3999999999999999, 0.], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJxFmHuwlWUVxvdh73P29+29nRSQSmfKc8HDARTMSJBLGgVqYuV4AQlFLgIi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             "]], 
            PolygonBox[CompressedData["
1:eJwtlltsVVUQhhfnnO6z9z6HxAASwESlWmmhxhpQuRQCUVtAWoQQBAqoUIzc
CuGiBBAEQVBDIkV88IUoykU0DbwQSrkEIVHAIOIFMDyo0Wh80EixQo36/fn7
MMn/r5k1a/asmVm7/5wlk5syIYR3kBwyIQ2hV0kIa5DXCiHMS0KoRfEmvAT8
EGu/gs9nQxgCvqcYQgv63kgpuCMOYSS60fAj+BqK/ADv3y2E6ejOIJ0c+Ddr
K8Az2bM2H8Jh1nbAX8BndRTCz8iDnDcWngUvI7a+6MfDS+AbFCv8BjbPcdYd
8Ah+nPNWE99apBM+Cf+P4b+Z88uxncP+u9lfCZ+Ffh/2jdhWEs/74FOsdRDL
9/AZ4BPsuQjejv/j4A/YP5/9C5FD6HuwtiZrm2PgT1kL4CKyVLnAvgP/b7N8
H7wJmxLi/ZLzF8A/gs+G7+LMA/JPDHOxX8LaNvgI9t+An+G8bnzLJdY+RNeB
/+Xsvwjfl3OOG2LHrNi1Jt1TiX2/AW8B/5PYt+6oE7wVGQTextoh8CnkJLHt
hp8Ffxd7r2JcD5+BPJJzzvYSa3ViW9XAN/KNTAGnyETFqjNyvqPN+NoAfxrc
qmKDb0Lm5Wwj24OJY9GadEfhO3OuuX7wleRjeOQYFWs5MVxH345UgMeQo9vy
vpPR6L9lTzP2Veinwm/B341cI6qVw6w1K3bVMLrV+B+FvoycLYZfSFy71/D3
BXg5+mGRY1gBnpS49vXNozj7AdbOZe2zClyTeO8VcfRH4I3BNq3gkYlz9THy
NfgtZCX4EtKL80/DB2RcM2eUT9YuwyP2n48twqrZqeAdnDmd2GYge+E18Ezk
HqoFl8aORTlVbvXN+nb1eE3smlXtdkc+B2/BpiK4RlQrJ1LPBuVQuZSNbNXT
p8Hr0NeUOOfK/fqu+tZ9/wK+wlq/rO93A7YZeFvONaHaaGOtBV/n4MfA7Ylt
df51cF3i2s9wx0PJ52L4ZPT/cd74xDXV2lWv65Rr9QD2U1A9HjvHyrX2LAIv
Y+2vrHtKvaWZpNmktQnw8cTQk+/ZglwA7y2494dxfj3nz5R9xndyALwLKS1x
Tao265SP4JlanzoHrV3fuxHcp+hZtACffcFDip59uvPB4IOxdZo5mj3Div72
Bu2BvxS7v2vx/zL+L8fGugPdxSupZ6P4JvA45MnI3/RE6m/St6nmVHvPq+fw
PRibpfgfmLq35uKjD7rfsLmT3NTpfUD3Y9f8eBa+G/5q1/0rps2p3wy9HV/h
I049YzVrNeP2gN9LvVczRbNFb4DeAsW4Ve8PfCfxVMGbCv5mfXuZZjD4ZOpZ
r5p5hv2/60z872ftj9R3rru/Ci8veIZrlmumVsMHFKzTnU3D/mjqt2sUPm6y
dyD5bo880x9l742Ce0s93K5eR9qI52HWzoObYs+OMfC18BeRkZHfNL1tq9DX
R34T9DaMwH9VN69Vg/egnxa5Z9W7qmnVtnysgg8q+u1QTJXg11PXku7kGns3
pp516rGr8HHYDKReehLTIvhE+PC8Z9wn8LHw8rxzNjRxTau2ZSPbfOpZpB6K
Ur/BeotnsX+n3tKivzWP/i7wv4l7VzOju95XpCHyTNJsUg2plvSNzfAkdW2o
R25HV8H+bNZvtt5uvXl6+/Rm91Y/F3z3ytns2P8g+hf5k7UKbHsWXSu6kx7g
WqQs7x69n/33xv530Buht6K86L2KUbFWYfNT5BmvWb8w8bdprR+2ywq+a/XI
fM2a1LWifxj9y5wtuHf0DZ+pX9mfy/oOdBcLY9+Fcq7cN8b+N1GMinV/7Nzq
H2cc+2+lrmX1wE3w/wLiKwE=
             "]]}]}, {
          EdgeForm[], 
          RGBColor[0.7999999999999999, 0.19999999999999996`, 0.], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJxFV1lsVVUUvfQNvcMDgqb96ECYlCkgVQzPH5EfiiiTxkrFoELLEA0So1JN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             "]], 
            PolygonBox[CompressedData["
1:eJwtlVuIllUUhrfz+/+z9/f9GhQWmF44Zh7Cw1TWiKBJNEk1oyZmQyUiTdrB
Q2FJF85A42FmoumiCewinbpoaNQ0BTvgUDoaNB7SC0HRIpKgUsrTSGpGz8vb
xYJ3rfWutdde+1vrG7Vk5ZMrKkIIryODkVN5CJtKIUwshPBpFsJz5RDWVobw
JaTOGMKzyOhBIWzHPzGFcA5+WzGER4n9A/wOMV1we0nWAX4Z/l64Xejfwe8X
h/wJ20rw3Myxt5NjHvh89NnL4PegH4DTCj/iX4NvNzk68K1SfvA3cB4quEbV
eh19N9wfifkTPJX439BXc8Zw4puxjYT/GLZ14A3J531CzevxV0VzrxE/hXwb
M9eimDP4/kE+xreW+H34ziXftV5n4juGrRX8Brb38S0kxyJqG0D/VXfFdp34
bvRj4BHEHCX3FuRu9M+Qdnwj0FvAdxB/tuQ7XSP+Lmyb8R1BhpbNEVc9bybX
TPSL8DvJ8TX4+ei32ozel9wz9e4wMiS6p+ptHTEtuXum3vVguwCuTe7F38hk
zmuEX11yTartVWIy8negHwZ/gP9OYuejv40+gOwBN8LpBFcTcwP9Z+RWcF/u
u1yl/n3ELuS8amp7nBzrOX8AqQQv5U2ugB+I9qtH2+G2Yhsa/AZt4EO5a9EZ
OmtD5lx6P739I9hG8R5VfMPPkGs5/O6C77QC/FVy71TzFfTbyq5VHHHr0Gsq
PQNbib+KbTT5X8BfTu6xev0R+jjwOPjHK/wNjgf3EPNXcA7l+j25tl78g8k1
KBrrjrrr/uhaR8J/uGwRVo6n8N2b++z34N8HruGOgfifsM1O7rl6rxq6o23y
qQfqxf7cvdeMHQRfJn4r8VX4a/FPwvZL0d+Uvq3xyXdr4rx+8jWUza2nxqfB
k+GfLTpGsV/AXxBsm4I+TfNC/BziXwLP4rxJ6AfwD8F/T+679GObAK6M9tVg
mw6eQMy2omu8mHmnaLco5yvqF7amomdUs9qeeTY1H03qfeZvu5mYQ+h16MOK
nlnNrr5xfeuaUc3qEWp4F/wg8iL8QvT3phouZa5JtWlnnszdE/VGO+573Sfz
7Osb6YqeCc2Gduam6BpUi3ZkTfKO1a6dJw7c2dHfvnaIdsmM5N5oxsain/9/
/6gm1bYMub/kmlV7I/6Ggt+gNnrnaveKswr8efLuW0qOXck7S7vrBDJM9SI7
K/xGequ25H14ECnh+zd5l8zEfxP8ROba1dN67e/Mu1I5+sBjk3fdh+oJeF3u
3aMZ16zvRd4Ez8K/ODmncsvWi++H5N2pb7yB81/L/TbaQdpFczL/S/QNtOd+
c729duRbxA4k166dr92/Mfnu+qfo3/Jt5rP1T7lBbMrcC/Uwgk9H59J87oB/
S9l30U4eg96S+d+iHqlX/wHxAvVv
             "]]}]}, {
          EdgeForm[], 
          RGBColor[0.6666666666666666, 0., 0.], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJxFVm1oVmUYfube9z3nPOfNGRjSHKzoC9RYTEhWEdtoH+Ags9jSrYgil3+K
fvVj4AJbg2aROSJ/NAdJ0tLFhpE1qHRaSVBUVM5tKTUHmpl9aEH+6Lq6LujH
4bnPc+7n/riu+76fc/2jT218ckkI4SyeSq6FEJYnIVxbEcJbMYTHiyHM5CEc
T0NYAoWvIR/E3gSe/Xgfx3qqFMKbkEdxbg3kRciV0P8Qts5nIVyFMxn0mmCv
Gc9t+L4Ue03Qfx1yNXz9Av06yG/j+3Z8242gnsHe1oL2a4Ji4dlVkIegVwv5
FHT6YWctnmmc+Q37e6kDv4chN0G+Ap2rIU/g+zKsndA9hP0v4PclvG+A3Rex
PgJf19lXATFM4f0s7LxbVM48M4D8ni8pvkHLTwRhsKcoHNphvw3PJN5/SBUn
461L9J3YMk/mdQHf6xPF2RD0vdc6M7D5QIXwYWw7HN9O2H0Fzybofxf1/i3W
9fj2PuJqx353on3qLCCXvbD1I9b3sJ7B/ufQa03EGfni+wL2H4R+P9b5gmJi
vnWuB37n2a6gHMk1a+D7qHhKwKqrHMII5HbktRb+FiHXG0vmuw9+dkLugdxR
KXuLtrktERbMoS+RX+I8WxS/zOtAJn5uh/03StInbsSJsTLOzyrlg/YbCqoZ
+qUN2mKdlDNhcRmxNSeqxa2w02iZmHNt9D55Ib/khpwPmHfq0TdxHjBf3Cd3
J61D7Bkr4zydisML8P8NfH8MmwnWOawXS4qN+VOf+Q4nOv8B9vpT1cH2TDVN
fo5E+Zyxr5VRutVR+RNncso+ow7jJbdzBcVDbNhXxKcFvg5AHsPeGM5vgXwe
fubwdEAexN6uRPgytmeLssO+egE5bIT9e91z87b/ZVFc8MycMWEst5SV792Z
ztMO+3pFUXaIwWXYegfv95RVq+w/1hsxYRzEaCgXZrtT5bHFuTAv2qVN+pw1
PqyB9ZX/9whnHWfeXalq5WQuzGrcC6ynXmNI/kdcA6+mwvkn6D8EGz14zuH8
aKpeWh3FMbku5uKM3I1jPRNlh73CGcl5xRlxIle8d6byz7jodx1nBOSv8P2+
KIw2RM1H9sdR7A96Vr6M/a5EM+4j6N2cqX5rUvVvh3MZK8kOsVhaFj43ZuKp
w/gQtxnzRT3qk5c7ou6ChijeONsZN+c75SH4uqasO+LvKD3qH3cenLe1nnMj
nkXMlVgztpsy1UpVWbVzuihOViHPecirc8W44LnBnp5zX3elqpmHc+XCOiFP
f0bdVZei6nxPIr2qVDW6MheH5HJz0PwZ9zxn/VGXtlmDrEXeHewV2iJ/nBXN
vs9abJv7x3LNiyO59CfdX5uNz19Rd8WE96vdv6wvxj7s+GfNHfPt9bwmVqxf
9v9/2MHm03jfVNbs7PN9w3rgnCEHnJfbfN9MR836o1hfS4Uf++kT35W8M9kv
/e6ZS8bwOej8E3UvXoma4QvmkX5Yd1VB3DMv5spe3eUZfiKqV2ptr89zvtb7
90fNvGH3eI/nMGfXsai58ynPltQnrA32Geufd8P+KJk9QZ7Jx5j/T8gdZwjv
0nrfp+T0oP9nljn3Halib7N+d1k6j6W699p9v9c7RvbF4VT/BNO57ropxzPv
+iR3v0f1PP+P2KPkhrzcmqvOV6TSnbU+eRzw/0ar72rW3ppMOS0vK55Rx8la
YE3wProh86zNVDu0SfzJT6druCrX3OP8I/Y9xpn/Dt2ejcSn03E2etaxRyaN
D+Pg2u4YOL84DxLbrPb9yLi6Hduvufi7iLW1rN74I6p+aZfv53LNqZ+NJ+Pc
5xrr8nzj/GE9NPifgHhXYC3l4ned764pn23JFXsb9v8F3GtnLQ==
             "]], 
            PolygonBox[CompressedData["
1:eJwllNtLVVEQxlfnuI/77H30EBQ+KF3oIumJyp4sCPKhgoLMoOxmZRT6UvQP
ZFAolF0MggzKHoTokJbRxQoibxX0EBaVmWZUCpqVXbCHCvp9zMPANzPfzJq1
ZmbNrjxQtj/inNuCZCBrfOcues41ISOBc7XolyHsQ0+jZyMDEAeRJLgssNgz
+F+Ddyacq8l0rouYc8SuiDs3ESMG/4LQuQL05qhzD4j/Ab8TWy3+OqQD/rhv
Z+1FruBfgn8YfAd/gtgs8vcrHzIPvRPOSvId4swKfIXwB+FvpqZ2/FPIlwe+
z3kZ+Bp9q0015cP/gK0ZXAznH74Z5BuFm0eO8+hVcJrIneaMFPmW428HR5Bl
4Deh1VpAfB/4eWi+h9hegB/DOQxu48xH4PG43X0mnDHwkG9Yb3IK/0ukwbMa
VMtncqSpby3+3sDuqLveJd9ZYmNxe3vFvAqMI656oF6cQC/FV0S+crj5yAX8
JfhLE9YT9UZvVgDuR4rhLoLzhfw/iW/xrL7v6jUxBzPNtiphOZSrmvvPJ/dp
ONXEz4L/nvij5GuF20i9R8C34TTgf4YtqV6E1vsq4nPRU+jbFYt/IXgT+XeQ
f4yYPs0ftsVRqzEJ7g4tt2aoB7xeMwnOIX5DYG+kt5LtGP65nP82ZjOkWarG
lgLfgF/pWw2qRZxs/Dm+1aKaVftH+PciNjOfwEXIiGczqlnVzGn2ZFsaWo/V
X/XgJPVk+jYrcfQs/HnYnkQtZy64Ff6uDJvZFvBfbLc8mznN3nHfYrWD2sU6
ZJ1nO6pdzQ3tbZVTubXD2uUh6p3KfX6jt6HfRLahT0vYbMs2HTyhfsWsB+qF
ZkazU49cB6/mjK3OeqLeFJLvacT+jGHwZGi7Ktsl395Ub6uZKYdfgf+aZzul
3dLOafe0Iz3E70YfiVpP1JtubDWe7XgHeI9vtetN/qAnE/YXaKbnUF+9b7um
GSnR7Ac2C9qhsdB2WrutO34L7U66m968Bl9vaPdVz9759sfpr1MNXYG9od5S
M/1L/Qxt15P6P+FvDGxW9SfqbxyN29+jHg34tuPaJb3BJNgLbVd0Zgz81bfd
0w5dxf8fvfPAvw==
             "]]}]}, {
          EdgeForm[], 
          RGBColor[0.39999999999999974`, 0., 0.], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJwtVDtPlEEUHWC/b2dnCGxYX8hLarCxEwoTMDFqCGExxqyKRgqg0Qj+ATtj
NKJYoD0JCZoQChMbbAQ6E9n4LFhZDVqIWEGhJp6Tc4vJ3LlzH+fee2Y6r90o
Xq91zt3BqsOazDq3AGEOqzvnXGvq3Hi9FuWR6Nwx3C3BqQv2lyG/hnwG8vHE
uU6cP9U41xOcq8W5F/tt7JWMc33mt4a9B/ZF6F9BPw/dRkZ31LfA5zvOrdhP
AE8BawQ+H3Gegc95YGlLlHsFPleBqQPYLnjnZrPyoT3roJ61FExP+4vwvwV5
D/GaEedHRvjp61LlWEzUC/oeRfwKzt1R/sxL+6ms4txEvQcQswrf1nr5TZn+
QxDWIvaunOJdQZwS7u9CfxZxdqJ6+BT4t4ClHzanoX8flCvNSbeRSE9bysRQ
sv6wBs6HuD3yZrxmkY3qF2s65dUDyqyDWObN/gl8xxLN9J/XrKo2a+o5o+fA
MwF5x0vHO9pPI/dAnTDuAusqznvEHGSTj7IftzgvbTbkSU0i3lBmz9i7RePF
hNnvB/5N4NtnPeZM6f8sKOYvrzjUsefMT/82p1xVsx+EzXAifdHmMoz9YZB+
06uPK8bnB9APkbvQdwBXe1Zn9uyc9a09aB7vgjhOHpPDS8Zp9od+tB80P57p
O2TyoO0dpmfvKxaHnGB85plJZUv8haAcTdjH6sWl9SBeVIwn5MOmcYL1Txon
2zCPdejyiN2A9QbyYeM4/ZmP749cZJwNr9xvo3SHEmHj3BmHs++19/43CEvJ
OElODNh7afSK9yInTOQf6x2x98m3cCSn/uZR00pQL8hH5uyzf+OL198xjfuT
UfnKQfkK9sb/BNU66vXf9Jtvk/XtvhfvHqd6J6y733CWo/Tr2Le93sbnqPst
mwvzlAxz2WrmHHaNM+TOQqr/ZcD4XmM8/4ZYc7j7GoVt2vpU9eLHI/gGvlF7
j41RcgP2Pru758WvYDbdNr/f2FOsZcgJ9p9ROLajesi87CNnRTzsUd7e+aWc
/lzOviWKF8RGjHxPy8Y9zo9zPAgMq/a/rwXV2Wz/Ev/RWfuH+efM2r/zH3Qa
xd4=
             "]], 
            PolygonBox[CompressedData["
1:eJwtk01L1FEUxo9j8/fOvYNOZG86w+Ta2rQRo9VoREREGhTZG7WoNonUF2gV
lIFlFH0AQbAgghZtatMobYImeqGF5hTVotFWFtSi38NxceA595znnnOfc27f
ufGRyzkzq2EbsFbB7AVgHlsD3w9m2/Nmc5nZz2R2GiuDQ5vZMWK/C55bgXsD
/IqzQfLbsMFo9g57SYFT7Wbvo+cod5T4bfz95E+DjTv3cXdW8NwKZx+IDxfN
qh1mR/DX8Ev4s+AZcvrJLcM5BG5wVgFv5b4DXLeEvwv/Hv428Dd67IFfht+k
1jM4A/AnOTtM/CjWJLeKX895Tx+jv0FvyWF7ot+hu75jveCVdb1GiH+G/xR/
Cv81fif+HDkXwA+o2cLP09PzvHPEnYrOnaXmdeIl/EViS9jG6BpLa2kgLX4l
f5s0XQWPRtdKPav3hjTG/6GZgFfhX1qvp9m2ks9Smkm7IeygOWcYfIv8J9y1
m/gQ/DvRtZHmO+D3JH/bAvFuYufJn6C/q/Q3Rn8nsCvgx+T8Id6bXCvNpCv4
mWLL9LCZ3AX8a/g17quD/0XXWnf+BY8VXBu94RF+d9G52sGdxErBZy/Npf0b
6k1nvmMDwTUV/yI5D6NrKm1Vcx7cTF57Bs5X8JfkWDuj3ZnEYt5notksB99d
7Yx2RzVUSzPN4H5KPut+zvYGn4FmoT+kv6Qzxer4XeSeLLjW6lFvbXB2N/M/
pL+0Erx37ZB2qTM5Vz3V8M8k/wtVOGfBx4Nj7fiWos9Is9JMN+ntwf+S+r+J
3wGnr91rvk1+ppg0XNT/jj5bzVSz/Q+Xt4cA
             "]]}]}, {
          EdgeForm[], 
          RGBColor[0.1333333333333332, 0., 0.], 
          GraphicsGroupBox[{
            PolygonBox[CompressedData["
1:eJwtUj1LA1EQXBMv3rsnElEsJCdqq00gIJiARVJbWAkKimUK/R+iiIJJ/oKF
VlrZR8voDxBjY6No5UelM8wWj92bt7szs+8W9g429gtmtoZTxHlIzAY4twDv
Rs0WAc4Bfw9mVeQfqdkz8BryOvA+4ol/3wRhZdQcZeodIn8qYQZOD9/zQfEM
93kUXwWxm4oz976e8y4F9ZfHheUl4ayhvouCuKlpGfgU+ofIpxEtk7ZrzGi7
F9ZTS+56LlGzirst98d7zlnB9ytqKuB9i9JGjZzXKorzJ0jDJO77ieawt+K+
3hEDeu6B/6L20HV8I06k2hV3NgOOMGK2CezLdXDf1MSZ20F85G2YvNHjbPR9
lNTfGTM7x1lH3R/4u55zXtt3RS30wHfjfcdreEeM+mMiP8z5L3Am/b+k2iHf
lu9E7DHTDtqJZlxlyj9T9XIP9NmK0tREPM2kh/vgu0XnIg97Gs5bc7/0yrq6
13RcD3dTdc2sHTgX/bCOvbtR+9lBbGbiOk7ltea9//CnXGE=
             "]], 
            PolygonBox[CompressedData["
1:eJwlkL1OQlEQhEcv6rn3EHPVxASDRGmtbKWUJ7Cy8C82JLeQJyEECvEVLLSy
sxdbpTdgYyPRSqXCb7PFJrtn5szs7O5l++hqUVKFKlGzVHqmeUqkM/pWWbpe
kQbUKJN+eSvA98F/6E+oA+MvSXmU1uGMmSfUBv1W9L6B9mqQTuHfYljAvwf/
Cq5lGnfM38GxIfMf3HP+15alN2qPeS06VkMvwJ0yv8B/RPOT/gFOt+QZUvC8
7H9v8NgBm/BWTzxDD788+G6msR09o2WdMzejZ7JskToEq6L3gV66IG3Sd4Jj
ltmy9zP3Mo93sDmezcR3Ethr5rvaTe22dmO7td3EbnMcXNsyX+D9D3MpNQ8=

             "]]}]}, {
          EdgeForm[], 
          RGBColor[0., 0., 0.], 
          GraphicsGroupBox[{
            
            PolygonBox[{{2057, 45, 2484}, {2552, 819, 2288}, {2734, 1083, 
             2397}, {2398, 1083, 2553}, {1083, 819, 45}, {2397, 1083, 2398}, {
             2560, 1229, 2559}, {2056, 1479, 2833}}], 
            
            PolygonBox[{{2484, 45, 1229, 2560}, {2553, 1083, 45, 2057}, {2833,
              1479, 819, 2552}, {2288, 819, 1083, 2734}}]}]}}}], {}}, {
      GraphicsComplexBox[CompressedData["
1:eJxtnAdcz9/3x7PKyojsIqVQktQ3IfciIzszq/AlWd8KoUV7p73s9JUR2dna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       "], {{{}, {}, {}, {}}, {{}, 
         TagBox[
          TooltipBox[{
            Directive[
             CapForm["Butt"], 
             Opacity[1], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJwV0L8rxHEcx/EP3/O9wSI/LlJKBulI30FJMVFXYhBlkm5hcoVRMVoYbMpo
8A+ITAyUushRBidklUV+ZfH4Ds9ev97fvt++ncXS1FJNCGEBc5kQGupCeItC
2KFHchGf/Dz9oS/03H7Mx3EIOfmQb6G1coQq36RrxLvbETqcev0icnw7Xca0
+xL9cHdCVzGjW6FfKOvH5DX+FBuYldfpN67tBXmTP8OvXMG4bkvuQeJ92+mG
Pj6PPzd3GOWj9PvdNyPv5lLupR1ymW+jrYj5qmcm+N30PyCDJ92NbY/vsiX0
Sr5FBd26evrsbpLft18gi1fdgy3R92NQdy8P0QH5kT/g/wF63TV1
             "]], 
            LineBox[CompressedData["
1:eJwV0ckrRmEYhvFXhkJKLFhS4j+QDGUofREZSgklipQobJSFlJRSSqyUYSkR
URaGKKWUUoqyUTIulLCS4XcWV9f93M857/eevtyuwaaBuBDCGEoSQyjFZUII
e/Eh9Mh96Ea6rhxleLTb4Grc2VXxPV/xDE9jCjHzM29xPRqTQqjlaxw4o8Lc
KO/gzXO7fKiv1LfIGfjQt/M7t/KL/TG2zNtYwir+0Gv/zT38gGzkm/v5FXny
ExfwF587p0r+lEejO+FTt6Cbj95Dqrvk6GNyDdLM6diXJ/UnnM9HfIZTZNr/
6P4whyzzLP86+waDnhlCHRoQZ3erH5ZH0IyW6HuxiFGMo9BzbdyBCayYx3iZ
i/xGCdbNm0iO/itzSvSdWENxdH++QKf8D7SGQ64=
             "]]}, "10"], Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[{
            Directive[
             CapForm["Butt"], 
             Opacity[1], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJwVz78rxHEcx/E39yMpyaDkuvyKLonLj2QziDIyKCWx2E4WizJYlCwGpYzq
+AvIqlskIlmQZNUtEpfJ4zs8e72e78+v77drdX2uVBcRazhNR7xmIkazEcM4
08uYMC/yZ/0jFZHlJxg0K8sm80b08QKe9AE5Yu1WL8pu3ot7/uaOlNkROs2O
ZYN5Bu38kN/oeT2HCh/j46jHNAKP7vlDf/Ieasl3yiEU9H3MOv9gTw27fJHv
yR7sYIbfWfvBFl/g2zKPTUzxa2tfKPF5viHb0eqdNlT1SXllTxUt+otZLvlX
2ZH8Cy71tPMZXPCKve9mv/qy/JYr8hwH+qf1ZrnE/wF7DTD/
             "]], 
            LineBox[CompressedData["
1:eJwV0UsoRGEYBuBfLklKJJaSZmFlJZGQ0kREIyWUUkopspGipKSUUrKRImuR
ohRyKUVKKUVslMillMtOyHMWT+/3fv+cc+bMFPYMJgaSQghj7CSHcJESwrbs
TQ2hjx6y7Kqp5NHZmqzjzlmtvJeXckZOM0Vcf5IbsomWtBAa5BV77lGjt5g3
efO5NvkqW+UN2XzqnfJdtstn1x2ypefqS3KFP5Lc71v22j+QT0zvly8UmQt5
d/0JH3a1+pccodi8Jw+Yj64jwz0L9Li5nkw9i13zpP2RjMl9ecIxOc5/7P6Y
I0+flb+eec2AzwzRSDPB2a39gnmYEj0R/R7RO7PICOOUOuuQXUxE34FRlu3L
PKeCVX2d9Oj/0qs4M59SHr2DPKfb/A9mVULO
             "]]}, 
           FractionBox["19", "2"]], Annotation[#, 
           Rational[19, 2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[{
            Directive[
             CapForm["Butt"], 
             Opacity[1], 
             GrayLevel[0]], 
            LineBox[CompressedData["
1:eJwV0EsoRGEYgOFfLpFSsheysLKSS4qUjUxESlkoUkq5bKSEjZSykgUpsnWL
KDUmlyhSSimShZJ7FNkJ8czi6f2+/5yZM2dy23sbexJCCENEE0M4SwphSzuS
Q+ikjQxnFZSzwjL3zqv1Rqv0Vs91QscZ45EH1pxHqE8JoUYviHlGpb3evMGb
+5r0RRv1Va/0mhbe7c365HN7bNqz7HO6wC/B931ph/MfvdNHungmz1kO7z5/
xIezKvunDlBgjukuU+Yu0nxnKtnOovZczbBvm0fN+5qvO3rEIZmuf8ff0zMi
5knzQfw32S/pdk8ftdTx52xGp+mn0L0N8f8j/s7MMsAIwxS5fqklOqqDzJuL
PauMJfsq6yw6P+GYUnu6ntJq/gcfMkiA
             "]], 
            LineBox[CompressedData["
1:eJwVz78rxHEcx/H3cUdKJiW66KTkdAZkvUGU9QZldZPBj8WiDBYlhUGUsuCS
f0D2W6TEYGCQyISSAWXy+AzPnq/X5/35fL6fb2F2sbKQiYgqXhsjznIRI00R
p1zDA+7xbJbLRhyhZF7jVustGNAP9Tt5UC7iRD7GsPU+/UZ+dEeDvo8eawdc
4BI3m+/yFe9x3nqdR/UxZDCR3uOObLo3vRN/9hQxJPfzJqacvbXvF+v6jL7B
vVjDpH5t9o0VfVpfTd/EMsb1S7MvzOsVfYk70e47HfiQy/ye3mzfZ5rrXek/
5W7O4yL9m/NzfK7X7X2Sf+QXrmJL3sYO3szb+B9eJTGV
             "]]}, "9"], 
          Annotation[#, 9, "Tooltip"]& ], {}, {}}}], {}}, {{}, {{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Directive[
          PointSize[
           NCache[
            Rational[7, 360], 0.019444444444444445`]], 
          AbsoluteThickness[1.6], 
          GrayLevel[0], 
          Dashing[{0.03, 0.01}]], 
         LineBox[CompressedData["
1:eJxTTMoPSmViYGBQAmIQnaG/cG/Lt0f2DCBQUOBg93IyECH4oovb9vsaIviv
YyodNp17aL96FRBMKnA4JJZzUCznIUT+RoHDjAtxTtWcUPmkQoe8rsDD95c9
gMgLFDm4gMED+1AQ2FvkYPonF6QCoj6r2OFRfnCP1L97EPUSJQ59jy2ACMp/
UeJgHS43YU3xXYj6W6UOz08xTypddwdi3tkyhylgD9yGyD8qdwA6diq7ym2I
/NUKh7eqW6ZfiLsFkX9V6TATDG5CzGeodnDjrZ+ddOUGRD6qxuFzQ8pcbf4b
UP/VOsz/4glE1yH8inoHH3AAXoPwexocftwWAYbYVYh9uY0OS/1/LfH/dQXC
L2xyCAKGhoTpFYj5bc0O/8yOrniYfxnC39fisAoMLkHM42hzAHv36UWI/tZ2
Bxagb20ULkLUm3U6bGCNBqILEPUy3Q67PoEcfB6i3rTXQfiWN9CFZyHyU/od
QLF1UOwMRL/KRAeQ7cE9pyDyeyY5gK1jPAnR3z7FAQBDQ+rU
          "]]}}}, {{}, {}}}, {{{{}, {}, 
        TagBox[{
          Directive[
           Opacity[1.], 
           AbsoluteThickness[1.6], 
           RGBColor[0.87, 0.94, 1], 
           Dashing[{0.03, 0.01}], 
           Thickness[0.01]], 
          LineBox[CompressedData["
1:eJwVzXk41HkcwHFbUaphxSqmHhNdW+tIjwrV52MfLGLNQ3SRyuNIlizbPr/R
yGjGTcoxUU1FNmepVgxCEtKmccyYGYOZbyl0aMmkQ237x/t5/fleeTjSK2iO
hoaGx7f+11TBma+hIQLxzcnPiRQfI4u0Gmq/E0HTYp2Ld//gY0NY2rGouSLY
WVzqMB3Fx90fcmRESwQ0IssLCeNjumFJ+QOaCFabRQfv2c9HNbPLM40ugpSQ
dqew7XzsfGB8znCLCB6ZhIS6z+Fj1I3b68wjRFA5yXo1nZmHfZ9CmwUjIrjY
mb8j/Eou6tfI5q3x6Qaq8ohS3Z2DeNrFlt3SDS6WrG7ZkhzkKO2eLbPtAZ3S
hR4mzGwUXB6177zWA1zDCJp98VnskhktbDbpheyC60HD6jP42tK1g5fbC4+M
ouvbfc7g6LtNmw7N7QMHp4+/itqzUG1daMBh9UGlSrPYbnMWKocfFd4Z64P6
rahtfvQ0CkunGA2+YoivSHuaH5uJxa8EP2g9FsPI59bkXm4G/ibQrAmyl8CV
wOSlS8rS0fXhRJf2bQncm5EPCDrSUF9PKmGv6weOgc52D3UqCttj0+bn9QNd
9XvpLvtUjH5feEe8WArb6HTFCJWC2nm8TGGsFMytVLLcx8l4q/KlQjUlhRC/
9ABnejK6EU+6/IgMfnz2QtcyJgkbeZFao/0yaPlXUT47lIhOhUtC7TzlcGFR
iONSx0QsMY86XtgohwOl7jHJQh5+FD+OkW8YAO0PGyN0t/Aw4H3lmG/hAFhZ
7rOwusHFy0mui8a+V8ChGP/ZcBsuTmeFFjUlK+BrX5uy6M4p3FrD2xD8RQFh
0ZMCBpzC3e4HDpqGD4Jd+FSetDcBU/fVLTJ7OghV9zeNiwMTML+/O9DWawgW
2GWXmn7lYF7Ui3KTpiEoYB4bkV/i4DVufJibzTAMfrJxZmzjYI6WWJxaNAwr
D1dn7yHx2BkvGUiiKcHH+0lCKDcea20YZj5OSsjfsZchtIzHFR9CDy88oYR7
uu57RI0ncTE1pThUowS9/Un+foYn8UjVgHnrGyUY1G445x0Xh8yrmnUd61Ww
wkXXVT3Exut/WeyoDlJBALn9U/UvbGQdrD5XcUEF3hUe9bSmEyiSsC2cpSqI
rDehEixPYM68qwXjugT8aCODJZWx+AQffjnuTKCF8XKfkXUs5thaCYo5BPJ9
18fTqljYPvZOf7iWgJvNiBnTjoVr+OllYiGBwOUZxm5bWch1XOXwTx2BPwe7
vB03sxAveUcIGwhkfZ3IsLVmoXDXrY7sZgK9ir0ma9ezsLwpku3SQWCm179C
x5iFp3PHn9/sJ2Dl57Rc9yOFb35OYJdICay0Wu2pN0Oh+1sjg0syAhYlq+7r
qylcsNPVIX2AQNCUd4TRJIUcjZLzwcMEbmRbiNaOUxh9NIhJf0GAd/VmDVNO
Yc+y2ed6owRS7Ze/95VSaNWWw14wRuBu8Ovj/hIKXzFay6bHCTiezd1ytIfC
IImppugNgbPshvqUTgpbT9Wdb5sgwHhqPHumg0LTjV7Wd98SOODFjStoo3Ao
jRNQNkkgoM7NoaKFwm22RurLUwSUE1kJ1c0UFjyvSue/I5BR8vfcpkYKZ7Jd
zDKnv/1Sylo7Gijc7aAUctUE4mxDHvTUUfgfNzFsSw==
           "]]}, Annotation[#, "Charting`Private`Tag$11496#1"]& ]}}, {}}, {
      RGBColor[
       NCache[
        Rational[5, 9], 0.5555555555555556], 
       NCache[
        Rational[5, 9], 0.5555555555555556], 1], 
      Thickness[0.01], 
      LineBox[{{0.5170835445683167, 765.0673288276087}, {0.5170835445683167, 
       605.0673288276087}}], 
      LineBox[{{0.5170835445683167, 245.0673288276086}, {0.5170835445683167, 
       405.0673288276086}}]}, {
      RGBColor[
       NCache[
        Rational[5, 9], 0.5555555555555556], 
       NCache[
        Rational[5, 9], 0.5555555555555556], 1], 
      Thickness[0.00001], 
      Arrowheads[0.05], 
      ArrowBox[{{0.5170835445683167, 765.0673288276087}, {0.5170835445683167, 
       520.0673288276087}}], 
      ArrowBox[{{0.5170835445683167, 245.0673288276086}, {0.5170835445683167, 
       490.0673288276086}}]}}, {LabelStyle -> Directive[FontSize -> 16, 
       GrayLevel[0], FontFamily -> "Helvetica"], Frame -> True, FrameLabel -> {
       FormBox[
       "\"\\!\\(\\*SubscriptBox[\\(x\\), \\(\\(1\\)\\(\\\\ \\)\\(=\\)\\(\\\\ \
\\)\\)]\\)\\!\\(\\*SubsuperscriptBox[\\(x\\), \\(1\\), \\(SI\\)]\\) / \
\\!\\(\\*SubscriptBox[\\(l\\), \\(c\\)]\\)\"", TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*SuperscriptBox[\\(\[Nu]\\), \\(SI\\)]\\) [Hz]\"", 
        TraditionalForm]}, 
     PlotRange -> {{0.1111111111111111, 0.5925925925925926}, {250, 1550}}, 
     AspectRatio -> 0.6172839506172839, ImageSize -> 450, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
     AxesOrigin -> {0.1111111111111111, 250.}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, AxesLabel -> {None, None}, 
     FrameLabel -> {{None, None}, {None, None}}, DisplayFunction -> Identity, 
     AspectRatio -> 1, AxesLabel -> {None, None}, DisplayFunction :> Identity,
      Frame -> True, FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], LabelStyle -> Directive[FontSize -> 16, 
       GrayLevel[0], FontFamily -> "Helvetica"], 
     Method -> {
      "DefaultBoundaryStyle" -> Automatic, 
       "DefaultGraphicsInteraction" -> {
        "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
         "Effects" -> {
          "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
           "Droplines" -> {
            "freeformCursorMode" -> True, 
             "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
       "GridLinesInFront" -> True}, PlotRange -> {All, All}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.02]}}, Ticks -> {Automatic, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{
       FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           GraphicsBox[{
             
             RasterBox[{{{1., 1., 1.}}, {{1., 1., 0.4}}, {{1., 1., 0.}}, {{1.,
               0.7999999999999999, 0.}}, {{1., 0.6, 0.}}, {{
              0.9333333333333333, 0.4, 0.}}, {{0.7999999999999999, 
              0.1999999999999998, 0.}}, {{0.6666666666666663, 0., 0.}}, {{
              0.39999999999999997`, 0., 0.}}, {{0.1333333333333333, 0., 
              0.}}, {{0., 0., 0.}}}, {{
                Rational[-15, 2], 
                Rational[-225, 2]}, {
                Rational[15, 2], 
                Rational[225, 2]}}], {Antialiasing -> False, 
              AbsoluteThickness[0.1], 
              Directive[
               Opacity[0.3], 
               GrayLevel[0]], 
              LineBox[
               NCache[{{
                  Rational[15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[-225, 2]}, {
                  Rational[-15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[225, 2]}, {
                  Rational[15, 2], 
                  Rational[-225, 2]}}, {{7.5, -112.5}, {-7.5, -112.5}, {-7.5, 
                112.5}, {7.5, 112.5}, {7.5, -112.5}}]]}, {
              CapForm[None], {}}, 
             StyleBox[{Antialiasing -> False, 
               StyleBox[
                LineBox[{{7.5, -112.5}, {7.5, 112.5}}], {
                 Directive[
                  AbsoluteThickness[0.2], 
                  Opacity[0.3], 
                  GrayLevel[0]]}, StripOnInput -> False], 
               StyleBox[
                StyleBox[{{
                   StyleBox[
                    LineBox[{{{7.5, -92.04545454545455}, 
                    Offset[{4., 0}, {7.5, -92.04545454545455}]}, {{
                    7.5, -71.5909090909091}, 
                    Offset[{4., 0}, {7.5, -71.5909090909091}]}, {{
                    7.5, -51.13636363636364}, 
                    Offset[{4., 0}, {7.5, -51.13636363636364}]}, {{
                    7.5, -30.681818181818187`}, 
                    Offset[{4., 0}, {7.5, -30.681818181818187`}]}, {{
                    7.5, -10.227272727272718`}, 
                    Offset[{4., 0}, {7.5, -10.227272727272718`}]}, {{7.5, 
                    10.227272727272739`}, 
                    Offset[{4., 0}, {7.5, 10.227272727272739`}]}, {{7.5, 
                    30.681818181818176`}, 
                    Offset[{4., 0}, {7.5, 30.681818181818176`}]}, {{7.5, 
                    51.13636363636363}, 
                    Offset[{4., 0}, {7.5, 51.13636363636363}]}, {{7.5, 
                    71.59090909090911}, 
                    Offset[{4., 0}, {7.5, 71.59090909090911}]}, {{7.5, 
                    92.04545454545452}, 
                    Offset[{4., 0}, {7.5, 92.04545454545452}]}}], {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]]}, StripOnInput -> False]}, 
                  StyleBox[
                   StyleBox[{{
                    StyleBox[{
                    InsetBox[
                    FormBox["1", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -92.04545454545455}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["2", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -71.5909090909091}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["3", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -51.13636363636364}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["4", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -30.681818181818187`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["5", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, -10.227272727272718`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["6", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 10.227272727272739`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["7", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 30.681818181818176`}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["8", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 51.13636363636363}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["9", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 71.59090909090911}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}], 
                    InsetBox[
                    FormBox["10", TraditionalForm], 
                    Offset[{7., 0.}, {7.5, 92.04545454545452}], 
                    ImageScaled[{0, 0.5}], Automatic, {1, 0}]}, {
                    Directive[
                    AbsoluteThickness[0.2], 
                    GrayLevel[0.4]], {
                    Directive[
                    Opacity[1], 
                    Directive[FontSize -> 16, 
                    GrayLevel[0], FontFamily -> "Helvetica"]]}}, StripOnInput -> 
                    False]}, {}}, {{
                    Directive[
                    Opacity[1], 
                    Directive[FontSize -> 16, 
                    GrayLevel[0], FontFamily -> "Helvetica"]]}}, StripOnInput -> 
                    False], {"GraphicsLabel"}, StripOnInput -> False]}, {
                 "GraphicsTicks"}, StripOnInput -> False], {{
                  Directive[
                   AbsoluteThickness[0.2], 
                   GrayLevel[0.4]]}}, StripOnInput -> False]}, {
              "GraphicsAxes"}, StripOnInput -> False]}, PlotRangePadding -> 
            Scaled[0.02], PlotRange -> All, Frame -> True, 
            FrameTicks -> {{False, False}, {True, False}}, FrameStyle -> 
            Opacity[0], FrameTicksStyle -> Opacity[0], 
            ImageSize -> {Automatic, 225}, BaseStyle -> {}], Alignment -> 
           Left, AppearanceElements -> None, ImageMargins -> {{5, 5}, {5, 5}},
            ImageSizeAction -> "ResizeToFit"], LineIndent -> 0, StripOnInput -> 
          False], {
          Directive[FontSize -> 16, 
           GrayLevel[0], FontFamily -> "Helvetica"], FontFamily -> "Arial"}, 
         Background -> Automatic, StripOnInput -> False], TraditionalForm]}, 
      "BarLegend", DisplayFunction -> (#& ), 
      InterpretationFunction :> (RowBox[{"BarLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{
                 RowBox[{"zColorFunction", "[", 
                   RowBox[{"Rescale", "[", 
                    RowBox[{"#1", ",", 
                    RowBox[{"{", 
                    RowBox[{"zMin", ",", "zMax"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "]"}], "&"}], 
               ",", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "6.764855749676994`*^-24", ",", "10.209881459295637`"}], 
                 "}"}]}], "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", 
               ",", "7", ",", "8", ",", "9", ",", "10"}], "}"}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                 RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}]}], 
               "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}], ",", 
           RowBox[{"LegendMarkerSize", "\[Rule]", "225"}], ",", 
           RowBox[{"ScalingFunctions", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"Identity", ",", "Identity"}], "}"}]}], ",", 
           RowBox[{"Charting`TickSide", "\[Rule]", "Right"}], ",", 
           RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]& )], 
     TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.8791718349401274`*^9, 3.879171848400981*^9}, 
   3.879171999484192*^9, {3.896067519655113*^9, 3.8960675383999357`*^9}, 
   3.896075750635685*^9},
 CellLabel->
  "Out[185]=",ExpressionUUID->"a99536d4-65c7-4dcd-acc5-f7a8e90c9cc9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\n\\nAngular dependency of \[CapitalDelta]p(\[Theta]) and d\
\[Sigma](\[Theta]) at specific point \\!\\(\\*SubscriptBox[\\(x\\), \
\\(1\\)]\\)=\"\>", "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.6\"\>",
      ShowStringCharacters->False],
     0.6,
     AutoDelete->True],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\" and k=\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"250.\"\>",
      ShowStringCharacters->False],
     250.,
     AutoDelete->True],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\":\"\>"}],
  SequenceForm[
  "\n\nAngular dependency of \[CapitalDelta]p(\[Theta]) and \
d\[Sigma](\[Theta]) at specific point \!\(\*SubscriptBox[\(x\), \(1\)]\)=", 
   NumberForm[0.6, 3], " and k=", 
   NumberForm[250., 3], ":"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757507856865`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"e260af66-1978-4ebe-8449-18bc06c3bcdf"],

Cell[BoxData[
 TemplateBox[{
   OverlayBox[{
     GraphicsBox[{{{{}, {}, 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            RGBColor[1, 0, 0]], 
           LineBox[CompressedData["
1:eJw12nc81d8bAHDbvfa6XElJG5VkNPA8qZBKaCiF0iBJyCiUhoyUEJLKymog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            "]]}, Annotation[#, "Charting`Private`Tag$11631#1"]& ]}}, {}}, {
      DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
       AxesOrigin -> {0., 0.}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLines -> {None, None}, DisplayFunction -> Identity, 
       PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, PlotRangeClipping -> True, 
       ImagePadding -> {{55, 105}, {50, 10}}, DisplayFunction -> Identity, 
       AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
       Axes -> {True, True}, AxesLabel -> {None, None}, 
       AxesOrigin -> {0., 0.}, DisplayFunction :> Identity, 
       Frame -> {{True, False}, {True, True}}, FrameLabel -> {{
          FormBox[
          "\"\[CapitalDelta]p/\\!\\(\\*SubscriptBox[\\(p\\), \
\\(init\\)]\\)\"", TraditionalForm], 
          FormBox[
          "\"d\[Sigma]/\\!\\(\\*SubscriptBox[\\(d\[CapitalOmega]\\), \\(p\\)]\
\\)\"", TraditionalForm]}, {
          FormBox["\"scattering angle \[Theta] [rad]\"", TraditionalForm], 
          FormBox["\"\"", TraditionalForm]}}, FrameStyle -> {
         GrayLevel[0], 
         GrayLevel[0], Automatic, Automatic}, 
       FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
       GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImagePadding -> {{55, 105}, {50, 10}}, 
       ImageSize -> 610, LabelStyle -> Directive[FontSize -> 16, 
         GrayLevel[0], FontFamily -> "Helvetica"], 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{Automatic, Automatic}, {
         Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}], 
     GraphicsBox[{{{{}, {}, 
         TagBox[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            GrayLevel[0], 
            Dashing[{Small, Small}]], 
           LineBox[CompressedData["
1:eJw1mnc8l9/7x+1NvI33WxJJ8hEpWZWrc0iKSkZG2aOM7J1NRJS9ZWRvbySV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            "]]}, Annotation[#, "Charting`Private`Tag$11677#1"]& ]}}, {}}, {
      DisplayFunction -> Identity, Ticks -> {Automatic, Automatic}, 
       AxesOrigin -> {0., 0.}, FrameTicks -> {{{}, {{0., 
            FormBox["0", TraditionalForm], {0.01, 0.}}, {5.*^-12, 
            FormBox[
             TemplateBox[{"\[Times]", "\"\[Times]\"", 
               TagBox[
                InterpretationBox[
                 StyleBox["\"5.0\"", ShowStringCharacters -> False], 
                 4.99999999999999999999999999953320808622`15.954589770191003, 
                 AutoDelete -> True], NumberForm[#, {
                  DirectedInfinity[1], 1}]& ], 
               TemplateBox[{"10", 
                 RowBox[{"-", "12"}]}, "Superscript", SyntaxForm -> 
                SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {
            0.01, 0.}}, {1.*^-11, 
            FormBox[
             TemplateBox[{"\[Times]", "\"\[Times]\"", 
               TagBox[
                InterpretationBox[
                 StyleBox["\"1.0\"", ShowStringCharacters -> False], 
                 0.99999999999999999999999999990664161724`15.954589770191003, 
                 AutoDelete -> True], NumberForm[#, {
                  DirectedInfinity[1], 1}]& ], 
               TemplateBox[{"10", 
                 RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
                SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {
            0.01, 0.}}, {1.5*^-11, 
            FormBox[
             TemplateBox[{"\[Times]", "\"\[Times]\"", 
               TagBox[
                InterpretationBox[
                 StyleBox["\"1.5\"", ShowStringCharacters -> False], 
                 1.49999999999999999999999999985996242587`15.954589770191003, 
                 AutoDelete -> True], NumberForm[#, {
                  DirectedInfinity[1], 1}]& ], 
               TemplateBox[{"10", 
                 RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> 
                SuperscriptBox]}, "RowWithSeparators"], TraditionalForm], {
            0.01, 0.}}, {1.*^-12, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           2.*^-12, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           3.*^-12, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           4.*^-12, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           6.*^-12, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           7.*^-12, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           8.*^-12, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           9.*^-12, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.1*^-11, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.2*^-11, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.3*^-11, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.4*^-11, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.6*^-11, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.7*^-11, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.8*^-11, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           1.9*^-11, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 0.}}, {
           2.*^-11, 
            FormBox[
             TemplateBox[{0, 0}, "Spacer2"], TraditionalForm], {0.005, 
            0.}}}}, {{}, {}}}, GridLines -> {None, None}, DisplayFunction -> 
       Identity, PlotRangePadding -> {{
          Scaled[0.02], 
          Scaled[0.02]}, {
          Scaled[0.05], 
          Scaled[0.05]}}, PlotRangeClipping -> True, 
       ImagePadding -> {{55, 105}, {50, 10}}, DisplayFunction -> Identity, 
       AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
       Axes -> {False, False}, AxesLabel -> {None, None}, 
       AxesOrigin -> {0., 0.}, DisplayFunction :> Identity, 
       Frame -> {{False, True}, {False, False}}, FrameLabel -> {{
          FormBox[
          "\"\[CapitalDelta]p/\\!\\(\\*SubscriptBox[\\(p\\), \
\\(init\\)]\\)\"", TraditionalForm], 
          FormBox[
          
          "\"d\[Sigma]/\\!\\(\\*SubscriptBox[\\(d\[CapitalOmega]\\), \\(p\\)]\
\\)\"", TraditionalForm]}, {
          FormBox["\"scattering angle \[Theta] [rad]\"", TraditionalForm], 
          FormBox["\"\"", TraditionalForm]}}, 
       FrameStyle -> {Automatic, Automatic, Automatic, 
         GrayLevel[0]}, FrameTicks -> {{None, All}, {None, None}}, 
       GridLines -> {None, None}, GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], ImagePadding -> {{55, 105}, {50, 10}}, 
       ImageSize -> 610, LabelStyle -> Directive[FontSize -> 16, 
         GrayLevel[0], FontFamily -> "Helvetica"], 
       Method -> {
        "DefaultBoundaryStyle" -> Automatic, 
         "DefaultGraphicsInteraction" -> {
          "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
           "Effects" -> {
            "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2},
              "Droplines" -> {
              "freeformCursorMode" -> True, 
               "placement" -> {"x" -> "All", "y" -> "None"}}}}, 
         "DefaultMeshStyle" -> AbsolutePointSize[6], "ScalingFunctions" -> 
         None, "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& ), "CopiedValueFunction" -> ({
             (Identity[#]& )[
              Part[#, 1]], 
             (Identity[#]& )[
              Part[#, 2]]}& )}}, PlotRange -> {All, All}, PlotRangeClipping -> 
       True, PlotRangePadding -> {{Automatic, Automatic}, {
         Automatic, Automatic}}, Ticks -> {Automatic, Automatic}}]}], 
   FrameBox[
    TemplateBox[{
     "\"momentum transfer \[CapitalDelta]p/\\!\\(\\*SubscriptBox[\\(p\\), \
\\(init\\)]\\)\"", 
      "\"cross section \\!\\(\\*FractionBox[\\(d\[Sigma]\\), \
SubscriptBox[\\(d\[CapitalOmega]\\), \\(p\\)]]\\)\""}, "LineLegend", 
     DisplayFunction -> (StyleBox[
       StyleBox[
        PaneBox[
         TagBox[
          GridBox[{{
             TagBox[
              GridBox[{{
                 GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                  ImageSize -> {40, 10}, PlotRangePadding -> None, 
                  ImagePadding -> Automatic, 
                  BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                 GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                  ImageSize -> {40, 10}, PlotRangePadding -> None, 
                  ImagePadding -> Automatic, 
                  BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
               GridBoxAlignment -> {
                "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
               AutoDelete -> False, 
               GridBoxDividers -> {
                "Columns" -> {{False}}, "Rows" -> {{False}}}, 
               GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], 
              "Grid"]}}, 
           GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
           AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
           GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], "Grid"],
          Alignment -> Left, AppearanceElements -> None, 
         ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> "ResizeToFit"], 
        LineIndent -> 0, StripOnInput -> False], {
        Directive[FontSize -> 16, 
         GrayLevel[0], FontFamily -> "Helvetica"], FontFamily -> "Arial"}, 
       Background -> Automatic, StripOnInput -> False]& ), 
     InterpretationFunction :> (RowBox[{"LineLegend", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{"Directive", "[", 
                InterpretationBox[
                 ButtonBox[
                  TooltipBox[
                   GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                  BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                  ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                  Automatic, Method -> "Preemptive"], 
                 RGBColor[1, 0, 0], Editable -> False, Selectable -> False], 
                "]"}], ",", 
              RowBox[{"{", 
                RowBox[{
                  InterpretationBox[
                   ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                   GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                  RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "}"}]}], 
            "}"}], ",", 
          RowBox[{"{", 
            RowBox[{#, ",", #2}], "}"}], ",", 
          RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"Directive", "[", 
              RowBox[{
                RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
                InterpretationBox[
                 ButtonBox[
                  TooltipBox[
                   GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                  BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                  ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                  Automatic, Method -> "Preemptive"], 
                 GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}]}], 
              "]"}]}]}], "]"}]& ), Editable -> True], Background -> 
    GrayLevel[1], FrameStyle -> Thickness[Tiny], StripOnInput -> False]},
  "Legended",
  DisplayFunction->(
   OverlayBox[{#, #2}, All, 2, Alignment -> {-0.09999999999999998, 0.5}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", 
           RowBox[{"{", 
             RowBox[{"0.45`", ",", "0.75`"}], "}"}]}], "]"}]}], 
     "]"}]& )]], "Output",
 CellChangeTimes->{{3.8791718349401274`*^9, 3.879171848400981*^9}, 
   3.879171999484192*^9, {3.896067519655113*^9, 3.8960675383999357`*^9}, 
   3.896075750915685*^9},
 CellLabel->
  "Out[199]=",ExpressionUUID->"c364cceb-017e-4d7f-ba8c-025770b3752e"],

Cell[CellGroupData[{

Cell[BoxData["\<\"\\n\\n--- Formulae with some values cleared to show the \
main dependencies ---\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075751050686*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"623e6f2d-8ea9-413c-8498-d6aebe6f54e9"],

Cell[BoxData["\<\"Approx. max. wavenumber (dimensionless) and frequency (in \
Hz):\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075751053186*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"6e0d3347-b9a3-4088-8162-d582d2e08e6b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \\!\\(\\*SubscriptBox[\\(k\\), \
\\(max\\)]\\)(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"0.0912\"\>",
        ShowStringCharacters->False],
       0.09119726573591151,
       AutoDelete->True], " ", 
      SqrtBox["ReyC"]}], 
     SqrtBox["x1"]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    \!\(\*SubscriptBox[\(k\), \(max\)]\)(\!\(\*SubscriptBox[\(x\), \
\(1\)]\)) = ", 
   NumberForm[
   0.09119726573591151 $CellContext`ReyC^Rational[1, 2] $CellContext`x1^
     Rational[-1, 2], 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757510631857`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"ed331df8-e8bd-4e4d-88c9-96612f44f192"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \\!\\(\\*SubsuperscriptBox[\\(\[Nu]\\), \\(max\\), \
\\(\\(SI\\)\\(\\\\ \\)\\)]\\)(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \
\"\>", "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"0.00319\"\>",
        ShowStringCharacters->False],
       0.0031931890404337995`,
       AutoDelete->True], " ", 
      SqrtBox["ReyC"], " ", "vFreestreamSI"}], 
     RowBox[{"LcharactSI", " ", 
      SuperscriptBox["x1", 
       RowBox[{
        InterpretationBox[
         StyleBox["\<\"3\"\>",
          ShowStringCharacters->False],
         3,
         Editable->False], "/", 
        InterpretationBox[
         StyleBox["\<\"2\"\>",
          ShowStringCharacters->False],
         2,
         Editable->False]}]]}]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    \!\(\*SubsuperscriptBox[\(\[Nu]\), \(max\), \(\(SI\)\(\\ \
\)\)]\)(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = ", 
   NumberForm[
   0.0031931890404337995` $CellContext`LcharactSI^(-1) $CellContext`ReyC^
     Rational[1, 2] $CellContext`vFreestreamSI $CellContext`x1^
     Rational[-3, 2], 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757510681877`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"719a1d2f-516e-4495-8f3c-f08e47bea0ca"],

Cell[BoxData["\<\"Approx. max. amplification factor:\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075751070687*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"7e48ea4c-9ec5-4f52-adab-46fb7a1a7dca"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    N(\\!\\(\\*SubscriptBox[\\(x\\), \\(1\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    RowBox[{
     InterpretationBox[
      StyleBox["\<\"0.0405\"\>",
       ShowStringCharacters->False],
      0.04046157694745245,
      AutoDelete->True], " ", 
     SuperscriptBox["ReyC", 
      InterpretationBox[
       StyleBox["\<\"0.426\"\>",
        ShowStringCharacters->False],
       0.42563819035358863`,
       AutoDelete->True]], " ", 
     SuperscriptBox["x1", 
      InterpretationBox[
       StyleBox["\<\"1.57\"\>",
        ShowStringCharacters->False],
       1.5743618096464114`,
       AutoDelete->True]]}],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm["    N(\!\(\*SubscriptBox[\(x\), \(1\)]\)) = ", 
   NumberForm[
   0.04046157694745245 $CellContext`ReyC^0.42563819035358863` \
$CellContext`x1^1.5743618096464114`, 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757510756874`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"e9a9548a-ecb7-47f4-8330-75e2cb597503"],

Cell[BoxData["\<\"Approx. transition point:\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.896075751078186*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"cd50020b-6985-4eec-8568-37b5c68b7d9c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    \\!\\(\\*SubscriptBox[\\(x\\), \\(\\(trans\\)\\(\\\\ \
\\)\\)]\\)(\\!\\(\\*SubscriptBox[\\(N\\), \\(trans\\)]\\)) = \"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    FractionBox[
     RowBox[{
      InterpretationBox[
       StyleBox["\<\"7.67\"\>",
        ShowStringCharacters->False],
       7.669654104636657,
       AutoDelete->True], " ", 
      SuperscriptBox["Ntrans", 
       InterpretationBox[
        StyleBox["\<\"0.635\"\>",
         ShowStringCharacters->False],
        0.6351780091925576,
        AutoDelete->True]]}], 
     SuperscriptBox["ReyC", 
      InterpretationBox[
       StyleBox["\<\"0.27\"\>",
        ShowStringCharacters->False],
       0.27035601838511525`,
       AutoDelete->True]]],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  "    \!\(\*SubscriptBox[\(x\), \(\(trans\)\(\\ \
\)\)]\)(\!\(\*SubscriptBox[\(N\), \(trans\)]\)) = ", 
   NumberForm[
   7.669654104636657 $CellContext`Ntrans^0.6351780091925576 \
$CellContext`ReyC^(-0.27035601838511525`), 3], "."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757510806856`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"b70a244d-ea0b-43a1-81cb-722d9513ef1a"],

Cell[BoxData["\<\"\\n\\n\"\>"], "Print",
 CellChangeTimes->{
  3.863667251061803*^9, 3.863667319582533*^9, 3.863667401268071*^9, 
   3.8637911242032723`*^9, 3.863791221070609*^9, 3.86379125963805*^9, {
   3.8637916102074723`*^9, 3.863791633331667*^9}, 3.8637916853552446`*^9, 
   3.863792018572097*^9, 3.863792052715678*^9, 3.8637920874714146`*^9, 
   3.8637921459727955`*^9, 3.8637921827086024`*^9, {3.8637922154348*^9, 
   3.863792268279688*^9}, 3.8647272672055774`*^9, {3.8647273024677224`*^9, 
   3.8647273311840878`*^9}, 3.864727420712182*^9, {3.864727469788685*^9, 
   3.8647274890295525`*^9}, {3.864727543024851*^9, 3.8647275728440723`*^9}, 
   3.864728694570628*^9, {3.8647287620264263`*^9, 3.864728776107015*^9}, 
   3.8647288094036207`*^9, 3.8648862946215744`*^9, 3.8651393854324856`*^9, 
   3.865255758166417*^9, 3.865255872861986*^9, 3.865255919561674*^9, 
   3.8652559732071457`*^9, 3.86525606407915*^9, {3.865256110294861*^9, 
   3.865256135090191*^9}, {3.8653418232218595`*^9, 3.8653418517523956`*^9}, 
   3.8739765655791144`*^9, 3.873977599101453*^9, 3.873980388973259*^9, 
   3.873980498803178*^9, 3.8741416921292815`*^9, 3.874142170357024*^9, 
   3.87414478794936*^9, {3.8741448343230925`*^9, 3.8741448424980288`*^9}, {
   3.879171009532977*^9, 3.8791710240471935`*^9}, {3.8791714673003235`*^9, 
   3.8791714805516143`*^9}, {3.8791715221892767`*^9, 3.879171532916847*^9}, {
   3.879171828063198*^9, 3.8791718417927322`*^9}, 3.879171992842988*^9, {
   3.896067512459525*^9, 3.896067531812543*^9}, 3.8960757510856867`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"d5cad7dd-23f8-4704-a8c7-cd18b3b92a25"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"B", ".", " ", "Initialization"}], " ", "cell"}], ",", " ", 
    RowBox[{"load", " ", "experimental", " ", "parameters"}]}], 
   "                          ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
     "**", "**", "**", "**", "**", "**", "**", "**"}], "******)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"SetOptions", "[", 
    RowBox[{"$FrontEnd", ",", 
     RowBox[{"InitializationCellWarning", "\[Rule]", "False"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"suppress", " ", "warnings", " ", "if", " ", "solve", " ", 
     RowBox[{"doesn", "'"}], "t", " ", "find", " ", "exact", " ", 
     RowBox[{"solutions", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Off", "[", 
    RowBox[{"Solve", "::", "ratnz"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "suppress", " ", "warnings", " ", "if", " ", "numbers", " ", "are", " ", 
      "too", " ", "small", " ", 
      RowBox[{"(", 
       RowBox[{"in", " ", "plots"}], ")"}]}], ":"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Off", "[", 
    RowBox[{"General", "::", "munfl"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Unprotect", " ", "the", " ", "initialization", " ", "functions"}], " ",
       "&"}], " ", "standard", " ", "parameters", " ", "to", " ", "allow", 
     " ", 
     RowBox[{"reloading", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"(", 
     RowBox[{
     "will", " ", "be", " ", "protected", " ", "again", " ", "at", " ", "the",
       " ", "end", " ", "of", " ", "the", " ", "block"}], ")"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Unprotect", "[", 
     RowBox[{"\"\<Load*\>\"", ",", "\"\<std*\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Set", " ", "some", " ", "standard", " ", "settings", " ", "for", " ", 
     RowBox[{"plots", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stdFontSize", "=", "10"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stdFontSize", "=", "16"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stdFontColor", "=", "Black"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stdFontFamily", "=", "\"\<Helvetica\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stdLabelStyle", "=", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontSize", "\[Rule]", "stdFontSize"}], ",", "stdFontColor", 
       ",", 
       RowBox[{"FontFamily", "\[Rule]", "stdFontFamily"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"stdFrame", "=", "True"}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LoadFlightParams", "[", "paramSet0_", "]"}], ":=", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Module", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"paramSet", "=", "paramSet0"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"geometryType", "=", "\"\<flat plate\>\""}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"paramSet", "!=", "\"\<geometry only\>\""}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{"Examples", " ", "from", " ", "Simon", 
               RowBox[{"(", "2017", ")"}]}], ":"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"B", ".", "J", ".", "Simon", ".", " ", "Active"}], " ",
                "Cancellation", " ", "of", " ", "Tollmien"}], "-", 
              RowBox[{
              "Schlichting", " ", "Waves", " ", "under", " ", "Varying", " ", 
               "Inflow", " ", "Conditions", " ", "for", " ", "In"}], "-", 
              RowBox[{"Flight", " ", 
               RowBox[{"Application", ".", "Technische"}], " ", 
               "Universit\[ADoubleDot]t", " ", 
               RowBox[{"Darmstadt", "."}]}]}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{"https", ":"}], "//", 
              RowBox[{
               RowBox[{"tuprints", ".", "ulb", ".", "tu"}], "-", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"darmstadt", ".", "de"}], "/", "6161"}], "/", "7"}],
                 "/", 
                RowBox[{"Dissertation_Simon", ".", "pdf"}]}]}]}], " ", "*)"}],
             "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"Flight", " ", 
                RowBox[{"example", ":", " ", 
                 RowBox[{"parameters", " ", "p", ".46", " ", "ff"}]}]}], ";", 
               " ", 
               RowBox[{"graph", " ", "p", ".106"}]}], ",", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"(", "b", ")"}], " ", "alpha"}], "=", 
               RowBox[{"2.5", "\[Degree]", " ", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                  "approx", " ", "zero", " ", "pressure", " ", "gradient"}], 
                  ")"}], "."}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"rhoSI", "=", "1.007"}], ";", " ", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"kg", "/", "m3"}], " ", ";", " ", 
               RowBox[{
                RowBox[{"estimate", ":", " ", 
                 RowBox[{
                 "atmosphere", " ", "density", " ", "at", " ", "2000", "m", 
                  " ", "above", " ", "sea", " ", "level", "  ", "from", " ", 
                  "https"}], ":"}], "//", 
                RowBox[{
                 RowBox[{
                  RowBox[{"www", ".", "engineeringtoolbox", ".", "com"}], "/",
                   "standard"}], "-", "atmosphere", "-", 
                 RowBox[{"d_", "604.", "html"}]}]}], " ", ";", " ", 
               RowBox[{"also", " ", "2", "\[Degree]C"}], " ", ";", " ", 
               RowBox[{"0.795", "*", 
                RowBox[{"10", "^", "5"}], " ", "Pa"}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"vFreestreamSI", "=", "41"}], ";", " ", 
             RowBox[{"(*", " ", 
              RowBox[{"m", "/", "s"}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"LcharactSI", "=", "1.35"}], ";", " ", 
             RowBox[{"(*", " ", "m", " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"ReynoldsChord", " ", "=", " ", 
              RowBox[{"3.75", "*", 
               RowBox[{"10", "^", "6"}]}]}], ";", " ", "\[IndentingNewLine]", 
             RowBox[{"viscositySI", "=", 
              RowBox[{"rhoSI", "*", "vFreestreamSI", "*", 
               RowBox[{"LcharactSI", "/", "ReynoldsChord"}]}]}], ";", " ", 
             RowBox[{"(*", " ", 
              RowBox[{"Pa", "*", "s"}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"dBoxSI", "=", 
              RowBox[{"81", "*", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "9"}], ")"}]}]}]}], ";", " ", 
             RowBox[{"(*", " ", 
              RowBox[{"m", " ", ";", " ", 
               RowBox[{
                RowBox[{"estimate", ":", " ", 
                 RowBox[{
                 "average", " ", "free", " ", "path", " ", "of", " ", "N2", 
                  " ", "at", " ", "2000", "m", " ", "above", " ", "sea", " ", 
                  "level", " ", "from", " ", "https"}], ":"}], "//", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"www", ".", "omnicalculator", ".", "com"}], "/", 
                   "physics"}], "/", "mean"}], "-", "free", "-", "path"}]}], 
               " ", ";", " ", 
               RowBox[{"2", "\[Degree]C"}], " ", ";", " ", 
               RowBox[{"0.795", "*", 
                RowBox[{"10", "^", "5"}], " ", "Pa"}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"rParticleSI", "=", 
              RowBox[{
               RowBox[{"0.364", "/", "2"}], "*", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "9"}], ")"}]}]}]}], ";", 
             RowBox[{"(*", " ", 
              RowBox[{"m", " ", ";", " ", 
               RowBox[{"estimate", ":", " ", 
                RowBox[{
                "kinetic", " ", "diameter", " ", "of", " ", "N2", " ", "from",
                  " ", "Scholes", " ", "et", " ", 
                 RowBox[{"al", ".", 
                  RowBox[{"(", "2010", ")"}]}], " ", "doi", " ", 
                 RowBox[{"10.2174", "/", "1874478810801010052"}]}]}]}], " ", 
              "*)"}], "\[IndentingNewLine]", 
             RowBox[{"Sc", "=", "1"}], ";", 
             RowBox[{"(*", " ", 
              RowBox[{"Schmidt", " ", "number"}], " ", "*)"}], 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"x1AxisScaling", "=", "LcharactSI"}], ";", " ", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"if", " ", "dimensionless", " ", "x1"}], "-", 
               RowBox[{"Axis", " ", "is", " ", "drawn"}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"xMin", "=", "0.15"}], ";", "\[IndentingNewLine]", 
             RowBox[{"xMax", "=", "0.8"}], ";", "\[IndentingNewLine]", 
             RowBox[{"yMin", "=", "250"}], ";", "\[IndentingNewLine]", 
             RowBox[{"yMax", "=", "1550"}], ";", "\[IndentingNewLine]", 
             RowBox[{"zMax", "=", "10"}], ";"}]}], "\[IndentingNewLine]", 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Return", " ", "[", 
           RowBox[{
           "\"\<Flight-parameters loaded: \>\"", " ", "<>", " ", "paramSet", 
            " ", "<>", " ", "\"\<.\>\""}], "]"}]}]}], "\[IndentingNewLine]", 
        "]"}], ";"}], "\[IndentingNewLine]", ")"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"LoadLabParams", "[", "paramSet0_", "]"}], ":=", 
     RowBox[{"(", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Module", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"paramSet", "=", "paramSet0"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"geometryType", "=", "\"\<flat plate\>\""}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"paramSet", "!=", "\"\<geometry only\>\""}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{"Examples", " ", "from", " ", "Simon", 
               RowBox[{"(", "2017", ")"}]}], ":"}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{
               RowBox[{"B", ".", "J", ".", "Simon", ".", " ", "Active"}], " ",
                "Cancellation", " ", "of", " ", "Tollmien"}], "-", 
              RowBox[{
              "Schlichting", " ", "Waves", " ", "under", " ", "Varying", " ", 
               "Inflow", " ", "Conditions", " ", "for", " ", "In"}], "-", 
              RowBox[{"Flight", " ", 
               RowBox[{"Application", ".", "Technische"}], " ", 
               "Universit\[ADoubleDot]t", " ", 
               RowBox[{"Darmstadt", "."}]}]}], " ", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{"https", ":"}], "//", 
              RowBox[{
               RowBox[{"tuprints", ".", "ulb", ".", "tu"}], "-", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"darmstadt", ".", "de"}], "/", "6161"}], "/", "7"}],
                 "/", 
                RowBox[{"Dissertation_Simon", ".", "pdf"}]}]}]}], " ", "*)"}],
             "\[IndentingNewLine]", 
            RowBox[{"(*", " ", 
             RowBox[{
              RowBox[{"wind", " ", "tunnel", " ", 
               RowBox[{"example", ":", " ", 
                RowBox[{"parameters", " ", "p", ".75", " ", "ff"}]}]}], ";", 
              " ", 
              RowBox[{"graph", " ", "p", 
               RowBox[{".76", "."}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
            RowBox[{
             RowBox[{"rhoSI", "=", "1.225"}], ";", " ", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"kg", "/", "m3"}], " ", ";", " ", 
               RowBox[{
                RowBox[{"estimate", ":", " ", 
                 RowBox[{
                 "atmosphere", " ", "density", " ", "at", " ", "0", "m", " ", 
                  "above", " ", "sea", " ", "level", "  ", "from", " ", 
                  "https"}], ":"}], "//", 
                RowBox[{
                 RowBox[{
                  RowBox[{"www", ".", "engineeringtoolbox", ".", "com"}], "/",
                   "standard"}], "-", "atmosphere", "-", 
                 RowBox[{"d_", "604.", "html"}]}]}], " ", ";", " ", 
               RowBox[{"also", " ", "15", "\[Degree]C"}], " ", ";", " ", 
               RowBox[{"1.013", "*", 
                RowBox[{"10", "^", "5"}], " ", "Pa"}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"vFreestreamSI", "=", "14"}], ";", " ", 
             RowBox[{"(*", " ", 
              RowBox[{"m", "/", "s"}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"LcharactSI", "=", "1"}], ";", 
             RowBox[{"(*", " ", 
              RowBox[{"m", " ", ";", " ", 
               RowBox[{
                RowBox[{"for", " ", "unscaled", " ", "x1"}], "-", "Axis"}]}], 
              " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"kinviscositySI", "=", 
              RowBox[{"15.96", "*", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "6"}], ")"}]}]}]}], ";", " ", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"m", "^", "2"}], "/", "s"}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"viscositySI", "=", 
              RowBox[{"kinviscositySI", "*", "rhoSI"}]}], ";", 
             RowBox[{"(*", " ", 
              RowBox[{"Pa", "*", "s"}], " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"dBoxSI", " ", "=", " ", 
              RowBox[{"67", "*", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "9"}], ")"}]}]}]}], ";", 
             RowBox[{"(*", " ", 
              RowBox[{"m", " ", ";", " ", 
               RowBox[{
                RowBox[{"estimate", ":", " ", 
                 RowBox[{
                 "average", " ", "free", " ", "path", " ", "of", " ", "N2", 
                  " ", "at", " ", "0", "m", " ", "above", " ", "sea", " ", 
                  "level", " ", "from", " ", "https"}], ":"}], "//", 
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"www", ".", "omnicalculator", ".", "com"}], "/", 
                   "physics"}], "/", "mean"}], "-", "free", "-", "path"}]}], 
               " ", ";", " ", 
               RowBox[{"15", "\[Degree]C"}], " ", ";", " ", 
               RowBox[{"1.013", "*", 
                RowBox[{"10", "^", "5"}], " ", "Pa"}]}], " ", "*)"}], 
             "\[IndentingNewLine]", 
             RowBox[{"rParticleSI", "=", 
              RowBox[{
               RowBox[{"0.364", "/", "2"}], "*", 
               RowBox[{"10", "^", 
                RowBox[{"(", 
                 RowBox[{"-", "9"}], ")"}]}]}]}], ";", 
             RowBox[{"(*", " ", 
              RowBox[{"m", " ", ";", " ", 
               RowBox[{"estimate", ":", " ", 
                RowBox[{
                "kinetic", " ", "diameter", " ", "of", " ", "N2", " ", "from",
                  " ", "Scholes", " ", "et", " ", 
                 RowBox[{"al", ".", 
                  RowBox[{"(", "2010", ")"}]}], " ", "doi", " ", 
                 RowBox[{"10.2174", "/", "1874478810801010052"}]}]}]}], " ", 
              "*)"}], "\[IndentingNewLine]", 
             RowBox[{"Sc", "=", "1"}], ";", 
             RowBox[{"(*", " ", 
              RowBox[{"Schmidt", " ", "number"}], " ", "*)"}], 
             "\[IndentingNewLine]", "\[IndentingNewLine]", 
             RowBox[{"x1AxisScaling", "=", "LcharactSI"}], ";", " ", 
             RowBox[{"(*", " ", 
              RowBox[{
               RowBox[{"for", " ", "unscaled", " ", "x1"}], "-", "Axis"}], 
              " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"xMin", "=", "0.1"}], ";", "\[IndentingNewLine]", 
             RowBox[{"xMax", "=", "0.5"}], ";", "\[IndentingNewLine]", 
             RowBox[{"yMin", "=", "50"}], ";", "\[IndentingNewLine]", 
             RowBox[{"yMax", "=", "500"}], ";", "\[IndentingNewLine]", 
             RowBox[{"zMax", "=", "5"}], ";"}]}], "\[IndentingNewLine]", 
           "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Return", " ", "[", 
           RowBox[{
           "\"\<Lab-parameters loaded: \>\"", "<>", " ", "paramSet", " ", "<>",
             " ", "\"\<.\>\""}], "]"}]}]}], "\[IndentingNewLine]", "]"}], 
       ";"}], "\[IndentingNewLine]", ")"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LoadParams", "[", 
     RowBox[{"problemSet0_", ",", "paramSet0_"}], "]"}], ":=", 
    "\[IndentingNewLine]", 
    RowBox[{"Module", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"problemSet", "=", "problemSet0"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Switch", "[", 
        RowBox[{
        "problemSet", ",", "\[IndentingNewLine]", "\"\<flight\>\"", ",", 
         RowBox[{"msg", "=", 
          RowBox[{"LoadFlightParams", "[", "paramSet0", "]"}]}], ",", 
         "\[IndentingNewLine]", "\"\<lab\>\"", ",", 
         RowBox[{"msg", "=", 
          RowBox[{"LoadLabParams", "[", "paramSet0", "]"}]}], ",", 
         "\[IndentingNewLine]", "_", ",", 
         RowBox[{"msg", "=", "\"\<undefined set of parameters.\>\""}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", " ", "[", "msg", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "Protect", " ", "the", " ", "initialization", " ", "functions"}], " ", 
      "&"}], " ", "standard", " ", 
     RowBox[{"parameters", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Protect", "[", 
     RowBox[{"\"\<Load*\>\"", ",", "\"\<std*\>\""}], "]"}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.8166201012483425`*^9, 3.8166201021503215`*^9}, 
   3.816620171827264*^9, {3.8167037951638174`*^9, 3.8167037995372863`*^9}, {
   3.816704024431816*^9, 3.8167041366229563`*^9}, {3.8167042266204696`*^9, 
   3.816704402197425*^9}, {3.8167044738099055`*^9, 3.8167044986638093`*^9}, {
   3.8167045305605183`*^9, 3.8167047294619627`*^9}, {3.8167047850978255`*^9, 
   3.8167050284484153`*^9}, {3.8167050816310883`*^9, 
   3.8167050863899484`*^9}, {3.8167052248903775`*^9, 3.816705254409684*^9}, {
   3.8167052873787303`*^9, 3.816705320226858*^9}, 3.81670629589043*^9, {
   3.816764355760409*^9, 3.816764409965308*^9}, {3.8167644859561443`*^9, 
   3.8167645418292685`*^9}, {3.816764583263134*^9, 3.816764628303459*^9}, {
   3.8167646615991917`*^9, 3.8167646733248987`*^9}, {3.816764733777999*^9, 
   3.8167647929280634`*^9}, {3.8167648388551283`*^9, 3.81676490305818*^9}, {
   3.8167652698064103`*^9, 3.8167652768088646`*^9}, {3.816765352883634*^9, 
   3.8167653644784455`*^9}, {3.81676552718034*^9, 3.816765576131297*^9}, {
   3.816776315208922*^9, 3.816776347354726*^9}, 3.816858691294018*^9, {
   3.816858721301411*^9, 3.8168587736409054`*^9}, {3.816959591186244*^9, 
   3.816959725874643*^9}, {3.816959759997356*^9, 3.816959760698431*^9}, {
   3.816960676877684*^9, 3.8169607030220847`*^9}, {3.8169617731323586`*^9, 
   3.8169617753657675`*^9}, {3.8170289916076345`*^9, 
   3.8170290410955114`*^9}, {3.8170290872693796`*^9, 
   3.8170291801763773`*^9}, {3.817029237246071*^9, 3.8170292477611465`*^9}, {
   3.817029292286645*^9, 3.817029375717876*^9}, {3.8170294218356304`*^9, 
   3.8170294275731664`*^9}, {3.817031248032642*^9, 3.8170312540655065`*^9}, {
   3.8170324746819954`*^9, 3.8170324857025347`*^9}, {3.817032551107407*^9, 
   3.8170325541604176`*^9}, 3.8170326043551264`*^9, 3.8170327324695263`*^9, {
   3.8170382650783243`*^9, 3.8170382657664146`*^9}, {3.8170387342440405`*^9, 
   3.817038736801916*^9}, {3.8171359916575513`*^9, 3.8171359921564026`*^9}, 
   3.8171361605051317`*^9, 3.817136273631759*^9, 3.8171363736192408`*^9, {
   3.817137100354598*^9, 3.817137167214964*^9}, {3.8171372151423035`*^9, 
   3.8171372431900845`*^9}, {3.8171373134194336`*^9, 3.817137343696946*^9}, {
   3.8171373937143345`*^9, 3.8171373986524916`*^9}, {3.817138471204213*^9, 
   3.817138488432293*^9}, {3.8171396273988495`*^9, 3.8171396331468983`*^9}, {
   3.8171396873581605`*^9, 3.8171397237501855`*^9}, {3.8171397565199647`*^9, 
   3.8171397580804605`*^9}, 3.817139791544342*^9, {3.8171399290337563`*^9, 
   3.8171399329826264`*^9}, 3.8171400648073397`*^9, {3.8171405553421073`*^9, 
   3.8171405568694015`*^9}, 3.817140667191636*^9, {3.8171407231273785`*^9, 
   3.81714072808992*^9}, {3.8171407590922494`*^9, 3.8171407595053186`*^9}, {
   3.817140806892517*^9, 3.8171408538875704`*^9}, {3.8174745051024427`*^9, 
   3.817474506718423*^9}, 3.8174746725728498`*^9, 3.8174747114518194`*^9, {
   3.818073130357949*^9, 3.8180732769328513`*^9}, {3.818073308394272*^9, 
   3.818073319931552*^9}, {3.8194952553814993`*^9, 3.8194953151030765`*^9}, 
   3.8194953556130714`*^9, {3.8194953872450333`*^9, 3.81949545035649*^9}, {
   3.8194955154279532`*^9, 3.8194955252426295`*^9}, {3.8194955648223963`*^9, 
   3.819495567918085*^9}, {3.819495629815897*^9, 3.819495633517106*^9}, {
   3.819532271589577*^9, 3.8195323206043124`*^9}, {3.8195331101050825`*^9, 
   3.8195331156828213`*^9}, {3.819541757602687*^9, 3.819541782603667*^9}, {
   3.8195418258689003`*^9, 3.819541894465311*^9}, 3.8195604291359687`*^9, {
   3.8220180215835857`*^9, 3.8220180909545317`*^9}, {3.8220212057699814`*^9, 
   3.822021205975294*^9}, {3.8220260984246855`*^9, 3.822026208626373*^9}, {
   3.822026357395993*^9, 3.822026363219781*^9}, {3.8220364193850946`*^9, 
   3.822036419947427*^9}, {3.8220364664170303`*^9, 3.8220365589102173`*^9}, {
   3.8220471948217974`*^9, 3.8220471980433064`*^9}, {3.822047277031478*^9, 
   3.822047278971554*^9}, {3.8222060902715616`*^9, 3.8222061329892263`*^9}, {
   3.822843639433316*^9, 3.822843639920757*^9}, {3.822844526611308*^9, 
   3.8228445483808255`*^9}, {3.8228479110544004`*^9, 3.8228479165641794`*^9}, 
   3.8228480076056433`*^9, {3.823711852641383*^9, 3.8237118922929964`*^9}, {
   3.8237133028076353`*^9, 3.823713309406752*^9}, {3.823807686314717*^9, 
   3.8238077020827847`*^9}, 3.823807917240408*^9, {3.8238080121305685`*^9, 
   3.8238080583456593`*^9}, {3.823810242248881*^9, 3.823810254335493*^9}, {
   3.8238102846411033`*^9, 3.823810294903264*^9}, {3.82381032786086*^9, 
   3.823810370262113*^9}, {3.8238104651765213`*^9, 3.823810523613267*^9}, {
   3.82381061362988*^9, 3.823810614574374*^9}, {3.8238106548056335`*^9, 
   3.8238107106712275`*^9}, {3.8238505446438437`*^9, 3.823850546455266*^9}, 
   3.823850626855379*^9, {3.8238701450835752`*^9, 3.8238701498319955`*^9}, {
   3.823870208239423*^9, 3.823870213865831*^9}, 3.823871562428435*^9, {
   3.8238735467223053`*^9, 3.8238735606343546`*^9}, {3.823873631689315*^9, 
   3.8238736327421856`*^9}, {3.8238736691139174`*^9, 
   3.8238737048625517`*^9}, {3.8238760137395163`*^9, 3.823876032376675*^9}, {
   3.823877309438158*^9, 3.8238773101257973`*^9}, {3.8238783735623293`*^9, 
   3.8238783935651245`*^9}, {3.823878430879249*^9, 3.8238784358978977`*^9}, {
   3.823878506067739*^9, 3.8238785063074164`*^9}, {3.823894277150434*^9, 
   3.8238942801882877`*^9}, {3.8238943739813747`*^9, 3.8238943794284487`*^9}, 
   3.823895079446416*^9, {3.8238951142785892`*^9, 3.823895115788919*^9}, {
   3.8239539468690243`*^9, 3.8239539679522204`*^9}, {3.8264565185078983`*^9, 
   3.826456521461439*^9}, 3.8269788445287557`*^9, {3.827139781956358*^9, 
   3.827139800585474*^9}, {3.827139869614255*^9, 3.8271398961675787`*^9}, {
   3.827140013046079*^9, 3.8271400248581915`*^9}, {3.8271400580738597`*^9, 
   3.827140091356061*^9}, {3.827140272942707*^9, 3.82714027916881*^9}, {
   3.827233438044011*^9, 3.8272334544201803`*^9}, {3.828017120129864*^9, 
   3.8280171485307302`*^9}, {3.8280173921929417`*^9, 3.828017395710205*^9}, {
   3.828022598572014*^9, 3.828022635208479*^9}, 3.828022736174264*^9, 
   3.828023357161793*^9, {3.8280235280615387`*^9, 3.828023562419566*^9}, {
   3.828024109720766*^9, 3.828024221505898*^9}, {3.8280251569376073`*^9, 
   3.8280251814791517`*^9}, 3.828026823100031*^9, {3.828026880907735*^9, 
   3.8280269351350803`*^9}, {3.8280270293775425`*^9, 
   3.8280270296480627`*^9}, {3.8280271305147533`*^9, 3.8280271306467743`*^9}, 
   3.828027162062978*^9, {3.828027204802036*^9, 3.8280272050338335`*^9}, {
   3.828027263528279*^9, 3.828027290665814*^9}, {3.828027352446043*^9, 
   3.8280273525778866`*^9}, {3.8282489636885147`*^9, 
   3.8282489811351724`*^9}, {3.8282491153243484`*^9, 3.82824911575713*^9}, {
   3.835093824353829*^9, 3.835093838903404*^9}, {3.8350952514001617`*^9, 
   3.835095255311955*^9}, {3.8351787879737215`*^9, 3.835178795025079*^9}, {
   3.8351788481029153`*^9, 3.8351788484474525`*^9}, {3.8351817146990385`*^9, 
   3.8351817159737015`*^9}, {3.8351817662260685`*^9, 3.835181766370846*^9}, {
   3.8352031209108353`*^9, 3.8352031233296165`*^9}, {3.8352044686871476`*^9, 
   3.8352045329793434`*^9}, 3.835204577876791*^9, {3.83525571906067*^9, 
   3.8352557235128317`*^9}, {3.8352557549748955`*^9, 
   3.8352557743678617`*^9}, {3.835255821027423*^9, 3.835255821460785*^9}, {
   3.8414703743525777`*^9, 3.8414703743600664`*^9}, {3.841470621299858*^9, 
   3.8414706234117875`*^9}, {3.841470661600957*^9, 3.8414706638089275`*^9}, {
   3.8414714352116346`*^9, 3.8414714362527914`*^9}, {3.841471480307687*^9, 
   3.841471482739612*^9}, {3.8414715237524586`*^9, 3.841471556593154*^9}, {
   3.843293696974146*^9, 3.8432937048203373`*^9}, 3.8432937727954173`*^9, {
   3.8432939327906704`*^9, 3.843293938202235*^9}, {3.8433696289077735`*^9, 
   3.843369651092353*^9}, {3.8433697105805264`*^9, 3.8433697107477465`*^9}, {
   3.8433888536845694`*^9, 3.8433888572795877`*^9}, {3.8433925777907023`*^9, 
   3.8433925781435223`*^9}, {3.843397956952546*^9, 3.8433979631572313`*^9}, {
   3.8433979934231443`*^9, 3.843397994313572*^9}, {3.843398034702922*^9, 
   3.8433980350221443`*^9}, {3.843405605270977*^9, 3.8434056054586196`*^9}, {
   3.843410963935869*^9, 3.843410967215207*^9}, {3.843411053615574*^9, 
   3.843411053765664*^9}, {3.843412692585001*^9, 3.84341272021797*^9}, 
   3.8434608817580743`*^9, 3.8434609124478817`*^9, 3.8434609793666534`*^9, {
   3.8434614592536125`*^9, 3.8434614905049553`*^9}, {3.8434695816655254`*^9, 
   3.8434696089675508`*^9}, {3.8438427913402014`*^9, 
   3.8438428478796377`*^9}, {3.8445971613526955`*^9, 3.844597191818107*^9}, {
   3.8445974634069366`*^9, 3.8445975042395716`*^9}, 3.844678619850574*^9, {
   3.8446786670351524`*^9, 3.8446786975997353`*^9}, {3.845789167186702*^9, 
   3.8457891671967216`*^9}, {3.845790201448549*^9, 3.8457902014585333`*^9}, {
   3.845792497789821*^9, 3.845792497794814*^9}, {3.8458227528434973`*^9, 
   3.845822752859155*^9}, {3.8458301091159725`*^9, 3.84583011780597*^9}, {
   3.8458774302672043`*^9, 3.8458774378266873`*^9}, {3.8458847116506543`*^9, 
   3.8458847200241733`*^9}, {3.846613754520728*^9, 3.8466137549164934`*^9}, {
   3.8466137998428106`*^9, 3.8466138028829556`*^9}, {3.8466138375065656`*^9, 
   3.846613896874016*^9}, {3.846613934083194*^9, 3.8466139572910433`*^9}, {
   3.8466139945110493`*^9, 3.8466140175909443`*^9}, {3.846614292318609*^9, 
   3.846614422340437*^9}, 3.846614512350379*^9, {3.846614600927679*^9, 
   3.8466146012523384`*^9}, 3.8466146361059184`*^9, {3.8466162107491446`*^9, 
   3.846616225599307*^9}, {3.846647736328348*^9, 3.84664773772113*^9}, {
   3.846648301909867*^9, 3.8466483020696087`*^9}, {3.8466484990448656`*^9, 
   3.846648512779518*^9}, {3.8466486148723717`*^9, 3.8466486151939645`*^9}, {
   3.8466487323877983`*^9, 3.84664873255752*^9}, {3.8466489027064543`*^9, 
   3.846648936428917*^9}, {3.846649043658179*^9, 3.8466490641020203`*^9}, {
   3.846649295174439*^9, 3.8466492954323444`*^9}, {3.8466494289234943`*^9, 
   3.8466494748852243`*^9}, {3.846651892872881*^9, 3.8466519215167265`*^9}, {
   3.846652076117396*^9, 3.846652100170659*^9}, {3.8466521314309216`*^9, 
   3.846652154319629*^9}, {3.8466521996577253`*^9, 3.8466522023994727`*^9}, {
   3.8466528668745365`*^9, 3.8466528816586313`*^9}, {3.8466529420504313`*^9, 
   3.8466529479671297`*^9}, {3.846654487452986*^9, 3.8466544988233376`*^9}, {
   3.8466545368531723`*^9, 3.846654537173581*^9}, {3.846654571061716*^9, 
   3.846654574824827*^9}, {3.8466546051940594`*^9, 3.846654605500305*^9}, {
   3.846654641539035*^9, 3.846654697697152*^9}, {3.846655575066619*^9, 
   3.846655633001408*^9}, {3.846657053457594*^9, 3.846657085990875*^9}, {
   3.8466571251540165`*^9, 3.84665716094073*^9}, {3.846679355547273*^9, 
   3.846679370097763*^9}, {3.8466794050140777`*^9, 3.8466794079461107`*^9}, {
   3.8466794414658365`*^9, 3.8466795420206137`*^9}, {3.846679634660181*^9, 
   3.8466796638535523`*^9}, {3.8466797689036517`*^9, 3.846679772920754*^9}, 
   3.84667994932828*^9, 3.846692741457425*^9, {3.8467090563681684`*^9, 
   3.846709068787899*^9}, {3.8467091623180103`*^9, 3.8467092103772306`*^9}, 
   3.8467092516208*^9, 3.846734774879247*^9, {3.846734832423679*^9, 
   3.8467348996614633`*^9}, {3.8467888646430626`*^9, 
   3.8467888649594135`*^9}, {3.846788899230558*^9, 3.8467888993731117`*^9}, 
   3.846789024460434*^9, 3.8467890629855003`*^9, {3.846830482461136*^9, 
   3.8468304826358566`*^9}, {3.8469210834734006`*^9, 3.846921143826758*^9}, 
   3.846921399345619*^9, {3.846921548248932*^9, 3.846921591540662*^9}, {
   3.8469220750996637`*^9, 3.84692211217721*^9}, {3.846922441367694*^9, 
   3.846922448796138*^9}, {3.846922481108639*^9, 3.8469225224162836`*^9}, {
   3.8469274300870323`*^9, 3.8469274334104395`*^9}, {3.846927658386042*^9, 
   3.8469276774818473`*^9}, {3.8469278368551064`*^9, 
   3.8469278521138325`*^9}, {3.8469336303144803`*^9, 
   3.8469336317410874`*^9}, {3.8469336657977777`*^9, 3.846933666237217*^9}, {
   3.846933726215604*^9, 3.8469339645051975`*^9}, {3.8469340757413464`*^9, 
   3.846934133533778*^9}, {3.8469343374176326`*^9, 3.8469344335386715`*^9}, {
   3.84693449355096*^9, 3.8469344956373725`*^9}, {3.846934551166583*^9, 
   3.84693467237904*^9}, {3.8469347218955193`*^9, 3.8469350633945193`*^9}, {
   3.8469642957098646`*^9, 3.8469643103015165`*^9}, 3.846964360088526*^9, {
   3.846964412954296*^9, 3.8469644193044977`*^9}, {3.8470201590513673`*^9, 
   3.847020168420714*^9}, {3.8470601954688716`*^9, 3.8470601997280684`*^9}, {
   3.847060314291232*^9, 3.8470603384127603`*^9}, {3.8470603702551565`*^9, 
   3.8470603741056395`*^9}, {3.8470604092608447`*^9, 3.8470604895580406`*^9}, 
   3.8470860756102576`*^9, 3.8470861555100245`*^9, {3.8470862293359523`*^9, 
   3.8470862511842594`*^9}, {3.847120775922636*^9, 3.8471208095448723`*^9}, {
   3.8471208711450176`*^9, 3.8471208738853006`*^9}, {3.847345908072467*^9, 
   3.8473459208757763`*^9}, 3.8473741843697176`*^9, 3.8473778417587967`*^9, {
   3.847436577293234*^9, 3.8474365933291683`*^9}, {3.847436637920209*^9, 
   3.847436664214382*^9}, {3.8474367393735094`*^9, 3.84743675613813*^9}, {
   3.847444626377942*^9, 3.8474446318032837`*^9}, {3.847444673302723*^9, 
   3.847444789993576*^9}, {3.847729268089881*^9, 3.8477292812753706`*^9}, {
   3.8477293304721127`*^9, 3.847729339649612*^9}, 3.8477293937947216`*^9, 
   3.847729467200653*^9, {3.8477295102062635`*^9, 3.847729513491911*^9}, {
   3.8477295641128063`*^9, 3.8477295656912203`*^9}, {3.8477295965108347`*^9, 
   3.8477296030032377`*^9}, {3.8477298739654245`*^9, 3.847729915080312*^9}, {
   3.847729945768526*^9, 3.8477299476238523`*^9}, {3.84772998408715*^9, 
   3.847730029698181*^9}, 3.8477300641089673`*^9, {3.8477301295377674`*^9, 
   3.847730130355565*^9}, {3.8477302179581375`*^9, 3.8477302561029944`*^9}, 
   3.8477303321657963`*^9, {3.847730384982896*^9, 3.8477303972071514`*^9}, 
   3.8477326380562997`*^9, {3.8477343497482457`*^9, 3.8477343704019637`*^9}, {
   3.8477344055582514`*^9, 3.847734429015237*^9}, {3.8477344740888023`*^9, 
   3.847734541376718*^9}, {3.847734618501636*^9, 3.847734638407178*^9}, {
   3.8477369273701153`*^9, 3.8477369284586396`*^9}, 3.847737072520697*^9, {
   3.847737200648388*^9, 3.847737230482215*^9}, {3.847743423643902*^9, 
   3.8477434247511053`*^9}, 3.8477450107132106`*^9, {3.8477828982911644`*^9, 
   3.8477829208504143`*^9}, {3.8477842132909784`*^9, 3.8477842494255*^9}, {
   3.847784299030315*^9, 3.8477843225078096`*^9}, {3.847791311572226*^9, 
   3.8477913126864367`*^9}, 3.8477913564185123`*^9, {3.8478681311379614`*^9, 
   3.8478681322110295`*^9}, {3.8478681647796173`*^9, 3.847868168155845*^9}, 
   3.8478681993907127`*^9, {3.847880115553094*^9, 3.8478801173039255`*^9}, 
   3.8478801557411537`*^9, {3.847885529784888*^9, 3.84788553098553*^9}, 
   3.847885601491018*^9, {3.84788596517087*^9, 3.8478859869656334`*^9}, {
   3.84790503294794*^9, 3.8479050354746895`*^9}, {3.8479050667930937`*^9, 
   3.8479050945990076`*^9}, {3.8479132017295256`*^9, 3.847913202829358*^9}, {
   3.847951354399607*^9, 3.847951356487561*^9}, {3.8479513884097147`*^9, 
   3.8479513887741117`*^9}, {3.8479876531136274`*^9, 
   3.8479876757109933`*^9}, {3.847987722406699*^9, 3.847987746506715*^9}, 
   3.8481486135078115`*^9, {3.8481486730376887`*^9, 3.848148701787315*^9}, {
   3.848148800418459*^9, 3.84814880073102*^9}, 3.848148859409509*^9, 
   3.8481488908899093`*^9, {3.8482239460800424`*^9, 3.8482239758733177`*^9}, {
   3.8483001593972387`*^9, 3.8483001707711143`*^9}, {3.8483002177079277`*^9, 
   3.848300225722414*^9}, {3.848300271681881*^9, 3.8483002845467587`*^9}, {
   3.8483003332732806`*^9, 3.8483003413306665`*^9}, {3.8483004883694468`*^9, 
   3.8483005043119435`*^9}, {3.848300546928132*^9, 3.848300561117093*^9}, {
   3.84847413555462*^9, 3.8484742416406317`*^9}, {3.8488147097340364`*^9, 
   3.8488147148124623`*^9}, {3.848815025519202*^9, 3.8488150257169023`*^9}, {
   3.84881508439172*^9, 3.848815087019704*^9}, {3.848815200823248*^9, 
   3.848815201434615*^9}, 3.8489998414229536`*^9, 3.8490000401427507`*^9, {
   3.8490298491104193`*^9, 3.8490298499857883`*^9}, {3.849029934807171*^9, 
   3.8490299749857078`*^9}, {3.8490300537268047`*^9, 3.849030067089901*^9}, {
   3.849030559126955*^9, 3.8490305645155163`*^9}, {3.8490306971431155`*^9, 
   3.8490307061954365`*^9}, {3.849030791830057*^9, 3.849030792248418*^9}, 
   3.850648669403797*^9, {3.850884461369577*^9, 3.850884493879323*^9}, 
   3.851229001360178*^9, {3.8512292222284565`*^9, 3.8512294133327675`*^9}, {
   3.851229445369418*^9, 3.851229490249201*^9}, {3.8512295968242397`*^9, 
   3.8512296190278654`*^9}, {3.8512298463624544`*^9, 3.851229849416788*^9}, {
   3.8512313795207834`*^9, 3.8512314857896276`*^9}, {3.851231526539448*^9, 
   3.851231527446371*^9}, {3.851231563049714*^9, 3.8512316728474636`*^9}, {
   3.8512317056007147`*^9, 3.8512317141648755`*^9}, {3.8512317515098352`*^9, 
   3.8512318048042607`*^9}, {3.8512318358205495`*^9, 3.851231969114379*^9}, {
   3.851232165872731*^9, 3.8512322137009773`*^9}, {3.8512322455835953`*^9, 
   3.8512322854445753`*^9}, {3.8512323231026487`*^9, 
   3.8512323238678927`*^9}, {3.8512323966198997`*^9, 3.85123240067513*^9}, {
   3.8512362300711336`*^9, 3.8512364246828065`*^9}, {3.851242816232866*^9, 
   3.8512428197797155`*^9}, {3.851243091747719*^9, 3.8512431353948927`*^9}, {
   3.8512431946754627`*^9, 3.851243195464885*^9}, {3.8512432368908086`*^9, 
   3.851243267396307*^9}, {3.851243299812357*^9, 3.8512433164484653`*^9}, {
   3.8512436849295187`*^9, 3.851243721744898*^9}, {3.8512437677111297`*^9, 
   3.85124376850798*^9}, {3.8513440900714073`*^9, 3.851344101573882*^9}, {
   3.851344147620509*^9, 3.851344158643011*^9}, {3.85134418964318*^9, 
   3.8513442521535654`*^9}, {3.851344291030528*^9, 3.851344291400148*^9}, {
   3.8513443306297245`*^9, 3.8513443428212156`*^9}, {3.8513444029008265`*^9, 
   3.85134440496692*^9}, 3.851344439025508*^9, {3.851401928699644*^9, 
   3.8514019348264503`*^9}, {3.8518488114748487`*^9, 3.8518488156147428`*^9},
    {3.851848867604294*^9, 3.851848870426227*^9}, {3.851934162257681*^9, 
   3.8519341724620075`*^9}, {3.852526815388255*^9, 3.852526815419171*^9}, {
   3.852965827686511*^9, 3.852965830838746*^9}, {3.8530731212777452`*^9, 
   3.853073150471143*^9}, {3.8532606313763084`*^9, 3.8532606375730824`*^9}, {
   3.8532607686104302`*^9, 3.853260769418641*^9}, {3.859647353175146*^9, 
   3.859647361671827*^9}, {3.859647451055176*^9, 3.85964747328506*^9}, {
   3.8596475263775215`*^9, 3.8596475326964016`*^9}, {3.8596477456233015`*^9, 
   3.8596477914941792`*^9}, {3.8596478347009*^9, 3.859647851446471*^9}, {
   3.8596478818296556`*^9, 3.859647882166051*^9}, {3.861183182075283*^9, 
   3.8611831927950196`*^9}, 3.861183235399659*^9, 3.861183379173787*^9, {
   3.861183530788741*^9, 3.8611835387186303`*^9}, {3.861183642413165*^9, 
   3.861183648162181*^9}, {3.861184536278223*^9, 3.8611845447429504`*^9}, 
   3.8611845750098753`*^9, 3.8611846113899007`*^9, {3.8611847485691147`*^9, 
   3.8611847488517265`*^9}, 3.8611848443714447`*^9, {3.861186753387412*^9, 
   3.861186755482097*^9}, {3.861186793366743*^9, 3.861186794905285*^9}, {
   3.8611873736418877`*^9, 3.8611873961058702`*^9}, 3.861188455347824*^9, {
   3.861188558407382*^9, 3.861188565555483*^9}, 3.861188796807153*^9, {
   3.8611892215255995`*^9, 3.861189223101325*^9}, {3.8611894793938*^9, 
   3.8611894795320225`*^9}, {3.861189967828977*^9, 3.861189971419575*^9}, {
   3.861190029325513*^9, 3.861190029685949*^9}, {3.861192791561829*^9, 
   3.8611928199198513`*^9}, {3.8613337156993384`*^9, 3.861333719214159*^9}, {
   3.861333812300581*^9, 3.8613338354536257`*^9}, 3.8613343696237936`*^9, {
   3.8613345591070595`*^9, 3.8613346221988707`*^9}, {3.8613346678532705`*^9, 
   3.861334695279934*^9}, 3.86134323369071*^9, {3.8613433652566233`*^9, 
   3.8613433656299925`*^9}, {3.8613494912490406`*^9, 3.861349568390853*^9}, {
   3.862203890568008*^9, 3.862203895687374*^9}, {3.8622138453987255`*^9, 
   3.862213865641421*^9}, {3.8622139197958345`*^9, 3.862213923445119*^9}, {
   3.8622139697328653`*^9, 3.862213974406226*^9}, {3.8622186286405582`*^9, 
   3.862218642000004*^9}, {3.862218673783435*^9, 3.86221867530835*^9}, {
   3.862220101067586*^9, 3.862220223828302*^9}, {3.862220308879691*^9, 
   3.8622203359488096`*^9}, {3.862220415219137*^9, 3.8622204219081264`*^9}, {
   3.8622204581890554`*^9, 3.8622205138913774`*^9}, {3.862220968618125*^9, 
   3.8622210133221054`*^9}, {3.862221054637194*^9, 3.862221109680373*^9}, {
   3.8622211559285803`*^9, 3.8622212592007103`*^9}, {3.8622214589256663`*^9, 
   3.8622215147448053`*^9}, {3.8622216257114005`*^9, 
   3.8622216689065833`*^9}, {3.8622229339366407`*^9, 
   3.8622229591705904`*^9}, {3.8622229962559595`*^9, 3.862223051474473*^9}, {
   3.8622234207049184`*^9, 3.862223472996978*^9}, {3.8622235695697126`*^9, 
   3.8622237210720663`*^9}, {3.86222378510368*^9, 3.862223785466131*^9}, {
   3.862223851397781*^9, 3.862223851683443*^9}, {3.862225030306738*^9, 
   3.8622250304844294`*^9}, {3.8622250938698406`*^9, 
   3.8622251260105243`*^9}, {3.8622256731105194`*^9, 
   3.8622256746848936`*^9}, {3.8622257444868455`*^9, 
   3.8622258365873113`*^9}, {3.862226014297761*^9, 3.862226014924803*^9}, {
   3.862226076482656*^9, 3.86222607685954*^9}, {3.862228530056226*^9, 
   3.862228585793563*^9}, {3.8622289597198825`*^9, 3.8622290273147807`*^9}, {
   3.862229113308367*^9, 3.862229168513279*^9}, 3.8622293967033544`*^9, {
   3.862229575247785*^9, 3.86222973396749*^9}, {3.862229906201195*^9, 
   3.8622299301366043`*^9}, {3.862229990841465*^9, 3.8622300158885236`*^9}, {
   3.862237059986286*^9, 3.862237081701171*^9}, {3.8622372684747972`*^9, 
   3.862237274282336*^9}, {3.862237314372467*^9, 3.8622373149030514`*^9}, {
   3.862237420781041*^9, 3.8622374471132298`*^9}, 3.8622383631626387`*^9, {
   3.8624134238425703`*^9, 3.8624134613070693`*^9}, {3.863791103895136*^9, 
   3.863791106024708*^9}, 3.8637915786285877`*^9, 3.8741445548467426`*^9, 
   3.8791710001425085`*^9},
 CellLabel->"In[1]:=",ExpressionUUID->"fb78d978-8748-45f9-9180-f541108f9942"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**"}], "*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**"}]}], "***********)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"C", ".", " ", "Detailed"}], " ", "velocity", " ", "profile", " ",
     "and", " ", "momentum", " ", "thickness"}], 
   "                           ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**"}], "*", 
    RowBox[{
    "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
      "**", "**", "**", "**", "**"}]}], "*********)"}], "\[IndentingNewLine]",
   "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Clear", " ", "previous", " ", "parameters", " ", "to", " ", "avoid", " ", 
    "changeup", " ", 
    RowBox[{"errors", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "eta", " ", "denotes", " ", "the", " ", "relative", " ", "height", " ", 
     "in", " ", "the", " ", "boundary", " ", "layer", " ", "eta"}], " ", "=", 
    " ", 
    RowBox[{
     RowBox[{"y", "/", "delta"}], 
     RowBox[{"(", "x1", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"eta", ",", "v"}], "]"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "dimensionless", " ", "velocity", " ", "profile", " ", "in", " ", "the", 
      " ", "blasius", " ", "boundary", " ", "layer"}], ",", " ", 
     RowBox[{
     "numerical", " ", "values", " ", "calculated", " ", "using", " ", "the", 
      " ", "nonlinear", " ", "shooting", " ", 
      RowBox[{"method", ":"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"from", ":", " ", 
       RowBox[{
       "Numerical", " ", "Approximations", " ", "of", " ", "Blasius", " ", 
        "Boundary", " ", "Layer", " ", "Equation"}]}], ";", " ", 
      RowBox[{"M", ".", "K", ".", "Jaman"}]}], ",", " ", 
     RowBox[{
      RowBox[{"Mohammad", " ", "Riazuddin", " ", "Molla", " ", "and", " ", 
       RowBox[{"S", ".", "Sultana"}]}], ";", " ", 
      RowBox[{
       RowBox[{"Dhaka", " ", 
        RowBox[{"Univ", ".", "J", ".", "Sci", ".", "59"}], 
        RowBox[{"(", "1", ")"}]}], ":", 
       RowBox[{"87", "-", "90"}]}]}], ",", 
     RowBox[{"2011", " ", 
      RowBox[{"(", "January", ")"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vXnonLinearShooting", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "0.00000", ",", "0.06645", ",", "0.19906", ",", "0.32994", ",", 
          "0.45654", ",", "0.57511", ",", "0.63014", ",", "0.72940", ",", 
          "0.81196", ",", "0.84650", ",", "0.90222", ",", "0.94157", ",", 
          "0.95585", ",", "0.97631", ",", "0.98822", ",", "0.99190", ",", 
          "0.99658"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
         "0.00", ",", "0.20", ",", "0.60", ",", "1.00", ",", "1.40", ",", 
          "1.80", ",", "2.00", ",", "2.40", ",", "2.80", ",", "3.00", ",", 
          "3.40", ",", "3.80", ",", "4.00", ",", "4.40", ",", "4.80", ",", 
          "5.00", ",", "5.40"}], "}"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "linear", " ", "approximation", " ", "for", " ", "the", " ", "velocity", 
     " ", "profile", " ", "at", " ", "small", " ", 
     RowBox[{"eta", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"c1", "=", "0.332"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vXsmallEta", "=", 
     RowBox[{"c1", "*", "eta"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"momentum", " ", 
     RowBox[{"thickness", ":"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"etaMomentumThickness", "=", "0.664"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"vMomentumThickness", "=", 
     RowBox[{"c1", "*", "etaMomentumThickness"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Detailed velocity profile and momentum thickness at \
(\!\(\*SubscriptBox[\(v\), \(1\)]\)/\[Eta]): (\>\"", " ", ",", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"vMomentumThickness", ",", "3"}], "]"}], ",", "\"\<|\>\"", ",", 
     " ", 
     RowBox[{"NumberForm", "[", 
      RowBox[{"etaMomentumThickness", ",", "3"}], "]"}], ",", 
     "\"\<).\\n\>\""}], "]"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"plot", ":"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"FontSizeBlasius", "=", "stdFontSize"}], ";"}], 
   RowBox[{"(*", " ", 
    RowBox[{
    "insert", " ", "a", " ", "different", " ", "font", " ", "size", " ", "if",
      " ", 
     RowBox[{"needed", "."}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"LabelStyleBlasius", "=", 
     RowBox[{"Directive", "[", 
      RowBox[{
       RowBox[{"FontSize", "\[Rule]", "FontSizeBlasius"}], ",", 
       "stdFontColor", ",", 
       RowBox[{"FontFamily", "\[Rule]", "stdFontFamily"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"aspectRatioBlasius", "=", "1.1"}], ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "aspect", " ", "ratio", " ", "to", " ", "fit", " ", "into", " ", 
     "Figure"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotRange", "=", 
     RowBox[{"Reverse", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "5."}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1.05"}], "}"}]}], "}"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"frameLabels", "=", 
     RowBox[{"Reverse", "[", 
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Eta] = y/\[Delta](\!\(\*SubsuperscriptBox[\(x\), \(1\), \(SI\)]\
\))\>\"", ",", "\"\<\!\(\*SubscriptBox[\(v\), \(1\)]\)\>\""}], "}"}], "]"}]}],
     ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"thicknessLegend", "=", 
      RowBox[{
       RowBox[{
       "StringTemplate", "[", 
        "\"\<momentum thickness \!\(\*SubscriptBox[\(\[Delta]\), \(2\)]\) (\
\[Eta] = `1`)\>\"", "]"}], "[", 
       RowBox[{"NumberForm", "[", 
        RowBox[{"etaMomentumThickness", ",", "3"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"legend", "=", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Blasius v-profile\>\"", ",", 
        "\"\<v-profile approx. small \[Eta] (\!\(\*SubscriptBox[\(v\), \(1\)]\
\) = 0.332\[Eta])\>\"", ",", "thicknessLegend"}], "}"}]}], ";"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"thicknessLegend", "=", 
     RowBox[{
      RowBox[{
      "StringTemplate", "[", 
       "\"\<momentum thickness \!\(\*SubscriptBox[\(\[Delta]\), \(2\)]\)\>\"",
        "]"}], "[", 
      RowBox[{"NumberForm", "[", 
       RowBox[{"etaMomentumThickness", ",", "3"}], "]"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"legend", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Blasius v-profile\>\"", ",", 
       "\"\<v-profile approx. small \[Eta]\>\"", ",", "thicknessLegend"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt1", "=", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{"vXnonLinearShooting", ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", "Thin"}], "}"}]}], ",", 
       RowBox[{"PlotMarkers", "\[Rule]", 
        RowBox[{"{", "\"\<+\>\"", "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt2", "=", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{"vXsmallEta", ",", 
        RowBox[{"{", 
         RowBox[{"eta", ",", 
          RowBox[{"-", "0.1"}], ",", "3.1"}], "}"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", "Gray", "}"}]}]}], "]"}], "/.", 
      RowBox[{
       RowBox[{"Line", "[", "pnts_", "]"}], "\[RuleDelayed]", 
       RowBox[{"Line", "[", 
        RowBox[{"Reverse", "/@", "pnts"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plt3", "=", 
     RowBox[{
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"etaMomentumThickness", ",", 
            RowBox[{"-", "0.1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"etaMomentumThickness", ",", "vMomentumThickness"}], 
           "}"}]}], "}"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Red", ",", "Dashed"}], "}"}]}]}], "]"}], "/.", 
      RowBox[{
       RowBox[{"Line", "[", "pnts_", "]"}], "\[RuleDelayed]", 
       RowBox[{"Line", "[", 
        RowBox[{"Reverse", "/@", "pnts"}], "]"}]}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plot", "=", 
     RowBox[{"Show", "[", 
      RowBox[{"plt3", ",", "plt2", ",", "plt1", ",", 
       RowBox[{"LabelStyle", "\[Rule]", "LabelStyleBlasius"}], ",", 
       RowBox[{"Frame", "\[Rule]", "stdFrame"}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", "frameLabels"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "plotRange"}], ",", 
       RowBox[{"AxesOrigin", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "->", "aspectRatioBlasius"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "350"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Legended", "[", 
    RowBox[{"plot", ",", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"Framed", "[", 
        RowBox[{
         RowBox[{"LineLegend", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Blue", ",", "Thin"}], "}"}], ",", "Gray", ",", 
             RowBox[{"{", 
              RowBox[{"Red", ",", "Dashed"}], "}"}]}], "}"}], ",", "legend", 
           ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"\"\<+\>\"", ",", "False", ",", "False"}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", "LabelStyleBlasius"}]}], "]"}], 
         ",", 
         RowBox[{"Background", "\[Rule]", "White"}], ",", 
         RowBox[{"FrameStyle", "\[Rule]", "Thin"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.43", ",", "0.83"}], "}"}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.819708350380616*^9, 3.81970871777153*^9}, {
   3.8197087514619923`*^9, 3.8197088741193027`*^9}, 3.8197189171898203`*^9, {
   3.8197190761708055`*^9, 3.819719082379303*^9}, {3.8197191582836504`*^9, 
   3.819719382409671*^9}, {3.8197194274833784`*^9, 3.8197194348824167`*^9}, {
   3.8197194812787933`*^9, 3.8197196006042233`*^9}, {3.8220211963822503`*^9, 
   3.822021212358509*^9}, {3.8220221939165926`*^9, 3.8220221940678263`*^9}, {
   3.822022881141966*^9, 3.822022934222528*^9}, 3.822023404304488*^9, {
   3.822036655907191*^9, 3.822036674099502*^9}, {3.8220368010662065`*^9, 
   3.8220369340213757`*^9}, {3.8220370361935472`*^9, 3.822037395300765*^9}, {
   3.822037441367036*^9, 3.8220376016241364`*^9}, {3.82203809018935*^9, 
   3.822038091805269*^9}, {3.8220381321833916`*^9, 3.8220381551433043`*^9}, {
   3.822038186158347*^9, 3.8220382467036643`*^9}, {3.822038287754529*^9, 
   3.822038581136054*^9}, {3.822038623288213*^9, 3.822038669055875*^9}, {
   3.8220387139716997`*^9, 3.822038717624748*^9}, 3.8220387711435366`*^9, {
   3.8220388341266775`*^9, 3.8220388700770035`*^9}, {3.822038926579127*^9, 
   3.822039102920573*^9}, {3.822039155983241*^9, 3.822039165085329*^9}, {
   3.822039208660547*^9, 3.822039322344232*^9}, {3.82203935917465*^9, 
   3.8220394485186043`*^9}, {3.8220395224897184`*^9, 
   3.8220395887443137`*^9}, {3.822039634893405*^9, 3.822039646679206*^9}, {
   3.8220397198516803`*^9, 3.8220397483610253`*^9}, {3.822039872037094*^9, 
   3.822039917500984*^9}, {3.8220400115852394`*^9, 3.8220400365071*^9}, {
   3.8220402321822033`*^9, 3.822040396712265*^9}, {3.822040461908435*^9, 
   3.8220404825779295`*^9}, 3.822040664560647*^9, {3.8220407024291253`*^9, 
   3.8220408008740788`*^9}, {3.8220408592675014`*^9, 3.822040904781831*^9}, {
   3.822040943480097*^9, 3.8220411436889296`*^9}, {3.8220411842947264`*^9, 
   3.822041298098905*^9}, {3.82204138150379*^9, 3.8220414792993817`*^9}, {
   3.8220415298327227`*^9, 3.822041556478821*^9}, {3.822041588500906*^9, 
   3.822041617394045*^9}, {3.8220416677548714`*^9, 3.8220416799351683`*^9}, {
   3.8220417835328627`*^9, 3.8220418528767166`*^9}, {3.8220419002686453`*^9, 
   3.8220420666418047`*^9}, {3.822042122722026*^9, 3.822042175068301*^9}, {
   3.8220423289831*^9, 3.822042480498505*^9}, 3.822042545016307*^9, {
   3.822042582961635*^9, 3.8220426027766647`*^9}, {3.8220427304545784`*^9, 
   3.8220427404164667`*^9}, {3.8220427777454348`*^9, 
   3.8220428387063503`*^9}, {3.8220428823586187`*^9, 3.822042893522212*^9}, {
   3.8220429598977723`*^9, 3.822043071877818*^9}, {3.822043114446652*^9, 
   3.8220431274346104`*^9}, {3.822043199185828*^9, 3.822043301434866*^9}, {
   3.8220433532387743`*^9, 3.822043356982932*^9}, {3.822043393781804*^9, 
   3.8220434216087666`*^9}, {3.822043464900025*^9, 3.8220435381132526`*^9}, {
   3.822043578636492*^9, 3.8220436199028406`*^9}, {3.8220436541347885`*^9, 
   3.8220436806074276`*^9}, {3.8220437205124607`*^9, 
   3.8220438102479753`*^9}, {3.8220438494802976`*^9, 
   3.8220440441109943`*^9}, {3.8220441723427067`*^9, 3.822044188319067*^9}, {
   3.822044248129343*^9, 3.822044318056893*^9}, {3.8220443998838587`*^9, 
   3.822044502103719*^9}, {3.8220445433674803`*^9, 3.8220445627283907`*^9}, 
   3.8220446037505503`*^9, {3.822044790630768*^9, 3.8220448215202208`*^9}, {
   3.822044858797708*^9, 3.8220448626024055`*^9}, {3.822044982246725*^9, 
   3.82204517342791*^9}, {3.822045267795138*^9, 3.8220453935446944`*^9}, {
   3.8220455720879145`*^9, 3.822045598334301*^9}, {3.822045673548109*^9, 
   3.822045674151205*^9}, {3.822045843394687*^9, 3.822046048204421*^9}, {
   3.8220460904825106`*^9, 3.8220461152581444`*^9}, {3.822046231445379*^9, 
   3.822046273624681*^9}, {3.822046304123344*^9, 3.822046304566229*^9}, {
   3.822047128778572*^9, 3.822047130673183*^9}, {3.822047164678967*^9, 
   3.8220471801262455`*^9}, {3.8220472908113604`*^9, 
   3.8220473233267365`*^9}, {3.822205538639073*^9, 3.822205698175973*^9}, {
   3.822205728492401*^9, 3.822205818639514*^9}, {3.8222058905419817`*^9, 
   3.822205908477558*^9}, {3.822205978512416*^9, 3.8222060265649548`*^9}, 
   3.8222061444371877`*^9, {3.822206184318433*^9, 3.8222062528801494`*^9}, {
   3.822207322939109*^9, 3.822207365350998*^9}, {3.822843625686227*^9, 
   3.8228436269210978`*^9}, 3.8228444880298724`*^9, {3.822849103247347*^9, 
   3.822849126054659*^9}, {3.8228491787184286`*^9, 3.822849179167493*^9}, {
   3.8228534252148223`*^9, 3.8228536844902186`*^9}, {3.82289960465031*^9, 
   3.82289960945887*^9}, {3.822900262634719*^9, 3.8229002942472305`*^9}, {
   3.822900384580011*^9, 3.822900387481666*^9}, {3.8229004270589266`*^9, 
   3.8229004292839503`*^9}, {3.8229004693439865`*^9, 
   3.8229004903402243`*^9}, {3.822900527933527*^9, 3.822900769881789*^9}, {
   3.822900839427552*^9, 3.8229008426718583`*^9}, {3.8229008848521166`*^9, 
   3.8229010657047358`*^9}, {3.8229011285406713`*^9, 
   3.8229011310924454`*^9}, {3.8237623011216526`*^9, 
   3.8237623252376814`*^9}, {3.8268181810376043`*^9, 3.826818188035143*^9}, {
   3.8268182211967564`*^9, 3.8268182552365217`*^9}, {3.8268186182830677`*^9, 
   3.826818651260501*^9}, {3.826818703299093*^9, 3.8268187194292145`*^9}, {
   3.826818770306571*^9, 3.8268188450463657`*^9}, {3.8268192703374043`*^9, 
   3.8268193180215645`*^9}, {3.826819512911804*^9, 3.826819538591299*^9}, {
   3.8268195700583982`*^9, 3.8268195739168034`*^9}, {3.8268196364999237`*^9, 
   3.826819652238899*^9}, {3.826819701974675*^9, 3.826819702540434*^9}, {
   3.826819754009658*^9, 3.8268197840063896`*^9}, {3.826820199272318*^9, 
   3.826820231636803*^9}, {3.8268202989863873`*^9, 3.8268202994454327`*^9}, {
   3.8268203640930915`*^9, 3.8268203642568665`*^9}, {3.8268206761114764`*^9, 
   3.826820676722663*^9}, {3.826822213980627*^9, 3.8268222559753976`*^9}, {
   3.826822292919165*^9, 3.8268222952509103`*^9}, {3.826822334867569*^9, 
   3.8268223448219023`*^9}, {3.8268235609826264`*^9, 3.826823566668189*^9}, {
   3.82682374612722*^9, 3.8268238699322977`*^9}, {3.826823901264906*^9, 
   3.826824121874398*^9}, {3.8268263242108593`*^9, 3.826826500399334*^9}, {
   3.8268282292512264`*^9, 3.826828232344531*^9}, {3.8268290090789165`*^9, 
   3.8268290214644113`*^9}, {3.8268291360084424`*^9, 3.826829136371174*^9}, {
   3.8268298199540215`*^9, 3.8268298613272533`*^9}, {3.8268304922755146`*^9, 
   3.826830542337288*^9}, {3.826830574699741*^9, 3.8268305782493024`*^9}, {
   3.8268306700834694`*^9, 3.826830674083722*^9}, {3.826830713570664*^9, 
   3.8268307160981207`*^9}, {3.8268307605401473`*^9, 3.826830787755599*^9}, 
   3.8268308209053826`*^9, 3.826830927780785*^9, {3.8268581150480747`*^9, 
   3.826858207548362*^9}, {3.826858446318966*^9, 3.826858446506091*^9}, {
   3.826858593112259*^9, 3.8268585958644023`*^9}, {3.826867487549729*^9, 
   3.8268675155234118`*^9}, {3.8268675573224382`*^9, 
   3.8268675870930047`*^9}, {3.8268677395849543`*^9, 
   3.8268680033193936`*^9}, {3.8268681266364737`*^9, 
   3.8268681423104963`*^9}, {3.8268682795734167`*^9, 
   3.8268683447318077`*^9}, {3.82686837477145*^9, 3.8268684328615503`*^9}, {
   3.8268705889818845`*^9, 3.82687064132318*^9}, {3.826881134046956*^9, 
   3.8268813202015796`*^9}, {3.82688135197964*^9, 3.826881355802704*^9}, {
   3.8433942932379904`*^9, 3.843394355793909*^9}, {3.8433944444960413`*^9, 
   3.843394473038229*^9}, 3.845792306871488*^9, {3.845792447061231*^9, 
   3.845792451013794*^9}, {3.8457937904212313`*^9, 3.845793791589265*^9}, {
   3.8457987361158543`*^9, 3.845798795624983*^9}, {3.8457989992721043`*^9, 
   3.845799018491503*^9}, {3.8457990889862967`*^9, 3.8457991069171886`*^9}, {
   3.8457998326404004`*^9, 3.845799882910882*^9}, {3.8457999303256364`*^9, 
   3.8457999754756336`*^9}, {3.8458000084082437`*^9, 
   3.8458000107607727`*^9}, {3.8458000425635767`*^9, 3.845800055552065*^9}, {
   3.845800086054468*^9, 3.845800106812708*^9}, {3.845800161563367*^9, 
   3.845800226600545*^9}, {3.8458301235511184`*^9, 3.845830131657314*^9}, {
   3.8458781984587164`*^9, 3.845878292700329*^9}, {3.845878322815184*^9, 
   3.845878328476433*^9}, {3.845878408418462*^9, 3.8458784395072994`*^9}, {
   3.846500530792322*^9, 3.8465005383893633`*^9}, {3.8607408595997276`*^9, 
   3.860740863470021*^9}, {3.8607527304867735`*^9, 3.8607527880945683`*^9}, {
   3.8607528243115892`*^9, 3.860752841092861*^9}, {3.860752877069147*^9, 
   3.860752879007127*^9}, {3.860752962412347*^9, 3.860752970007402*^9}, {
   3.860753028050537*^9, 3.8607530983934827`*^9}, {3.860753147636558*^9, 
   3.8607532781528516`*^9}, {3.8607534494289365`*^9, 
   3.8607535058479156`*^9}, {3.8607535383078213`*^9, 3.860753612667927*^9}, {
   3.861687127408908*^9, 3.8616871541316814`*^9}, {3.8616872263627644`*^9, 
   3.86168726710697*^9}, {3.8616873733444786`*^9, 3.8616874112657003`*^9}, {
   3.861687444981262*^9, 3.861687493087657*^9}, {3.861687822578759*^9, 
   3.8616878588007126`*^9}, {3.8620537004237733`*^9, 3.862053913664098*^9}, 
   3.862203690798381*^9, {3.8622037503769913`*^9, 3.8622038460618286`*^9}, {
   3.8623265889148903`*^9, 3.862326589511942*^9}, {3.8623266226648583`*^9, 
   3.862326655052127*^9}, {3.8623267092502356`*^9, 3.8623267112092934`*^9}, {
   3.8623267415890074`*^9, 3.862326847314867*^9}, {3.8623268886554413`*^9, 
   3.862326946500692*^9}, {3.8623271521681023`*^9, 3.862327169602745*^9}, 
   3.8623279772815847`*^9, {3.862328013363023*^9, 3.862328291874325*^9}, 
   3.862328618233304*^9, {3.8623287450154552`*^9, 3.8623287458354206`*^9}, {
   3.8623380129899693`*^9, 3.862338019481866*^9}, {3.8624039437719088`*^9, 
   3.8624039950520964`*^9}, {3.862404101031816*^9, 3.86240410730252*^9}, {
   3.862413133137187*^9, 3.8624132338719244`*^9}, {3.8624133122668915`*^9, 
   3.86241337748137*^9}, {3.862413508375386*^9, 3.8624137438579845`*^9}, {
   3.862413797125321*^9, 3.8624138327629447`*^9}, {3.862413885831932*^9, 
   3.862413893812989*^9}, {3.8624139831075163`*^9, 3.862414004552278*^9}, 
   3.862414127971278*^9, 3.8624141630787864`*^9, {3.8624141961981506`*^9, 
   3.8624142387823*^9}, 3.862414276033477*^9, {3.8624143147599373`*^9, 
   3.8624143644572897`*^9}, {3.862414421427502*^9, 3.8624144284751477`*^9}, {
   3.86241446041367*^9, 3.8624145014758196`*^9}, {3.863791963594895*^9, 
   3.863792004737111*^9}, {3.874144523593604*^9, 3.874144523966052*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"69fe0c69-b7b5-4ed4-84e4-5835f88bbc46"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Detailed velocity profile and momentum thickness at \
(\\!\\(\\*SubscriptBox[\\(v\\), \\(1\\)]\\)/\[Eta]): (\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.22\"\>",
      ShowStringCharacters->False],
     0.22044800000000003`,
     AutoDelete->True],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\"|\"\>", 
   "\[InvisibleSpace]", 
   TagBox[
    InterpretationBox[
     StyleBox["\<\"0.664\"\>",
      ShowStringCharacters->False],
     0.664,
     AutoDelete->True],
    NumberForm[#, 3]& ], "\[InvisibleSpace]", "\<\").\\n\"\>"}],
  SequenceForm[
  "Detailed velocity profile and momentum thickness at \
(\!\(\*SubscriptBox[\(v\), \(1\)]\)/\[Eta]): (", 
   NumberForm[0.22044800000000003`, 3], "|", 
   NumberForm[0.664, 3], ").\n"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.822205764553327*^9, 3.8222058189575477`*^9}, {
   3.822205902864581*^9, 3.8222059095429544`*^9}, {3.822205981280013*^9, 
   3.8222060270015917`*^9}, 3.8222061714156637`*^9, {3.8222062395964413`*^9, 
   3.822206254286294*^9}, {3.822207327817791*^9, 3.8222073659570456`*^9}, 
   3.822847937358605*^9, 3.8228486465428653`*^9, 3.822849103956499*^9, {
   3.8228491510550385`*^9, 3.8228491795410376`*^9}, {3.822853457010418*^9, 
   3.82285368593841*^9}, {3.8229002682796526`*^9, 3.82290029456044*^9}, 
   3.8229004702918377`*^9, {3.8229005295864916`*^9, 3.8229006048677673`*^9}, {
   3.822900639967971*^9, 3.8229007755116796`*^9}, 3.8229008445248604`*^9, {
   3.8229008865317645`*^9, 3.8229010664267073`*^9}, 3.8229011315185213`*^9, 
   3.822915122215898*^9, 3.8237623266678333`*^9, 3.8238708877833824`*^9, 
   3.8238710056520023`*^9, 3.8238794540520163`*^9, 3.823953990415094*^9, 
   3.826552723385997*^9, {3.826818694266966*^9, 3.8268187203646965`*^9}, 
   3.8268187883110805`*^9, 3.8268188477452707`*^9, 3.8268193225511274`*^9, {
   3.8268195412581005`*^9, 3.82681957527999*^9}, {3.8268196374770613`*^9, 
   3.8268196526823473`*^9}, 3.826819704074685*^9, 3.8268197543160963`*^9, 
   3.826819784874755*^9, {3.8268202143962173`*^9, 3.8268202321290507`*^9}, 
   3.826820300016474*^9, 3.8268203648413935`*^9, 3.8268206780501533`*^9, {
   3.8268222331973276`*^9, 3.8268222564911103`*^9}, 3.826822297125558*^9, 
   3.8268223457959747`*^9, {3.8268235620352783`*^9, 3.826823567085354*^9}, 
   3.8268237466029587`*^9, {3.82682381697231*^9, 3.8268238703653307`*^9}, {
   3.8268239025256243`*^9, 3.826824089595103*^9}, 3.8268241226743593`*^9, {
   3.8268263960027003`*^9, 3.826826501021863*^9}, {3.8268282209310536`*^9, 
   3.826828232935828*^9}, 3.826829022044985*^9, 3.82682913763017*^9, 
   3.826829170138546*^9, {3.8268298261438656`*^9, 3.826829861988538*^9}, {
   3.826830493408123*^9, 3.826830512760064*^9}, 3.8268305432586603`*^9, 
   3.8268305799049225`*^9, 3.8268306748184385`*^9, 3.82683071681289*^9, {
   3.826830761188419*^9, 3.8268307886006165`*^9}, 3.82683082151642*^9, 
   3.8268309283691835`*^9, {3.826858149920929*^9, 3.8268581773649716`*^9}, 
   3.8268582085434523`*^9, 3.8268584469276495`*^9, 3.826858600444682*^9, {
   3.826867493348003*^9, 3.8268675167801914`*^9}, {3.826867560004337*^9, 
   3.826867587591473*^9}, 3.8268677300538964`*^9, {3.826867765344861*^9, 
   3.8268680035786467`*^9}, {3.8268681322755933`*^9, 3.826868142886252*^9}, {
   3.8268682876718903`*^9, 3.826868345332238*^9}, {3.8268683757988186`*^9, 
   3.8268684334101553`*^9}, {3.8268705991282043`*^9, 3.8268706109244046`*^9}, 
   3.8268706423107796`*^9, {3.8268811346962457`*^9, 3.8268813206545706`*^9}, {
   3.8268813523039618`*^9, 3.8268813562350416`*^9}, 3.8269784592043924`*^9, {
   3.8433943009307127`*^9, 3.8433943561515336`*^9}, {3.8433944456829515`*^9, 
   3.843394473948128*^9}, 3.8457937928823767`*^9, 3.8457987705553474`*^9, 
   3.8457998839592695`*^9, 3.8457999765056076`*^9, {3.8458000667018604`*^9, 
   3.8458001078507824`*^9}, 3.8458001684342318`*^9, {3.845800209666359*^9, 
   3.845800236006827*^9}, 3.8458228185060663`*^9, {3.8458782009980035`*^9, 
   3.8458782288349085`*^9}, {3.845878262307473*^9, 3.845878294467168*^9}, 
   3.8458783302121515`*^9, {3.8458784095229907`*^9, 3.8458784417629614`*^9}, 
   3.8458785011627817`*^9, 3.845885334893852*^9, 3.860740864501355*^9, 
   3.860752775118763*^9, 3.8607529135907507`*^9, 3.860752980898265*^9, 
   3.860753033692189*^9, 3.860753066920539*^9, 3.860753099445475*^9, {
   3.8607531537412434`*^9, 3.860753243670803*^9}, 3.8607532790892906`*^9, 
   3.8607534560992794`*^9, 3.8607535084936905`*^9, {3.8607535435583344`*^9, 
   3.8607536132082624`*^9}, {3.8616871291573877`*^9, 3.861687154725932*^9}, {
   3.8616872302521663`*^9, 3.861687267508943*^9}, {3.861687376340734*^9, 
   3.861687411612836*^9}, {3.861687451730913*^9, 3.861687493668008*^9}, {
   3.86168783641105*^9, 3.8616878604668026`*^9}, {3.8620537100033813`*^9, 
   3.8620539140316467`*^9}, {3.862203773106237*^9, 3.8622038466388674`*^9}, 
   3.86232665638997*^9, 3.8623267117142453`*^9, {3.8623267429325695`*^9, 
   3.862326848038725*^9}, {3.8623269350672398`*^9, 3.8623269471033525`*^9}, {
   3.862327152748126*^9, 3.8623271701671686`*^9}, {3.8623280701804996`*^9, 
   3.86232808687422*^9}, 3.862328124420179*^9, {3.862328161824156*^9, 
   3.862328292426321*^9}, 3.8623286186903095`*^9, 3.8623287464816914`*^9, 
   3.862338020369936*^9, {3.8624039482897863`*^9, 3.8624039957565064`*^9}, 
   3.8624041082677884`*^9, {3.8624133686520653`*^9, 3.8624133777586966`*^9}, {
   3.8624135257311735`*^9, 3.862413744251148*^9}, {3.8624138148259716`*^9, 
   3.8624138335871153`*^9}, {3.8624138862993317`*^9, 
   3.8624138941896467`*^9}, {3.862413986856992*^9, 3.8624140049402065`*^9}, 
   3.8624141282882586`*^9, 3.8624141635461116`*^9, {3.8624142231916404`*^9, 
   3.8624142391580544`*^9}, 3.8624142765508337`*^9, {3.8624143153632936`*^9, 
   3.862414364839864*^9}, {3.862414421869534*^9, 3.8624144291434946`*^9}, {
   3.8624144615388193`*^9, 3.8624145017907934`*^9}, 3.863791970057661*^9, 
   3.865256057145054*^9, 3.8739776586500216`*^9, 3.874144612056967*^9, 
   3.8960675032552547`*^9},
 CellLabel->
  "During evaluation of \
In[15]:=",ExpressionUUID->"acb29429-5b41-48b3-9b64-3d1d3a89da81"],

Cell[BoxData[
 TagBox[
  GraphicsBox[{{{{}, {{}, {}, 
       {RGBColor[1, 0, 0], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], AbsoluteThickness[1.6], 
        Dashing[{Small, Small}], 
        LineBox[{{-0.1, 0.664}, {0.22044800000000003`, 
         0.664}}]}}, {{}, {}}}, {{{}, {}, 
       TagBox[
        {GrayLevel[0.5], AbsoluteThickness[1.6], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVknk41HkcgCfn9/FgQo4eutldRDObDpv1+aZUagalLZvNLA+2NCmUI0ft
RpJc1SJRs6QZR1ujhJH5uYrK5B4MyjFM06JfckWzs+0f7/P+/z7vGt9TB/xV
KBQK8yv/O0K+KTBDySFc68x+z7pZSRQZr6QPdXKINOebr3f9XEn0O2vMWxdx
iPYmQ7MZk0oC8sTxtQc5xKEW3fL9WRUE9cmkU6/HHcK7nzKhlVlO2N4M5sfz
coigWalnzI0ygs0KT3mzP5NItrpP803lE63d6umrXRKJLIuomsNa+YS1Mm1P
tWo8bMlDfmr37sAniaawicqBPa9ybEJoFRB6TjDgxSuCU6Z7dTv0G8DY9oMR
2+ARfGM8S08WNEORXo191OkK2F3P5dv91g5HMl5Mx2IhkLnswdJGMdxyHWh4
sFALbUVNz2oN+sBvX9lVdLcBrgQv8ocM30JVViGn71Ij5Nisk+wpHwI2S0HP
3PoSWMpH3oXCEbCT7aTV9jeDY2CaY3vVKCQRvHP+ghbIGouw3CGVwW20eU3k
xjZ4QzRnPpXJQdhrURx9rx3uFK3XizUah2NJqSfK9TshyrZnVHPbJNR+5gUG
BHRBXsLcSuYKElhprantYjHUUxLdBd9/hJIR7qdS2x7w+q61vnjTFGxnJce4
5/cC3zPXYbvrJ/CpGv/RQq8Pbvy0dETgMw3WnYsOQQH9ME6xf1XhOwOOhst9
z/QMgEqZrOJI5Cwo9ceeTdLfQoox492FmDkoiDCiuTsNAm/XIeek6HmYXMRp
mguDcD52jGuf/hlSj9ZTIwuGQOS3nsG+vgAeHYy1Lqxh6PWYn3EqXoRf7A1a
HxuOQAg1UKSo/gJPY+i5EmIELkSmjzkIFQDiQwrvCCkwxh3VV3f+C8t1OqNz
zUchRSfPP6FbCfZ2KZnholF4ENMVKQ+k4OhTbs4P48Zgdj5nx9A0BRslHtPP
3yCDiH1ge+vsEtzx5HLI9DsZeObdNf12iQqW1VGmlH++g9BWqeXZiyoYE2Xa
XJBDl3TOdZOqKq5uCRaUzMkhQyEKa0xWxenC+AR2/nu4NhFLmFLVcGItR3bl
6D8wMTSl5XRLDTc+nh/euWwcUp/an5SYq2OvSzxFhXAc2EFepF2BOtZjs4qT
wieAa47DfGgaeBUtKMLEfBJWlCrN3Es1cIi0chCLJkFicU3ykK6J5SXa/Y1x
H2A2V5Y9UqWJ+wq9otRMSGBOGEf3OCBstVmt44/lJND4W5gmgPC5uhKrJaYk
LDt7eKXndoRN+hS9iq9fSL5k1HQ7I3xQm7N1bh0JAdpG6t2uCIuCpDPyDSTE
Wi9L6foVYWLjydMtu0l4eHwppz0OYd0awyamCwnXbWjB+gkIH2UIVzXvJSHs
o5vTgUSEF/2oLU1MEhwiU6VtyQhvzeDb1HmQ8OKyrmVbBsL8+Zn3j1kkDHO1
S1t4CFPibztt9CHh2Yn1F6nFCLvp7c7m+5LA28A46HYf4QnLLJe//UkIKk+a
fc1H2NLrBx73BAkLz7W2vRYgHCEbVlqcJGHgipW2bjXCjaFJh+8GkVDjuneA
SSAccLVf469gEi6JE8+L6hEuM4n3XhVKwvHsQned5wirFdg8yT1DAsP7xRpm
E8IedLGOWdjXfmvlU1dfIpxXHeufHU6CwRhqaG5G+D9nSWTs
          "]]},
        Annotation[#, "Charting`Private`Tag$7724#1"]& ]}, {}}, {{}, {{{}, {}, 
        {RGBColor[0, 0, 1], PointSize[
          NCache[
           Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
         LineBox[{{0., 0.}, {0.06645, 0.2}, {0.19906, 0.6}, {0.32994, 1.}, {
          0.45654, 1.4}, {0.57511, 1.8}, {0.63014, 2.}, {0.7294, 2.4}, {
          0.81196, 2.8}, {0.8465, 3.}, {0.90222, 3.4}, {0.94157, 3.8}, {
          0.95585, 4.}, {0.97631, 4.4}, {0.98822, 4.8}, {0.9919, 5.}, {
          0.99658, 5.4}}]}}, 
       {RGBColor[0, 0, 1], PointSize[
         NCache[
          Rational[7, 360], 0.019444444444444445`]], Thickness[Tiny], 
        GeometricTransformationBox[
         TagBox[InsetBox["+", {0., 0.}],
          "InsetString"], {{{0., 0.}}, {{0.06645, 0.2}}, {{0.19906, 0.6}}, {{
         0.32994, 1.}}, {{0.45654, 1.4}}, {{0.57511, 1.8}}, {{0.63014, 
         2.}}, {{0.7294, 2.4}}, {{0.81196, 2.8}}, {{0.8465, 3.}}, {{0.90222, 
         3.4}}, {{0.94157, 3.8}}, {{0.95585, 4.}}, {{0.97631, 4.4}}, {{
         0.98822, 4.8}}, {{0.9919, 5.}}, {{0.99658, 5.4}}}]}}, {{}, {}}}}, 
    InsetBox[
     FrameBox[
      TemplateBox[{
       "\"Blasius v-profile\"", "\"v-profile approx. small \[Eta]\"", 
        "\"momentum thickness \\!\\(\\*SubscriptBox[\\(\[Delta]\\), \
\\(2\\)]\\)\""},
       "LineLegend",
       DisplayFunction->(FormBox[
         StyleBox[
          StyleBox[
           PaneBox[
            TagBox[
             GridBox[{{
                TagBox[
                 GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Thickness[Tiny]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Thickness[Tiny]], {
                    InsetBox[
                    FormBox[
                    StyleBox["\"+\"", 
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1], 
                    Thickness[Tiny]], FontSize -> 10, Plain, StripOnInput -> 
                    False], TraditionalForm], 
                    NCache[
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}], 
                    Scaled[{0.5, 0.5}]]]}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0.5]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0.5]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.5], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0], 
                    Dashing[{Small, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                  GridBoxAlignment -> {
                   "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                  AutoDelete -> False, 
                  GridBoxDividers -> {
                   "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {
                   "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
              GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
              AutoDelete -> False, 
              GridBoxItemSize -> {
               "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
              GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
             "Grid"], Alignment -> Left, AppearanceElements -> None, 
            ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
            "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           Directive[FontSize -> 16, 
            GrayLevel[0], FontFamily -> "Helvetica"], FontFamily -> "Arial"}, 
          Background -> Automatic, StripOnInput -> False], TraditionalForm]& ),
       Editable->True,
       InterpretationFunction:>(RowBox[{"LineLegend", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"0", ",", "0", ",", "1"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Thickness", "[", "Tiny", "]"}]}], "}"}], ",", 
                InterpretationBox[
                 ButtonBox[
                  TooltipBox[
                   GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.33333333333333337`], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                   StyleBox[
                    RowBox[{"GrayLevel", "[", "0.5`", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                  BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                  ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                  Automatic, Method -> "Preemptive"], 
                 GrayLevel[0.5], Editable -> False, Selectable -> False], ",", 
                RowBox[{"{", 
                  RowBox[{
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", "0", ",", "0"}], "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}]}], "}"}]}], 
              "}"}], ",", 
            RowBox[{"{", 
              RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
            RowBox[{"LegendMarkers", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{"\"+\"", ",", "False", ",", "False"}], "}"}]}], ",", 
            RowBox[{"Joined", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"Directive", "[", 
                RowBox[{
                  RowBox[{"FontSize", "\[Rule]", "16"}], ",", 
                  InterpretationBox[
                   ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                   GrayLevel[0], Editable -> False, Selectable -> False], ",", 
                  RowBox[{"FontFamily", "\[Rule]", "\"Helvetica\""}]}], 
                "]"}]}]}], "]"}]& )],
      Background->GrayLevel[1],
      FrameStyle->Thickness[Tiny],
      StripOnInput->False], Scaled[{0.43, 0.83}], ImageScaled[{0.5, 0.5}],
     BaseStyle->{FontSize -> Larger},
     FormatType->StandardForm]},
   AspectRatio->1.1,
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0, 0},
   DisplayFunction->Identity,
   Frame->True,
   FrameLabel->{
     FormBox[
     "\"\\!\\(\\*SubscriptBox[\\(v\\), \\(1\\)]\\)\"", TraditionalForm], 
     FormBox[
     "\"\[Eta] = y/\[Delta](\\!\\(\\*SubsuperscriptBox[\\(x\\), \\(1\\), \
\\(SI\\)]\\))\"", TraditionalForm]},
   FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->350,
   LabelStyle->Directive[FontSize -> 16, 
     GrayLevel[0], FontFamily -> "Helvetica"],
   Method->{
    "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
     "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& ), "CopiedValueFunction" -> ({
         Identity[
          Part[#, 1]], 
         Identity[
          Part[#, 2]]}& )}},
   PlotRange->{{0, 1.05}, {0, 5.}},
   PlotRangeClipping->True,
   PlotRangePadding->{{
      Scaled[0.02], 
      Scaled[0.02]}, {
      Scaled[0.05], 
      Scaled[0.05]}},
   Ticks->{Automatic, Automatic}],
  InterpretTemplate[Legended[
    Graphics[{{{}, {{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[
            Rational[7, 360]], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0], 
           Dashing[{Small, Small}]], 
          
          Line[{{-0.1, 0.664}, {0.22044800000000003`, 
           0.664}}]}}}, {{}, {}}}, {{{{}, {}, 
         Annotation[{
           Directive[
            Opacity[1.], 
            AbsoluteThickness[1.6], 
            GrayLevel[0.5]], 
           Line[CompressedData["
1:eJwVknk41HkcgCfn9/FgQo4eutldRDObDpv1+aZUagalLZvNLA+2NCmUI0ft
RpJc1SJRs6QZR1ujhJH5uYrK5B4MyjFM06JfckWzs+0f7/P+/z7vGt9TB/xV
KBQK8yv/O0K+KTBDySFc68x+z7pZSRQZr6QPdXKINOebr3f9XEn0O2vMWxdx
iPYmQ7MZk0oC8sTxtQc5xKEW3fL9WRUE9cmkU6/HHcK7nzKhlVlO2N4M5sfz
coigWalnzI0ygs0KT3mzP5NItrpP803lE63d6umrXRKJLIuomsNa+YS1Mm1P
tWo8bMlDfmr37sAniaawicqBPa9ybEJoFRB6TjDgxSuCU6Z7dTv0G8DY9oMR
2+ARfGM8S08WNEORXo191OkK2F3P5dv91g5HMl5Mx2IhkLnswdJGMdxyHWh4
sFALbUVNz2oN+sBvX9lVdLcBrgQv8ocM30JVViGn71Ij5Nisk+wpHwI2S0HP
3PoSWMpH3oXCEbCT7aTV9jeDY2CaY3vVKCQRvHP+ghbIGouw3CGVwW20eU3k
xjZ4QzRnPpXJQdhrURx9rx3uFK3XizUah2NJqSfK9TshyrZnVHPbJNR+5gUG
BHRBXsLcSuYKElhprantYjHUUxLdBd9/hJIR7qdS2x7w+q61vnjTFGxnJce4
5/cC3zPXYbvrJ/CpGv/RQq8Pbvy0dETgMw3WnYsOQQH9ME6xf1XhOwOOhst9
z/QMgEqZrOJI5Cwo9ceeTdLfQoox492FmDkoiDCiuTsNAm/XIeek6HmYXMRp
mguDcD52jGuf/hlSj9ZTIwuGQOS3nsG+vgAeHYy1Lqxh6PWYn3EqXoRf7A1a
HxuOQAg1UKSo/gJPY+i5EmIELkSmjzkIFQDiQwrvCCkwxh3VV3f+C8t1OqNz
zUchRSfPP6FbCfZ2KZnholF4ENMVKQ+k4OhTbs4P48Zgdj5nx9A0BRslHtPP
3yCDiH1ge+vsEtzx5HLI9DsZeObdNf12iQqW1VGmlH++g9BWqeXZiyoYE2Xa
XJBDl3TOdZOqKq5uCRaUzMkhQyEKa0xWxenC+AR2/nu4NhFLmFLVcGItR3bl
6D8wMTSl5XRLDTc+nh/euWwcUp/an5SYq2OvSzxFhXAc2EFepF2BOtZjs4qT
wieAa47DfGgaeBUtKMLEfBJWlCrN3Es1cIi0chCLJkFicU3ykK6J5SXa/Y1x
H2A2V5Y9UqWJ+wq9otRMSGBOGEf3OCBstVmt44/lJND4W5gmgPC5uhKrJaYk
LDt7eKXndoRN+hS9iq9fSL5k1HQ7I3xQm7N1bh0JAdpG6t2uCIuCpDPyDSTE
Wi9L6foVYWLjydMtu0l4eHwppz0OYd0awyamCwnXbWjB+gkIH2UIVzXvJSHs
o5vTgUSEF/2oLU1MEhwiU6VtyQhvzeDb1HmQ8OKyrmVbBsL8+Zn3j1kkDHO1
S1t4CFPibztt9CHh2Yn1F6nFCLvp7c7m+5LA28A46HYf4QnLLJe//UkIKk+a
fc1H2NLrBx73BAkLz7W2vRYgHCEbVlqcJGHgipW2bjXCjaFJh+8GkVDjuneA
SSAccLVf469gEi6JE8+L6hEuM4n3XhVKwvHsQned5wirFdg8yT1DAsP7xRpm
E8IedLGOWdjXfmvlU1dfIpxXHeufHU6CwRhqaG5G+D9nSWTs
            "]]}, "Charting`Private`Tag$7724#1"]}}, {}}, {{}, {{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[
            Rational[7, 360]], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1], 
           Thickness[Tiny]], 
          
          Line[{{0., 0.}, {0.06645, 0.2}, {0.19906, 0.6}, {0.32994, 1.}, {
           0.45654, 1.4}, {0.57511, 1.8}, {0.63014, 2.}, {0.7294, 2.4}, {
           0.81196, 2.8}, {0.8465, 3.}, {0.90222, 3.4}, {0.94157, 3.8}, {
           0.95585, 4.}, {0.97631, 4.4}, {0.98822, 4.8}, {0.9919, 5.}, {
           0.99658, 5.4}}]}}, {{
          Directive[
           PointSize[
            Rational[7, 360]], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1], 
           Thickness[Tiny]], 
          GeometricTransformation[
           Inset["+", {0., 0.}], {{{0., 0.}}, {{0.06645, 0.2}}, {{0.19906, 
           0.6}}, {{0.32994, 1.}}, {{0.45654, 1.4}}, {{0.57511, 1.8}}, {{
           0.63014, 2.}}, {{0.7294, 2.4}}, {{0.81196, 2.8}}, {{0.8465, 
           3.}}, {{0.90222, 3.4}}, {{0.94157, 3.8}}, {{0.95585, 4.}}, {{
           0.97631, 4.4}}, {{0.98822, 4.8}}, {{0.9919, 5.}}, {{0.99658, 
           5.4}}}]}}}, {{}, {}}}}, {LabelStyle -> Directive[FontSize -> 16, 
        GrayLevel[0], FontFamily -> "Helvetica"], Frame -> True, 
      FrameLabel -> {
       "\!\(\*SubscriptBox[\(v\), \(1\)]\)", 
        "\[Eta] = y/\[Delta](\!\(\*SubsuperscriptBox[\(x\), \(1\), \
\(SI\)]\))"}, PlotRange -> {{0, 1.05}, {0, 5.}}, AxesOrigin -> {0, 0}, 
      AspectRatio -> 1.1, ImageSize -> 350, DisplayFunction -> Identity, 
      DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
      Axes -> {True, True}, AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, 
      DisplayFunction :> Identity, Frame -> {{False, False}, {False, False}}, 
      FrameLabel -> {{None, None}, {None, None}}, 
      FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
      GridLines -> {None, None}, GridLinesStyle -> Directive[
        GrayLevel[0.5, 0.4]], 
      Method -> {
       "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
        "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& ), "CopiedValueFunction" -> ({
            Identity[
             Part[#, 1]], 
            Identity[
             Part[#, 2]]}& )}}, 
      PlotRange -> {{0, 1.328}, {-0.1, 0.22044800000000003`}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}], 
    Placed[
     Unevaluated[
      Framed[
       LineLegend[{{
          RGBColor[0, 0, 1], 
          Thickness[Tiny]}, 
         GrayLevel[0.5], {
          RGBColor[1, 0, 0], 
          Dashing[{Small, Small}]}}, {
        "Blasius v-profile", "v-profile approx. small \[Eta]", 
         "momentum thickness \!\(\*SubscriptBox[\(\[Delta]\), \(2\)]\)"}, 
        LegendMarkers -> {"+", False, False}, Joined -> {True, True, True}, 
        LabelStyle -> Directive[FontSize -> 16, 
          GrayLevel[0], FontFamily -> "Helvetica"]], Background -> 
       GrayLevel[1], FrameStyle -> Thickness[Tiny]]], {0.43, 0.83}, Identity]]
   & ],
  AutoDelete->True,
  Editable->True,
  SelectWithContents->False,
  Selectable->True]], "Output",
 CellChangeTimes->{
  3.8268187204728084`*^9, 3.826818788413398*^9, 3.8268188478522606`*^9, 
   3.8268193226537623`*^9, {3.8268195412506123`*^9, 3.826819575276997*^9}, {
   3.826819637378711*^9, 3.8268196526798525`*^9}, 3.826819705072128*^9, 
   3.8268197543921046`*^9, 3.8268197858822527`*^9, {3.826820214391225*^9, 
   3.8268202321240597`*^9}, 3.826820300003881*^9, 3.826820364836401*^9, 
   3.8268206780377045`*^9, {3.8268222331693525`*^9, 3.8268222564861746`*^9}, 
   3.826822297125558*^9, 3.8268223457919626`*^9, {3.8268235620185127`*^9, 
   3.8268235670697594`*^9}, 3.8268237465931773`*^9, {3.82682381697231*^9, 
   3.8268238703653307`*^9}, {3.8268239016337476`*^9, 3.826824089595103*^9}, 
   3.8268241226699595`*^9, {3.8268263959877405`*^9, 3.8268265010170355`*^9}, {
   3.8268282208981113`*^9, 3.8268282329308734`*^9}, 3.8268290220263352`*^9, 
   3.8268291376177425`*^9, 3.8268291701335793`*^9, {3.826829825251854*^9, 
   3.8268298619860415`*^9}, {3.82683049339112*^9, 3.8268305127548857`*^9}, 
   3.826830543253696*^9, 3.8268305790094595`*^9, 3.826830674813767*^9, 
   3.826830716806938*^9, {3.8268307611801357`*^9, 3.826830788590615*^9}, 
   3.826830821512355*^9, 3.8268309283651085`*^9, {3.826858149036805*^9, 
   3.8268581773649716`*^9}, 3.8268582085434523`*^9, 3.826858446911994*^9, 
   3.826858600444682*^9, {3.826867493335522*^9, 3.8268675167776957`*^9}, {
   3.8268675599993467`*^9, 3.8268675875789366`*^9}, 3.826867730041419*^9, {
   3.8268677653423147`*^9, 3.826868003573653*^9}, {3.826868132271916*^9, 
   3.826868142882001*^9}, {3.8268682876668587`*^9, 3.8268683453272142`*^9}, {
   3.8268683757938275`*^9, 3.8268684334051495`*^9}, {3.826870599123162*^9, 
   3.826870610922143*^9}, 3.826870642295122*^9, {3.826881134661339*^9, 
   3.826881320649702*^9}, {3.826881352301508*^9, 3.8268813562275724`*^9}, 
   3.826978459169852*^9, {3.8433943008483825`*^9, 3.843394356144045*^9}, {
   3.843394445677966*^9, 3.8433944739031982`*^9}, 3.8457937928408933`*^9, 
   3.8457987705431404`*^9, 3.845799884324139*^9, 3.8457999766129093`*^9, {
   3.8458000668042665`*^9, 3.845800107955681*^9}, 3.8458001685340366`*^9, {
   3.8458002098236046`*^9, 3.8458002361066847`*^9}, 3.8458228187807655`*^9, {
   3.845878201281822*^9, 3.8458782289290376`*^9}, {3.8458782624077015`*^9, 
   3.845878294561319*^9}, 3.845878330322*^9, {3.8458784096167564`*^9, 
   3.8458784418571143`*^9}, 3.8458785012725954`*^9, 3.8458853355028334`*^9, 
   3.8607408649185495`*^9, 3.860752776041442*^9, 3.8607529136824055`*^9, 
   3.86075298100238*^9, 3.860753033797474*^9, 3.8607530670062265`*^9, 
   3.860753099528101*^9, {3.8607531538471117`*^9, 3.8607532437565165`*^9}, 
   3.8607532791934166`*^9, 3.860753456226075*^9, 3.860753508590531*^9, {
   3.8607535436578474`*^9, 3.8607536132967253`*^9}, {3.8616871296602454`*^9, 
   3.861687154840749*^9}, {3.8616872303528175`*^9, 3.861687267610859*^9}, {
   3.861687376442811*^9, 3.8616874117153482`*^9}, {3.861687451833707*^9, 
   3.8616874937781043`*^9}, {3.861687836513383*^9, 3.861687860564311*^9}, {
   3.862053710486966*^9, 3.862053914128956*^9}, {3.86220377361117*^9, 
   3.86220384672392*^9}, 3.862326656908308*^9, 3.862326711808466*^9, {
   3.8623267430257807`*^9, 3.862326848134532*^9}, {3.862326935165512*^9, 
   3.86232694717841*^9}, {3.8623271528367057`*^9, 3.8623271702769356`*^9}, {
   3.862328070274762*^9, 3.862328086952366*^9}, 3.862328124518924*^9, {
   3.8623281619027243`*^9, 3.8623282925206003`*^9}, 3.8623286187845263`*^9, 
   3.8623287465760965`*^9, 3.8623380208977537`*^9, {3.862403948814342*^9, 
   3.862403995851552*^9}, 3.8624041083651323`*^9, {3.8624133691452017`*^9, 
   3.862413377763688*^9}, {3.862413526005729*^9, 3.8624137443514647`*^9}, {
   3.8624138149233537`*^9, 3.862413833684459*^9}, {3.8624138863966713`*^9, 
   3.862413894290529*^9}, {3.862413986951999*^9, 3.8624140050329685`*^9}, 
   3.862414128402822*^9, 3.8624141636459823`*^9, {3.862414223291238*^9, 
   3.8624142392529335`*^9}, 3.8624142766531687`*^9, {3.8624143154656935`*^9, 
   3.8624143649376097`*^9}, {3.8624144219727883`*^9, 3.862414429248359*^9}, {
   3.86241446162673*^9, 3.8624145018850603`*^9}, 3.863791970335124*^9, 
   3.8652560576243114`*^9, 3.873977658932678*^9, 3.874144612619685*^9, 
   3.896067503815936*^9},
 CellLabel->"Out[33]=",ExpressionUUID->"87e7dfac-1fce-4b54-a965-5c7a36dd020e"]
}, Open  ]]
},
PrintingStyleEnvironment->"Printout",
WindowSize->{1904, 973},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Landscape",
"PaperSize"->{1190.52, 841.92},
"PrintingMargins"->{{72.00000078, 72.00000078}, {54.000000584999995`, \
54.000000584999995`}}},
TaggingRules->Association["TryRealOnly" -> False],
FontFamily->"Courier New",
FontSize->12,
Magnification->1.1 Inherited,
FrontEndVersion->"12.3 for Microsoft Windows (64-bit) (July 9, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5fdc1711-3ab9-468a-83d9-c857ab58e014"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 11466, 217, 601, "Input",ExpressionUUID->"bd086455-bcad-490d-ab2a-0cc074b3f5b5"],
Cell[CellGroupData[{
Cell[12049, 241, 320790, 5510, 9638, "Input",ExpressionUUID->"a544a711-39a2-40b2-972b-2df50604db20"],
Cell[CellGroupData[{
Cell[332864, 5755, 1675, 24, 25, "Print",ExpressionUUID->"01e78d50-d635-465a-9e90-c42d8f34b688"],
Cell[334542, 5781, 1849, 30, 46, "Print",ExpressionUUID->"e74442f6-d022-48f2-b454-ec8baea967ef"],
Cell[336394, 5813, 2190, 37, 25, "Print",ExpressionUUID->"4b06bb11-dd69-4338-8d09-c191addb71a8"],
Cell[338587, 5852, 2138, 36, 45, "Print",ExpressionUUID->"a0a8b152-9eeb-467a-809b-04ca969eb1d6"],
Cell[340728, 5890, 2447, 48, 45, "Print",ExpressionUUID->"1f9931c3-9037-4789-8522-8bb6822abd14"],
Cell[343178, 5940, 2322, 45, 42, "Print",ExpressionUUID->"96748a81-4aa2-4b34-9f0a-4b3825b0b5ae"],
Cell[345503, 5987, 1646, 24, 66, "Print",ExpressionUUID->"b1bbcef8-facd-413a-96e9-2a300715cf1f"],
Cell[347152, 6013, 3257, 77, 47, "Print",ExpressionUUID->"9fe942ae-7514-4e65-a962-05709a82261e"],
Cell[350412, 6092, 2173, 38, 26, "Print",ExpressionUUID->"0ce7b3ec-850e-472a-a920-6ad40b0d31db"],
Cell[352588, 6132, 2115, 37, 48, "Print",ExpressionUUID->"a2b81855-c6ad-49f4-bc73-d671edab0462"],
Cell[354706, 6171, 3637, 83, 51, "Print",ExpressionUUID->"6352d422-49f4-4825-9c2f-5051ce73e7fc"],
Cell[358346, 6256, 3283, 70, 51, "Print",ExpressionUUID->"7a5c5861-c001-49ae-be40-cbd7c13c9031"],
Cell[361632, 6328, 3916, 94, 55, "Print",ExpressionUUID->"aaf97b79-c900-40a2-bcd8-db7e123719b8"],
Cell[365551, 6424, 2987, 62, 54, "Print",ExpressionUUID->"db2d7bed-512a-4e5c-b4cf-f79b586e84b2"],
Cell[368541, 6488, 3137, 69, 49, "Print",ExpressionUUID->"dfc91636-9bf8-43d6-8353-916d8a6c9bea"],
Cell[371681, 6559, 2462, 48, 82, "Print",ExpressionUUID->"3eda43a5-7e46-4eb0-9ac1-390fbca7cf9e"],
Cell[374146, 6609, 1667, 24, 66, "Print",ExpressionUUID->"3a18d7b9-bc33-4474-b6e1-74a0f03c14f5"],
Cell[375816, 6635, 1719, 25, 25, "Print",ExpressionUUID->"03d1f2b2-0ef2-4848-af07-a3f6ccbd5380"],
Cell[377538, 6662, 3776, 91, 49, "Print",ExpressionUUID->"26a67767-95a2-48f6-b735-297c3e973f55"],
Cell[381317, 6755, 4790, 125, 72, "Print",ExpressionUUID->"76a468eb-1117-4739-ac4d-4f2601130eaf"],
Cell[386110, 6882, 1693, 25, 25, "Print",ExpressionUUID->"4161d216-16e2-449b-bdf1-7f26643b1494"]
}, Open  ]],
Cell[387818, 6910, 1905, 31, 30, "Message",ExpressionUUID->"8a47f104-d8f6-43e6-a863-d0e080f5afa9"],
Cell[CellGroupData[{
Cell[389748, 6945, 2294, 42, 50, "Print",ExpressionUUID->"fb1bf7e1-627e-40c7-984b-f289b7aa1b7d"],
Cell[392045, 6989, 2895, 62, 49, "Print",ExpressionUUID->"ba6d0f7f-a14b-46a7-8c19-664e4aa5f3f5"],
Cell[394943, 7053, 1757, 26, 48, "Print",ExpressionUUID->"334b5c27-7cd6-4173-af62-c82a4bc5397d"],
Cell[396703, 7081, 1671, 24, 25, "Print",ExpressionUUID->"898c85e9-f633-4afd-beb1-7fcf48051169"],
Cell[398377, 7107, 3678, 85, 66, "Print",ExpressionUUID->"8528c8de-b03e-4a08-ab6f-02e5e2e1d5b1"],
Cell[402058, 7194, 2283, 33, 52, "Print",ExpressionUUID->"04696031-da8e-49db-a031-93f4d4a93f38"],
Cell[404344, 7229, 1871, 29, 46, "Print",ExpressionUUID->"a6a5fcd2-18bf-46a0-8a72-d15242a3ddc1"],
Cell[406218, 7260, 1660, 24, 25, "Print",ExpressionUUID->"e4fbc667-55fe-467f-8191-cec10de5e5f5"],
Cell[407881, 7286, 5492, 145, 85, "Print",ExpressionUUID->"0e53bb34-7bc5-426f-9460-f0b9c59d97d2"],
Cell[413376, 7433, 2419, 36, 50, "Print",ExpressionUUID->"1eb296ac-7b89-460c-b0a9-064389d261e4"],
Cell[415798, 7471, 1873, 29, 46, "Print",ExpressionUUID->"3582515a-dd6c-4541-9cf4-a70837311d3f"],
Cell[417674, 7502, 1677, 24, 66, "Print",ExpressionUUID->"67eb0404-1a51-436a-a8ec-2e5d20dbfbf8"],
Cell[419354, 7528, 1674, 24, 25, "Print",ExpressionUUID->"6a2c4748-72fe-4776-9609-82c3698dca74"],
Cell[421031, 7554, 2072, 37, 25, "Print",ExpressionUUID->"92833faa-506e-49fd-bd70-e685b7b53fdd"],
Cell[423106, 7593, 2163, 37, 26, "Print",ExpressionUUID->"fccf01df-5874-473d-a115-1140a5b51901"],
Cell[425272, 7632, 2138, 38, 46, "Print",ExpressionUUID->"b43bcde8-05a6-47b3-8706-93bb1963b4c0"],
Cell[427413, 7672, 1658, 24, 25, "Print",ExpressionUUID->"c3fe4473-cd09-4412-bb09-0faa8a47725c"],
Cell[429074, 7698, 2583, 53, 66, "Print",ExpressionUUID->"ae2ac0fc-9cb5-4e5c-8d63-466aa793f6bb"],
Cell[431660, 7753, 1660, 24, 25, "Print",ExpressionUUID->"8bc92492-e203-4b53-88f4-9c130fdf3970"],
Cell[433323, 7779, 2423, 43, 27, "Print",ExpressionUUID->"ba4b692a-272f-4423-aff2-09448b103164"],
Cell[435749, 7824, 2426, 44, 48, "Print",ExpressionUUID->"3d36daa8-4d04-4bd1-aabc-00adb6cd2784"],
Cell[438178, 7870, 2441, 50, 46, "Print",ExpressionUUID->"e8bc8e9a-074e-4ac9-a251-d53cde27e0dc"]
}, Open  ]],
Cell[440634, 7923, 114758, 2020, 331, "Output",ExpressionUUID->"a99536d4-65c7-4dcd-acc5-f7a8e90c9cc9"],
Cell[555395, 9945, 2494, 49, 66, "Print",ExpressionUUID->"e260af66-1978-4ebe-8449-18bc06c3bcdf"],
Cell[557892, 9996, 46466, 861, 391, "Output",ExpressionUUID->"c364cceb-017e-4d7f-ba8c-025770b3752e"],
Cell[CellGroupData[{
Cell[604383, 10861, 1714, 25, 66, "Print",ExpressionUUID->"623e6f2d-8ea9-413c-8498-d6aebe6f54e9"],
Cell[606100, 10888, 1699, 25, 25, "Print",ExpressionUUID->"6e0d3347-b9a3-4088-8162-d582d2e08e6b"],
Cell[607802, 10915, 2342, 46, 50, "Print",ExpressionUUID->"ed331df8-e8bd-4e4d-88c9-96612f44f192"],
Cell[610147, 10963, 2837, 59, 48, "Print",ExpressionUUID->"719a1d2f-516e-4495-8f3c-f08e47bea0ca"],
Cell[612987, 11024, 1669, 24, 25, "Print",ExpressionUUID->"7e48ea4c-9ec5-4f52-adab-46fb7a1a7dca"],
Cell[614659, 11050, 2559, 52, 26, "Print",ExpressionUUID->"e9a9548a-ecb7-47f4-8330-75e2cb597503"],
Cell[617221, 11104, 1660, 24, 25, "Print",ExpressionUUID->"cd50020b-6985-4eec-8568-37b5c68b7d9c"],
Cell[618884, 11130, 2712, 56, 51, "Print",ExpressionUUID->"b70a244d-ea0b-43a1-81cb-722d9513ef1a"],
Cell[621599, 11188, 1643, 24, 66, "Print",ExpressionUUID->"d5cad7dd-23f8-4704-a8c7-cd18b3b92a25"]
}, Open  ]]
}, Open  ]],
Cell[623269, 11216, 41954, 732, 2303, "Input",ExpressionUUID->"fb78d978-8748-45f9-9180-f541108f9942",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[665248, 11952, 21606, 426, 1112, "Input",ExpressionUUID->"69fe0c69-b7b5-4ed4-84e4-5835f88bbc46"],
Cell[686857, 12380, 6169, 98, 46, "Print",ExpressionUUID->"acb29429-5b41-48b3-9b64-3d1d3a89da81"],
Cell[693029, 12480, 29473, 592, 467, "Output",ExpressionUUID->"87e7dfac-1fce-4b54-a965-5c7a36dd020e"]
}, Open  ]]
}
]
*)

